/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.service.legalentitymanagement;

import com.adyen.Client;
import com.adyen.Service;
import com.adyen.constants.ApiConstants;
import com.adyen.model.RequestOptions;
import com.adyen.model.legalentitymanagement.BusinessLines;
import com.adyen.model.legalentitymanagement.LegalEntity;
import com.adyen.model.legalentitymanagement.LegalEntityInfo;
import com.adyen.model.legalentitymanagement.LegalEntityInfoRequiredType;
import com.adyen.model.legalentitymanagement.VerificationErrors;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.Resource;
import java.io.IOException;
import java.util.HashMap;

public class LegalEntitiesApi
extends Service {
    private final String baseURL = this.createBaseURL("https://kyc-test.adyen.com/lem/v3");

    public LegalEntitiesApi(Client client) {
        super(client);
    }

    public LegalEntity getLegalEntity(String id) throws ApiException, IOException {
        return this.getLegalEntity(id, null);
    }

    public LegalEntity getLegalEntity(String id, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (id == null) {
            throw new IllegalArgumentException("Please provide the id path parameter");
        }
        pathParams.put("id", id);
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/legalEntities/{id}", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams);
        return LegalEntity.fromJson(jsonResult);
    }

    public BusinessLines getAllBusinessLinesUnderLegalEntity(String id) throws ApiException, IOException {
        return this.getAllBusinessLinesUnderLegalEntity(id, null);
    }

    public BusinessLines getAllBusinessLinesUnderLegalEntity(String id, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (id == null) {
            throw new IllegalArgumentException("Please provide the id path parameter");
        }
        pathParams.put("id", id);
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/legalEntities/{id}/businessLines", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams);
        return BusinessLines.fromJson(jsonResult);
    }

    public LegalEntity updateLegalEntity(String id, LegalEntityInfo legalEntityInfo) throws ApiException, IOException {
        return this.updateLegalEntity(id, legalEntityInfo, null);
    }

    public LegalEntity updateLegalEntity(String id, LegalEntityInfo legalEntityInfo, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (id == null) {
            throw new IllegalArgumentException("Please provide the id path parameter");
        }
        pathParams.put("id", id);
        String requestBody = legalEntityInfo.toJson();
        Resource resource = new Resource(this, this.baseURL + "/legalEntities/{id}", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.PATCH, pathParams);
        return LegalEntity.fromJson(jsonResult);
    }

    public LegalEntity createLegalEntity(LegalEntityInfoRequiredType legalEntityInfoRequiredType) throws ApiException, IOException {
        return this.createLegalEntity(legalEntityInfoRequiredType, null);
    }

    public LegalEntity createLegalEntity(LegalEntityInfoRequiredType legalEntityInfoRequiredType, RequestOptions requestOptions) throws ApiException, IOException {
        String requestBody = legalEntityInfoRequiredType.toJson();
        Resource resource = new Resource(this, this.baseURL + "/legalEntities", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
        return LegalEntity.fromJson(jsonResult);
    }

    public VerificationErrors checkLegalEntitysVerificationErrors(String id) throws ApiException, IOException {
        return this.checkLegalEntitysVerificationErrors(id, null);
    }

    public VerificationErrors checkLegalEntitysVerificationErrors(String id, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (id == null) {
            throw new IllegalArgumentException("Please provide the id path parameter");
        }
        pathParams.put("id", id);
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/legalEntities/{id}/checkVerificationErrors", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, pathParams);
        return VerificationErrors.fromJson(jsonResult);
    }
}

