/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.transfers;

import com.adyen.model.transfers.Amount;
import com.adyen.model.transfers.CounterpartyV3;
import com.adyen.model.transfers.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;

@JsonPropertyOrder(value={"accountHolderId", "amount", "balanceAccountId", "balancePlatform", "bookingDate", "category", "counterparty", "createdAt", "description", "id", "instructedAmount", "paymentInstrumentId", "reference", "referenceForBeneficiary", "status", "transferId", "type", "valueDate"})
public class Transaction {
    public static final String JSON_PROPERTY_ACCOUNT_HOLDER_ID = "accountHolderId";
    private String accountHolderId;
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private Amount amount;
    public static final String JSON_PROPERTY_BALANCE_ACCOUNT_ID = "balanceAccountId";
    private String balanceAccountId;
    public static final String JSON_PROPERTY_BALANCE_PLATFORM = "balancePlatform";
    private String balancePlatform;
    public static final String JSON_PROPERTY_BOOKING_DATE = "bookingDate";
    private OffsetDateTime bookingDate;
    public static final String JSON_PROPERTY_CATEGORY = "category";
    private CategoryEnum category;
    public static final String JSON_PROPERTY_COUNTERPARTY = "counterparty";
    private CounterpartyV3 counterparty;
    public static final String JSON_PROPERTY_CREATED_AT = "createdAt";
    private OffsetDateTime createdAt;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_INSTRUCTED_AMOUNT = "instructedAmount";
    private Amount instructedAmount;
    public static final String JSON_PROPERTY_PAYMENT_INSTRUMENT_ID = "paymentInstrumentId";
    private String paymentInstrumentId;
    public static final String JSON_PROPERTY_REFERENCE = "reference";
    private String reference;
    public static final String JSON_PROPERTY_REFERENCE_FOR_BENEFICIARY = "referenceForBeneficiary";
    private String referenceForBeneficiary;
    public static final String JSON_PROPERTY_STATUS = "status";
    private StatusEnum status;
    public static final String JSON_PROPERTY_TRANSFER_ID = "transferId";
    private String transferId;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_VALUE_DATE = "valueDate";
    private OffsetDateTime valueDate;

    public Transaction accountHolderId(String accountHolderId) {
        this.accountHolderId = accountHolderId;
        return this;
    }

    @ApiModelProperty(required=true, value="Unique identifier of the account holder.")
    @JsonProperty(value="accountHolderId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAccountHolderId() {
        return this.accountHolderId;
    }

    @JsonProperty(value="accountHolderId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccountHolderId(String accountHolderId) {
        this.accountHolderId = accountHolderId;
    }

    public Transaction amount(Amount amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Amount getAmount() {
        return this.amount;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAmount(Amount amount) {
        this.amount = amount;
    }

    public Transaction balanceAccountId(String balanceAccountId) {
        this.balanceAccountId = balanceAccountId;
        return this;
    }

    @ApiModelProperty(required=true, value="Unique identifier of the balance account.")
    @JsonProperty(value="balanceAccountId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBalanceAccountId() {
        return this.balanceAccountId;
    }

    @JsonProperty(value="balanceAccountId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBalanceAccountId(String balanceAccountId) {
        this.balanceAccountId = balanceAccountId;
    }

    public Transaction balancePlatform(String balancePlatform) {
        this.balancePlatform = balancePlatform;
        return this;
    }

    @ApiModelProperty(required=true, value="Unique identifier of the balance platform.")
    @JsonProperty(value="balancePlatform")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBalancePlatform() {
        return this.balancePlatform;
    }

    @JsonProperty(value="balancePlatform")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBalancePlatform(String balancePlatform) {
        this.balancePlatform = balancePlatform;
    }

    public Transaction bookingDate(OffsetDateTime bookingDate) {
        this.bookingDate = bookingDate;
        return this;
    }

    @ApiModelProperty(required=true, value="The date the transaction was booked to the balance account.")
    @JsonProperty(value="bookingDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getBookingDate() {
        return this.bookingDate;
    }

    @JsonProperty(value="bookingDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBookingDate(OffsetDateTime bookingDate) {
        this.bookingDate = bookingDate;
    }

    public Transaction category(CategoryEnum category) {
        this.category = category;
        return this;
    }

    @ApiModelProperty(value="The category of the transaction indicating the type of activity.   Possible values:  * **platformPayment**: The transaction is a payment or payment modification made with an Adyen merchant account.  * **internal**: The transaction resulted from an internal adjustment such as a deposit correction or invoice deduction.  * **bank**: The transaction is a bank-related activity, such as sending a payout or receiving funds.  * **issuedCard**: The transaction is a card-related activity, such as using an Adyen-issued card to pay online.  ")
    @JsonProperty(value="category")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CategoryEnum getCategory() {
        return this.category;
    }

    @JsonProperty(value="category")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCategory(CategoryEnum category) {
        this.category = category;
    }

    public Transaction counterparty(CounterpartyV3 counterparty) {
        this.counterparty = counterparty;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="counterparty")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CounterpartyV3 getCounterparty() {
        return this.counterparty;
    }

    @JsonProperty(value="counterparty")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCounterparty(CounterpartyV3 counterparty) {
        this.counterparty = counterparty;
    }

    public Transaction createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @ApiModelProperty(required=true, value="The date the transaction was created.")
    @JsonProperty(value="createdAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="createdAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public Transaction description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="The `description` from the `/transfers` request.")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public Transaction id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="Unique identifier of the transaction.")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public Transaction instructedAmount(Amount instructedAmount) {
        this.instructedAmount = instructedAmount;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="instructedAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Amount getInstructedAmount() {
        return this.instructedAmount;
    }

    @JsonProperty(value="instructedAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInstructedAmount(Amount instructedAmount) {
        this.instructedAmount = instructedAmount;
    }

    public Transaction paymentInstrumentId(String paymentInstrumentId) {
        this.paymentInstrumentId = paymentInstrumentId;
        return this;
    }

    @ApiModelProperty(value="Unique identifier of the payment instrument that was used for the transaction.")
    @JsonProperty(value="paymentInstrumentId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPaymentInstrumentId() {
        return this.paymentInstrumentId;
    }

    @JsonProperty(value="paymentInstrumentId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPaymentInstrumentId(String paymentInstrumentId) {
        this.paymentInstrumentId = paymentInstrumentId;
    }

    public Transaction reference(String reference) {
        this.reference = reference;
        return this;
    }

    @ApiModelProperty(required=true, value="The [`reference`](https://docs.adyen.com/api-explorer/#/transfers/latest/post/transfers__reqParam_reference) from the `/transfers` request. If you haven't provided any, Adyen generates a unique reference.")
    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReference() {
        return this.reference;
    }

    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReference(String reference) {
        this.reference = reference;
    }

    public Transaction referenceForBeneficiary(String referenceForBeneficiary) {
        this.referenceForBeneficiary = referenceForBeneficiary;
        return this;
    }

    @ApiModelProperty(value="The reference sent to or received from the counterparty.  * For outgoing funds, this is the [`referenceForBeneficiary`](https://docs.adyen.com/api-explorer/#/transfers/latest/post/transfers__resParam_referenceForBeneficiary) from the  [`/transfers`](https://docs.adyen.com/api-explorer/#/transfers/latest/post/transfers__reqParam_referenceForBeneficiary) request.   * For incoming funds, this is the reference from the sender.")
    @JsonProperty(value="referenceForBeneficiary")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReferenceForBeneficiary() {
        return this.referenceForBeneficiary;
    }

    @JsonProperty(value="referenceForBeneficiary")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReferenceForBeneficiary(String referenceForBeneficiary) {
        this.referenceForBeneficiary = referenceForBeneficiary;
    }

    public Transaction status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(required=true, value="The status of the transaction.   Possible values:  * **pending**: The transaction is still pending.  * **booked**: The transaction has been booked to the balance account.  ")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StatusEnum getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public Transaction transferId(String transferId) {
        this.transferId = transferId;
        return this;
    }

    @ApiModelProperty(value="Unique identifier of the related transfer.")
    @JsonProperty(value="transferId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTransferId() {
        return this.transferId;
    }

    @JsonProperty(value="transferId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTransferId(String transferId) {
        this.transferId = transferId;
    }

    public Transaction type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="The type of the transaction.   Possible values: **payment**, **capture**, **captureReversal**, **refund** **refundReversal**, **chargeback**, **chargebackReversal**, **secondChargeback**, **atmWithdrawal**, **atmWithdrawalReversal**, **internalTransfer**, **manualCorrection**, **invoiceDeduction**, **depositCorrection**, **bankTransfer**, **miscCost**, **paymentCost**, **fee**")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public Transaction valueDate(OffsetDateTime valueDate) {
        this.valueDate = valueDate;
        return this;
    }

    @ApiModelProperty(required=true, value="The date the transfer amount becomes available in the balance account.")
    @JsonProperty(value="valueDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getValueDate() {
        return this.valueDate;
    }

    @JsonProperty(value="valueDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setValueDate(OffsetDateTime valueDate) {
        this.valueDate = valueDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Transaction transaction = (Transaction)o;
        return Objects.equals(this.accountHolderId, transaction.accountHolderId) && Objects.equals(this.amount, transaction.amount) && Objects.equals(this.balanceAccountId, transaction.balanceAccountId) && Objects.equals(this.balancePlatform, transaction.balancePlatform) && Objects.equals(this.bookingDate, transaction.bookingDate) && Objects.equals((Object)this.category, (Object)transaction.category) && Objects.equals(this.counterparty, transaction.counterparty) && Objects.equals(this.createdAt, transaction.createdAt) && Objects.equals(this.description, transaction.description) && Objects.equals(this.id, transaction.id) && Objects.equals(this.instructedAmount, transaction.instructedAmount) && Objects.equals(this.paymentInstrumentId, transaction.paymentInstrumentId) && Objects.equals(this.reference, transaction.reference) && Objects.equals(this.referenceForBeneficiary, transaction.referenceForBeneficiary) && Objects.equals((Object)this.status, (Object)transaction.status) && Objects.equals(this.transferId, transaction.transferId) && Objects.equals((Object)this.type, (Object)transaction.type) && Objects.equals(this.valueDate, transaction.valueDate);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountHolderId, this.amount, this.balanceAccountId, this.balancePlatform, this.bookingDate, this.category, this.counterparty, this.createdAt, this.description, this.id, this.instructedAmount, this.paymentInstrumentId, this.reference, this.referenceForBeneficiary, this.status, this.transferId, this.type, this.valueDate});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Transaction {\n");
        sb.append("    accountHolderId: ").append(this.toIndentedString(this.accountHolderId)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    balanceAccountId: ").append(this.toIndentedString(this.balanceAccountId)).append("\n");
        sb.append("    balancePlatform: ").append(this.toIndentedString(this.balancePlatform)).append("\n");
        sb.append("    bookingDate: ").append(this.toIndentedString(this.bookingDate)).append("\n");
        sb.append("    category: ").append(this.toIndentedString((Object)this.category)).append("\n");
        sb.append("    counterparty: ").append(this.toIndentedString(this.counterparty)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    instructedAmount: ").append(this.toIndentedString(this.instructedAmount)).append("\n");
        sb.append("    paymentInstrumentId: ").append(this.toIndentedString(this.paymentInstrumentId)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    referenceForBeneficiary: ").append(this.toIndentedString(this.referenceForBeneficiary)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    transferId: ").append(this.toIndentedString(this.transferId)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    valueDate: ").append(this.toIndentedString(this.valueDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Transaction fromJson(String jsonString) throws JsonProcessingException {
        return (Transaction)JSON.getMapper().readValue(jsonString, Transaction.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum TypeEnum {
        ATMWITHDRAWAL("atmWithdrawal"),
        ATMWITHDRAWALREVERSAL("atmWithdrawalReversal"),
        BALANCEADJUSTMENT("balanceAdjustment"),
        BALANCEROLLOVER("balanceRollover"),
        BANKTRANSFER("bankTransfer"),
        CAPTURE("capture"),
        CAPTUREREVERSAL("captureReversal"),
        CARDTRANSFER("cardTransfer"),
        CHARGEBACK("chargeback"),
        CHARGEBACKREVERSAL("chargebackReversal"),
        DEPOSITCORRECTION("depositCorrection"),
        FEE("fee"),
        GRANT("grant"),
        INSTALLMENT("installment"),
        INSTALLMENTREVERSAL("installmentReversal"),
        INTERNALTRANSFER("internalTransfer"),
        INVOICEDEDUCTION("invoiceDeduction"),
        LEFTOVER("leftover"),
        MANUALCORRECTION("manualCorrection"),
        MISCCOST("miscCost"),
        PAYMENT("payment"),
        PAYMENTCOST("paymentCost"),
        REFUND("refund"),
        REFUNDREVERSAL("refundReversal"),
        REPAYMENT("repayment"),
        RESERVEADJUSTMENT("reserveAdjustment"),
        SECONDCHARGEBACK("secondChargeback");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum StatusEnum {
        BOOKED("booked"),
        PENDING("pending");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum CategoryEnum {
        BANK("bank"),
        CARD("card"),
        GRANTS("grants"),
        INTERNAL("internal"),
        ISSUEDCARD("issuedCard"),
        MIGRATION("migration"),
        PLATFORMPAYMENT("platformPayment");

        private String value;

        private CategoryEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CategoryEnum fromValue(String value) {
            for (CategoryEnum b : CategoryEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

