/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.nexo;

import com.adyen.model.nexo.AllowedProduct;
import com.adyen.model.nexo.ContentInformation;
import com.adyen.model.nexo.CustomerOrder;
import com.adyen.model.nexo.EntryModeType;
import com.adyen.model.nexo.PaymentToken;
import com.adyen.model.nexo.SensitiveCardData;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="CardData", propOrder={"protectedCardData", "sensitiveCardData", "allowedProductCode", "allowedProduct", "paymentToken", "customerOrder"})
public class CardData {
    @XmlElement(name="ProtectedCardData")
    @Schema(description="Sensitive information related to the payment card, protected by CMS. --Rule: SensitiveCardData protected by CMS EnvelopedData")
    protected ContentInformation protectedCardData;
    @XmlElement(name="SensitiveCardData")
    @Schema(description="Sensitive information related to the payment card, entered or read by the Sale System. --Rule: If structure non empty and unprotected")
    protected SensitiveCardData sensitiveCardData;
    @XmlElement(name="AllowedProductCode")
    @Schema(description="Product codes that are payable by the payment card. --Rule: If ErrorCondition is \"PaymentRestriction\", some products are not payable by the payment card (payment response).", minLength=1, maxLength=20)
    protected List<String> allowedProductCode;
    @XmlElement(name="AllowedProduct")
    @Schema(description="Product that are payable by the payment card. --Rule: If the card has restrictions on product that can be purchased (card acquisition or balance inquiry response).")
    protected List<AllowedProduct> allowedProduct;
    @XmlElement(name="PaymentToken")
    @Schema(description="Surrogate of the PAN (Primary Account Number) of the payment card to identify the payment mean of the customer. --Rule: Present in If requested in CardAcquisitionResponse or PaymentResponse if requested in the request or in the Login")
    protected PaymentToken paymentToken;
    @XmlElement(name="CustomerOrder")
    @Schema(description="Customer order attached to a card, recorded in the POI system. --Rule: If the list of customer orders has been requested.")
    protected List<CustomerOrder> customerOrder;
    @XmlElement(name="PaymentBrand")
    @Schema(description="Type of payment card --Rule: If card PAN is readable ")
    protected String paymentBrand;
    @XmlElement(name="MaskedPan")
    protected String maskedPAN;
    @XmlElement(name="PaymentAccountRef")
    @Schema(description="Reference of the PAN, which identifies the PAN or the card uniquely, named also PAR (Payment Account Reference). This --Rule: Mandatory if available.")
    protected String paymentAccountRef;
    @XmlElement(name="EntryMode")
    @Schema(description="Entry mode of the payment instrument information --Rule: Mandatory in the request")
    protected List<EntryModeType> entryMode;
    @XmlElement(name="CardCountryCode")
    @Schema(description="Country Code attached to the card (3 numerics). --Rule: If available in the card", minLength=3, maxLength=3)
    protected String cardCountryCode;

    public ContentInformation getProtectedCardData() {
        return this.protectedCardData;
    }

    public void setProtectedCardData(ContentInformation value) {
        this.protectedCardData = value;
    }

    public SensitiveCardData getSensitiveCardData() {
        return this.sensitiveCardData;
    }

    public void setSensitiveCardData(SensitiveCardData value) {
        this.sensitiveCardData = value;
    }

    public List<String> getAllowedProductCode() {
        if (this.allowedProductCode == null) {
            this.allowedProductCode = new ArrayList<String>();
        }
        return this.allowedProductCode;
    }

    public List<AllowedProduct> getAllowedProduct() {
        if (this.allowedProduct == null) {
            this.allowedProduct = new ArrayList<AllowedProduct>();
        }
        return this.allowedProduct;
    }

    public PaymentToken getPaymentToken() {
        return this.paymentToken;
    }

    public void setPaymentToken(PaymentToken value) {
        this.paymentToken = value;
    }

    public List<CustomerOrder> getCustomerOrder() {
        if (this.customerOrder == null) {
            this.customerOrder = new ArrayList<CustomerOrder>();
        }
        return this.customerOrder;
    }

    public String getPaymentBrand() {
        return this.paymentBrand;
    }

    public void setPaymentBrand(String value) {
        this.paymentBrand = value;
    }

    public String getMaskedPAN() {
        return this.maskedPAN;
    }

    public void setMaskedPAN(String value) {
        this.maskedPAN = value;
    }

    public String getPaymentAccountRef() {
        return this.paymentAccountRef;
    }

    public void setPaymentAccountRef(String value) {
        this.paymentAccountRef = value;
    }

    public List<EntryModeType> getEntryMode() {
        if (this.entryMode == null) {
            this.entryMode = new ArrayList<EntryModeType>();
        }
        return this.entryMode;
    }

    public String getCardCountryCode() {
        return this.cardCountryCode;
    }

    public void setCardCountryCode(String value) {
        this.cardCountryCode = value;
    }
}

