/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.AfterpayTouchInfo;
import com.adyen.model.management.ApplePayInfo;
import com.adyen.model.management.BcmcInfo;
import com.adyen.model.management.CartesBancairesInfo;
import com.adyen.model.management.ClearpayInfo;
import com.adyen.model.management.GiroPayInfo;
import com.adyen.model.management.GooglePayInfo;
import com.adyen.model.management.JSON;
import com.adyen.model.management.KlarnaInfo;
import com.adyen.model.management.MealVoucherFRInfo;
import com.adyen.model.management.PayPalInfo;
import com.adyen.model.management.SofortInfo;
import com.adyen.model.management.SwishInfo;
import com.adyen.model.management.TwintInfo;
import com.adyen.model.management.VippsInfo;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"afterpayTouch", "allowed", "applePay", "bcmc", "businessLineId", "cartesBancaires", "clearpay", "countries", "currencies", "customRoutingFlags", "enabled", "giroPay", "googlePay", "id", "klarna", "mealVoucher_FR", "paypal", "reference", "shopperInteraction", "sofort", "storeId", "swish", "twint", "type", "verificationStatus", "vipps"})
public class PaymentMethod {
    public static final String JSON_PROPERTY_AFTERPAY_TOUCH = "afterpayTouch";
    private AfterpayTouchInfo afterpayTouch;
    public static final String JSON_PROPERTY_ALLOWED = "allowed";
    private Boolean allowed;
    public static final String JSON_PROPERTY_APPLE_PAY = "applePay";
    private ApplePayInfo applePay;
    public static final String JSON_PROPERTY_BCMC = "bcmc";
    private BcmcInfo bcmc;
    public static final String JSON_PROPERTY_BUSINESS_LINE_ID = "businessLineId";
    private String businessLineId;
    public static final String JSON_PROPERTY_CARTES_BANCAIRES = "cartesBancaires";
    private CartesBancairesInfo cartesBancaires;
    public static final String JSON_PROPERTY_CLEARPAY = "clearpay";
    private ClearpayInfo clearpay;
    public static final String JSON_PROPERTY_COUNTRIES = "countries";
    private List<String> countries = null;
    public static final String JSON_PROPERTY_CURRENCIES = "currencies";
    private List<String> currencies = null;
    public static final String JSON_PROPERTY_CUSTOM_ROUTING_FLAGS = "customRoutingFlags";
    private List<String> customRoutingFlags = null;
    public static final String JSON_PROPERTY_ENABLED = "enabled";
    private Boolean enabled;
    public static final String JSON_PROPERTY_GIRO_PAY = "giroPay";
    private GiroPayInfo giroPay;
    public static final String JSON_PROPERTY_GOOGLE_PAY = "googlePay";
    private GooglePayInfo googlePay;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_KLARNA = "klarna";
    private KlarnaInfo klarna;
    public static final String JSON_PROPERTY_MEAL_VOUCHER_F_R = "mealVoucher_FR";
    private MealVoucherFRInfo mealVoucherFR;
    public static final String JSON_PROPERTY_PAYPAL = "paypal";
    private PayPalInfo paypal;
    public static final String JSON_PROPERTY_REFERENCE = "reference";
    private String reference;
    public static final String JSON_PROPERTY_SHOPPER_INTERACTION = "shopperInteraction";
    private String shopperInteraction;
    public static final String JSON_PROPERTY_SOFORT = "sofort";
    private SofortInfo sofort;
    public static final String JSON_PROPERTY_STORE_ID = "storeId";
    private String storeId;
    public static final String JSON_PROPERTY_SWISH = "swish";
    private SwishInfo swish;
    public static final String JSON_PROPERTY_TWINT = "twint";
    private TwintInfo twint;
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;
    public static final String JSON_PROPERTY_VERIFICATION_STATUS = "verificationStatus";
    private VerificationStatusEnum verificationStatus;
    public static final String JSON_PROPERTY_VIPPS = "vipps";
    private VippsInfo vipps;

    public PaymentMethod afterpayTouch(AfterpayTouchInfo afterpayTouch) {
        this.afterpayTouch = afterpayTouch;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="afterpayTouch")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AfterpayTouchInfo getAfterpayTouch() {
        return this.afterpayTouch;
    }

    @JsonProperty(value="afterpayTouch")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAfterpayTouch(AfterpayTouchInfo afterpayTouch) {
        this.afterpayTouch = afterpayTouch;
    }

    public PaymentMethod allowed(Boolean allowed) {
        this.allowed = allowed;
        return this;
    }

    @ApiModelProperty(value="Indicates whether receiving payments is allowed. This value is set to **true** by Adyen after screening your merchant account.")
    @JsonProperty(value="allowed")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAllowed() {
        return this.allowed;
    }

    @JsonProperty(value="allowed")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAllowed(Boolean allowed) {
        this.allowed = allowed;
    }

    public PaymentMethod applePay(ApplePayInfo applePay) {
        this.applePay = applePay;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="applePay")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ApplePayInfo getApplePay() {
        return this.applePay;
    }

    @JsonProperty(value="applePay")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setApplePay(ApplePayInfo applePay) {
        this.applePay = applePay;
    }

    public PaymentMethod bcmc(BcmcInfo bcmc) {
        this.bcmc = bcmc;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="bcmc")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BcmcInfo getBcmc() {
        return this.bcmc;
    }

    @JsonProperty(value="bcmc")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBcmc(BcmcInfo bcmc) {
        this.bcmc = bcmc;
    }

    public PaymentMethod businessLineId(String businessLineId) {
        this.businessLineId = businessLineId;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the business line.")
    @JsonProperty(value="businessLineId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBusinessLineId() {
        return this.businessLineId;
    }

    @JsonProperty(value="businessLineId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBusinessLineId(String businessLineId) {
        this.businessLineId = businessLineId;
    }

    public PaymentMethod cartesBancaires(CartesBancairesInfo cartesBancaires) {
        this.cartesBancaires = cartesBancaires;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="cartesBancaires")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CartesBancairesInfo getCartesBancaires() {
        return this.cartesBancaires;
    }

    @JsonProperty(value="cartesBancaires")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCartesBancaires(CartesBancairesInfo cartesBancaires) {
        this.cartesBancaires = cartesBancaires;
    }

    public PaymentMethod clearpay(ClearpayInfo clearpay) {
        this.clearpay = clearpay;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="clearpay")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ClearpayInfo getClearpay() {
        return this.clearpay;
    }

    @JsonProperty(value="clearpay")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setClearpay(ClearpayInfo clearpay) {
        this.clearpay = clearpay;
    }

    public PaymentMethod countries(List<String> countries) {
        this.countries = countries;
        return this;
    }

    public PaymentMethod addCountriesItem(String countriesItem) {
        if (this.countries == null) {
            this.countries = new ArrayList<String>();
        }
        this.countries.add(countriesItem);
        return this;
    }

    @ApiModelProperty(value="The list of countries where a payment method is available. By default, all countries supported by the payment method.")
    @JsonProperty(value="countries")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getCountries() {
        return this.countries;
    }

    @JsonProperty(value="countries")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCountries(List<String> countries) {
        this.countries = countries;
    }

    public PaymentMethod currencies(List<String> currencies) {
        this.currencies = currencies;
        return this;
    }

    public PaymentMethod addCurrenciesItem(String currenciesItem) {
        if (this.currencies == null) {
            this.currencies = new ArrayList<String>();
        }
        this.currencies.add(currenciesItem);
        return this;
    }

    @ApiModelProperty(value="The list of currencies that a payment method supports. By default, all currencies supported by the payment method.")
    @JsonProperty(value="currencies")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getCurrencies() {
        return this.currencies;
    }

    @JsonProperty(value="currencies")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCurrencies(List<String> currencies) {
        this.currencies = currencies;
    }

    public PaymentMethod customRoutingFlags(List<String> customRoutingFlags) {
        this.customRoutingFlags = customRoutingFlags;
        return this;
    }

    public PaymentMethod addCustomRoutingFlagsItem(String customRoutingFlagsItem) {
        if (this.customRoutingFlags == null) {
            this.customRoutingFlags = new ArrayList<String>();
        }
        this.customRoutingFlags.add(customRoutingFlagsItem);
        return this;
    }

    @ApiModelProperty(value="The list of custom routing flags to route payment to the intended acquirer.")
    @JsonProperty(value="customRoutingFlags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getCustomRoutingFlags() {
        return this.customRoutingFlags;
    }

    @JsonProperty(value="customRoutingFlags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCustomRoutingFlags(List<String> customRoutingFlags) {
        this.customRoutingFlags = customRoutingFlags;
    }

    public PaymentMethod enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @ApiModelProperty(value="Indicates whether the payment method is enabled (**true**) or disabled (**false**).")
    @JsonProperty(value="enabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getEnabled() {
        return this.enabled;
    }

    @JsonProperty(value="enabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public PaymentMethod giroPay(GiroPayInfo giroPay) {
        this.giroPay = giroPay;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="giroPay")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public GiroPayInfo getGiroPay() {
        return this.giroPay;
    }

    @JsonProperty(value="giroPay")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGiroPay(GiroPayInfo giroPay) {
        this.giroPay = giroPay;
    }

    public PaymentMethod googlePay(GooglePayInfo googlePay) {
        this.googlePay = googlePay;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="googlePay")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public GooglePayInfo getGooglePay() {
        return this.googlePay;
    }

    @JsonProperty(value="googlePay")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGooglePay(GooglePayInfo googlePay) {
        this.googlePay = googlePay;
    }

    public PaymentMethod id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="The identifier of the resource.")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public PaymentMethod klarna(KlarnaInfo klarna) {
        this.klarna = klarna;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="klarna")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public KlarnaInfo getKlarna() {
        return this.klarna;
    }

    @JsonProperty(value="klarna")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setKlarna(KlarnaInfo klarna) {
        this.klarna = klarna;
    }

    public PaymentMethod mealVoucherFR(MealVoucherFRInfo mealVoucherFR) {
        this.mealVoucherFR = mealVoucherFR;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="mealVoucher_FR")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MealVoucherFRInfo getMealVoucherFR() {
        return this.mealVoucherFR;
    }

    @JsonProperty(value="mealVoucher_FR")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMealVoucherFR(MealVoucherFRInfo mealVoucherFR) {
        this.mealVoucherFR = mealVoucherFR;
    }

    public PaymentMethod paypal(PayPalInfo paypal) {
        this.paypal = paypal;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="paypal")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PayPalInfo getPaypal() {
        return this.paypal;
    }

    @JsonProperty(value="paypal")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPaypal(PayPalInfo paypal) {
        this.paypal = paypal;
    }

    public PaymentMethod reference(String reference) {
        this.reference = reference;
        return this;
    }

    @ApiModelProperty(value="Your reference for the payment method. Supported characters a-z, A-Z, 0-9.")
    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReference() {
        return this.reference;
    }

    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReference(String reference) {
        this.reference = reference;
    }

    public PaymentMethod shopperInteraction(String shopperInteraction) {
        this.shopperInteraction = shopperInteraction;
        return this;
    }

    @ApiModelProperty(value="The sales channel.")
    @JsonProperty(value="shopperInteraction")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getShopperInteraction() {
        return this.shopperInteraction;
    }

    @JsonProperty(value="shopperInteraction")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShopperInteraction(String shopperInteraction) {
        this.shopperInteraction = shopperInteraction;
    }

    public PaymentMethod sofort(SofortInfo sofort) {
        this.sofort = sofort;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="sofort")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SofortInfo getSofort() {
        return this.sofort;
    }

    @JsonProperty(value="sofort")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSofort(SofortInfo sofort) {
        this.sofort = sofort;
    }

    public PaymentMethod storeId(String storeId) {
        this.storeId = storeId;
        return this;
    }

    @ApiModelProperty(value="The ID of the [store](https://docs.adyen.com/api-explorer/#/ManagementService/latest/post/stores__resParam_id), if any.")
    @JsonProperty(value="storeId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStoreId() {
        return this.storeId;
    }

    @JsonProperty(value="storeId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStoreId(String storeId) {
        this.storeId = storeId;
    }

    public PaymentMethod swish(SwishInfo swish) {
        this.swish = swish;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="swish")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SwishInfo getSwish() {
        return this.swish;
    }

    @JsonProperty(value="swish")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSwish(SwishInfo swish) {
        this.swish = swish;
    }

    public PaymentMethod twint(TwintInfo twint) {
        this.twint = twint;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="twint")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TwintInfo getTwint() {
        return this.twint;
    }

    @JsonProperty(value="twint")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTwint(TwintInfo twint) {
        this.twint = twint;
    }

    public PaymentMethod type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="Payment method [variant](https://docs.adyen.com/development-resources/paymentmethodvariant#management-api).")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(String type) {
        this.type = type;
    }

    public PaymentMethod verificationStatus(VerificationStatusEnum verificationStatus) {
        this.verificationStatus = verificationStatus;
        return this;
    }

    @ApiModelProperty(value="Payment method status. Possible values: * **valid** * **pending** * **invalid** * **rejected**")
    @JsonProperty(value="verificationStatus")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public VerificationStatusEnum getVerificationStatus() {
        return this.verificationStatus;
    }

    @JsonProperty(value="verificationStatus")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVerificationStatus(VerificationStatusEnum verificationStatus) {
        this.verificationStatus = verificationStatus;
    }

    public PaymentMethod vipps(VippsInfo vipps) {
        this.vipps = vipps;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="vipps")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public VippsInfo getVipps() {
        return this.vipps;
    }

    @JsonProperty(value="vipps")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVipps(VippsInfo vipps) {
        this.vipps = vipps;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentMethod paymentMethod = (PaymentMethod)o;
        return Objects.equals(this.afterpayTouch, paymentMethod.afterpayTouch) && Objects.equals(this.allowed, paymentMethod.allowed) && Objects.equals(this.applePay, paymentMethod.applePay) && Objects.equals(this.bcmc, paymentMethod.bcmc) && Objects.equals(this.businessLineId, paymentMethod.businessLineId) && Objects.equals(this.cartesBancaires, paymentMethod.cartesBancaires) && Objects.equals(this.clearpay, paymentMethod.clearpay) && Objects.equals(this.countries, paymentMethod.countries) && Objects.equals(this.currencies, paymentMethod.currencies) && Objects.equals(this.customRoutingFlags, paymentMethod.customRoutingFlags) && Objects.equals(this.enabled, paymentMethod.enabled) && Objects.equals(this.giroPay, paymentMethod.giroPay) && Objects.equals(this.googlePay, paymentMethod.googlePay) && Objects.equals(this.id, paymentMethod.id) && Objects.equals(this.klarna, paymentMethod.klarna) && Objects.equals(this.mealVoucherFR, paymentMethod.mealVoucherFR) && Objects.equals(this.paypal, paymentMethod.paypal) && Objects.equals(this.reference, paymentMethod.reference) && Objects.equals(this.shopperInteraction, paymentMethod.shopperInteraction) && Objects.equals(this.sofort, paymentMethod.sofort) && Objects.equals(this.storeId, paymentMethod.storeId) && Objects.equals(this.swish, paymentMethod.swish) && Objects.equals(this.twint, paymentMethod.twint) && Objects.equals(this.type, paymentMethod.type) && Objects.equals((Object)this.verificationStatus, (Object)paymentMethod.verificationStatus) && Objects.equals(this.vipps, paymentMethod.vipps);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.afterpayTouch, this.allowed, this.applePay, this.bcmc, this.businessLineId, this.cartesBancaires, this.clearpay, this.countries, this.currencies, this.customRoutingFlags, this.enabled, this.giroPay, this.googlePay, this.id, this.klarna, this.mealVoucherFR, this.paypal, this.reference, this.shopperInteraction, this.sofort, this.storeId, this.swish, this.twint, this.type, this.verificationStatus, this.vipps});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentMethod {\n");
        sb.append("    afterpayTouch: ").append(this.toIndentedString(this.afterpayTouch)).append("\n");
        sb.append("    allowed: ").append(this.toIndentedString(this.allowed)).append("\n");
        sb.append("    applePay: ").append(this.toIndentedString(this.applePay)).append("\n");
        sb.append("    bcmc: ").append(this.toIndentedString(this.bcmc)).append("\n");
        sb.append("    businessLineId: ").append(this.toIndentedString(this.businessLineId)).append("\n");
        sb.append("    cartesBancaires: ").append(this.toIndentedString(this.cartesBancaires)).append("\n");
        sb.append("    clearpay: ").append(this.toIndentedString(this.clearpay)).append("\n");
        sb.append("    countries: ").append(this.toIndentedString(this.countries)).append("\n");
        sb.append("    currencies: ").append(this.toIndentedString(this.currencies)).append("\n");
        sb.append("    customRoutingFlags: ").append(this.toIndentedString(this.customRoutingFlags)).append("\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    giroPay: ").append(this.toIndentedString(this.giroPay)).append("\n");
        sb.append("    googlePay: ").append(this.toIndentedString(this.googlePay)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    klarna: ").append(this.toIndentedString(this.klarna)).append("\n");
        sb.append("    mealVoucherFR: ").append(this.toIndentedString(this.mealVoucherFR)).append("\n");
        sb.append("    paypal: ").append(this.toIndentedString(this.paypal)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    shopperInteraction: ").append(this.toIndentedString(this.shopperInteraction)).append("\n");
        sb.append("    sofort: ").append(this.toIndentedString(this.sofort)).append("\n");
        sb.append("    storeId: ").append(this.toIndentedString(this.storeId)).append("\n");
        sb.append("    swish: ").append(this.toIndentedString(this.swish)).append("\n");
        sb.append("    twint: ").append(this.toIndentedString(this.twint)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    verificationStatus: ").append(this.toIndentedString((Object)this.verificationStatus)).append("\n");
        sb.append("    vipps: ").append(this.toIndentedString(this.vipps)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static PaymentMethod fromJson(String jsonString) throws JsonProcessingException {
        return (PaymentMethod)JSON.getMapper().readValue(jsonString, PaymentMethod.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum VerificationStatusEnum {
        VALID("valid"),
        PENDING("pending"),
        INVALID("invalid"),
        REJECTED("rejected");

        private String value;

        private VerificationStatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static VerificationStatusEnum fromValue(String value) {
            for (VerificationStatusEnum b : VerificationStatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

