/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"allowedOrigins", "associatedMerchantAccounts", "description", "roles"})
public class CreateCompanyApiCredentialRequest {
    public static final String JSON_PROPERTY_ALLOWED_ORIGINS = "allowedOrigins";
    private List<String> allowedOrigins = null;
    public static final String JSON_PROPERTY_ASSOCIATED_MERCHANT_ACCOUNTS = "associatedMerchantAccounts";
    private List<String> associatedMerchantAccounts = null;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_ROLES = "roles";
    private List<String> roles = null;

    public CreateCompanyApiCredentialRequest allowedOrigins(List<String> allowedOrigins) {
        this.allowedOrigins = allowedOrigins;
        return this;
    }

    public CreateCompanyApiCredentialRequest addAllowedOriginsItem(String allowedOriginsItem) {
        if (this.allowedOrigins == null) {
            this.allowedOrigins = new ArrayList<String>();
        }
        this.allowedOrigins.add(allowedOriginsItem);
        return this;
    }

    @ApiModelProperty(value="List of [allowed origins](https://docs.adyen.com/development-resources/client-side-authentication#allowed-origins) for the new API credential.")
    @JsonProperty(value="allowedOrigins")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getAllowedOrigins() {
        return this.allowedOrigins;
    }

    @JsonProperty(value="allowedOrigins")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAllowedOrigins(List<String> allowedOrigins) {
        this.allowedOrigins = allowedOrigins;
    }

    public CreateCompanyApiCredentialRequest associatedMerchantAccounts(List<String> associatedMerchantAccounts) {
        this.associatedMerchantAccounts = associatedMerchantAccounts;
        return this;
    }

    public CreateCompanyApiCredentialRequest addAssociatedMerchantAccountsItem(String associatedMerchantAccountsItem) {
        if (this.associatedMerchantAccounts == null) {
            this.associatedMerchantAccounts = new ArrayList<String>();
        }
        this.associatedMerchantAccounts.add(associatedMerchantAccountsItem);
        return this;
    }

    @ApiModelProperty(value="List of merchant accounts that the API credential has access to.")
    @JsonProperty(value="associatedMerchantAccounts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getAssociatedMerchantAccounts() {
        return this.associatedMerchantAccounts;
    }

    @JsonProperty(value="associatedMerchantAccounts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAssociatedMerchantAccounts(List<String> associatedMerchantAccounts) {
        this.associatedMerchantAccounts = associatedMerchantAccounts;
    }

    public CreateCompanyApiCredentialRequest description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="Description of the API credential.")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public CreateCompanyApiCredentialRequest roles(List<String> roles) {
        this.roles = roles;
        return this;
    }

    public CreateCompanyApiCredentialRequest addRolesItem(String rolesItem) {
        if (this.roles == null) {
            this.roles = new ArrayList<String>();
        }
        this.roles.add(rolesItem);
        return this;
    }

    @ApiModelProperty(value="List of [roles](https://docs.adyen.com/development-resources/api-credentials#roles-1) for the API credential. Only roles assigned to 'ws@Company.<CompanyName>' can be assigned to other API credentials.")
    @JsonProperty(value="roles")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getRoles() {
        return this.roles;
    }

    @JsonProperty(value="roles")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRoles(List<String> roles) {
        this.roles = roles;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateCompanyApiCredentialRequest createCompanyApiCredentialRequest = (CreateCompanyApiCredentialRequest)o;
        return Objects.equals(this.allowedOrigins, createCompanyApiCredentialRequest.allowedOrigins) && Objects.equals(this.associatedMerchantAccounts, createCompanyApiCredentialRequest.associatedMerchantAccounts) && Objects.equals(this.description, createCompanyApiCredentialRequest.description) && Objects.equals(this.roles, createCompanyApiCredentialRequest.roles);
    }

    public int hashCode() {
        return Objects.hash(this.allowedOrigins, this.associatedMerchantAccounts, this.description, this.roles);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateCompanyApiCredentialRequest {\n");
        sb.append("    allowedOrigins: ").append(this.toIndentedString(this.allowedOrigins)).append("\n");
        sb.append("    associatedMerchantAccounts: ").append(this.toIndentedString(this.associatedMerchantAccounts)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    roles: ").append(this.toIndentedString(this.roles)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static CreateCompanyApiCredentialRequest fromJson(String jsonString) throws JsonProcessingException {
        return (CreateCompanyApiCredentialRequest)JSON.getMapper().readValue(jsonString, CreateCompanyApiCredentialRequest.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

