/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.configurationwebhooks;

import com.adyen.model.configurationwebhooks.JSON;
import com.adyen.model.configurationwebhooks.PaymentInstrumentNotificationData;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"data", "environment", "type"})
public class PaymentNotificationRequest {
    public static final String JSON_PROPERTY_DATA = "data";
    private PaymentInstrumentNotificationData data;
    public static final String JSON_PROPERTY_ENVIRONMENT = "environment";
    private String environment;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;

    public PaymentNotificationRequest data(PaymentInstrumentNotificationData data) {
        this.data = data;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="data")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PaymentInstrumentNotificationData getData() {
        return this.data;
    }

    @JsonProperty(value="data")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setData(PaymentInstrumentNotificationData data) {
        this.data = data;
    }

    public PaymentNotificationRequest environment(String environment) {
        this.environment = environment;
        return this;
    }

    @ApiModelProperty(required=true, value="The environment from which the webhook originated.  Possible values: **test**, **live**.")
    @JsonProperty(value="environment")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEnvironment() {
        return this.environment;
    }

    @JsonProperty(value="environment")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public PaymentNotificationRequest type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="Type of webhook.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentNotificationRequest paymentNotificationRequest = (PaymentNotificationRequest)o;
        return Objects.equals(this.data, paymentNotificationRequest.data) && Objects.equals(this.environment, paymentNotificationRequest.environment) && Objects.equals((Object)this.type, (Object)paymentNotificationRequest.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.data, this.environment, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentNotificationRequest {\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("    environment: ").append(this.toIndentedString(this.environment)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static PaymentNotificationRequest fromJson(String jsonString) throws JsonProcessingException {
        return (PaymentNotificationRequest)JSON.getMapper().readValue(jsonString, PaymentNotificationRequest.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum TypeEnum {
        CREATED("balancePlatform.paymentInstrument.created"),
        UPDATED("balancePlatform.paymentInstrument.updated");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

