/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.configurationwebhooks;

import com.adyen.model.configurationwebhooks.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"status", "statusError", "statusErrorMessage", "trackingNumber"})
public class CardOrderItemDeliveryStatus {
    public static final String JSON_PROPERTY_STATUS = "status";
    private StatusEnum status;
    public static final String JSON_PROPERTY_STATUS_ERROR = "statusError";
    private String statusError;
    public static final String JSON_PROPERTY_STATUS_ERROR_MESSAGE = "statusErrorMessage";
    private String statusErrorMessage;
    public static final String JSON_PROPERTY_TRACKING_NUMBER = "trackingNumber";
    private String trackingNumber;

    public CardOrderItemDeliveryStatus status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="Status of the delivery.")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StatusEnum getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public CardOrderItemDeliveryStatus statusError(String statusError) {
        this.statusError = statusError;
        return this;
    }

    @ApiModelProperty(value="Error status, if any.")
    @JsonProperty(value="statusError")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStatusError() {
        return this.statusError;
    }

    @JsonProperty(value="statusError")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatusError(String statusError) {
        this.statusError = statusError;
    }

    public CardOrderItemDeliveryStatus statusErrorMessage(String statusErrorMessage) {
        this.statusErrorMessage = statusErrorMessage;
        return this;
    }

    @ApiModelProperty(value="Error message, if any.")
    @JsonProperty(value="statusErrorMessage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStatusErrorMessage() {
        return this.statusErrorMessage;
    }

    @JsonProperty(value="statusErrorMessage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatusErrorMessage(String statusErrorMessage) {
        this.statusErrorMessage = statusErrorMessage;
    }

    public CardOrderItemDeliveryStatus trackingNumber(String trackingNumber) {
        this.trackingNumber = trackingNumber;
        return this;
    }

    @ApiModelProperty(value="Tracking number of the delivery.")
    @JsonProperty(value="trackingNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTrackingNumber() {
        return this.trackingNumber;
    }

    @JsonProperty(value="trackingNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTrackingNumber(String trackingNumber) {
        this.trackingNumber = trackingNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CardOrderItemDeliveryStatus cardOrderItemDeliveryStatus = (CardOrderItemDeliveryStatus)o;
        return Objects.equals((Object)this.status, (Object)cardOrderItemDeliveryStatus.status) && Objects.equals(this.statusError, cardOrderItemDeliveryStatus.statusError) && Objects.equals(this.statusErrorMessage, cardOrderItemDeliveryStatus.statusErrorMessage) && Objects.equals(this.trackingNumber, cardOrderItemDeliveryStatus.trackingNumber);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.status, this.statusError, this.statusErrorMessage, this.trackingNumber});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CardOrderItemDeliveryStatus {\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    statusError: ").append(this.toIndentedString(this.statusError)).append("\n");
        sb.append("    statusErrorMessage: ").append(this.toIndentedString(this.statusErrorMessage)).append("\n");
        sb.append("    trackingNumber: ").append(this.toIndentedString(this.trackingNumber)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static CardOrderItemDeliveryStatus fromJson(String jsonString) throws JsonProcessingException {
        return (CardOrderItemDeliveryStatus)JSON.getMapper().readValue(jsonString, CardOrderItemDeliveryStatus.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum StatusEnum {
        CREATED("created"),
        DELIVERED("delivered"),
        PROCESSING("processing"),
        PRODUCED("produced"),
        REJECTED("rejected"),
        SHIPPED("shipped"),
        UNKNOWN("unknown");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

