/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.service.management;

import com.adyen.Client;
import com.adyen.Service;
import com.adyen.constants.ApiConstants;
import com.adyen.model.RequestOptions;
import com.adyen.model.management.ApplePayInfo;
import com.adyen.model.management.PaymentMethod;
import com.adyen.model.management.PaymentMethodResponse;
import com.adyen.model.management.PaymentMethodSetupInfo;
import com.adyen.model.management.UpdatePaymentMethodInfo;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.Resource;
import java.io.IOException;
import java.util.HashMap;

public class PaymentMethodsMerchantLevelApi
extends Service {
    private final String baseURL = this.createBaseURL("https://management-test.adyen.com/v1");

    public PaymentMethodsMerchantLevelApi(Client client) {
        super(client);
    }

    public PaymentMethodResponse getAllPaymentMethods(String merchantId) throws ApiException, IOException {
        return this.getAllPaymentMethods(merchantId, null, null, null, null, null);
    }

    public PaymentMethodResponse getAllPaymentMethods(String merchantId, String storeId, String businessLineId, Integer pageSize, Integer pageNumber, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (merchantId == null) {
            throw new IllegalArgumentException("Please provide the merchantId path parameter");
        }
        pathParams.put("merchantId", merchantId);
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (storeId != null) {
            queryParams.put("storeId", storeId);
        }
        if (businessLineId != null) {
            queryParams.put("businessLineId", businessLineId);
        }
        if (pageSize != null) {
            queryParams.put("pageSize", pageSize.toString());
        }
        if (pageNumber != null) {
            queryParams.put("pageNumber", pageNumber.toString());
        }
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/merchants/{merchantId}/paymentMethodSettings", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams, queryParams);
        return PaymentMethodResponse.fromJson(jsonResult);
    }

    public PaymentMethod getPaymentMethodDetails(String merchantId, String paymentMethodId) throws ApiException, IOException {
        return this.getPaymentMethodDetails(merchantId, paymentMethodId, null);
    }

    public PaymentMethod getPaymentMethodDetails(String merchantId, String paymentMethodId, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (merchantId == null) {
            throw new IllegalArgumentException("Please provide the merchantId path parameter");
        }
        pathParams.put("merchantId", merchantId);
        if (paymentMethodId == null) {
            throw new IllegalArgumentException("Please provide the paymentMethodId path parameter");
        }
        pathParams.put("paymentMethodId", paymentMethodId);
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/merchants/{merchantId}/paymentMethodSettings/{paymentMethodId}", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams);
        return PaymentMethod.fromJson(jsonResult);
    }

    public ApplePayInfo getApplePayDomains(String merchantId, String paymentMethodId) throws ApiException, IOException {
        return this.getApplePayDomains(merchantId, paymentMethodId, null);
    }

    public ApplePayInfo getApplePayDomains(String merchantId, String paymentMethodId, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (merchantId == null) {
            throw new IllegalArgumentException("Please provide the merchantId path parameter");
        }
        pathParams.put("merchantId", merchantId);
        if (paymentMethodId == null) {
            throw new IllegalArgumentException("Please provide the paymentMethodId path parameter");
        }
        pathParams.put("paymentMethodId", paymentMethodId);
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/merchants/{merchantId}/paymentMethodSettings/{paymentMethodId}/getApplePayDomains", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams);
        return ApplePayInfo.fromJson(jsonResult);
    }

    public PaymentMethod updatePaymentMethod(String merchantId, String paymentMethodId, UpdatePaymentMethodInfo updatePaymentMethodInfo) throws ApiException, IOException {
        return this.updatePaymentMethod(merchantId, paymentMethodId, updatePaymentMethodInfo, null);
    }

    public PaymentMethod updatePaymentMethod(String merchantId, String paymentMethodId, UpdatePaymentMethodInfo updatePaymentMethodInfo, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (merchantId == null) {
            throw new IllegalArgumentException("Please provide the merchantId path parameter");
        }
        pathParams.put("merchantId", merchantId);
        if (paymentMethodId == null) {
            throw new IllegalArgumentException("Please provide the paymentMethodId path parameter");
        }
        pathParams.put("paymentMethodId", paymentMethodId);
        String requestBody = updatePaymentMethodInfo.toJson();
        Resource resource = new Resource(this, this.baseURL + "/merchants/{merchantId}/paymentMethodSettings/{paymentMethodId}", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.PATCH, pathParams);
        return PaymentMethod.fromJson(jsonResult);
    }

    public PaymentMethod requestPaymentMethod(String merchantId, PaymentMethodSetupInfo paymentMethodSetupInfo) throws ApiException, IOException {
        return this.requestPaymentMethod(merchantId, paymentMethodSetupInfo, null);
    }

    public PaymentMethod requestPaymentMethod(String merchantId, PaymentMethodSetupInfo paymentMethodSetupInfo, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (merchantId == null) {
            throw new IllegalArgumentException("Please provide the merchantId path parameter");
        }
        pathParams.put("merchantId", merchantId);
        String requestBody = paymentMethodSetupInfo.toJson();
        Resource resource = new Resource(this, this.baseURL + "/merchants/{merchantId}/paymentMethodSettings", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, pathParams);
        return PaymentMethod.fromJson(jsonResult);
    }

    public void addApplePayDomain(String merchantId, String paymentMethodId, ApplePayInfo applePayInfo) throws ApiException, IOException {
        this.addApplePayDomain(merchantId, paymentMethodId, applePayInfo, null);
    }

    public void addApplePayDomain(String merchantId, String paymentMethodId, ApplePayInfo applePayInfo, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (merchantId == null) {
            throw new IllegalArgumentException("Please provide the merchantId path parameter");
        }
        pathParams.put("merchantId", merchantId);
        if (paymentMethodId == null) {
            throw new IllegalArgumentException("Please provide the paymentMethodId path parameter");
        }
        pathParams.put("paymentMethodId", paymentMethodId);
        String requestBody = applePayInfo.toJson();
        Resource resource = new Resource(this, this.baseURL + "/merchants/{merchantId}/paymentMethodSettings/{paymentMethodId}/addApplePayDomains", null);
        resource.request(requestBody, null, ApiConstants.HttpMethod.POST, pathParams);
    }
}

