/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.posterminalmanagement;

import com.adyen.model.posterminalmanagement.JSON;
import com.adyen.model.posterminalmanagement.Store;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GetTerminalDetailsResponse {
    public static final String SERIALIZED_NAME_BLUETOOTH_IP = "bluetoothIp";
    @SerializedName(value="bluetoothIp")
    private String bluetoothIp;
    public static final String SERIALIZED_NAME_BLUETOOTH_MAC = "bluetoothMac";
    @SerializedName(value="bluetoothMac")
    private String bluetoothMac;
    public static final String SERIALIZED_NAME_COMPANY_ACCOUNT = "companyAccount";
    @SerializedName(value="companyAccount")
    private String companyAccount;
    public static final String SERIALIZED_NAME_COUNTRY = "country";
    @SerializedName(value="country")
    private String country;
    public static final String SERIALIZED_NAME_DEVICE_MODEL = "deviceModel";
    @SerializedName(value="deviceModel")
    private String deviceModel;
    public static final String SERIALIZED_NAME_DHCP_ENABLED = "dhcpEnabled";
    @SerializedName(value="dhcpEnabled")
    private Boolean dhcpEnabled;
    public static final String SERIALIZED_NAME_DISPLAY_LABEL = "displayLabel";
    @SerializedName(value="displayLabel")
    private String displayLabel;
    public static final String SERIALIZED_NAME_ETHERNET_IP = "ethernetIp";
    @SerializedName(value="ethernetIp")
    private String ethernetIp;
    public static final String SERIALIZED_NAME_ETHERNET_MAC = "ethernetMac";
    @SerializedName(value="ethernetMac")
    private String ethernetMac;
    public static final String SERIALIZED_NAME_FIRMWARE_VERSION = "firmwareVersion";
    @SerializedName(value="firmwareVersion")
    private String firmwareVersion;
    public static final String SERIALIZED_NAME_ICCID = "iccid";
    @SerializedName(value="iccid")
    private String iccid;
    public static final String SERIALIZED_NAME_LAST_ACTIVITY_DATE_TIME = "lastActivityDateTime";
    @SerializedName(value="lastActivityDateTime")
    private OffsetDateTime lastActivityDateTime;
    public static final String SERIALIZED_NAME_LAST_TRANSACTION_DATE_TIME = "lastTransactionDateTime";
    @SerializedName(value="lastTransactionDateTime")
    private OffsetDateTime lastTransactionDateTime;
    public static final String SERIALIZED_NAME_LINK_NEGOTIATION = "linkNegotiation";
    @SerializedName(value="linkNegotiation")
    private String linkNegotiation;
    public static final String SERIALIZED_NAME_MERCHANT_ACCOUNT = "merchantAccount";
    @SerializedName(value="merchantAccount")
    private String merchantAccount;
    public static final String SERIALIZED_NAME_MERCHANT_INVENTORY = "merchantInventory";
    @SerializedName(value="merchantInventory")
    private Boolean merchantInventory;
    public static final String SERIALIZED_NAME_PERMANENT_TERMINAL_ID = "permanentTerminalId";
    @SerializedName(value="permanentTerminalId")
    private String permanentTerminalId;
    public static final String SERIALIZED_NAME_SERIAL_NUMBER = "serialNumber";
    @SerializedName(value="serialNumber")
    private String serialNumber;
    public static final String SERIALIZED_NAME_SIM_STATUS = "simStatus";
    @SerializedName(value="simStatus")
    private String simStatus;
    public static final String SERIALIZED_NAME_STORE = "store";
    @SerializedName(value="store")
    private String store;
    public static final String SERIALIZED_NAME_STORE_DETAILS = "storeDetails";
    @SerializedName(value="storeDetails")
    private Store storeDetails;
    public static final String SERIALIZED_NAME_TERMINAL = "terminal";
    @SerializedName(value="terminal")
    private String terminal;
    public static final String SERIALIZED_NAME_TERMINAL_STATUS = "terminalStatus";
    @SerializedName(value="terminalStatus")
    private TerminalStatusEnum terminalStatus;
    public static final String SERIALIZED_NAME_WIFI_IP = "wifiIp";
    @SerializedName(value="wifiIp")
    private String wifiIp;
    public static final String SERIALIZED_NAME_WIFI_MAC = "wifiMac";
    @SerializedName(value="wifiMac")
    private String wifiMac;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public GetTerminalDetailsResponse bluetoothIp(String bluetoothIp) {
        this.bluetoothIp = bluetoothIp;
        return this;
    }

    @ApiModelProperty(value="The Bluetooth IP address of the terminal.")
    public String getBluetoothIp() {
        return this.bluetoothIp;
    }

    public void setBluetoothIp(String bluetoothIp) {
        this.bluetoothIp = bluetoothIp;
    }

    public GetTerminalDetailsResponse bluetoothMac(String bluetoothMac) {
        this.bluetoothMac = bluetoothMac;
        return this;
    }

    @ApiModelProperty(value="The Bluetooth MAC address of the terminal.")
    public String getBluetoothMac() {
        return this.bluetoothMac;
    }

    public void setBluetoothMac(String bluetoothMac) {
        this.bluetoothMac = bluetoothMac;
    }

    public GetTerminalDetailsResponse companyAccount(String companyAccount) {
        this.companyAccount = companyAccount;
        return this;
    }

    @ApiModelProperty(required=true, value="The company account that the terminal is associated with. If this is the only account level shown in the response, the terminal is assigned to the inventory of the company account.")
    public String getCompanyAccount() {
        return this.companyAccount;
    }

    public void setCompanyAccount(String companyAccount) {
        this.companyAccount = companyAccount;
    }

    public GetTerminalDetailsResponse country(String country) {
        this.country = country;
        return this;
    }

    @ApiModelProperty(value="The country where the terminal is used.")
    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public GetTerminalDetailsResponse deviceModel(String deviceModel) {
        this.deviceModel = deviceModel;
        return this;
    }

    @ApiModelProperty(value="The model name of the terminal.")
    public String getDeviceModel() {
        return this.deviceModel;
    }

    public void setDeviceModel(String deviceModel) {
        this.deviceModel = deviceModel;
    }

    public GetTerminalDetailsResponse dhcpEnabled(Boolean dhcpEnabled) {
        this.dhcpEnabled = dhcpEnabled;
        return this;
    }

    @ApiModelProperty(value="Indicates whether assigning IP addresses through a DHCP server is enabled on the terminal.")
    public Boolean getDhcpEnabled() {
        return this.dhcpEnabled;
    }

    public void setDhcpEnabled(Boolean dhcpEnabled) {
        this.dhcpEnabled = dhcpEnabled;
    }

    public GetTerminalDetailsResponse displayLabel(String displayLabel) {
        this.displayLabel = displayLabel;
        return this;
    }

    @ApiModelProperty(value="The label shown on the status bar of the display. This label (if any) is specified in your Customer Area.")
    public String getDisplayLabel() {
        return this.displayLabel;
    }

    public void setDisplayLabel(String displayLabel) {
        this.displayLabel = displayLabel;
    }

    public GetTerminalDetailsResponse ethernetIp(String ethernetIp) {
        this.ethernetIp = ethernetIp;
        return this;
    }

    @ApiModelProperty(value="The terminal's IP address in your Ethernet network.")
    public String getEthernetIp() {
        return this.ethernetIp;
    }

    public void setEthernetIp(String ethernetIp) {
        this.ethernetIp = ethernetIp;
    }

    public GetTerminalDetailsResponse ethernetMac(String ethernetMac) {
        this.ethernetMac = ethernetMac;
        return this;
    }

    @ApiModelProperty(value="The terminal's MAC address in your Ethernet network.")
    public String getEthernetMac() {
        return this.ethernetMac;
    }

    public void setEthernetMac(String ethernetMac) {
        this.ethernetMac = ethernetMac;
    }

    public GetTerminalDetailsResponse firmwareVersion(String firmwareVersion) {
        this.firmwareVersion = firmwareVersion;
        return this;
    }

    @ApiModelProperty(value="The software release currently in use on the terminal.")
    public String getFirmwareVersion() {
        return this.firmwareVersion;
    }

    public void setFirmwareVersion(String firmwareVersion) {
        this.firmwareVersion = firmwareVersion;
    }

    public GetTerminalDetailsResponse iccid(String iccid) {
        this.iccid = iccid;
        return this;
    }

    @ApiModelProperty(value="The integrated circuit card identifier (ICCID) of the SIM card in the terminal.")
    public String getIccid() {
        return this.iccid;
    }

    public void setIccid(String iccid) {
        this.iccid = iccid;
    }

    public GetTerminalDetailsResponse lastActivityDateTime(OffsetDateTime lastActivityDateTime) {
        this.lastActivityDateTime = lastActivityDateTime;
        return this;
    }

    @ApiModelProperty(value="Date and time of the last activity on the terminal. Not included when the last activity was more than 14 days ago.")
    public OffsetDateTime getLastActivityDateTime() {
        return this.lastActivityDateTime;
    }

    public void setLastActivityDateTime(OffsetDateTime lastActivityDateTime) {
        this.lastActivityDateTime = lastActivityDateTime;
    }

    public GetTerminalDetailsResponse lastTransactionDateTime(OffsetDateTime lastTransactionDateTime) {
        this.lastTransactionDateTime = lastTransactionDateTime;
        return this;
    }

    @ApiModelProperty(value="Date and time of the last transaction on the terminal. Not included when the last transaction was more than 14 days ago.")
    public OffsetDateTime getLastTransactionDateTime() {
        return this.lastTransactionDateTime;
    }

    public void setLastTransactionDateTime(OffsetDateTime lastTransactionDateTime) {
        this.lastTransactionDateTime = lastTransactionDateTime;
    }

    public GetTerminalDetailsResponse linkNegotiation(String linkNegotiation) {
        this.linkNegotiation = linkNegotiation;
        return this;
    }

    @ApiModelProperty(value="The Ethernet link negotiation that the terminal uses:   - `auto`: Auto-negotiation  - `100full`: 100 Mbps full duplex")
    public String getLinkNegotiation() {
        return this.linkNegotiation;
    }

    public void setLinkNegotiation(String linkNegotiation) {
        this.linkNegotiation = linkNegotiation;
    }

    public GetTerminalDetailsResponse merchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
        return this;
    }

    @ApiModelProperty(value="The merchant account that the terminal is associated with. If the response doesn't contain a `store` the terminal is assigned to this merchant account.")
    public String getMerchantAccount() {
        return this.merchantAccount;
    }

    public void setMerchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
    }

    public GetTerminalDetailsResponse merchantInventory(Boolean merchantInventory) {
        this.merchantInventory = merchantInventory;
        return this;
    }

    @ApiModelProperty(value="Boolean that indicates if the terminal is assigned to the merchant inventory. This is returned when the terminal is assigned to a merchant account.  - If **true**, this indicates that the terminal is in the merchant inventory. This also means that the terminal cannot be boarded.  - If **false**, this indicates that the terminal is assigned to the merchant account as an in-store terminal. This means that the terminal is ready to be boarded, or is already boarded.")
    public Boolean getMerchantInventory() {
        return this.merchantInventory;
    }

    public void setMerchantInventory(Boolean merchantInventory) {
        this.merchantInventory = merchantInventory;
    }

    public GetTerminalDetailsResponse permanentTerminalId(String permanentTerminalId) {
        this.permanentTerminalId = permanentTerminalId;
        return this;
    }

    @ApiModelProperty(value="The permanent terminal ID.")
    public String getPermanentTerminalId() {
        return this.permanentTerminalId;
    }

    public void setPermanentTerminalId(String permanentTerminalId) {
        this.permanentTerminalId = permanentTerminalId;
    }

    public GetTerminalDetailsResponse serialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
        return this;
    }

    @ApiModelProperty(value="The serial number of the terminal.")
    public String getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    public GetTerminalDetailsResponse simStatus(String simStatus) {
        this.simStatus = simStatus;
        return this;
    }

    @ApiModelProperty(value="On a terminal that supports 3G or 4G connectivity, indicates the status of the SIM card in the terminal: ACTIVE or INVENTORY.")
    public String getSimStatus() {
        return this.simStatus;
    }

    public void setSimStatus(String simStatus) {
        this.simStatus = simStatus;
    }

    public GetTerminalDetailsResponse store(String store) {
        this.store = store;
        return this;
    }

    @ApiModelProperty(value="The store code of the store that the terminal is assigned to.")
    public String getStore() {
        return this.store;
    }

    public void setStore(String store) {
        this.store = store;
    }

    public GetTerminalDetailsResponse storeDetails(Store storeDetails) {
        this.storeDetails = storeDetails;
        return this;
    }

    @ApiModelProperty(value="")
    public Store getStoreDetails() {
        return this.storeDetails;
    }

    public void setStoreDetails(Store storeDetails) {
        this.storeDetails = storeDetails;
    }

    public GetTerminalDetailsResponse terminal(String terminal) {
        this.terminal = terminal;
        return this;
    }

    @ApiModelProperty(required=true, value="The unique terminal ID.")
    public String getTerminal() {
        return this.terminal;
    }

    public void setTerminal(String terminal) {
        this.terminal = terminal;
    }

    public GetTerminalDetailsResponse terminalStatus(TerminalStatusEnum terminalStatus) {
        this.terminalStatus = terminalStatus;
        return this;
    }

    @ApiModelProperty(value="The status of the terminal:   - `OnlineToday`, `OnlineLast1Day`, `OnlineLast2Days` etcetera to `OnlineLast7Days`: Indicates when in the past week the terminal was last online.   - `SwitchedOff`: Indicates it was more than a week ago that the terminal was last online.   - `ReAssignToInventoryPending`, `ReAssignToStorePending`, `ReAssignToMerchantInventoryPending`: Indicates the terminal is scheduled to be reassigned.")
    public TerminalStatusEnum getTerminalStatus() {
        return this.terminalStatus;
    }

    public void setTerminalStatus(TerminalStatusEnum terminalStatus) {
        this.terminalStatus = terminalStatus;
    }

    public GetTerminalDetailsResponse wifiIp(String wifiIp) {
        this.wifiIp = wifiIp;
        return this;
    }

    @ApiModelProperty(value="The terminal's IP address in your Wi-Fi network.")
    public String getWifiIp() {
        return this.wifiIp;
    }

    public void setWifiIp(String wifiIp) {
        this.wifiIp = wifiIp;
    }

    public GetTerminalDetailsResponse wifiMac(String wifiMac) {
        this.wifiMac = wifiMac;
        return this;
    }

    @ApiModelProperty(value="The terminal's MAC address in your Wi-Fi network.")
    public String getWifiMac() {
        return this.wifiMac;
    }

    public void setWifiMac(String wifiMac) {
        this.wifiMac = wifiMac;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetTerminalDetailsResponse getTerminalDetailsResponse = (GetTerminalDetailsResponse)o;
        return Objects.equals(this.bluetoothIp, getTerminalDetailsResponse.bluetoothIp) && Objects.equals(this.bluetoothMac, getTerminalDetailsResponse.bluetoothMac) && Objects.equals(this.companyAccount, getTerminalDetailsResponse.companyAccount) && Objects.equals(this.country, getTerminalDetailsResponse.country) && Objects.equals(this.deviceModel, getTerminalDetailsResponse.deviceModel) && Objects.equals(this.dhcpEnabled, getTerminalDetailsResponse.dhcpEnabled) && Objects.equals(this.displayLabel, getTerminalDetailsResponse.displayLabel) && Objects.equals(this.ethernetIp, getTerminalDetailsResponse.ethernetIp) && Objects.equals(this.ethernetMac, getTerminalDetailsResponse.ethernetMac) && Objects.equals(this.firmwareVersion, getTerminalDetailsResponse.firmwareVersion) && Objects.equals(this.iccid, getTerminalDetailsResponse.iccid) && Objects.equals(this.lastActivityDateTime, getTerminalDetailsResponse.lastActivityDateTime) && Objects.equals(this.lastTransactionDateTime, getTerminalDetailsResponse.lastTransactionDateTime) && Objects.equals(this.linkNegotiation, getTerminalDetailsResponse.linkNegotiation) && Objects.equals(this.merchantAccount, getTerminalDetailsResponse.merchantAccount) && Objects.equals(this.merchantInventory, getTerminalDetailsResponse.merchantInventory) && Objects.equals(this.permanentTerminalId, getTerminalDetailsResponse.permanentTerminalId) && Objects.equals(this.serialNumber, getTerminalDetailsResponse.serialNumber) && Objects.equals(this.simStatus, getTerminalDetailsResponse.simStatus) && Objects.equals(this.store, getTerminalDetailsResponse.store) && Objects.equals(this.storeDetails, getTerminalDetailsResponse.storeDetails) && Objects.equals(this.terminal, getTerminalDetailsResponse.terminal) && Objects.equals((Object)this.terminalStatus, (Object)getTerminalDetailsResponse.terminalStatus) && Objects.equals(this.wifiIp, getTerminalDetailsResponse.wifiIp) && Objects.equals(this.wifiMac, getTerminalDetailsResponse.wifiMac);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.bluetoothIp, this.bluetoothMac, this.companyAccount, this.country, this.deviceModel, this.dhcpEnabled, this.displayLabel, this.ethernetIp, this.ethernetMac, this.firmwareVersion, this.iccid, this.lastActivityDateTime, this.lastTransactionDateTime, this.linkNegotiation, this.merchantAccount, this.merchantInventory, this.permanentTerminalId, this.serialNumber, this.simStatus, this.store, this.storeDetails, this.terminal, this.terminalStatus, this.wifiIp, this.wifiMac});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GetTerminalDetailsResponse {\n");
        sb.append("    bluetoothIp: ").append(this.toIndentedString(this.bluetoothIp)).append("\n");
        sb.append("    bluetoothMac: ").append(this.toIndentedString(this.bluetoothMac)).append("\n");
        sb.append("    companyAccount: ").append(this.toIndentedString(this.companyAccount)).append("\n");
        sb.append("    country: ").append(this.toIndentedString(this.country)).append("\n");
        sb.append("    deviceModel: ").append(this.toIndentedString(this.deviceModel)).append("\n");
        sb.append("    dhcpEnabled: ").append(this.toIndentedString(this.dhcpEnabled)).append("\n");
        sb.append("    displayLabel: ").append(this.toIndentedString(this.displayLabel)).append("\n");
        sb.append("    ethernetIp: ").append(this.toIndentedString(this.ethernetIp)).append("\n");
        sb.append("    ethernetMac: ").append(this.toIndentedString(this.ethernetMac)).append("\n");
        sb.append("    firmwareVersion: ").append(this.toIndentedString(this.firmwareVersion)).append("\n");
        sb.append("    iccid: ").append(this.toIndentedString(this.iccid)).append("\n");
        sb.append("    lastActivityDateTime: ").append(this.toIndentedString(this.lastActivityDateTime)).append("\n");
        sb.append("    lastTransactionDateTime: ").append(this.toIndentedString(this.lastTransactionDateTime)).append("\n");
        sb.append("    linkNegotiation: ").append(this.toIndentedString(this.linkNegotiation)).append("\n");
        sb.append("    merchantAccount: ").append(this.toIndentedString(this.merchantAccount)).append("\n");
        sb.append("    merchantInventory: ").append(this.toIndentedString(this.merchantInventory)).append("\n");
        sb.append("    permanentTerminalId: ").append(this.toIndentedString(this.permanentTerminalId)).append("\n");
        sb.append("    serialNumber: ").append(this.toIndentedString(this.serialNumber)).append("\n");
        sb.append("    simStatus: ").append(this.toIndentedString(this.simStatus)).append("\n");
        sb.append("    store: ").append(this.toIndentedString(this.store)).append("\n");
        sb.append("    storeDetails: ").append(this.toIndentedString(this.storeDetails)).append("\n");
        sb.append("    terminal: ").append(this.toIndentedString(this.terminal)).append("\n");
        sb.append("    terminalStatus: ").append(this.toIndentedString((Object)this.terminalStatus)).append("\n");
        sb.append("    wifiIp: ").append(this.toIndentedString(this.wifiIp)).append("\n");
        sb.append("    wifiMac: ").append(this.toIndentedString(this.wifiMac)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in GetTerminalDetailsResponse is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `GetTerminalDetailsResponse` properties.", entry.getKey()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_BLUETOOTH_IP) != null && !jsonObj.get(SERIALIZED_NAME_BLUETOOTH_IP).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `bluetoothIp` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BLUETOOTH_IP).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_BLUETOOTH_MAC) != null && !jsonObj.get(SERIALIZED_NAME_BLUETOOTH_MAC).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `bluetoothMac` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BLUETOOTH_MAC).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_COMPANY_ACCOUNT) != null && !jsonObj.get(SERIALIZED_NAME_COMPANY_ACCOUNT).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `companyAccount` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_COMPANY_ACCOUNT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_COUNTRY) != null && !jsonObj.get(SERIALIZED_NAME_COUNTRY).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `country` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_COUNTRY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DEVICE_MODEL) != null && !jsonObj.get(SERIALIZED_NAME_DEVICE_MODEL).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `deviceModel` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DEVICE_MODEL).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DISPLAY_LABEL) != null && !jsonObj.get(SERIALIZED_NAME_DISPLAY_LABEL).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `displayLabel` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DISPLAY_LABEL).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ETHERNET_IP) != null && !jsonObj.get(SERIALIZED_NAME_ETHERNET_IP).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `ethernetIp` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ETHERNET_IP).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ETHERNET_MAC) != null && !jsonObj.get(SERIALIZED_NAME_ETHERNET_MAC).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `ethernetMac` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ETHERNET_MAC).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_FIRMWARE_VERSION) != null && !jsonObj.get(SERIALIZED_NAME_FIRMWARE_VERSION).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `firmwareVersion` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FIRMWARE_VERSION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ICCID) != null && !jsonObj.get(SERIALIZED_NAME_ICCID).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `iccid` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ICCID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_LINK_NEGOTIATION) != null && !jsonObj.get(SERIALIZED_NAME_LINK_NEGOTIATION).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `linkNegotiation` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_LINK_NEGOTIATION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MERCHANT_ACCOUNT) != null && !jsonObj.get(SERIALIZED_NAME_MERCHANT_ACCOUNT).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `merchantAccount` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MERCHANT_ACCOUNT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PERMANENT_TERMINAL_ID) != null && !jsonObj.get(SERIALIZED_NAME_PERMANENT_TERMINAL_ID).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `permanentTerminalId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PERMANENT_TERMINAL_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SERIAL_NUMBER) != null && !jsonObj.get(SERIALIZED_NAME_SERIAL_NUMBER).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `serialNumber` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SERIAL_NUMBER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SIM_STATUS) != null && !jsonObj.get(SERIALIZED_NAME_SIM_STATUS).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `simStatus` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SIM_STATUS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_STORE) != null && !jsonObj.get(SERIALIZED_NAME_STORE).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `store` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STORE).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_STORE_DETAILS) != null) {
            Store.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_STORE_DETAILS));
        }
        if (jsonObj.get(SERIALIZED_NAME_TERMINAL) != null && !jsonObj.get(SERIALIZED_NAME_TERMINAL).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `terminal` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TERMINAL).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TERMINAL_STATUS) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_TERMINAL_STATUS).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `terminalStatus` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TERMINAL_STATUS).toString()));
            }
            TerminalStatusEnum.fromValue(jsonObj.get(SERIALIZED_NAME_TERMINAL_STATUS).getAsString());
        }
        if (jsonObj.get(SERIALIZED_NAME_WIFI_IP) != null && !jsonObj.get(SERIALIZED_NAME_WIFI_IP).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `wifiIp` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_WIFI_IP).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_WIFI_MAC) != null && !jsonObj.get(SERIALIZED_NAME_WIFI_MAC).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `wifiMac` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_WIFI_MAC).toString()));
        }
    }

    public static GetTerminalDetailsResponse fromJson(String jsonString) throws IOException {
        return (GetTerminalDetailsResponse)JSON.getGson().fromJson(jsonString, GetTerminalDetailsResponse.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_BLUETOOTH_IP);
        openapiFields.add(SERIALIZED_NAME_BLUETOOTH_MAC);
        openapiFields.add(SERIALIZED_NAME_COMPANY_ACCOUNT);
        openapiFields.add(SERIALIZED_NAME_COUNTRY);
        openapiFields.add(SERIALIZED_NAME_DEVICE_MODEL);
        openapiFields.add(SERIALIZED_NAME_DHCP_ENABLED);
        openapiFields.add(SERIALIZED_NAME_DISPLAY_LABEL);
        openapiFields.add(SERIALIZED_NAME_ETHERNET_IP);
        openapiFields.add(SERIALIZED_NAME_ETHERNET_MAC);
        openapiFields.add(SERIALIZED_NAME_FIRMWARE_VERSION);
        openapiFields.add(SERIALIZED_NAME_ICCID);
        openapiFields.add(SERIALIZED_NAME_LAST_ACTIVITY_DATE_TIME);
        openapiFields.add(SERIALIZED_NAME_LAST_TRANSACTION_DATE_TIME);
        openapiFields.add(SERIALIZED_NAME_LINK_NEGOTIATION);
        openapiFields.add(SERIALIZED_NAME_MERCHANT_ACCOUNT);
        openapiFields.add(SERIALIZED_NAME_MERCHANT_INVENTORY);
        openapiFields.add(SERIALIZED_NAME_PERMANENT_TERMINAL_ID);
        openapiFields.add(SERIALIZED_NAME_SERIAL_NUMBER);
        openapiFields.add(SERIALIZED_NAME_SIM_STATUS);
        openapiFields.add(SERIALIZED_NAME_STORE);
        openapiFields.add(SERIALIZED_NAME_STORE_DETAILS);
        openapiFields.add(SERIALIZED_NAME_TERMINAL);
        openapiFields.add(SERIALIZED_NAME_TERMINAL_STATUS);
        openapiFields.add(SERIALIZED_NAME_WIFI_IP);
        openapiFields.add(SERIALIZED_NAME_WIFI_MAC);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_COMPANY_ACCOUNT);
        openapiRequiredFields.add(SERIALIZED_NAME_TERMINAL);
        log = Logger.getLogger(GetTerminalDetailsResponse.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!GetTerminalDetailsResponse.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(GetTerminalDetailsResponse.class));
            return new TypeAdapter<GetTerminalDetailsResponse>(){

                public void write(JsonWriter out, GetTerminalDetailsResponse value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public GetTerminalDetailsResponse read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    GetTerminalDetailsResponse.validateJsonObject(jsonObj);
                    return (GetTerminalDetailsResponse)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TerminalStatusEnum {
        ONLINELAST1DAY("OnlineLast1Day"),
        ONLINELAST2DAYS("OnlineLast2Days"),
        ONLINELAST3DAYS("OnlineLast3Days"),
        ONLINELAST4DAYS("OnlineLast4Days"),
        ONLINELAST5DAYS("OnlineLast5Days"),
        ONLINELAST6DAYS("OnlineLast6Days"),
        ONLINELAST7DAYS("OnlineLast7Days"),
        ONLINETODAY("OnlineToday"),
        REASSIGNTOINVENTORYPENDING("ReAssignToInventoryPending"),
        REASSIGNTOMERCHANTINVENTORYPENDING("ReAssignToMerchantInventoryPending"),
        REASSIGNTOSTOREPENDING("ReAssignToStorePending"),
        SWITCHEDOFF("SwitchedOff");

        private String value;

        private TerminalStatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TerminalStatusEnum fromValue(String value) {
            for (TerminalStatusEnum b : TerminalStatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<TerminalStatusEnum> {
            public void write(JsonWriter jsonWriter, TerminalStatusEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TerminalStatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TerminalStatusEnum.fromValue(value);
            }
        }
    }
}

