/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.posterminalmanagement;

import com.adyen.model.posterminalmanagement.JSON;
import com.adyen.model.posterminalmanagement.Store;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GetStoresUnderAccountResponse {
    public static final String SERIALIZED_NAME_STORES = "stores";
    @SerializedName(value="stores")
    private List<Store> stores = null;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public GetStoresUnderAccountResponse stores(List<Store> stores) {
        this.stores = stores;
        return this;
    }

    public GetStoresUnderAccountResponse addStoresItem(Store storesItem) {
        if (this.stores == null) {
            this.stores = new ArrayList<Store>();
        }
        this.stores.add(storesItem);
        return this;
    }

    @ApiModelProperty(value="Array that returns a list of all stores for the specified merchant account, or for all merchant accounts under the company account.")
    public List<Store> getStores() {
        return this.stores;
    }

    public void setStores(List<Store> stores) {
        this.stores = stores;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetStoresUnderAccountResponse getStoresUnderAccountResponse = (GetStoresUnderAccountResponse)o;
        return Objects.equals(this.stores, getStoresUnderAccountResponse.stores);
    }

    public int hashCode() {
        return Objects.hash(this.stores);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GetStoresUnderAccountResponse {\n");
        sb.append("    stores: ").append(this.toIndentedString(this.stores)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in GetStoresUnderAccountResponse is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `GetStoresUnderAccountResponse` properties.", entry.getKey()));
        }
        JsonArray jsonArraystores = jsonObj.getAsJsonArray(SERIALIZED_NAME_STORES);
        if (jsonArraystores != null) {
            if (!jsonObj.get(SERIALIZED_NAME_STORES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `stores` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STORES).toString()));
            }
            for (int i = 0; i < jsonArraystores.size(); ++i) {
                Store.validateJsonObject(jsonArraystores.get(i).getAsJsonObject());
            }
        }
    }

    public static GetStoresUnderAccountResponse fromJson(String jsonString) throws IOException {
        return (GetStoresUnderAccountResponse)JSON.getGson().fromJson(jsonString, GetStoresUnderAccountResponse.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_STORES);
        openapiRequiredFields = new HashSet();
        log = Logger.getLogger(GetStoresUnderAccountResponse.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!GetStoresUnderAccountResponse.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(GetStoresUnderAccountResponse.class));
            return new TypeAdapter<GetStoresUnderAccountResponse>(){

                public void write(JsonWriter out, GetStoresUnderAccountResponse value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public GetStoresUnderAccountResponse read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    GetStoresUnderAccountResponse.validateJsonObject(jsonObj);
                    return (GetStoresUnderAccountResponse)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

