/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.payment;

import com.adyen.model.payment.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ResponseAdditionalData3DSecure {
    public static final String SERIALIZED_NAME_CARD_HOLDER_INFO = "cardHolderInfo";
    @SerializedName(value="cardHolderInfo")
    private String cardHolderInfo;
    public static final String SERIALIZED_NAME_CAVV = "cavv";
    @SerializedName(value="cavv")
    private String cavv;
    public static final String SERIALIZED_NAME_CAVV_ALGORITHM = "cavvAlgorithm";
    @SerializedName(value="cavvAlgorithm")
    private String cavvAlgorithm;
    public static final String SERIALIZED_NAME_SCA_EXEMPTION_REQUESTED = "scaExemptionRequested";
    @SerializedName(value="scaExemptionRequested")
    private String scaExemptionRequested;
    public static final String SERIALIZED_NAME_THREEDS2_CARD_ENROLLED = "threeds2.cardEnrolled";
    @SerializedName(value="threeds2.cardEnrolled")
    private Boolean threeds2CardEnrolled;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public ResponseAdditionalData3DSecure cardHolderInfo(String cardHolderInfo) {
        this.cardHolderInfo = cardHolderInfo;
        return this;
    }

    @ApiModelProperty(value="Information provided by the issuer to the cardholder. If this field is present, you need to display this information to the cardholder. ")
    public String getCardHolderInfo() {
        return this.cardHolderInfo;
    }

    public void setCardHolderInfo(String cardHolderInfo) {
        this.cardHolderInfo = cardHolderInfo;
    }

    public ResponseAdditionalData3DSecure cavv(String cavv) {
        this.cavv = cavv;
        return this;
    }

    @ApiModelProperty(value="The Cardholder Authentication Verification Value (CAVV) for the 3D Secure authentication session, as a Base64-encoded 20-byte array.")
    public String getCavv() {
        return this.cavv;
    }

    public void setCavv(String cavv) {
        this.cavv = cavv;
    }

    public ResponseAdditionalData3DSecure cavvAlgorithm(String cavvAlgorithm) {
        this.cavvAlgorithm = cavvAlgorithm;
        return this;
    }

    @ApiModelProperty(value="The CAVV algorithm used.")
    public String getCavvAlgorithm() {
        return this.cavvAlgorithm;
    }

    public void setCavvAlgorithm(String cavvAlgorithm) {
        this.cavvAlgorithm = cavvAlgorithm;
    }

    public ResponseAdditionalData3DSecure scaExemptionRequested(String scaExemptionRequested) {
        this.scaExemptionRequested = scaExemptionRequested;
        return this;
    }

    @ApiModelProperty(value="Shows the [exemption type](https://docs.adyen.com/payments-fundamentals/psd2-sca-compliance-and-implementation-guide#specifypreferenceinyourapirequest) that Adyen requested for the payment.   Possible values: * **lowValue**  * **secureCorporate**  * **trustedBeneficiary**  * **transactionRiskAnalysis** ")
    public String getScaExemptionRequested() {
        return this.scaExemptionRequested;
    }

    public void setScaExemptionRequested(String scaExemptionRequested) {
        this.scaExemptionRequested = scaExemptionRequested;
    }

    public ResponseAdditionalData3DSecure threeds2CardEnrolled(Boolean threeds2CardEnrolled) {
        this.threeds2CardEnrolled = threeds2CardEnrolled;
        return this;
    }

    @ApiModelProperty(value="Indicates whether a card is enrolled for 3D Secure 2.")
    public Boolean getThreeds2CardEnrolled() {
        return this.threeds2CardEnrolled;
    }

    public void setThreeds2CardEnrolled(Boolean threeds2CardEnrolled) {
        this.threeds2CardEnrolled = threeds2CardEnrolled;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResponseAdditionalData3DSecure responseAdditionalData3DSecure = (ResponseAdditionalData3DSecure)o;
        return Objects.equals(this.cardHolderInfo, responseAdditionalData3DSecure.cardHolderInfo) && Objects.equals(this.cavv, responseAdditionalData3DSecure.cavv) && Objects.equals(this.cavvAlgorithm, responseAdditionalData3DSecure.cavvAlgorithm) && Objects.equals(this.scaExemptionRequested, responseAdditionalData3DSecure.scaExemptionRequested) && Objects.equals(this.threeds2CardEnrolled, responseAdditionalData3DSecure.threeds2CardEnrolled);
    }

    public int hashCode() {
        return Objects.hash(this.cardHolderInfo, this.cavv, this.cavvAlgorithm, this.scaExemptionRequested, this.threeds2CardEnrolled);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ResponseAdditionalData3DSecure {\n");
        sb.append("    cardHolderInfo: ").append(this.toIndentedString(this.cardHolderInfo)).append("\n");
        sb.append("    cavv: ").append(this.toIndentedString(this.cavv)).append("\n");
        sb.append("    cavvAlgorithm: ").append(this.toIndentedString(this.cavvAlgorithm)).append("\n");
        sb.append("    scaExemptionRequested: ").append(this.toIndentedString(this.scaExemptionRequested)).append("\n");
        sb.append("    threeds2CardEnrolled: ").append(this.toIndentedString(this.threeds2CardEnrolled)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in ResponseAdditionalData3DSecure is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `ResponseAdditionalData3DSecure` properties.", entry.getKey()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CARD_HOLDER_INFO) != null && !jsonObj.get(SERIALIZED_NAME_CARD_HOLDER_INFO).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `cardHolderInfo` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CARD_HOLDER_INFO).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CAVV) != null && !jsonObj.get(SERIALIZED_NAME_CAVV).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `cavv` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CAVV).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CAVV_ALGORITHM) != null && !jsonObj.get(SERIALIZED_NAME_CAVV_ALGORITHM).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `cavvAlgorithm` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CAVV_ALGORITHM).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SCA_EXEMPTION_REQUESTED) != null && !jsonObj.get(SERIALIZED_NAME_SCA_EXEMPTION_REQUESTED).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `scaExemptionRequested` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SCA_EXEMPTION_REQUESTED).toString()));
        }
    }

    public static ResponseAdditionalData3DSecure fromJson(String jsonString) throws IOException {
        return (ResponseAdditionalData3DSecure)JSON.getGson().fromJson(jsonString, ResponseAdditionalData3DSecure.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_CARD_HOLDER_INFO);
        openapiFields.add(SERIALIZED_NAME_CAVV);
        openapiFields.add(SERIALIZED_NAME_CAVV_ALGORITHM);
        openapiFields.add(SERIALIZED_NAME_SCA_EXEMPTION_REQUESTED);
        openapiFields.add(SERIALIZED_NAME_THREEDS2_CARD_ENROLLED);
        openapiRequiredFields = new HashSet();
        log = Logger.getLogger(ResponseAdditionalData3DSecure.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!ResponseAdditionalData3DSecure.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(ResponseAdditionalData3DSecure.class));
            return new TypeAdapter<ResponseAdditionalData3DSecure>(){

                public void write(JsonWriter out, ResponseAdditionalData3DSecure value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public ResponseAdditionalData3DSecure read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    ResponseAdditionalData3DSecure.validateJsonObject(jsonObj);
                    return (ResponseAdditionalData3DSecure)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

