/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.JSON;
import com.adyen.model.management.StoreSplitConfiguration;
import com.adyen.model.management.UpdatableAddress;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UpdateStoreRequest {
    public static final String SERIALIZED_NAME_ADDRESS = "address";
    @SerializedName(value="address")
    private UpdatableAddress address;
    public static final String SERIALIZED_NAME_BUSINESS_LINE_IDS = "businessLineIds";
    @SerializedName(value="businessLineIds")
    private List<String> businessLineIds = null;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_EXTERNAL_REFERENCE_ID = "externalReferenceId";
    @SerializedName(value="externalReferenceId")
    private String externalReferenceId;
    public static final String SERIALIZED_NAME_SPLIT_CONFIGURATION = "splitConfiguration";
    @SerializedName(value="splitConfiguration")
    private StoreSplitConfiguration splitConfiguration;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private StatusEnum status;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public UpdateStoreRequest address(UpdatableAddress address) {
        this.address = address;
        return this;
    }

    @ApiModelProperty(value="")
    public UpdatableAddress getAddress() {
        return this.address;
    }

    public void setAddress(UpdatableAddress address) {
        this.address = address;
    }

    public UpdateStoreRequest businessLineIds(List<String> businessLineIds) {
        this.businessLineIds = businessLineIds;
        return this;
    }

    public UpdateStoreRequest addBusinessLineIdsItem(String businessLineIdsItem) {
        if (this.businessLineIds == null) {
            this.businessLineIds = new ArrayList<String>();
        }
        this.businessLineIds.add(businessLineIdsItem);
        return this;
    }

    @ApiModelProperty(value="The unique identifiers of the [business lines](https://docs.adyen.com/api-explorer/#/legalentity/latest/post/businesslines__resParam_id) that the store is associated with.")
    public List<String> getBusinessLineIds() {
        return this.businessLineIds;
    }

    public void setBusinessLineIds(List<String> businessLineIds) {
        this.businessLineIds = businessLineIds;
    }

    public UpdateStoreRequest description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="The description of the store.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public UpdateStoreRequest externalReferenceId(String externalReferenceId) {
        this.externalReferenceId = externalReferenceId;
        return this;
    }

    @ApiModelProperty(value="When using the Zip payment method: The location ID that Zip has assigned to your store.")
    public String getExternalReferenceId() {
        return this.externalReferenceId;
    }

    public void setExternalReferenceId(String externalReferenceId) {
        this.externalReferenceId = externalReferenceId;
    }

    public UpdateStoreRequest splitConfiguration(StoreSplitConfiguration splitConfiguration) {
        this.splitConfiguration = splitConfiguration;
        return this;
    }

    @ApiModelProperty(value="")
    public StoreSplitConfiguration getSplitConfiguration() {
        return this.splitConfiguration;
    }

    public void setSplitConfiguration(StoreSplitConfiguration splitConfiguration) {
        this.splitConfiguration = splitConfiguration;
    }

    public UpdateStoreRequest status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="The status of the store. Possible values are:  - **active**: This value is assigned automatically when a store is created.  - **inactive**: The maximum [transaction limits and number of Store-and-Forward transactions](https://docs.adyen.com/point-of-sale/determine-account-structure/configure-features#payment-features) for the store are set to 0. This blocks new transactions, but captures are still possible. - **closed**: The terminals of the store are reassigned to the merchant inventory, so they can't process payments.  You can change the status from **active** to **inactive**, and from **inactive** to **active** or **closed**.  Once **closed**, a store can't be reopened.")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateStoreRequest updateStoreRequest = (UpdateStoreRequest)o;
        return Objects.equals(this.address, updateStoreRequest.address) && Objects.equals(this.businessLineIds, updateStoreRequest.businessLineIds) && Objects.equals(this.description, updateStoreRequest.description) && Objects.equals(this.externalReferenceId, updateStoreRequest.externalReferenceId) && Objects.equals(this.splitConfiguration, updateStoreRequest.splitConfiguration) && Objects.equals((Object)this.status, (Object)updateStoreRequest.status);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.address, this.businessLineIds, this.description, this.externalReferenceId, this.splitConfiguration, this.status});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpdateStoreRequest {\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    businessLineIds: ").append(this.toIndentedString(this.businessLineIds)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    externalReferenceId: ").append(this.toIndentedString(this.externalReferenceId)).append("\n");
        sb.append("    splitConfiguration: ").append(this.toIndentedString(this.splitConfiguration)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in UpdateStoreRequest is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `UpdateStoreRequest` properties.", entry.getKey()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_ADDRESS) != null) {
            UpdatableAddress.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_ADDRESS));
        }
        if (jsonObj.get(SERIALIZED_NAME_BUSINESS_LINE_IDS) != null && !jsonObj.get(SERIALIZED_NAME_BUSINESS_LINE_IDS).isJsonArray()) {
            log.log(Level.WARNING, String.format("Expected the field `businessLineIds` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BUSINESS_LINE_IDS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DESCRIPTION) != null && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DESCRIPTION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_EXTERNAL_REFERENCE_ID) != null && !jsonObj.get(SERIALIZED_NAME_EXTERNAL_REFERENCE_ID).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `externalReferenceId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_EXTERNAL_REFERENCE_ID).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_SPLIT_CONFIGURATION) != null) {
            StoreSplitConfiguration.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_SPLIT_CONFIGURATION));
        }
        if (jsonObj.get(SERIALIZED_NAME_STATUS) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_STATUS).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `status` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STATUS).toString()));
            }
            StatusEnum.fromValue(jsonObj.get(SERIALIZED_NAME_STATUS).getAsString());
        }
    }

    public static UpdateStoreRequest fromJson(String jsonString) throws IOException {
        return (UpdateStoreRequest)JSON.getGson().fromJson(jsonString, UpdateStoreRequest.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ADDRESS);
        openapiFields.add(SERIALIZED_NAME_BUSINESS_LINE_IDS);
        openapiFields.add(SERIALIZED_NAME_DESCRIPTION);
        openapiFields.add(SERIALIZED_NAME_EXTERNAL_REFERENCE_ID);
        openapiFields.add(SERIALIZED_NAME_SPLIT_CONFIGURATION);
        openapiFields.add(SERIALIZED_NAME_STATUS);
        openapiRequiredFields = new HashSet();
        log = Logger.getLogger(UpdateStoreRequest.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!UpdateStoreRequest.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(UpdateStoreRequest.class));
            return new TypeAdapter<UpdateStoreRequest>(){

                public void write(JsonWriter out, UpdateStoreRequest value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public UpdateStoreRequest read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    UpdateStoreRequest.validateJsonObject(jsonObj);
                    return (UpdateStoreRequest)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StatusEnum {
        ACTIVE("active"),
        CLOSED("closed"),
        INACTIVE("inactive");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<StatusEnum> {
            public void write(JsonWriter jsonWriter, StatusEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StatusEnum.fromValue(value);
            }
        }
    }
}

