/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.AdditionalSettings;
import com.adyen.model.management.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UpdateMerchantWebhookRequest {
    public static final String SERIALIZED_NAME_ACCEPTS_EXPIRED_CERTIFICATE = "acceptsExpiredCertificate";
    @SerializedName(value="acceptsExpiredCertificate")
    private Boolean acceptsExpiredCertificate;
    public static final String SERIALIZED_NAME_ACCEPTS_SELF_SIGNED_CERTIFICATE = "acceptsSelfSignedCertificate";
    @SerializedName(value="acceptsSelfSignedCertificate")
    private Boolean acceptsSelfSignedCertificate;
    public static final String SERIALIZED_NAME_ACCEPTS_UNTRUSTED_ROOT_CERTIFICATE = "acceptsUntrustedRootCertificate";
    @SerializedName(value="acceptsUntrustedRootCertificate")
    private Boolean acceptsUntrustedRootCertificate;
    public static final String SERIALIZED_NAME_ACTIVE = "active";
    @SerializedName(value="active")
    private Boolean active;
    public static final String SERIALIZED_NAME_ADDITIONAL_SETTINGS = "additionalSettings";
    @SerializedName(value="additionalSettings")
    private AdditionalSettings additionalSettings;
    public static final String SERIALIZED_NAME_COMMUNICATION_FORMAT = "communicationFormat";
    @SerializedName(value="communicationFormat")
    private CommunicationFormatEnum communicationFormat;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_NETWORK_TYPE = "networkType";
    @SerializedName(value="networkType")
    private NetworkTypeEnum networkType;
    public static final String SERIALIZED_NAME_PASSWORD = "password";
    @SerializedName(value="password")
    private String password;
    public static final String SERIALIZED_NAME_POPULATE_SOAP_ACTION_HEADER = "populateSoapActionHeader";
    @SerializedName(value="populateSoapActionHeader")
    private Boolean populateSoapActionHeader;
    public static final String SERIALIZED_NAME_SSL_VERSION = "sslVersion";
    @SerializedName(value="sslVersion")
    private SslVersionEnum sslVersion;
    public static final String SERIALIZED_NAME_URL = "url";
    @SerializedName(value="url")
    private String url;
    public static final String SERIALIZED_NAME_USERNAME = "username";
    @SerializedName(value="username")
    private String username;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public UpdateMerchantWebhookRequest acceptsExpiredCertificate(Boolean acceptsExpiredCertificate) {
        this.acceptsExpiredCertificate = acceptsExpiredCertificate;
        return this;
    }

    @ApiModelProperty(value="Indicates if expired SSL certificates are accepted. Default value: **false**.")
    public Boolean getAcceptsExpiredCertificate() {
        return this.acceptsExpiredCertificate;
    }

    public void setAcceptsExpiredCertificate(Boolean acceptsExpiredCertificate) {
        this.acceptsExpiredCertificate = acceptsExpiredCertificate;
    }

    public UpdateMerchantWebhookRequest acceptsSelfSignedCertificate(Boolean acceptsSelfSignedCertificate) {
        this.acceptsSelfSignedCertificate = acceptsSelfSignedCertificate;
        return this;
    }

    @ApiModelProperty(value="Indicates if self-signed SSL certificates are accepted. Default value: **false**.")
    public Boolean getAcceptsSelfSignedCertificate() {
        return this.acceptsSelfSignedCertificate;
    }

    public void setAcceptsSelfSignedCertificate(Boolean acceptsSelfSignedCertificate) {
        this.acceptsSelfSignedCertificate = acceptsSelfSignedCertificate;
    }

    public UpdateMerchantWebhookRequest acceptsUntrustedRootCertificate(Boolean acceptsUntrustedRootCertificate) {
        this.acceptsUntrustedRootCertificate = acceptsUntrustedRootCertificate;
        return this;
    }

    @ApiModelProperty(value="Indicates if untrusted SSL certificates are accepted. Default value: **false**.")
    public Boolean getAcceptsUntrustedRootCertificate() {
        return this.acceptsUntrustedRootCertificate;
    }

    public void setAcceptsUntrustedRootCertificate(Boolean acceptsUntrustedRootCertificate) {
        this.acceptsUntrustedRootCertificate = acceptsUntrustedRootCertificate;
    }

    public UpdateMerchantWebhookRequest active(Boolean active) {
        this.active = active;
        return this;
    }

    @ApiModelProperty(value="Indicates if the webhook configuration is active. The field must be **true** for us to send webhooks about events related an account.")
    public Boolean getActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public UpdateMerchantWebhookRequest additionalSettings(AdditionalSettings additionalSettings) {
        this.additionalSettings = additionalSettings;
        return this;
    }

    @ApiModelProperty(value="")
    public AdditionalSettings getAdditionalSettings() {
        return this.additionalSettings;
    }

    public void setAdditionalSettings(AdditionalSettings additionalSettings) {
        this.additionalSettings = additionalSettings;
    }

    public UpdateMerchantWebhookRequest communicationFormat(CommunicationFormatEnum communicationFormat) {
        this.communicationFormat = communicationFormat;
        return this;
    }

    @ApiModelProperty(example="soap", value="Format or protocol for receiving webhooks. Possible values: * **soap** * **http** * **json** ")
    public CommunicationFormatEnum getCommunicationFormat() {
        return this.communicationFormat;
    }

    public void setCommunicationFormat(CommunicationFormatEnum communicationFormat) {
        this.communicationFormat = communicationFormat;
    }

    public UpdateMerchantWebhookRequest description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="Your description for this webhook configuration.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public UpdateMerchantWebhookRequest networkType(NetworkTypeEnum networkType) {
        this.networkType = networkType;
        return this;
    }

    @ApiModelProperty(value="Network type for Terminal API notification webhooks. Possible values: * **public** * **local**  Default Value: **public**.")
    public NetworkTypeEnum getNetworkType() {
        return this.networkType;
    }

    public void setNetworkType(NetworkTypeEnum networkType) {
        this.networkType = networkType;
    }

    public UpdateMerchantWebhookRequest password(String password) {
        this.password = password;
        return this;
    }

    @ApiModelProperty(value="Password to access the webhook URL.")
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public UpdateMerchantWebhookRequest populateSoapActionHeader(Boolean populateSoapActionHeader) {
        this.populateSoapActionHeader = populateSoapActionHeader;
        return this;
    }

    @ApiModelProperty(value="Indicates if the SOAP action header needs to be populated. Default value: **false**.  Only applies if `communicationFormat`: **soap**.")
    public Boolean getPopulateSoapActionHeader() {
        return this.populateSoapActionHeader;
    }

    public void setPopulateSoapActionHeader(Boolean populateSoapActionHeader) {
        this.populateSoapActionHeader = populateSoapActionHeader;
    }

    public UpdateMerchantWebhookRequest sslVersion(SslVersionEnum sslVersion) {
        this.sslVersion = sslVersion;
        return this;
    }

    @ApiModelProperty(example="TLSv1.2", value="SSL version to access the public webhook URL specified in the `url` field. Possible values: * **TLSv1.3** * **TLSv1.2** * **HTTP** - Only allowed on Test environment.  If not specified, the webhook will use `sslVersion`: **TLSv1.2**.")
    public SslVersionEnum getSslVersion() {
        return this.sslVersion;
    }

    public void setSslVersion(SslVersionEnum sslVersion) {
        this.sslVersion = sslVersion;
    }

    public UpdateMerchantWebhookRequest url(String url) {
        this.url = url;
        return this;
    }

    @ApiModelProperty(example="http://www.adyen.com", value="Public URL where webhooks will be sent, for example **https://www.domain.com/webhook-endpoint**.")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public UpdateMerchantWebhookRequest username(String username) {
        this.username = username;
        return this;
    }

    @ApiModelProperty(value="Username to access the webhook URL.")
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateMerchantWebhookRequest updateMerchantWebhookRequest = (UpdateMerchantWebhookRequest)o;
        return Objects.equals(this.acceptsExpiredCertificate, updateMerchantWebhookRequest.acceptsExpiredCertificate) && Objects.equals(this.acceptsSelfSignedCertificate, updateMerchantWebhookRequest.acceptsSelfSignedCertificate) && Objects.equals(this.acceptsUntrustedRootCertificate, updateMerchantWebhookRequest.acceptsUntrustedRootCertificate) && Objects.equals(this.active, updateMerchantWebhookRequest.active) && Objects.equals(this.additionalSettings, updateMerchantWebhookRequest.additionalSettings) && Objects.equals((Object)this.communicationFormat, (Object)updateMerchantWebhookRequest.communicationFormat) && Objects.equals(this.description, updateMerchantWebhookRequest.description) && Objects.equals((Object)this.networkType, (Object)updateMerchantWebhookRequest.networkType) && Objects.equals(this.password, updateMerchantWebhookRequest.password) && Objects.equals(this.populateSoapActionHeader, updateMerchantWebhookRequest.populateSoapActionHeader) && Objects.equals((Object)this.sslVersion, (Object)updateMerchantWebhookRequest.sslVersion) && Objects.equals(this.url, updateMerchantWebhookRequest.url) && Objects.equals(this.username, updateMerchantWebhookRequest.username);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.acceptsExpiredCertificate, this.acceptsSelfSignedCertificate, this.acceptsUntrustedRootCertificate, this.active, this.additionalSettings, this.communicationFormat, this.description, this.networkType, this.password, this.populateSoapActionHeader, this.sslVersion, this.url, this.username});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpdateMerchantWebhookRequest {\n");
        sb.append("    acceptsExpiredCertificate: ").append(this.toIndentedString(this.acceptsExpiredCertificate)).append("\n");
        sb.append("    acceptsSelfSignedCertificate: ").append(this.toIndentedString(this.acceptsSelfSignedCertificate)).append("\n");
        sb.append("    acceptsUntrustedRootCertificate: ").append(this.toIndentedString(this.acceptsUntrustedRootCertificate)).append("\n");
        sb.append("    active: ").append(this.toIndentedString(this.active)).append("\n");
        sb.append("    additionalSettings: ").append(this.toIndentedString(this.additionalSettings)).append("\n");
        sb.append("    communicationFormat: ").append(this.toIndentedString((Object)this.communicationFormat)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    networkType: ").append(this.toIndentedString((Object)this.networkType)).append("\n");
        sb.append("    password: ").append(this.toIndentedString(this.password)).append("\n");
        sb.append("    populateSoapActionHeader: ").append(this.toIndentedString(this.populateSoapActionHeader)).append("\n");
        sb.append("    sslVersion: ").append(this.toIndentedString((Object)this.sslVersion)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    username: ").append(this.toIndentedString(this.username)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in UpdateMerchantWebhookRequest is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `UpdateMerchantWebhookRequest` properties.", entry.getKey()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_ADDITIONAL_SETTINGS) != null) {
            AdditionalSettings.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_ADDITIONAL_SETTINGS));
        }
        if (jsonObj.get(SERIALIZED_NAME_COMMUNICATION_FORMAT) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_COMMUNICATION_FORMAT).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `communicationFormat` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_COMMUNICATION_FORMAT).toString()));
            }
            CommunicationFormatEnum.fromValue(jsonObj.get(SERIALIZED_NAME_COMMUNICATION_FORMAT).getAsString());
        }
        if (jsonObj.get(SERIALIZED_NAME_DESCRIPTION) != null && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DESCRIPTION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NETWORK_TYPE) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_NETWORK_TYPE).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `networkType` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NETWORK_TYPE).toString()));
            }
            NetworkTypeEnum.fromValue(jsonObj.get(SERIALIZED_NAME_NETWORK_TYPE).getAsString());
        }
        if (jsonObj.get(SERIALIZED_NAME_PASSWORD) != null && !jsonObj.get(SERIALIZED_NAME_PASSWORD).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `password` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PASSWORD).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SSL_VERSION) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_SSL_VERSION).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `sslVersion` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SSL_VERSION).toString()));
            }
            SslVersionEnum.fromValue(jsonObj.get(SERIALIZED_NAME_SSL_VERSION).getAsString());
        }
        if (jsonObj.get(SERIALIZED_NAME_URL) != null && !jsonObj.get(SERIALIZED_NAME_URL).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `url` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_URL).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_USERNAME) != null && !jsonObj.get(SERIALIZED_NAME_USERNAME).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `username` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_USERNAME).toString()));
        }
    }

    public static UpdateMerchantWebhookRequest fromJson(String jsonString) throws IOException {
        return (UpdateMerchantWebhookRequest)JSON.getGson().fromJson(jsonString, UpdateMerchantWebhookRequest.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ACCEPTS_EXPIRED_CERTIFICATE);
        openapiFields.add(SERIALIZED_NAME_ACCEPTS_SELF_SIGNED_CERTIFICATE);
        openapiFields.add(SERIALIZED_NAME_ACCEPTS_UNTRUSTED_ROOT_CERTIFICATE);
        openapiFields.add(SERIALIZED_NAME_ACTIVE);
        openapiFields.add(SERIALIZED_NAME_ADDITIONAL_SETTINGS);
        openapiFields.add(SERIALIZED_NAME_COMMUNICATION_FORMAT);
        openapiFields.add(SERIALIZED_NAME_DESCRIPTION);
        openapiFields.add(SERIALIZED_NAME_NETWORK_TYPE);
        openapiFields.add(SERIALIZED_NAME_PASSWORD);
        openapiFields.add(SERIALIZED_NAME_POPULATE_SOAP_ACTION_HEADER);
        openapiFields.add(SERIALIZED_NAME_SSL_VERSION);
        openapiFields.add(SERIALIZED_NAME_URL);
        openapiFields.add(SERIALIZED_NAME_USERNAME);
        openapiRequiredFields = new HashSet();
        log = Logger.getLogger(UpdateMerchantWebhookRequest.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!UpdateMerchantWebhookRequest.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(UpdateMerchantWebhookRequest.class));
            return new TypeAdapter<UpdateMerchantWebhookRequest>(){

                public void write(JsonWriter out, UpdateMerchantWebhookRequest value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public UpdateMerchantWebhookRequest read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    UpdateMerchantWebhookRequest.validateJsonObject(jsonObj);
                    return (UpdateMerchantWebhookRequest)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum SslVersionEnum {
        HTTP("HTTP"),
        SSL("SSL"),
        SSLV3("SSLv3"),
        TLS("TLS"),
        TLSV1("TLSv1"),
        TLSV1_1("TLSv1.1"),
        TLSV1_2("TLSv1.2"),
        TLSV1_3("TLSv1.3");

        private String value;

        private SslVersionEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static SslVersionEnum fromValue(String value) {
            for (SslVersionEnum b : SslVersionEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<SslVersionEnum> {
            public void write(JsonWriter jsonWriter, SslVersionEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public SslVersionEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return SslVersionEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum NetworkTypeEnum {
        LOCAL("LOCAL"),
        PUBLIC("PUBLIC");

        private String value;

        private NetworkTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static NetworkTypeEnum fromValue(String value) {
            for (NetworkTypeEnum b : NetworkTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<NetworkTypeEnum> {
            public void write(JsonWriter jsonWriter, NetworkTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public NetworkTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return NetworkTypeEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum CommunicationFormatEnum {
        HTTP("http"),
        JSON("json"),
        SOAP("soap");

        private String value;

        private CommunicationFormatEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static CommunicationFormatEnum fromValue(String value) {
            for (CommunicationFormatEnum b : CommunicationFormatEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<CommunicationFormatEnum> {
            public void write(JsonWriter jsonWriter, CommunicationFormatEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public CommunicationFormatEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return CommunicationFormatEnum.fromValue(value);
            }
        }
    }
}

