/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.JSON;
import com.adyen.model.management.Name2;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UpdateCompanyUserRequest {
    public static final String SERIALIZED_NAME_ACCOUNT_GROUPS = "accountGroups";
    @SerializedName(value="accountGroups")
    private List<String> accountGroups = null;
    public static final String SERIALIZED_NAME_ACTIVE = "active";
    @SerializedName(value="active")
    private Boolean active;
    public static final String SERIALIZED_NAME_ASSOCIATED_MERCHANT_ACCOUNTS = "associatedMerchantAccounts";
    @SerializedName(value="associatedMerchantAccounts")
    private List<String> associatedMerchantAccounts = null;
    public static final String SERIALIZED_NAME_EMAIL = "email";
    @SerializedName(value="email")
    private String email;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private Name2 name;
    public static final String SERIALIZED_NAME_ROLES = "roles";
    @SerializedName(value="roles")
    private List<String> roles = null;
    public static final String SERIALIZED_NAME_TIME_ZONE_CODE = "timeZoneCode";
    @SerializedName(value="timeZoneCode")
    private String timeZoneCode;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public UpdateCompanyUserRequest accountGroups(List<String> accountGroups) {
        this.accountGroups = accountGroups;
        return this;
    }

    public UpdateCompanyUserRequest addAccountGroupsItem(String accountGroupsItem) {
        if (this.accountGroups == null) {
            this.accountGroups = new ArrayList<String>();
        }
        this.accountGroups.add(accountGroupsItem);
        return this;
    }

    @ApiModelProperty(value="The list of [account groups](https://docs.adyen.com/account/account-structure#account-groups) associated with this user.")
    public List<String> getAccountGroups() {
        return this.accountGroups;
    }

    public void setAccountGroups(List<String> accountGroups) {
        this.accountGroups = accountGroups;
    }

    public UpdateCompanyUserRequest active(Boolean active) {
        this.active = active;
        return this;
    }

    @ApiModelProperty(value="Indicates whether this user is active.")
    public Boolean getActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public UpdateCompanyUserRequest associatedMerchantAccounts(List<String> associatedMerchantAccounts) {
        this.associatedMerchantAccounts = associatedMerchantAccounts;
        return this;
    }

    public UpdateCompanyUserRequest addAssociatedMerchantAccountsItem(String associatedMerchantAccountsItem) {
        if (this.associatedMerchantAccounts == null) {
            this.associatedMerchantAccounts = new ArrayList<String>();
        }
        this.associatedMerchantAccounts.add(associatedMerchantAccountsItem);
        return this;
    }

    @ApiModelProperty(value="The list of [merchant accounts](https://docs.adyen.com/account/account-structure#merchant-accounts) to associate the user with.")
    public List<String> getAssociatedMerchantAccounts() {
        return this.associatedMerchantAccounts;
    }

    public void setAssociatedMerchantAccounts(List<String> associatedMerchantAccounts) {
        this.associatedMerchantAccounts = associatedMerchantAccounts;
    }

    public UpdateCompanyUserRequest email(String email) {
        this.email = email;
        return this;
    }

    @ApiModelProperty(value="The email address of the user.")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public UpdateCompanyUserRequest name(Name2 name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="")
    public Name2 getName() {
        return this.name;
    }

    public void setName(Name2 name) {
        this.name = name;
    }

    public UpdateCompanyUserRequest roles(List<String> roles) {
        this.roles = roles;
        return this;
    }

    public UpdateCompanyUserRequest addRolesItem(String rolesItem) {
        if (this.roles == null) {
            this.roles = new ArrayList<String>();
        }
        this.roles.add(rolesItem);
        return this;
    }

    @ApiModelProperty(value="The list of [roles](https://docs.adyen.com/account/user-roles) for this user.")
    public List<String> getRoles() {
        return this.roles;
    }

    public void setRoles(List<String> roles) {
        this.roles = roles;
    }

    public UpdateCompanyUserRequest timeZoneCode(String timeZoneCode) {
        this.timeZoneCode = timeZoneCode;
        return this;
    }

    @ApiModelProperty(value="The [tz database name](https://en.wikipedia.org/wiki/List_of_tz_database_time_zones) of the time zone of the user. For example, **Europe/Amsterdam**.")
    public String getTimeZoneCode() {
        return this.timeZoneCode;
    }

    public void setTimeZoneCode(String timeZoneCode) {
        this.timeZoneCode = timeZoneCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateCompanyUserRequest updateCompanyUserRequest = (UpdateCompanyUserRequest)o;
        return Objects.equals(this.accountGroups, updateCompanyUserRequest.accountGroups) && Objects.equals(this.active, updateCompanyUserRequest.active) && Objects.equals(this.associatedMerchantAccounts, updateCompanyUserRequest.associatedMerchantAccounts) && Objects.equals(this.email, updateCompanyUserRequest.email) && Objects.equals(this.name, updateCompanyUserRequest.name) && Objects.equals(this.roles, updateCompanyUserRequest.roles) && Objects.equals(this.timeZoneCode, updateCompanyUserRequest.timeZoneCode);
    }

    public int hashCode() {
        return Objects.hash(this.accountGroups, this.active, this.associatedMerchantAccounts, this.email, this.name, this.roles, this.timeZoneCode);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpdateCompanyUserRequest {\n");
        sb.append("    accountGroups: ").append(this.toIndentedString(this.accountGroups)).append("\n");
        sb.append("    active: ").append(this.toIndentedString(this.active)).append("\n");
        sb.append("    associatedMerchantAccounts: ").append(this.toIndentedString(this.associatedMerchantAccounts)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    roles: ").append(this.toIndentedString(this.roles)).append("\n");
        sb.append("    timeZoneCode: ").append(this.toIndentedString(this.timeZoneCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in UpdateCompanyUserRequest is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `UpdateCompanyUserRequest` properties.", entry.getKey()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ACCOUNT_GROUPS) != null && !jsonObj.get(SERIALIZED_NAME_ACCOUNT_GROUPS).isJsonArray()) {
            log.log(Level.WARNING, String.format("Expected the field `accountGroups` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ACCOUNT_GROUPS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ASSOCIATED_MERCHANT_ACCOUNTS) != null && !jsonObj.get(SERIALIZED_NAME_ASSOCIATED_MERCHANT_ACCOUNTS).isJsonArray()) {
            log.log(Level.WARNING, String.format("Expected the field `associatedMerchantAccounts` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ASSOCIATED_MERCHANT_ACCOUNTS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_EMAIL) != null && !jsonObj.get(SERIALIZED_NAME_EMAIL).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `email` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_EMAIL).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_NAME) != null) {
            Name2.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_NAME));
        }
        if (jsonObj.get(SERIALIZED_NAME_ROLES) != null && !jsonObj.get(SERIALIZED_NAME_ROLES).isJsonArray()) {
            log.log(Level.WARNING, String.format("Expected the field `roles` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ROLES).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TIME_ZONE_CODE) != null && !jsonObj.get(SERIALIZED_NAME_TIME_ZONE_CODE).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `timeZoneCode` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TIME_ZONE_CODE).toString()));
        }
    }

    public static UpdateCompanyUserRequest fromJson(String jsonString) throws IOException {
        return (UpdateCompanyUserRequest)JSON.getGson().fromJson(jsonString, UpdateCompanyUserRequest.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ACCOUNT_GROUPS);
        openapiFields.add(SERIALIZED_NAME_ACTIVE);
        openapiFields.add(SERIALIZED_NAME_ASSOCIATED_MERCHANT_ACCOUNTS);
        openapiFields.add(SERIALIZED_NAME_EMAIL);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_ROLES);
        openapiFields.add(SERIALIZED_NAME_TIME_ZONE_CODE);
        openapiRequiredFields = new HashSet();
        log = Logger.getLogger(UpdateCompanyUserRequest.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!UpdateCompanyUserRequest.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(UpdateCompanyUserRequest.class));
            return new TypeAdapter<UpdateCompanyUserRequest>(){

                public void write(JsonWriter out, UpdateCompanyUserRequest value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public UpdateCompanyUserRequest read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    UpdateCompanyUserRequest.validateJsonObject(jsonObj);
                    return (UpdateCompanyUserRequest)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

