/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.JSON;
import com.adyen.model.management.ModelFile;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Profile {
    public static final String SERIALIZED_NAME_AUTH_TYPE = "authType";
    @SerializedName(value="authType")
    private String authType;
    public static final String SERIALIZED_NAME_AUTO_WIFI = "autoWifi";
    @SerializedName(value="autoWifi")
    private Boolean autoWifi;
    public static final String SERIALIZED_NAME_BSS_TYPE = "bssType";
    @SerializedName(value="bssType")
    private String bssType;
    public static final String SERIALIZED_NAME_CHANNEL = "channel";
    @SerializedName(value="channel")
    private Integer channel;
    public static final String SERIALIZED_NAME_DEFAULT_PROFILE = "defaultProfile";
    @SerializedName(value="defaultProfile")
    private Boolean defaultProfile;
    public static final String SERIALIZED_NAME_EAP = "eap";
    @SerializedName(value="eap")
    private String eap;
    public static final String SERIALIZED_NAME_EAP_CA_CERT = "eapCaCert";
    @SerializedName(value="eapCaCert")
    private ModelFile eapCaCert;
    public static final String SERIALIZED_NAME_EAP_CLIENT_CERT = "eapClientCert";
    @SerializedName(value="eapClientCert")
    private ModelFile eapClientCert;
    public static final String SERIALIZED_NAME_EAP_CLIENT_KEY = "eapClientKey";
    @SerializedName(value="eapClientKey")
    private ModelFile eapClientKey;
    public static final String SERIALIZED_NAME_EAP_CLIENT_PWD = "eapClientPwd";
    @SerializedName(value="eapClientPwd")
    private String eapClientPwd;
    public static final String SERIALIZED_NAME_EAP_IDENTITY = "eapIdentity";
    @SerializedName(value="eapIdentity")
    private String eapIdentity;
    public static final String SERIALIZED_NAME_EAP_INTERMEDIATE_CERT = "eapIntermediateCert";
    @SerializedName(value="eapIntermediateCert")
    private ModelFile eapIntermediateCert;
    public static final String SERIALIZED_NAME_EAP_PWD = "eapPwd";
    @SerializedName(value="eapPwd")
    private String eapPwd;
    public static final String SERIALIZED_NAME_HIDDEN_SSID = "hiddenSsid";
    @SerializedName(value="hiddenSsid")
    private Boolean hiddenSsid;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_PSK = "psk";
    @SerializedName(value="psk")
    private String psk;
    public static final String SERIALIZED_NAME_SSID = "ssid";
    @SerializedName(value="ssid")
    private String ssid;
    public static final String SERIALIZED_NAME_WSEC = "wsec";
    @SerializedName(value="wsec")
    private String wsec;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public Profile authType(String authType) {
        this.authType = authType;
        return this;
    }

    @ApiModelProperty(required=true, value="The type of Wi-Fi network. Possible values: **wpa-psk**, **wpa2-psk**, **wpa-eap**, **wpa2-eap**.")
    public String getAuthType() {
        return this.authType;
    }

    public void setAuthType(String authType) {
        this.authType = authType;
    }

    public Profile autoWifi(Boolean autoWifi) {
        this.autoWifi = autoWifi;
        return this;
    }

    @ApiModelProperty(value="Indicates whether to automatically select the best authentication method available. Does not work on older terminal models.")
    public Boolean getAutoWifi() {
        return this.autoWifi;
    }

    public void setAutoWifi(Boolean autoWifi) {
        this.autoWifi = autoWifi;
    }

    public Profile bssType(String bssType) {
        this.bssType = bssType;
        return this;
    }

    @ApiModelProperty(required=true, value="Use **infra** for infrastructure-based networks. This applies to most networks. Use **adhoc** only if the communication is p2p-based between base stations.")
    public String getBssType() {
        return this.bssType;
    }

    public void setBssType(String bssType) {
        this.bssType = bssType;
    }

    public Profile channel(Integer channel) {
        this.channel = channel;
        return this;
    }

    @ApiModelProperty(value="The channel number of the Wi-Fi network. The recommended setting is **0** for automatic channel selection.")
    public Integer getChannel() {
        return this.channel;
    }

    public void setChannel(Integer channel) {
        this.channel = channel;
    }

    public Profile defaultProfile(Boolean defaultProfile) {
        this.defaultProfile = defaultProfile;
        return this;
    }

    @ApiModelProperty(value="Indicates whether this is your preferred wireless network. If **true**, the terminal will try connecting to this network first.")
    public Boolean getDefaultProfile() {
        return this.defaultProfile;
    }

    public void setDefaultProfile(Boolean defaultProfile) {
        this.defaultProfile = defaultProfile;
    }

    public Profile eap(String eap) {
        this.eap = eap;
        return this;
    }

    @ApiModelProperty(value="For `authType` **wpa-eap** or **wpa2-eap**. Possible values: **tls**, **peap**, **leap**, **fast**")
    public String getEap() {
        return this.eap;
    }

    public void setEap(String eap) {
        this.eap = eap;
    }

    public Profile eapCaCert(ModelFile eapCaCert) {
        this.eapCaCert = eapCaCert;
        return this;
    }

    @ApiModelProperty(value="")
    public ModelFile getEapCaCert() {
        return this.eapCaCert;
    }

    public void setEapCaCert(ModelFile eapCaCert) {
        this.eapCaCert = eapCaCert;
    }

    public Profile eapClientCert(ModelFile eapClientCert) {
        this.eapClientCert = eapClientCert;
        return this;
    }

    @ApiModelProperty(value="")
    public ModelFile getEapClientCert() {
        return this.eapClientCert;
    }

    public void setEapClientCert(ModelFile eapClientCert) {
        this.eapClientCert = eapClientCert;
    }

    public Profile eapClientKey(ModelFile eapClientKey) {
        this.eapClientKey = eapClientKey;
        return this;
    }

    @ApiModelProperty(value="")
    public ModelFile getEapClientKey() {
        return this.eapClientKey;
    }

    public void setEapClientKey(ModelFile eapClientKey) {
        this.eapClientKey = eapClientKey;
    }

    public Profile eapClientPwd(String eapClientPwd) {
        this.eapClientPwd = eapClientPwd;
        return this;
    }

    @ApiModelProperty(value="For `eap` **tls**. The password of the RSA key file, if that file is password-protected.")
    public String getEapClientPwd() {
        return this.eapClientPwd;
    }

    public void setEapClientPwd(String eapClientPwd) {
        this.eapClientPwd = eapClientPwd;
    }

    public Profile eapIdentity(String eapIdentity) {
        this.eapIdentity = eapIdentity;
        return this;
    }

    @ApiModelProperty(value="For `authType` **wpa-eap** or **wpa2-eap**. The EAP-PEAP username from your MS-CHAP account. Must match the configuration of your RADIUS server.")
    public String getEapIdentity() {
        return this.eapIdentity;
    }

    public void setEapIdentity(String eapIdentity) {
        this.eapIdentity = eapIdentity;
    }

    public Profile eapIntermediateCert(ModelFile eapIntermediateCert) {
        this.eapIntermediateCert = eapIntermediateCert;
        return this;
    }

    @ApiModelProperty(value="")
    public ModelFile getEapIntermediateCert() {
        return this.eapIntermediateCert;
    }

    public void setEapIntermediateCert(ModelFile eapIntermediateCert) {
        this.eapIntermediateCert = eapIntermediateCert;
    }

    public Profile eapPwd(String eapPwd) {
        this.eapPwd = eapPwd;
        return this;
    }

    @ApiModelProperty(value="For `eap` **peap**. The EAP-PEAP password from your MS-CHAP account. Must match the configuration of your RADIUS server.")
    public String getEapPwd() {
        return this.eapPwd;
    }

    public void setEapPwd(String eapPwd) {
        this.eapPwd = eapPwd;
    }

    public Profile hiddenSsid(Boolean hiddenSsid) {
        this.hiddenSsid = hiddenSsid;
        return this;
    }

    @ApiModelProperty(value="Indicates if the network doesn't broadcast its SSID. Mandatory for Android terminals, because these terminals rely on this setting to be able to connect to any network.")
    public Boolean getHiddenSsid() {
        return this.hiddenSsid;
    }

    public void setHiddenSsid(Boolean hiddenSsid) {
        this.hiddenSsid = hiddenSsid;
    }

    public Profile name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="Your name for the Wi-Fi profile.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Profile psk(String psk) {
        this.psk = psk;
        return this;
    }

    @ApiModelProperty(value="For `authType` **wpa-psk or **wpa2-psk**. The password to the wireless network.")
    public String getPsk() {
        return this.psk;
    }

    public void setPsk(String psk) {
        this.psk = psk;
    }

    public Profile ssid(String ssid) {
        this.ssid = ssid;
        return this;
    }

    @ApiModelProperty(required=true, value="The name of the wireless network.")
    public String getSsid() {
        return this.ssid;
    }

    public void setSsid(String ssid) {
        this.ssid = ssid;
    }

    public Profile wsec(String wsec) {
        this.wsec = wsec;
        return this;
    }

    @ApiModelProperty(required=true, value="The type of encryption. Possible values: **auto**, **ccmp** (recommended), **tkip**")
    public String getWsec() {
        return this.wsec;
    }

    public void setWsec(String wsec) {
        this.wsec = wsec;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Profile profile = (Profile)o;
        return Objects.equals(this.authType, profile.authType) && Objects.equals(this.autoWifi, profile.autoWifi) && Objects.equals(this.bssType, profile.bssType) && Objects.equals(this.channel, profile.channel) && Objects.equals(this.defaultProfile, profile.defaultProfile) && Objects.equals(this.eap, profile.eap) && Objects.equals(this.eapCaCert, profile.eapCaCert) && Objects.equals(this.eapClientCert, profile.eapClientCert) && Objects.equals(this.eapClientKey, profile.eapClientKey) && Objects.equals(this.eapClientPwd, profile.eapClientPwd) && Objects.equals(this.eapIdentity, profile.eapIdentity) && Objects.equals(this.eapIntermediateCert, profile.eapIntermediateCert) && Objects.equals(this.eapPwd, profile.eapPwd) && Objects.equals(this.hiddenSsid, profile.hiddenSsid) && Objects.equals(this.name, profile.name) && Objects.equals(this.psk, profile.psk) && Objects.equals(this.ssid, profile.ssid) && Objects.equals(this.wsec, profile.wsec);
    }

    public int hashCode() {
        return Objects.hash(this.authType, this.autoWifi, this.bssType, this.channel, this.defaultProfile, this.eap, this.eapCaCert, this.eapClientCert, this.eapClientKey, this.eapClientPwd, this.eapIdentity, this.eapIntermediateCert, this.eapPwd, this.hiddenSsid, this.name, this.psk, this.ssid, this.wsec);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Profile {\n");
        sb.append("    authType: ").append(this.toIndentedString(this.authType)).append("\n");
        sb.append("    autoWifi: ").append(this.toIndentedString(this.autoWifi)).append("\n");
        sb.append("    bssType: ").append(this.toIndentedString(this.bssType)).append("\n");
        sb.append("    channel: ").append(this.toIndentedString(this.channel)).append("\n");
        sb.append("    defaultProfile: ").append(this.toIndentedString(this.defaultProfile)).append("\n");
        sb.append("    eap: ").append(this.toIndentedString(this.eap)).append("\n");
        sb.append("    eapCaCert: ").append(this.toIndentedString(this.eapCaCert)).append("\n");
        sb.append("    eapClientCert: ").append(this.toIndentedString(this.eapClientCert)).append("\n");
        sb.append("    eapClientKey: ").append(this.toIndentedString(this.eapClientKey)).append("\n");
        sb.append("    eapClientPwd: ").append(this.toIndentedString(this.eapClientPwd)).append("\n");
        sb.append("    eapIdentity: ").append(this.toIndentedString(this.eapIdentity)).append("\n");
        sb.append("    eapIntermediateCert: ").append(this.toIndentedString(this.eapIntermediateCert)).append("\n");
        sb.append("    eapPwd: ").append(this.toIndentedString(this.eapPwd)).append("\n");
        sb.append("    hiddenSsid: ").append(this.toIndentedString(this.hiddenSsid)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    psk: ").append(this.toIndentedString(this.psk)).append("\n");
        sb.append("    ssid: ").append(this.toIndentedString(this.ssid)).append("\n");
        sb.append("    wsec: ").append(this.toIndentedString(this.wsec)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in Profile is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `Profile` properties.", entry.getKey()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_AUTH_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_AUTH_TYPE).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `authType` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_AUTH_TYPE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_BSS_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_BSS_TYPE).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `bssType` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BSS_TYPE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_EAP) != null && !jsonObj.get(SERIALIZED_NAME_EAP).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `eap` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_EAP).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_EAP_CA_CERT) != null) {
            ModelFile.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_EAP_CA_CERT));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_EAP_CLIENT_CERT) != null) {
            ModelFile.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_EAP_CLIENT_CERT));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_EAP_CLIENT_KEY) != null) {
            ModelFile.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_EAP_CLIENT_KEY));
        }
        if (jsonObj.get(SERIALIZED_NAME_EAP_CLIENT_PWD) != null && !jsonObj.get(SERIALIZED_NAME_EAP_CLIENT_PWD).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `eapClientPwd` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_EAP_CLIENT_PWD).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_EAP_IDENTITY) != null && !jsonObj.get(SERIALIZED_NAME_EAP_IDENTITY).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `eapIdentity` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_EAP_IDENTITY).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_EAP_INTERMEDIATE_CERT) != null) {
            ModelFile.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_EAP_INTERMEDIATE_CERT));
        }
        if (jsonObj.get(SERIALIZED_NAME_EAP_PWD) != null && !jsonObj.get(SERIALIZED_NAME_EAP_PWD).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `eapPwd` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_EAP_PWD).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PSK) != null && !jsonObj.get(SERIALIZED_NAME_PSK).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `psk` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PSK).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SSID) != null && !jsonObj.get(SERIALIZED_NAME_SSID).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `ssid` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SSID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_WSEC) != null && !jsonObj.get(SERIALIZED_NAME_WSEC).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `wsec` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_WSEC).toString()));
        }
    }

    public static Profile fromJson(String jsonString) throws IOException {
        return (Profile)JSON.getGson().fromJson(jsonString, Profile.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_AUTH_TYPE);
        openapiFields.add(SERIALIZED_NAME_AUTO_WIFI);
        openapiFields.add(SERIALIZED_NAME_BSS_TYPE);
        openapiFields.add(SERIALIZED_NAME_CHANNEL);
        openapiFields.add(SERIALIZED_NAME_DEFAULT_PROFILE);
        openapiFields.add(SERIALIZED_NAME_EAP);
        openapiFields.add(SERIALIZED_NAME_EAP_CA_CERT);
        openapiFields.add(SERIALIZED_NAME_EAP_CLIENT_CERT);
        openapiFields.add(SERIALIZED_NAME_EAP_CLIENT_KEY);
        openapiFields.add(SERIALIZED_NAME_EAP_CLIENT_PWD);
        openapiFields.add(SERIALIZED_NAME_EAP_IDENTITY);
        openapiFields.add(SERIALIZED_NAME_EAP_INTERMEDIATE_CERT);
        openapiFields.add(SERIALIZED_NAME_EAP_PWD);
        openapiFields.add(SERIALIZED_NAME_HIDDEN_SSID);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_PSK);
        openapiFields.add(SERIALIZED_NAME_SSID);
        openapiFields.add(SERIALIZED_NAME_WSEC);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_AUTH_TYPE);
        openapiRequiredFields.add(SERIALIZED_NAME_BSS_TYPE);
        openapiRequiredFields.add(SERIALIZED_NAME_SSID);
        openapiRequiredFields.add(SERIALIZED_NAME_WSEC);
        log = Logger.getLogger(Profile.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!Profile.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(Profile.class));
            return new TypeAdapter<Profile>(){

                public void write(JsonWriter out, Profile value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public Profile read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    Profile.validateJsonObject(jsonObj);
                    return (Profile)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

