/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.legalentitymanagement;

import com.adyen.model.legalentitymanagement.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WebData {
    public static final String SERIALIZED_NAME_WEB_ADDRESS = "webAddress";
    @SerializedName(value="webAddress")
    private String webAddress;
    public static final String SERIALIZED_NAME_WEB_ADDRESS_ID = "webAddressId";
    @SerializedName(value="webAddressId")
    private String webAddressId;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public WebData() {
    }

    public WebData(String webAddressId) {
        this();
        this.webAddressId = webAddressId;
    }

    public WebData webAddress(String webAddress) {
        this.webAddress = webAddress;
        return this;
    }

    @ApiModelProperty(value="The URL of the website or the app store URL.")
    public String getWebAddress() {
        return this.webAddress;
    }

    public void setWebAddress(String webAddress) {
        this.webAddress = webAddress;
    }

    @ApiModelProperty(value="The unique identifier of the web address.")
    public String getWebAddressId() {
        return this.webAddressId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebData webData = (WebData)o;
        return Objects.equals(this.webAddress, webData.webAddress) && Objects.equals(this.webAddressId, webData.webAddressId);
    }

    public int hashCode() {
        return Objects.hash(this.webAddress, this.webAddressId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WebData {\n");
        sb.append("    webAddress: ").append(this.toIndentedString(this.webAddress)).append("\n");
        sb.append("    webAddressId: ").append(this.toIndentedString(this.webAddressId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in WebData is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `WebData` properties.", entry.getKey()));
        }
        if (jsonObj.get(SERIALIZED_NAME_WEB_ADDRESS) != null && !jsonObj.get(SERIALIZED_NAME_WEB_ADDRESS).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `webAddress` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_WEB_ADDRESS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_WEB_ADDRESS_ID) != null && !jsonObj.get(SERIALIZED_NAME_WEB_ADDRESS_ID).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `webAddressId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_WEB_ADDRESS_ID).toString()));
        }
    }

    public static WebData fromJson(String jsonString) throws IOException {
        return (WebData)JSON.getGson().fromJson(jsonString, WebData.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_WEB_ADDRESS);
        openapiFields.add(SERIALIZED_NAME_WEB_ADDRESS_ID);
        openapiRequiredFields = new HashSet();
        log = Logger.getLogger(WebData.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!WebData.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(WebData.class));
            return new TypeAdapter<WebData>(){

                public void write(JsonWriter out, WebData value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public WebData read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    WebData.validateJsonObject(jsonObj);
                    return (WebData)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

