/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SamsungPayDetails {
    public static final String SERIALIZED_NAME_CHECKOUT_ATTEMPT_ID = "checkoutAttemptId";
    @SerializedName(value="checkoutAttemptId")
    private String checkoutAttemptId;
    public static final String SERIALIZED_NAME_FUNDING_SOURCE = "fundingSource";
    @SerializedName(value="fundingSource")
    private FundingSourceEnum fundingSource;
    public static final String SERIALIZED_NAME_RECURRING_DETAIL_REFERENCE = "recurringDetailReference";
    @Deprecated
    @SerializedName(value="recurringDetailReference")
    private String recurringDetailReference;
    public static final String SERIALIZED_NAME_SAMSUNG_PAY_TOKEN = "samsungPayToken";
    @SerializedName(value="samsungPayToken")
    private String samsungPayToken;
    public static final String SERIALIZED_NAME_STORED_PAYMENT_METHOD_ID = "storedPaymentMethodId";
    @SerializedName(value="storedPaymentMethodId")
    private String storedPaymentMethodId;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private TypeEnum type = TypeEnum.SAMSUNGPAY;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public SamsungPayDetails checkoutAttemptId(String checkoutAttemptId) {
        this.checkoutAttemptId = checkoutAttemptId;
        return this;
    }

    @ApiModelProperty(value="The checkout attempt identifier.")
    public String getCheckoutAttemptId() {
        return this.checkoutAttemptId;
    }

    public void setCheckoutAttemptId(String checkoutAttemptId) {
        this.checkoutAttemptId = checkoutAttemptId;
    }

    public SamsungPayDetails fundingSource(FundingSourceEnum fundingSource) {
        this.fundingSource = fundingSource;
        return this;
    }

    @ApiModelProperty(value="The funding source that should be used when multiple sources are available. For Brazilian combo cards, by default the funding source is credit. To use debit, set this value to **debit**.")
    public FundingSourceEnum getFundingSource() {
        return this.fundingSource;
    }

    public void setFundingSource(FundingSourceEnum fundingSource) {
        this.fundingSource = fundingSource;
    }

    @Deprecated
    public SamsungPayDetails recurringDetailReference(String recurringDetailReference) {
        this.recurringDetailReference = recurringDetailReference;
        return this;
    }

    @Deprecated
    @ApiModelProperty(value="This is the `recurringDetailReference` returned in the response when you created the token.")
    public String getRecurringDetailReference() {
        return this.recurringDetailReference;
    }

    @Deprecated
    public void setRecurringDetailReference(String recurringDetailReference) {
        this.recurringDetailReference = recurringDetailReference;
    }

    public SamsungPayDetails samsungPayToken(String samsungPayToken) {
        this.samsungPayToken = samsungPayToken;
        return this;
    }

    @ApiModelProperty(required=true, value="The payload you received from the Samsung Pay SDK response.")
    public String getSamsungPayToken() {
        return this.samsungPayToken;
    }

    public void setSamsungPayToken(String samsungPayToken) {
        this.samsungPayToken = samsungPayToken;
    }

    public SamsungPayDetails storedPaymentMethodId(String storedPaymentMethodId) {
        this.storedPaymentMethodId = storedPaymentMethodId;
        return this;
    }

    @ApiModelProperty(value="This is the `recurringDetailReference` returned in the response when you created the token.")
    public String getStoredPaymentMethodId() {
        return this.storedPaymentMethodId;
    }

    public void setStoredPaymentMethodId(String storedPaymentMethodId) {
        this.storedPaymentMethodId = storedPaymentMethodId;
    }

    public SamsungPayDetails type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="**samsungpay**")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SamsungPayDetails samsungPayDetails = (SamsungPayDetails)o;
        return Objects.equals(this.checkoutAttemptId, samsungPayDetails.checkoutAttemptId) && Objects.equals((Object)this.fundingSource, (Object)samsungPayDetails.fundingSource) && Objects.equals(this.recurringDetailReference, samsungPayDetails.recurringDetailReference) && Objects.equals(this.samsungPayToken, samsungPayDetails.samsungPayToken) && Objects.equals(this.storedPaymentMethodId, samsungPayDetails.storedPaymentMethodId) && Objects.equals((Object)this.type, (Object)samsungPayDetails.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.checkoutAttemptId, this.fundingSource, this.recurringDetailReference, this.samsungPayToken, this.storedPaymentMethodId, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SamsungPayDetails {\n");
        sb.append("    checkoutAttemptId: ").append(this.toIndentedString(this.checkoutAttemptId)).append("\n");
        sb.append("    fundingSource: ").append(this.toIndentedString((Object)this.fundingSource)).append("\n");
        sb.append("    recurringDetailReference: ").append(this.toIndentedString(this.recurringDetailReference)).append("\n");
        sb.append("    samsungPayToken: ").append(this.toIndentedString(this.samsungPayToken)).append("\n");
        sb.append("    storedPaymentMethodId: ").append(this.toIndentedString(this.storedPaymentMethodId)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in SamsungPayDetails is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `SamsungPayDetails` properties.", entry.getKey()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CHECKOUT_ATTEMPT_ID) != null && !jsonObj.get(SERIALIZED_NAME_CHECKOUT_ATTEMPT_ID).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `checkoutAttemptId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CHECKOUT_ATTEMPT_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_FUNDING_SOURCE) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_FUNDING_SOURCE).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `fundingSource` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FUNDING_SOURCE).toString()));
            }
            FundingSourceEnum.fromValue(jsonObj.get(SERIALIZED_NAME_FUNDING_SOURCE).getAsString());
        }
        if (jsonObj.get(SERIALIZED_NAME_RECURRING_DETAIL_REFERENCE) != null && !jsonObj.get(SERIALIZED_NAME_RECURRING_DETAIL_REFERENCE).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `recurringDetailReference` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RECURRING_DETAIL_REFERENCE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SAMSUNG_PAY_TOKEN) != null && !jsonObj.get(SERIALIZED_NAME_SAMSUNG_PAY_TOKEN).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `samsungPayToken` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SAMSUNG_PAY_TOKEN).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_STORED_PAYMENT_METHOD_ID) != null && !jsonObj.get(SERIALIZED_NAME_STORED_PAYMENT_METHOD_ID).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `storedPaymentMethodId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STORED_PAYMENT_METHOD_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TYPE) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_TYPE).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TYPE).toString()));
            }
            TypeEnum.fromValue(jsonObj.get(SERIALIZED_NAME_TYPE).getAsString());
        }
    }

    public static SamsungPayDetails fromJson(String jsonString) throws IOException {
        return (SamsungPayDetails)JSON.getGson().fromJson(jsonString, SamsungPayDetails.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_CHECKOUT_ATTEMPT_ID);
        openapiFields.add(SERIALIZED_NAME_FUNDING_SOURCE);
        openapiFields.add(SERIALIZED_NAME_RECURRING_DETAIL_REFERENCE);
        openapiFields.add(SERIALIZED_NAME_SAMSUNG_PAY_TOKEN);
        openapiFields.add(SERIALIZED_NAME_STORED_PAYMENT_METHOD_ID);
        openapiFields.add(SERIALIZED_NAME_TYPE);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_SAMSUNG_PAY_TOKEN);
        log = Logger.getLogger(SamsungPayDetails.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!SamsungPayDetails.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(SamsungPayDetails.class));
            return new TypeAdapter<SamsungPayDetails>(){

                public void write(JsonWriter out, SamsungPayDetails value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public SamsungPayDetails read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    SamsungPayDetails.validateJsonObject(jsonObj);
                    return (SamsungPayDetails)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        SAMSUNGPAY("samsungpay");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum FundingSourceEnum {
        DEBIT("debit");

        private String value;

        private FundingSourceEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static FundingSourceEnum fromValue(String value) {
            for (FundingSourceEnum b : FundingSourceEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<FundingSourceEnum> {
            public void write(JsonWriter jsonWriter, FundingSourceEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public FundingSourceEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return FundingSourceEnum.fromValue(value);
            }
        }
    }
}

