/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.JSON;
import com.adyen.model.checkout.StoredPaymentMethodResource;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ListStoredPaymentMethodsResponse {
    public static final String SERIALIZED_NAME_MERCHANT_ACCOUNT = "merchantAccount";
    @SerializedName(value="merchantAccount")
    private String merchantAccount;
    public static final String SERIALIZED_NAME_SHOPPER_REFERENCE = "shopperReference";
    @SerializedName(value="shopperReference")
    private String shopperReference;
    public static final String SERIALIZED_NAME_STORED_PAYMENT_METHODS = "storedPaymentMethods";
    @SerializedName(value="storedPaymentMethods")
    private List<StoredPaymentMethodResource> storedPaymentMethods = null;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public ListStoredPaymentMethodsResponse merchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
        return this;
    }

    @ApiModelProperty(value="Your merchant account.")
    public String getMerchantAccount() {
        return this.merchantAccount;
    }

    public void setMerchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
    }

    public ListStoredPaymentMethodsResponse shopperReference(String shopperReference) {
        this.shopperReference = shopperReference;
        return this;
    }

    @ApiModelProperty(value="Your reference to uniquely identify this shopper, for example user ID or account ID. Minimum length: 3 characters. > Your reference must not include personally identifiable information (PII), for example name or email address.")
    public String getShopperReference() {
        return this.shopperReference;
    }

    public void setShopperReference(String shopperReference) {
        this.shopperReference = shopperReference;
    }

    public ListStoredPaymentMethodsResponse storedPaymentMethods(List<StoredPaymentMethodResource> storedPaymentMethods) {
        this.storedPaymentMethods = storedPaymentMethods;
        return this;
    }

    public ListStoredPaymentMethodsResponse addStoredPaymentMethodsItem(StoredPaymentMethodResource storedPaymentMethodsItem) {
        if (this.storedPaymentMethods == null) {
            this.storedPaymentMethods = new ArrayList<StoredPaymentMethodResource>();
        }
        this.storedPaymentMethods.add(storedPaymentMethodsItem);
        return this;
    }

    @ApiModelProperty(value="List of all stored payment methods.")
    public List<StoredPaymentMethodResource> getStoredPaymentMethods() {
        return this.storedPaymentMethods;
    }

    public void setStoredPaymentMethods(List<StoredPaymentMethodResource> storedPaymentMethods) {
        this.storedPaymentMethods = storedPaymentMethods;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListStoredPaymentMethodsResponse listStoredPaymentMethodsResponse = (ListStoredPaymentMethodsResponse)o;
        return Objects.equals(this.merchantAccount, listStoredPaymentMethodsResponse.merchantAccount) && Objects.equals(this.shopperReference, listStoredPaymentMethodsResponse.shopperReference) && Objects.equals(this.storedPaymentMethods, listStoredPaymentMethodsResponse.storedPaymentMethods);
    }

    public int hashCode() {
        return Objects.hash(this.merchantAccount, this.shopperReference, this.storedPaymentMethods);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ListStoredPaymentMethodsResponse {\n");
        sb.append("    merchantAccount: ").append(this.toIndentedString(this.merchantAccount)).append("\n");
        sb.append("    shopperReference: ").append(this.toIndentedString(this.shopperReference)).append("\n");
        sb.append("    storedPaymentMethods: ").append(this.toIndentedString(this.storedPaymentMethods)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArraystoredPaymentMethods;
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in ListStoredPaymentMethodsResponse is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `ListStoredPaymentMethodsResponse` properties.", entry.getKey()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MERCHANT_ACCOUNT) != null && !jsonObj.get(SERIALIZED_NAME_MERCHANT_ACCOUNT).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `merchantAccount` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MERCHANT_ACCOUNT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SHOPPER_REFERENCE) != null && !jsonObj.get(SERIALIZED_NAME_SHOPPER_REFERENCE).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `shopperReference` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SHOPPER_REFERENCE).toString()));
        }
        if ((jsonArraystoredPaymentMethods = jsonObj.getAsJsonArray(SERIALIZED_NAME_STORED_PAYMENT_METHODS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_STORED_PAYMENT_METHODS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `storedPaymentMethods` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STORED_PAYMENT_METHODS).toString()));
            }
            for (int i = 0; i < jsonArraystoredPaymentMethods.size(); ++i) {
                StoredPaymentMethodResource.validateJsonObject(jsonArraystoredPaymentMethods.get(i).getAsJsonObject());
            }
        }
    }

    public static ListStoredPaymentMethodsResponse fromJson(String jsonString) throws IOException {
        return (ListStoredPaymentMethodsResponse)JSON.getGson().fromJson(jsonString, ListStoredPaymentMethodsResponse.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_MERCHANT_ACCOUNT);
        openapiFields.add(SERIALIZED_NAME_SHOPPER_REFERENCE);
        openapiFields.add(SERIALIZED_NAME_STORED_PAYMENT_METHODS);
        openapiRequiredFields = new HashSet();
        log = Logger.getLogger(ListStoredPaymentMethodsResponse.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!ListStoredPaymentMethodsResponse.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(ListStoredPaymentMethodsResponse.class));
            return new TypeAdapter<ListStoredPaymentMethodsResponse>(){

                public void write(JsonWriter out, ListStoredPaymentMethodsResponse value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public ListStoredPaymentMethodsResponse read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    ListStoredPaymentMethodsResponse.validateJsonObject(jsonObj);
                    return (ListStoredPaymentMethodsResponse)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

