/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.AccountInfo;
import com.adyen.model.checkout.Address;
import com.adyen.model.checkout.Amount;
import com.adyen.model.checkout.ApplicationInfo;
import com.adyen.model.checkout.AuthenticationData;
import com.adyen.model.checkout.CheckoutSessionInstallmentOption;
import com.adyen.model.checkout.Company;
import com.adyen.model.checkout.FundOrigin;
import com.adyen.model.checkout.FundRecipient;
import com.adyen.model.checkout.JSON;
import com.adyen.model.checkout.LineItem;
import com.adyen.model.checkout.Mandate;
import com.adyen.model.checkout.Name;
import com.adyen.model.checkout.RiskData;
import com.adyen.model.checkout.Split;
import com.adyen.model.checkout.ThreeDSecureData;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CreateCheckoutSessionResponse {
    public static final String SERIALIZED_NAME_ACCOUNT_INFO = "accountInfo";
    @SerializedName(value="accountInfo")
    private AccountInfo accountInfo;
    public static final String SERIALIZED_NAME_ADDITIONAL_AMOUNT = "additionalAmount";
    @SerializedName(value="additionalAmount")
    private Amount additionalAmount;
    public static final String SERIALIZED_NAME_ADDITIONAL_DATA = "additionalData";
    @SerializedName(value="additionalData")
    private Map<String, String> additionalData = null;
    public static final String SERIALIZED_NAME_ALLOWED_PAYMENT_METHODS = "allowedPaymentMethods";
    @SerializedName(value="allowedPaymentMethods")
    private List<String> allowedPaymentMethods = null;
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private Amount amount;
    public static final String SERIALIZED_NAME_APPLICATION_INFO = "applicationInfo";
    @SerializedName(value="applicationInfo")
    private ApplicationInfo applicationInfo;
    public static final String SERIALIZED_NAME_AUTHENTICATION_DATA = "authenticationData";
    @SerializedName(value="authenticationData")
    private AuthenticationData authenticationData;
    public static final String SERIALIZED_NAME_BILLING_ADDRESS = "billingAddress";
    @SerializedName(value="billingAddress")
    private Address billingAddress;
    public static final String SERIALIZED_NAME_BLOCKED_PAYMENT_METHODS = "blockedPaymentMethods";
    @SerializedName(value="blockedPaymentMethods")
    private List<String> blockedPaymentMethods = null;
    public static final String SERIALIZED_NAME_CAPTURE_DELAY_HOURS = "captureDelayHours";
    @SerializedName(value="captureDelayHours")
    private Integer captureDelayHours;
    public static final String SERIALIZED_NAME_CHANNEL = "channel";
    @SerializedName(value="channel")
    private ChannelEnum channel;
    public static final String SERIALIZED_NAME_COMPANY = "company";
    @SerializedName(value="company")
    private Company company;
    public static final String SERIALIZED_NAME_COUNTRY_CODE = "countryCode";
    @SerializedName(value="countryCode")
    private String countryCode;
    public static final String SERIALIZED_NAME_DATE_OF_BIRTH = "dateOfBirth";
    @SerializedName(value="dateOfBirth")
    private LocalDate dateOfBirth;
    public static final String SERIALIZED_NAME_DELIVER_AT = "deliverAt";
    @SerializedName(value="deliverAt")
    private OffsetDateTime deliverAt;
    public static final String SERIALIZED_NAME_DELIVERY_ADDRESS = "deliveryAddress";
    @SerializedName(value="deliveryAddress")
    private Address deliveryAddress;
    public static final String SERIALIZED_NAME_ENABLE_ONE_CLICK = "enableOneClick";
    @SerializedName(value="enableOneClick")
    private Boolean enableOneClick;
    public static final String SERIALIZED_NAME_ENABLE_PAY_OUT = "enablePayOut";
    @SerializedName(value="enablePayOut")
    private Boolean enablePayOut;
    public static final String SERIALIZED_NAME_ENABLE_RECURRING = "enableRecurring";
    @SerializedName(value="enableRecurring")
    private Boolean enableRecurring;
    public static final String SERIALIZED_NAME_EXPIRES_AT = "expiresAt";
    @SerializedName(value="expiresAt")
    private OffsetDateTime expiresAt;
    public static final String SERIALIZED_NAME_FUND_ORIGIN = "fundOrigin";
    @SerializedName(value="fundOrigin")
    private FundOrigin fundOrigin;
    public static final String SERIALIZED_NAME_FUND_RECIPIENT = "fundRecipient";
    @SerializedName(value="fundRecipient")
    private FundRecipient fundRecipient;
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_INSTALLMENT_OPTIONS = "installmentOptions";
    @SerializedName(value="installmentOptions")
    private Map<String, CheckoutSessionInstallmentOption> installmentOptions = null;
    public static final String SERIALIZED_NAME_LINE_ITEMS = "lineItems";
    @SerializedName(value="lineItems")
    private List<LineItem> lineItems = null;
    public static final String SERIALIZED_NAME_MANDATE = "mandate";
    @SerializedName(value="mandate")
    private Mandate mandate;
    public static final String SERIALIZED_NAME_MCC = "mcc";
    @SerializedName(value="mcc")
    private String mcc;
    public static final String SERIALIZED_NAME_MERCHANT_ACCOUNT = "merchantAccount";
    @SerializedName(value="merchantAccount")
    private String merchantAccount;
    public static final String SERIALIZED_NAME_MERCHANT_ORDER_REFERENCE = "merchantOrderReference";
    @SerializedName(value="merchantOrderReference")
    private String merchantOrderReference;
    public static final String SERIALIZED_NAME_METADATA = "metadata";
    @SerializedName(value="metadata")
    private Map<String, String> metadata = null;
    public static final String SERIALIZED_NAME_MODE = "mode";
    @SerializedName(value="mode")
    private ModeEnum mode = ModeEnum.EMBEDDED;
    public static final String SERIALIZED_NAME_MPI_DATA = "mpiData";
    @SerializedName(value="mpiData")
    private ThreeDSecureData mpiData;
    public static final String SERIALIZED_NAME_RECURRING_EXPIRY = "recurringExpiry";
    @SerializedName(value="recurringExpiry")
    private String recurringExpiry;
    public static final String SERIALIZED_NAME_RECURRING_FREQUENCY = "recurringFrequency";
    @SerializedName(value="recurringFrequency")
    private String recurringFrequency;
    public static final String SERIALIZED_NAME_RECURRING_PROCESSING_MODEL = "recurringProcessingModel";
    @SerializedName(value="recurringProcessingModel")
    private RecurringProcessingModelEnum recurringProcessingModel;
    public static final String SERIALIZED_NAME_REDIRECT_FROM_ISSUER_METHOD = "redirectFromIssuerMethod";
    @SerializedName(value="redirectFromIssuerMethod")
    private String redirectFromIssuerMethod;
    public static final String SERIALIZED_NAME_REDIRECT_TO_ISSUER_METHOD = "redirectToIssuerMethod";
    @SerializedName(value="redirectToIssuerMethod")
    private String redirectToIssuerMethod;
    public static final String SERIALIZED_NAME_REFERENCE = "reference";
    @SerializedName(value="reference")
    private String reference;
    public static final String SERIALIZED_NAME_RETURN_URL = "returnUrl";
    @SerializedName(value="returnUrl")
    private String returnUrl;
    public static final String SERIALIZED_NAME_RISK_DATA = "riskData";
    @SerializedName(value="riskData")
    private RiskData riskData;
    public static final String SERIALIZED_NAME_SESSION_DATA = "sessionData";
    @SerializedName(value="sessionData")
    private String sessionData;
    public static final String SERIALIZED_NAME_SHOPPER_EMAIL = "shopperEmail";
    @SerializedName(value="shopperEmail")
    private String shopperEmail;
    public static final String SERIALIZED_NAME_SHOPPER_I_P = "shopperIP";
    @SerializedName(value="shopperIP")
    private String shopperIP;
    public static final String SERIALIZED_NAME_SHOPPER_INTERACTION = "shopperInteraction";
    @SerializedName(value="shopperInteraction")
    private ShopperInteractionEnum shopperInteraction;
    public static final String SERIALIZED_NAME_SHOPPER_LOCALE = "shopperLocale";
    @SerializedName(value="shopperLocale")
    private String shopperLocale;
    public static final String SERIALIZED_NAME_SHOPPER_NAME = "shopperName";
    @SerializedName(value="shopperName")
    private Name shopperName;
    public static final String SERIALIZED_NAME_SHOPPER_REFERENCE = "shopperReference";
    @SerializedName(value="shopperReference")
    private String shopperReference;
    public static final String SERIALIZED_NAME_SHOPPER_STATEMENT = "shopperStatement";
    @SerializedName(value="shopperStatement")
    private String shopperStatement;
    public static final String SERIALIZED_NAME_SOCIAL_SECURITY_NUMBER = "socialSecurityNumber";
    @SerializedName(value="socialSecurityNumber")
    private String socialSecurityNumber;
    public static final String SERIALIZED_NAME_SPLIT_CARD_FUNDING_SOURCES = "splitCardFundingSources";
    @SerializedName(value="splitCardFundingSources")
    private Boolean splitCardFundingSources = false;
    public static final String SERIALIZED_NAME_SPLITS = "splits";
    @SerializedName(value="splits")
    private List<Split> splits = null;
    public static final String SERIALIZED_NAME_STORE = "store";
    @SerializedName(value="store")
    private String store;
    public static final String SERIALIZED_NAME_STORE_PAYMENT_METHOD = "storePaymentMethod";
    @SerializedName(value="storePaymentMethod")
    private Boolean storePaymentMethod;
    public static final String SERIALIZED_NAME_STORE_PAYMENT_METHOD_MODE = "storePaymentMethodMode";
    @SerializedName(value="storePaymentMethodMode")
    private StorePaymentMethodModeEnum storePaymentMethodMode;
    public static final String SERIALIZED_NAME_TELEPHONE_NUMBER = "telephoneNumber";
    @SerializedName(value="telephoneNumber")
    private String telephoneNumber;
    public static final String SERIALIZED_NAME_THREE_D_S_AUTHENTICATION_ONLY = "threeDSAuthenticationOnly";
    @Deprecated
    @SerializedName(value="threeDSAuthenticationOnly")
    private Boolean threeDSAuthenticationOnly = false;
    public static final String SERIALIZED_NAME_TRUSTED_SHOPPER = "trustedShopper";
    @SerializedName(value="trustedShopper")
    private Boolean trustedShopper;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public CreateCheckoutSessionResponse() {
    }

    public CreateCheckoutSessionResponse(String id) {
        this();
        this.id = id;
    }

    public CreateCheckoutSessionResponse accountInfo(AccountInfo accountInfo) {
        this.accountInfo = accountInfo;
        return this;
    }

    @ApiModelProperty(value="")
    public AccountInfo getAccountInfo() {
        return this.accountInfo;
    }

    public void setAccountInfo(AccountInfo accountInfo) {
        this.accountInfo = accountInfo;
    }

    public CreateCheckoutSessionResponse additionalAmount(Amount additionalAmount) {
        this.additionalAmount = additionalAmount;
        return this;
    }

    @ApiModelProperty(value="")
    public Amount getAdditionalAmount() {
        return this.additionalAmount;
    }

    public void setAdditionalAmount(Amount additionalAmount) {
        this.additionalAmount = additionalAmount;
    }

    public CreateCheckoutSessionResponse additionalData(Map<String, String> additionalData) {
        this.additionalData = additionalData;
        return this;
    }

    public CreateCheckoutSessionResponse putAdditionalDataItem(String key, String additionalDataItem) {
        if (this.additionalData == null) {
            this.additionalData = new HashMap<String, String>();
        }
        this.additionalData.put(key, additionalDataItem);
        return this;
    }

    @ApiModelProperty(value="This field contains additional data, which may be required for a particular payment request.  The `additionalData` object consists of entries, each of which includes the key and value.")
    public Map<String, String> getAdditionalData() {
        return this.additionalData;
    }

    public void setAdditionalData(Map<String, String> additionalData) {
        this.additionalData = additionalData;
    }

    public CreateCheckoutSessionResponse allowedPaymentMethods(List<String> allowedPaymentMethods) {
        this.allowedPaymentMethods = allowedPaymentMethods;
        return this;
    }

    public CreateCheckoutSessionResponse addAllowedPaymentMethodsItem(String allowedPaymentMethodsItem) {
        if (this.allowedPaymentMethods == null) {
            this.allowedPaymentMethods = new ArrayList<String>();
        }
        this.allowedPaymentMethods.add(allowedPaymentMethodsItem);
        return this;
    }

    @ApiModelProperty(value="List of payment methods to be presented to the shopper. To refer to payment methods, use their [payment method type](https://docs.adyen.com/payment-methods/payment-method-types).  Example: `\"allowedPaymentMethods\":[\"ideal\",\"giropay\"]`")
    public List<String> getAllowedPaymentMethods() {
        return this.allowedPaymentMethods;
    }

    public void setAllowedPaymentMethods(List<String> allowedPaymentMethods) {
        this.allowedPaymentMethods = allowedPaymentMethods;
    }

    public CreateCheckoutSessionResponse amount(Amount amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Amount getAmount() {
        return this.amount;
    }

    public void setAmount(Amount amount) {
        this.amount = amount;
    }

    public CreateCheckoutSessionResponse applicationInfo(ApplicationInfo applicationInfo) {
        this.applicationInfo = applicationInfo;
        return this;
    }

    @ApiModelProperty(value="")
    public ApplicationInfo getApplicationInfo() {
        return this.applicationInfo;
    }

    public void setApplicationInfo(ApplicationInfo applicationInfo) {
        this.applicationInfo = applicationInfo;
    }

    public CreateCheckoutSessionResponse authenticationData(AuthenticationData authenticationData) {
        this.authenticationData = authenticationData;
        return this;
    }

    @ApiModelProperty(value="")
    public AuthenticationData getAuthenticationData() {
        return this.authenticationData;
    }

    public void setAuthenticationData(AuthenticationData authenticationData) {
        this.authenticationData = authenticationData;
    }

    public CreateCheckoutSessionResponse billingAddress(Address billingAddress) {
        this.billingAddress = billingAddress;
        return this;
    }

    @ApiModelProperty(value="")
    public Address getBillingAddress() {
        return this.billingAddress;
    }

    public void setBillingAddress(Address billingAddress) {
        this.billingAddress = billingAddress;
    }

    public CreateCheckoutSessionResponse blockedPaymentMethods(List<String> blockedPaymentMethods) {
        this.blockedPaymentMethods = blockedPaymentMethods;
        return this;
    }

    public CreateCheckoutSessionResponse addBlockedPaymentMethodsItem(String blockedPaymentMethodsItem) {
        if (this.blockedPaymentMethods == null) {
            this.blockedPaymentMethods = new ArrayList<String>();
        }
        this.blockedPaymentMethods.add(blockedPaymentMethodsItem);
        return this;
    }

    @ApiModelProperty(value="List of payment methods to be hidden from the shopper. To refer to payment methods, use their [payment method type](https://docs.adyen.com/payment-methods/payment-method-types).  Example: `\"blockedPaymentMethods\":[\"ideal\",\"giropay\"]`")
    public List<String> getBlockedPaymentMethods() {
        return this.blockedPaymentMethods;
    }

    public void setBlockedPaymentMethods(List<String> blockedPaymentMethods) {
        this.blockedPaymentMethods = blockedPaymentMethods;
    }

    public CreateCheckoutSessionResponse captureDelayHours(Integer captureDelayHours) {
        this.captureDelayHours = captureDelayHours;
        return this;
    }

    @ApiModelProperty(value="The delay between the authorisation and scheduled auto-capture, specified in hours.")
    public Integer getCaptureDelayHours() {
        return this.captureDelayHours;
    }

    public void setCaptureDelayHours(Integer captureDelayHours) {
        this.captureDelayHours = captureDelayHours;
    }

    public CreateCheckoutSessionResponse channel(ChannelEnum channel) {
        this.channel = channel;
        return this;
    }

    @ApiModelProperty(value="The platform where a payment transaction takes place. This field is optional for filtering out payment methods that are only available on specific platforms. If this value is not set, then we will try to infer it from the `sdkVersion` or `token`.  Possible values: * **iOS** * **Android** * **Web**")
    public ChannelEnum getChannel() {
        return this.channel;
    }

    public void setChannel(ChannelEnum channel) {
        this.channel = channel;
    }

    public CreateCheckoutSessionResponse company(Company company) {
        this.company = company;
        return this;
    }

    @ApiModelProperty(value="")
    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public CreateCheckoutSessionResponse countryCode(String countryCode) {
        this.countryCode = countryCode;
        return this;
    }

    @ApiModelProperty(value="The shopper's two-letter country code.")
    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public CreateCheckoutSessionResponse dateOfBirth(LocalDate dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
        return this;
    }

    @ApiModelProperty(value="The shopper's date of birth.  Format [ISO-8601](https://www.w3.org/TR/NOTE-datetime): YYYY-MM-DD")
    public LocalDate getDateOfBirth() {
        return this.dateOfBirth;
    }

    public void setDateOfBirth(LocalDate dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
    }

    public CreateCheckoutSessionResponse deliverAt(OffsetDateTime deliverAt) {
        this.deliverAt = deliverAt;
        return this;
    }

    @ApiModelProperty(value="The date and time when the purchased goods should be delivered.  [ISO 8601](https://www.w3.org/TR/NOTE-datetime) format: YYYY-MM-DDThh:mm:ss+TZD, for example, **2020-12-18T10:15:30+01:00**.")
    public OffsetDateTime getDeliverAt() {
        return this.deliverAt;
    }

    public void setDeliverAt(OffsetDateTime deliverAt) {
        this.deliverAt = deliverAt;
    }

    public CreateCheckoutSessionResponse deliveryAddress(Address deliveryAddress) {
        this.deliveryAddress = deliveryAddress;
        return this;
    }

    @ApiModelProperty(value="")
    public Address getDeliveryAddress() {
        return this.deliveryAddress;
    }

    public void setDeliveryAddress(Address deliveryAddress) {
        this.deliveryAddress = deliveryAddress;
    }

    public CreateCheckoutSessionResponse enableOneClick(Boolean enableOneClick) {
        this.enableOneClick = enableOneClick;
        return this;
    }

    @ApiModelProperty(value="When true and `shopperReference` is provided, the shopper will be asked if the payment details should be stored for future one-click payments.")
    public Boolean getEnableOneClick() {
        return this.enableOneClick;
    }

    public void setEnableOneClick(Boolean enableOneClick) {
        this.enableOneClick = enableOneClick;
    }

    public CreateCheckoutSessionResponse enablePayOut(Boolean enablePayOut) {
        this.enablePayOut = enablePayOut;
        return this;
    }

    @ApiModelProperty(value="When true and `shopperReference` is provided, the payment details will be tokenized for payouts.")
    public Boolean getEnablePayOut() {
        return this.enablePayOut;
    }

    public void setEnablePayOut(Boolean enablePayOut) {
        this.enablePayOut = enablePayOut;
    }

    public CreateCheckoutSessionResponse enableRecurring(Boolean enableRecurring) {
        this.enableRecurring = enableRecurring;
        return this;
    }

    @ApiModelProperty(value="When true and `shopperReference` is provided, the payment details will be tokenized for recurring payments.")
    public Boolean getEnableRecurring() {
        return this.enableRecurring;
    }

    public void setEnableRecurring(Boolean enableRecurring) {
        this.enableRecurring = enableRecurring;
    }

    public CreateCheckoutSessionResponse expiresAt(OffsetDateTime expiresAt) {
        this.expiresAt = expiresAt;
        return this;
    }

    @ApiModelProperty(required=true, value="The date the session expires in [ISO8601](https://www.iso.org/iso-8601-date-and-time-format.html) format. When not specified, the expiry date is set to 1 hour after session creation. You cannot set the session expiry to more than 24 hours after session creation.")
    public OffsetDateTime getExpiresAt() {
        return this.expiresAt;
    }

    public void setExpiresAt(OffsetDateTime expiresAt) {
        this.expiresAt = expiresAt;
    }

    public CreateCheckoutSessionResponse fundOrigin(FundOrigin fundOrigin) {
        this.fundOrigin = fundOrigin;
        return this;
    }

    @ApiModelProperty(value="")
    public FundOrigin getFundOrigin() {
        return this.fundOrigin;
    }

    public void setFundOrigin(FundOrigin fundOrigin) {
        this.fundOrigin = fundOrigin;
    }

    public CreateCheckoutSessionResponse fundRecipient(FundRecipient fundRecipient) {
        this.fundRecipient = fundRecipient;
        return this;
    }

    @ApiModelProperty(value="")
    public FundRecipient getFundRecipient() {
        return this.fundRecipient;
    }

    public void setFundRecipient(FundRecipient fundRecipient) {
        this.fundRecipient = fundRecipient;
    }

    @ApiModelProperty(required=true, value="A unique identifier of the session.")
    public String getId() {
        return this.id;
    }

    public CreateCheckoutSessionResponse installmentOptions(Map<String, CheckoutSessionInstallmentOption> installmentOptions) {
        this.installmentOptions = installmentOptions;
        return this;
    }

    public CreateCheckoutSessionResponse putInstallmentOptionsItem(String key, CheckoutSessionInstallmentOption installmentOptionsItem) {
        if (this.installmentOptions == null) {
            this.installmentOptions = new HashMap<String, CheckoutSessionInstallmentOption>();
        }
        this.installmentOptions.put(key, installmentOptionsItem);
        return this;
    }

    @ApiModelProperty(value="A set of key-value pairs that specifies the installment options available per payment method. The key must be a payment method name in lowercase. For example, **card** to specify installment options for all cards, or **visa** or **mc**. The value must be an object containing the installment options.")
    public Map<String, CheckoutSessionInstallmentOption> getInstallmentOptions() {
        return this.installmentOptions;
    }

    public void setInstallmentOptions(Map<String, CheckoutSessionInstallmentOption> installmentOptions) {
        this.installmentOptions = installmentOptions;
    }

    public CreateCheckoutSessionResponse lineItems(List<LineItem> lineItems) {
        this.lineItems = lineItems;
        return this;
    }

    public CreateCheckoutSessionResponse addLineItemsItem(LineItem lineItemsItem) {
        if (this.lineItems == null) {
            this.lineItems = new ArrayList<LineItem>();
        }
        this.lineItems.add(lineItemsItem);
        return this;
    }

    @ApiModelProperty(value="Price and product information about the purchased items, to be included on the invoice sent to the shopper. > This field is required for 3x 4x Oney, Affirm, Afterpay, Clearpay, Klarna, Ratepay, and Zip.")
    public List<LineItem> getLineItems() {
        return this.lineItems;
    }

    public void setLineItems(List<LineItem> lineItems) {
        this.lineItems = lineItems;
    }

    public CreateCheckoutSessionResponse mandate(Mandate mandate) {
        this.mandate = mandate;
        return this;
    }

    @ApiModelProperty(value="")
    public Mandate getMandate() {
        return this.mandate;
    }

    public void setMandate(Mandate mandate) {
        this.mandate = mandate;
    }

    public CreateCheckoutSessionResponse mcc(String mcc) {
        this.mcc = mcc;
        return this;
    }

    @ApiModelProperty(value="The [merchant category code](https://en.wikipedia.org/wiki/Merchant_category_code) (MCC) is a four-digit number, which relates to a particular market segment. This code reflects the predominant activity that is conducted by the merchant.")
    public String getMcc() {
        return this.mcc;
    }

    public void setMcc(String mcc) {
        this.mcc = mcc;
    }

    public CreateCheckoutSessionResponse merchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
        return this;
    }

    @ApiModelProperty(required=true, value="The merchant account identifier, with which you want to process the transaction.")
    public String getMerchantAccount() {
        return this.merchantAccount;
    }

    public void setMerchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
    }

    public CreateCheckoutSessionResponse merchantOrderReference(String merchantOrderReference) {
        this.merchantOrderReference = merchantOrderReference;
        return this;
    }

    @ApiModelProperty(value="This reference allows linking multiple transactions to each other for reporting purposes (i.e. order auth-rate). The reference should be unique per billing cycle. The same merchant order reference should never be reused after the first authorised attempt. If used, this field should be supplied for all incoming authorisations. > We strongly recommend you send the `merchantOrderReference` value to benefit from linking payment requests when authorisation retries take place. In addition, we recommend you provide `retry.orderAttemptNumber`, `retry.chainAttemptNumber`, and `retry.skipRetry` values in `PaymentRequest.additionalData`.")
    public String getMerchantOrderReference() {
        return this.merchantOrderReference;
    }

    public void setMerchantOrderReference(String merchantOrderReference) {
        this.merchantOrderReference = merchantOrderReference;
    }

    public CreateCheckoutSessionResponse metadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public CreateCheckoutSessionResponse putMetadataItem(String key, String metadataItem) {
        if (this.metadata == null) {
            this.metadata = new HashMap<String, String>();
        }
        this.metadata.put(key, metadataItem);
        return this;
    }

    @ApiModelProperty(value="Metadata consists of entries, each of which includes a key and a value. Limits: * Maximum 20 key-value pairs per request. * Maximum 20 characters per key. * Maximum 80 characters per value. ")
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public CreateCheckoutSessionResponse mode(ModeEnum mode) {
        this.mode = mode;
        return this;
    }

    @ApiModelProperty(value="Indicates the type of front end integration. Possible values: * **embedded** (default): Drop-in or Components integration * **hosted**: Hosted Checkout integration")
    public ModeEnum getMode() {
        return this.mode;
    }

    public void setMode(ModeEnum mode) {
        this.mode = mode;
    }

    public CreateCheckoutSessionResponse mpiData(ThreeDSecureData mpiData) {
        this.mpiData = mpiData;
        return this;
    }

    @ApiModelProperty(value="")
    public ThreeDSecureData getMpiData() {
        return this.mpiData;
    }

    public void setMpiData(ThreeDSecureData mpiData) {
        this.mpiData = mpiData;
    }

    public CreateCheckoutSessionResponse recurringExpiry(String recurringExpiry) {
        this.recurringExpiry = recurringExpiry;
        return this;
    }

    @ApiModelProperty(value="Date after which no further authorisations shall be performed. Only for 3D Secure 2.")
    public String getRecurringExpiry() {
        return this.recurringExpiry;
    }

    public void setRecurringExpiry(String recurringExpiry) {
        this.recurringExpiry = recurringExpiry;
    }

    public CreateCheckoutSessionResponse recurringFrequency(String recurringFrequency) {
        this.recurringFrequency = recurringFrequency;
        return this;
    }

    @ApiModelProperty(value="Minimum number of days between authorisations. Only for 3D Secure 2.")
    public String getRecurringFrequency() {
        return this.recurringFrequency;
    }

    public void setRecurringFrequency(String recurringFrequency) {
        this.recurringFrequency = recurringFrequency;
    }

    public CreateCheckoutSessionResponse recurringProcessingModel(RecurringProcessingModelEnum recurringProcessingModel) {
        this.recurringProcessingModel = recurringProcessingModel;
        return this;
    }

    @ApiModelProperty(value="Defines a recurring payment type. Required when creating a token to store payment details. Allowed values: * `Subscription` \u2013 A transaction for a fixed or variable amount, which follows a fixed schedule. * `CardOnFile` \u2013 With a card-on-file (CoF) transaction, card details are stored to enable one-click or omnichannel journeys, or simply to streamline the checkout process. Any subscription not following a fixed schedule is also considered a card-on-file transaction. * `UnscheduledCardOnFile` \u2013 An unscheduled card-on-file (UCoF) transaction is a transaction that occurs on a non-fixed schedule and/or have variable amounts. For example, automatic top-ups when a cardholder's balance drops below a certain amount. ")
    public RecurringProcessingModelEnum getRecurringProcessingModel() {
        return this.recurringProcessingModel;
    }

    public void setRecurringProcessingModel(RecurringProcessingModelEnum recurringProcessingModel) {
        this.recurringProcessingModel = recurringProcessingModel;
    }

    public CreateCheckoutSessionResponse redirectFromIssuerMethod(String redirectFromIssuerMethod) {
        this.redirectFromIssuerMethod = redirectFromIssuerMethod;
        return this;
    }

    @ApiModelProperty(value="Specifies the redirect method (GET or POST) when redirecting back from the issuer.")
    public String getRedirectFromIssuerMethod() {
        return this.redirectFromIssuerMethod;
    }

    public void setRedirectFromIssuerMethod(String redirectFromIssuerMethod) {
        this.redirectFromIssuerMethod = redirectFromIssuerMethod;
    }

    public CreateCheckoutSessionResponse redirectToIssuerMethod(String redirectToIssuerMethod) {
        this.redirectToIssuerMethod = redirectToIssuerMethod;
        return this;
    }

    @ApiModelProperty(value="Specifies the redirect method (GET or POST) when redirecting to the issuer.")
    public String getRedirectToIssuerMethod() {
        return this.redirectToIssuerMethod;
    }

    public void setRedirectToIssuerMethod(String redirectToIssuerMethod) {
        this.redirectToIssuerMethod = redirectToIssuerMethod;
    }

    public CreateCheckoutSessionResponse reference(String reference) {
        this.reference = reference;
        return this;
    }

    @ApiModelProperty(required=true, value="The reference to uniquely identify a payment.")
    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public CreateCheckoutSessionResponse returnUrl(String returnUrl) {
        this.returnUrl = returnUrl;
        return this;
    }

    @ApiModelProperty(required=true, value="The URL to return to when a redirect payment is completed.")
    public String getReturnUrl() {
        return this.returnUrl;
    }

    public void setReturnUrl(String returnUrl) {
        this.returnUrl = returnUrl;
    }

    public CreateCheckoutSessionResponse riskData(RiskData riskData) {
        this.riskData = riskData;
        return this;
    }

    @ApiModelProperty(value="")
    public RiskData getRiskData() {
        return this.riskData;
    }

    public void setRiskData(RiskData riskData) {
        this.riskData = riskData;
    }

    public CreateCheckoutSessionResponse sessionData(String sessionData) {
        this.sessionData = sessionData;
        return this;
    }

    @ApiModelProperty(value="The payment session data you need to pass to your front end.")
    public String getSessionData() {
        return this.sessionData;
    }

    public void setSessionData(String sessionData) {
        this.sessionData = sessionData;
    }

    public CreateCheckoutSessionResponse shopperEmail(String shopperEmail) {
        this.shopperEmail = shopperEmail;
        return this;
    }

    @ApiModelProperty(value="The shopper's email address.")
    public String getShopperEmail() {
        return this.shopperEmail;
    }

    public void setShopperEmail(String shopperEmail) {
        this.shopperEmail = shopperEmail;
    }

    public CreateCheckoutSessionResponse shopperIP(String shopperIP) {
        this.shopperIP = shopperIP;
        return this;
    }

    @ApiModelProperty(value="The shopper's IP address. In general, we recommend that you provide this data, as it is used in a number of risk checks (for instance, number of payment attempts or location-based checks). > For 3D Secure 2 transactions, schemes require `shopperIP` for all browser-based implementations. This field is also mandatory for some merchants depending on your business model. For more information, [contact Support](https://www.adyen.help/hc/en-us/requests/new).")
    public String getShopperIP() {
        return this.shopperIP;
    }

    public void setShopperIP(String shopperIP) {
        this.shopperIP = shopperIP;
    }

    public CreateCheckoutSessionResponse shopperInteraction(ShopperInteractionEnum shopperInteraction) {
        this.shopperInteraction = shopperInteraction;
        return this;
    }

    @ApiModelProperty(value="Specifies the sales channel, through which the shopper gives their card details, and whether the shopper is a returning customer. For the web service API, Adyen assumes Ecommerce shopper interaction by default.  This field has the following possible values: * `Ecommerce` - Online transactions where the cardholder is present (online). For better authorisation rates, we recommend sending the card security code (CSC) along with the request. * `ContAuth` - Card on file and/or subscription transactions, where the cardholder is known to the merchant (returning customer). If the shopper is present (online), you can supply also the CSC to improve authorisation (one-click payment). * `Moto` - Mail-order and telephone-order transactions where the shopper is in contact with the merchant via email or telephone. * `POS` - Point-of-sale transactions where the shopper is physically present to make a payment using a secure payment terminal.")
    public ShopperInteractionEnum getShopperInteraction() {
        return this.shopperInteraction;
    }

    public void setShopperInteraction(ShopperInteractionEnum shopperInteraction) {
        this.shopperInteraction = shopperInteraction;
    }

    public CreateCheckoutSessionResponse shopperLocale(String shopperLocale) {
        this.shopperLocale = shopperLocale;
        return this;
    }

    @ApiModelProperty(value="The combination of a language code and a country code to specify the language to be used in the payment.")
    public String getShopperLocale() {
        return this.shopperLocale;
    }

    public void setShopperLocale(String shopperLocale) {
        this.shopperLocale = shopperLocale;
    }

    public CreateCheckoutSessionResponse shopperName(Name shopperName) {
        this.shopperName = shopperName;
        return this;
    }

    @ApiModelProperty(value="")
    public Name getShopperName() {
        return this.shopperName;
    }

    public void setShopperName(Name shopperName) {
        this.shopperName = shopperName;
    }

    public CreateCheckoutSessionResponse shopperReference(String shopperReference) {
        this.shopperReference = shopperReference;
        return this;
    }

    @ApiModelProperty(value="Your reference to uniquely identify this shopper, for example user ID or account ID. Minimum length: 3 characters. > Your reference must not include personally identifiable information (PII), for example name or email address.")
    public String getShopperReference() {
        return this.shopperReference;
    }

    public void setShopperReference(String shopperReference) {
        this.shopperReference = shopperReference;
    }

    public CreateCheckoutSessionResponse shopperStatement(String shopperStatement) {
        this.shopperStatement = shopperStatement;
        return this;
    }

    @ApiModelProperty(value="The text to be shown on the shopper's bank statement.  We recommend sending a maximum of 22 characters, otherwise banks might truncate the string.  Allowed characters: **a-z**, **A-Z**, **0-9**, spaces, and special characters **. , ' _ - ? + * /_**.")
    public String getShopperStatement() {
        return this.shopperStatement;
    }

    public void setShopperStatement(String shopperStatement) {
        this.shopperStatement = shopperStatement;
    }

    public CreateCheckoutSessionResponse socialSecurityNumber(String socialSecurityNumber) {
        this.socialSecurityNumber = socialSecurityNumber;
        return this;
    }

    @ApiModelProperty(value="The shopper's social security number.")
    public String getSocialSecurityNumber() {
        return this.socialSecurityNumber;
    }

    public void setSocialSecurityNumber(String socialSecurityNumber) {
        this.socialSecurityNumber = socialSecurityNumber;
    }

    public CreateCheckoutSessionResponse splitCardFundingSources(Boolean splitCardFundingSources) {
        this.splitCardFundingSources = splitCardFundingSources;
        return this;
    }

    @ApiModelProperty(value="Boolean value indicating whether the card payment method should be split into separate debit and credit options.")
    public Boolean getSplitCardFundingSources() {
        return this.splitCardFundingSources;
    }

    public void setSplitCardFundingSources(Boolean splitCardFundingSources) {
        this.splitCardFundingSources = splitCardFundingSources;
    }

    public CreateCheckoutSessionResponse splits(List<Split> splits) {
        this.splits = splits;
        return this;
    }

    public CreateCheckoutSessionResponse addSplitsItem(Split splitsItem) {
        if (this.splits == null) {
            this.splits = new ArrayList<Split>();
        }
        this.splits.add(splitsItem);
        return this;
    }

    @ApiModelProperty(value="An array of objects specifying how to split a payment when using [Adyen for Platforms](https://docs.adyen.com/marketplaces-and-platforms/processing-payments#providing-split-information), [Classic Platforms integration](https://docs.adyen.com/marketplaces-and-platforms/classic/processing-payments#providing-split-information), or [Issuing](https://docs.adyen.com/issuing/manage-funds#split).")
    public List<Split> getSplits() {
        return this.splits;
    }

    public void setSplits(List<Split> splits) {
        this.splits = splits;
    }

    public CreateCheckoutSessionResponse store(String store) {
        this.store = store;
        return this;
    }

    @ApiModelProperty(value="The ecommerce or point-of-sale store that is processing the payment.")
    public String getStore() {
        return this.store;
    }

    public void setStore(String store) {
        this.store = store;
    }

    public CreateCheckoutSessionResponse storePaymentMethod(Boolean storePaymentMethod) {
        this.storePaymentMethod = storePaymentMethod;
        return this;
    }

    @ApiModelProperty(value="When this is set to **true** and the `shopperReference` is provided, the payment details will be stored.")
    public Boolean getStorePaymentMethod() {
        return this.storePaymentMethod;
    }

    public void setStorePaymentMethod(Boolean storePaymentMethod) {
        this.storePaymentMethod = storePaymentMethod;
    }

    public CreateCheckoutSessionResponse storePaymentMethodMode(StorePaymentMethodModeEnum storePaymentMethodMode) {
        this.storePaymentMethodMode = storePaymentMethodMode;
        return this;
    }

    @ApiModelProperty(value="Indicates if the details of the payment method will be stored for the shopper. Possible values: * **disabled** \u2013 No details will be stored (default). * **askForConsent** \u2013 If the `shopperReference` is provided, the UI lets the shopper choose if they want their payment details to be stored. * **enabled** \u2013 If the `shopperReference` is provided, the details will be stored without asking the shopper for consent.")
    public StorePaymentMethodModeEnum getStorePaymentMethodMode() {
        return this.storePaymentMethodMode;
    }

    public void setStorePaymentMethodMode(StorePaymentMethodModeEnum storePaymentMethodMode) {
        this.storePaymentMethodMode = storePaymentMethodMode;
    }

    public CreateCheckoutSessionResponse telephoneNumber(String telephoneNumber) {
        this.telephoneNumber = telephoneNumber;
        return this;
    }

    @ApiModelProperty(value="The shopper's telephone number.")
    public String getTelephoneNumber() {
        return this.telephoneNumber;
    }

    public void setTelephoneNumber(String telephoneNumber) {
        this.telephoneNumber = telephoneNumber;
    }

    @Deprecated
    public CreateCheckoutSessionResponse threeDSAuthenticationOnly(Boolean threeDSAuthenticationOnly) {
        this.threeDSAuthenticationOnly = threeDSAuthenticationOnly;
        return this;
    }

    @Deprecated
    @ApiModelProperty(value="If set to true, you will only perform the [3D Secure 2 authentication](https://docs.adyen.com/online-payments/3d-secure/other-3ds-flows/authentication-only), and not the payment authorisation.")
    public Boolean getThreeDSAuthenticationOnly() {
        return this.threeDSAuthenticationOnly;
    }

    @Deprecated
    public void setThreeDSAuthenticationOnly(Boolean threeDSAuthenticationOnly) {
        this.threeDSAuthenticationOnly = threeDSAuthenticationOnly;
    }

    public CreateCheckoutSessionResponse trustedShopper(Boolean trustedShopper) {
        this.trustedShopper = trustedShopper;
        return this;
    }

    @ApiModelProperty(value="Set to true if the payment should be routed to a trusted MID.")
    public Boolean getTrustedShopper() {
        return this.trustedShopper;
    }

    public void setTrustedShopper(Boolean trustedShopper) {
        this.trustedShopper = trustedShopper;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateCheckoutSessionResponse createCheckoutSessionResponse = (CreateCheckoutSessionResponse)o;
        return Objects.equals(this.accountInfo, createCheckoutSessionResponse.accountInfo) && Objects.equals(this.additionalAmount, createCheckoutSessionResponse.additionalAmount) && Objects.equals(this.additionalData, createCheckoutSessionResponse.additionalData) && Objects.equals(this.allowedPaymentMethods, createCheckoutSessionResponse.allowedPaymentMethods) && Objects.equals(this.amount, createCheckoutSessionResponse.amount) && Objects.equals(this.applicationInfo, createCheckoutSessionResponse.applicationInfo) && Objects.equals(this.authenticationData, createCheckoutSessionResponse.authenticationData) && Objects.equals(this.billingAddress, createCheckoutSessionResponse.billingAddress) && Objects.equals(this.blockedPaymentMethods, createCheckoutSessionResponse.blockedPaymentMethods) && Objects.equals(this.captureDelayHours, createCheckoutSessionResponse.captureDelayHours) && Objects.equals((Object)this.channel, (Object)createCheckoutSessionResponse.channel) && Objects.equals(this.company, createCheckoutSessionResponse.company) && Objects.equals(this.countryCode, createCheckoutSessionResponse.countryCode) && Objects.equals(this.dateOfBirth, createCheckoutSessionResponse.dateOfBirth) && Objects.equals(this.deliverAt, createCheckoutSessionResponse.deliverAt) && Objects.equals(this.deliveryAddress, createCheckoutSessionResponse.deliveryAddress) && Objects.equals(this.enableOneClick, createCheckoutSessionResponse.enableOneClick) && Objects.equals(this.enablePayOut, createCheckoutSessionResponse.enablePayOut) && Objects.equals(this.enableRecurring, createCheckoutSessionResponse.enableRecurring) && Objects.equals(this.expiresAt, createCheckoutSessionResponse.expiresAt) && Objects.equals(this.fundOrigin, createCheckoutSessionResponse.fundOrigin) && Objects.equals(this.fundRecipient, createCheckoutSessionResponse.fundRecipient) && Objects.equals(this.id, createCheckoutSessionResponse.id) && Objects.equals(this.installmentOptions, createCheckoutSessionResponse.installmentOptions) && Objects.equals(this.lineItems, createCheckoutSessionResponse.lineItems) && Objects.equals(this.mandate, createCheckoutSessionResponse.mandate) && Objects.equals(this.mcc, createCheckoutSessionResponse.mcc) && Objects.equals(this.merchantAccount, createCheckoutSessionResponse.merchantAccount) && Objects.equals(this.merchantOrderReference, createCheckoutSessionResponse.merchantOrderReference) && Objects.equals(this.metadata, createCheckoutSessionResponse.metadata) && Objects.equals((Object)this.mode, (Object)createCheckoutSessionResponse.mode) && Objects.equals(this.mpiData, createCheckoutSessionResponse.mpiData) && Objects.equals(this.recurringExpiry, createCheckoutSessionResponse.recurringExpiry) && Objects.equals(this.recurringFrequency, createCheckoutSessionResponse.recurringFrequency) && Objects.equals((Object)this.recurringProcessingModel, (Object)createCheckoutSessionResponse.recurringProcessingModel) && Objects.equals(this.redirectFromIssuerMethod, createCheckoutSessionResponse.redirectFromIssuerMethod) && Objects.equals(this.redirectToIssuerMethod, createCheckoutSessionResponse.redirectToIssuerMethod) && Objects.equals(this.reference, createCheckoutSessionResponse.reference) && Objects.equals(this.returnUrl, createCheckoutSessionResponse.returnUrl) && Objects.equals(this.riskData, createCheckoutSessionResponse.riskData) && Objects.equals(this.sessionData, createCheckoutSessionResponse.sessionData) && Objects.equals(this.shopperEmail, createCheckoutSessionResponse.shopperEmail) && Objects.equals(this.shopperIP, createCheckoutSessionResponse.shopperIP) && Objects.equals((Object)this.shopperInteraction, (Object)createCheckoutSessionResponse.shopperInteraction) && Objects.equals(this.shopperLocale, createCheckoutSessionResponse.shopperLocale) && Objects.equals(this.shopperName, createCheckoutSessionResponse.shopperName) && Objects.equals(this.shopperReference, createCheckoutSessionResponse.shopperReference) && Objects.equals(this.shopperStatement, createCheckoutSessionResponse.shopperStatement) && Objects.equals(this.socialSecurityNumber, createCheckoutSessionResponse.socialSecurityNumber) && Objects.equals(this.splitCardFundingSources, createCheckoutSessionResponse.splitCardFundingSources) && Objects.equals(this.splits, createCheckoutSessionResponse.splits) && Objects.equals(this.store, createCheckoutSessionResponse.store) && Objects.equals(this.storePaymentMethod, createCheckoutSessionResponse.storePaymentMethod) && Objects.equals((Object)this.storePaymentMethodMode, (Object)createCheckoutSessionResponse.storePaymentMethodMode) && Objects.equals(this.telephoneNumber, createCheckoutSessionResponse.telephoneNumber) && Objects.equals(this.threeDSAuthenticationOnly, createCheckoutSessionResponse.threeDSAuthenticationOnly) && Objects.equals(this.trustedShopper, createCheckoutSessionResponse.trustedShopper);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountInfo, this.additionalAmount, this.additionalData, this.allowedPaymentMethods, this.amount, this.applicationInfo, this.authenticationData, this.billingAddress, this.blockedPaymentMethods, this.captureDelayHours, this.channel, this.company, this.countryCode, this.dateOfBirth, this.deliverAt, this.deliveryAddress, this.enableOneClick, this.enablePayOut, this.enableRecurring, this.expiresAt, this.fundOrigin, this.fundRecipient, this.id, this.installmentOptions, this.lineItems, this.mandate, this.mcc, this.merchantAccount, this.merchantOrderReference, this.metadata, this.mode, this.mpiData, this.recurringExpiry, this.recurringFrequency, this.recurringProcessingModel, this.redirectFromIssuerMethod, this.redirectToIssuerMethod, this.reference, this.returnUrl, this.riskData, this.sessionData, this.shopperEmail, this.shopperIP, this.shopperInteraction, this.shopperLocale, this.shopperName, this.shopperReference, this.shopperStatement, this.socialSecurityNumber, this.splitCardFundingSources, this.splits, this.store, this.storePaymentMethod, this.storePaymentMethodMode, this.telephoneNumber, this.threeDSAuthenticationOnly, this.trustedShopper});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateCheckoutSessionResponse {\n");
        sb.append("    accountInfo: ").append(this.toIndentedString(this.accountInfo)).append("\n");
        sb.append("    additionalAmount: ").append(this.toIndentedString(this.additionalAmount)).append("\n");
        sb.append("    additionalData: ").append(this.toIndentedString(this.additionalData)).append("\n");
        sb.append("    allowedPaymentMethods: ").append(this.toIndentedString(this.allowedPaymentMethods)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    applicationInfo: ").append(this.toIndentedString(this.applicationInfo)).append("\n");
        sb.append("    authenticationData: ").append(this.toIndentedString(this.authenticationData)).append("\n");
        sb.append("    billingAddress: ").append(this.toIndentedString(this.billingAddress)).append("\n");
        sb.append("    blockedPaymentMethods: ").append(this.toIndentedString(this.blockedPaymentMethods)).append("\n");
        sb.append("    captureDelayHours: ").append(this.toIndentedString(this.captureDelayHours)).append("\n");
        sb.append("    channel: ").append(this.toIndentedString((Object)this.channel)).append("\n");
        sb.append("    company: ").append(this.toIndentedString(this.company)).append("\n");
        sb.append("    countryCode: ").append(this.toIndentedString(this.countryCode)).append("\n");
        sb.append("    dateOfBirth: ").append(this.toIndentedString(this.dateOfBirth)).append("\n");
        sb.append("    deliverAt: ").append(this.toIndentedString(this.deliverAt)).append("\n");
        sb.append("    deliveryAddress: ").append(this.toIndentedString(this.deliveryAddress)).append("\n");
        sb.append("    enableOneClick: ").append(this.toIndentedString(this.enableOneClick)).append("\n");
        sb.append("    enablePayOut: ").append(this.toIndentedString(this.enablePayOut)).append("\n");
        sb.append("    enableRecurring: ").append(this.toIndentedString(this.enableRecurring)).append("\n");
        sb.append("    expiresAt: ").append(this.toIndentedString(this.expiresAt)).append("\n");
        sb.append("    fundOrigin: ").append(this.toIndentedString(this.fundOrigin)).append("\n");
        sb.append("    fundRecipient: ").append(this.toIndentedString(this.fundRecipient)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    installmentOptions: ").append(this.toIndentedString(this.installmentOptions)).append("\n");
        sb.append("    lineItems: ").append(this.toIndentedString(this.lineItems)).append("\n");
        sb.append("    mandate: ").append(this.toIndentedString(this.mandate)).append("\n");
        sb.append("    mcc: ").append(this.toIndentedString(this.mcc)).append("\n");
        sb.append("    merchantAccount: ").append(this.toIndentedString(this.merchantAccount)).append("\n");
        sb.append("    merchantOrderReference: ").append(this.toIndentedString(this.merchantOrderReference)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    mode: ").append(this.toIndentedString((Object)this.mode)).append("\n");
        sb.append("    mpiData: ").append(this.toIndentedString(this.mpiData)).append("\n");
        sb.append("    recurringExpiry: ").append(this.toIndentedString(this.recurringExpiry)).append("\n");
        sb.append("    recurringFrequency: ").append(this.toIndentedString(this.recurringFrequency)).append("\n");
        sb.append("    recurringProcessingModel: ").append(this.toIndentedString((Object)this.recurringProcessingModel)).append("\n");
        sb.append("    redirectFromIssuerMethod: ").append(this.toIndentedString(this.redirectFromIssuerMethod)).append("\n");
        sb.append("    redirectToIssuerMethod: ").append(this.toIndentedString(this.redirectToIssuerMethod)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    returnUrl: ").append(this.toIndentedString(this.returnUrl)).append("\n");
        sb.append("    riskData: ").append(this.toIndentedString(this.riskData)).append("\n");
        sb.append("    sessionData: ").append(this.toIndentedString(this.sessionData)).append("\n");
        sb.append("    shopperEmail: ").append(this.toIndentedString(this.shopperEmail)).append("\n");
        sb.append("    shopperIP: ").append(this.toIndentedString(this.shopperIP)).append("\n");
        sb.append("    shopperInteraction: ").append(this.toIndentedString((Object)this.shopperInteraction)).append("\n");
        sb.append("    shopperLocale: ").append(this.toIndentedString(this.shopperLocale)).append("\n");
        sb.append("    shopperName: ").append(this.toIndentedString(this.shopperName)).append("\n");
        sb.append("    shopperReference: ").append(this.toIndentedString(this.shopperReference)).append("\n");
        sb.append("    shopperStatement: ").append(this.toIndentedString(this.shopperStatement)).append("\n");
        sb.append("    socialSecurityNumber: ").append(this.toIndentedString(this.socialSecurityNumber)).append("\n");
        sb.append("    splitCardFundingSources: ").append(this.toIndentedString(this.splitCardFundingSources)).append("\n");
        sb.append("    splits: ").append(this.toIndentedString(this.splits)).append("\n");
        sb.append("    store: ").append(this.toIndentedString(this.store)).append("\n");
        sb.append("    storePaymentMethod: ").append(this.toIndentedString(this.storePaymentMethod)).append("\n");
        sb.append("    storePaymentMethodMode: ").append(this.toIndentedString((Object)this.storePaymentMethodMode)).append("\n");
        sb.append("    telephoneNumber: ").append(this.toIndentedString(this.telephoneNumber)).append("\n");
        sb.append("    threeDSAuthenticationOnly: ").append(this.toIndentedString(this.threeDSAuthenticationOnly)).append("\n");
        sb.append("    trustedShopper: ").append(this.toIndentedString(this.trustedShopper)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArraysplits;
        JsonArray jsonArraylineItems;
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in CreateCheckoutSessionResponse is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `CreateCheckoutSessionResponse` properties.", entry.getKey()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_ACCOUNT_INFO) != null) {
            AccountInfo.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_ACCOUNT_INFO));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_ADDITIONAL_AMOUNT) != null) {
            Amount.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_ADDITIONAL_AMOUNT));
        }
        if (jsonObj.get(SERIALIZED_NAME_ALLOWED_PAYMENT_METHODS) != null && !jsonObj.get(SERIALIZED_NAME_ALLOWED_PAYMENT_METHODS).isJsonArray()) {
            log.log(Level.WARNING, String.format("Expected the field `allowedPaymentMethods` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ALLOWED_PAYMENT_METHODS).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_AMOUNT) != null) {
            Amount.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_AMOUNT));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_APPLICATION_INFO) != null) {
            ApplicationInfo.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_APPLICATION_INFO));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_AUTHENTICATION_DATA) != null) {
            AuthenticationData.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_AUTHENTICATION_DATA));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_BILLING_ADDRESS) != null) {
            Address.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_BILLING_ADDRESS));
        }
        if (jsonObj.get(SERIALIZED_NAME_BLOCKED_PAYMENT_METHODS) != null && !jsonObj.get(SERIALIZED_NAME_BLOCKED_PAYMENT_METHODS).isJsonArray()) {
            log.log(Level.WARNING, String.format("Expected the field `blockedPaymentMethods` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BLOCKED_PAYMENT_METHODS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CHANNEL) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_CHANNEL).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `channel` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CHANNEL).toString()));
            }
            ChannelEnum.fromValue(jsonObj.get(SERIALIZED_NAME_CHANNEL).getAsString());
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_COMPANY) != null) {
            Company.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_COMPANY));
        }
        if (jsonObj.get(SERIALIZED_NAME_COUNTRY_CODE) != null && !jsonObj.get(SERIALIZED_NAME_COUNTRY_CODE).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `countryCode` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_COUNTRY_CODE).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_DELIVERY_ADDRESS) != null) {
            Address.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_DELIVERY_ADDRESS));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_FUND_ORIGIN) != null) {
            FundOrigin.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_FUND_ORIGIN));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_FUND_RECIPIENT) != null) {
            FundRecipient.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_FUND_RECIPIENT));
        }
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if ((jsonArraylineItems = jsonObj.getAsJsonArray(SERIALIZED_NAME_LINE_ITEMS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_LINE_ITEMS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `lineItems` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_LINE_ITEMS).toString()));
            }
            for (int i = 0; i < jsonArraylineItems.size(); ++i) {
                LineItem.validateJsonObject(jsonArraylineItems.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_MANDATE) != null) {
            Mandate.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_MANDATE));
        }
        if (jsonObj.get(SERIALIZED_NAME_MCC) != null && !jsonObj.get(SERIALIZED_NAME_MCC).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `mcc` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MCC).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MERCHANT_ACCOUNT) != null && !jsonObj.get(SERIALIZED_NAME_MERCHANT_ACCOUNT).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `merchantAccount` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MERCHANT_ACCOUNT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MERCHANT_ORDER_REFERENCE) != null && !jsonObj.get(SERIALIZED_NAME_MERCHANT_ORDER_REFERENCE).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `merchantOrderReference` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MERCHANT_ORDER_REFERENCE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MODE) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_MODE).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `mode` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MODE).toString()));
            }
            ModeEnum.fromValue(jsonObj.get(SERIALIZED_NAME_MODE).getAsString());
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_MPI_DATA) != null) {
            ThreeDSecureData.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_MPI_DATA));
        }
        if (jsonObj.get(SERIALIZED_NAME_RECURRING_EXPIRY) != null && !jsonObj.get(SERIALIZED_NAME_RECURRING_EXPIRY).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `recurringExpiry` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RECURRING_EXPIRY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_RECURRING_FREQUENCY) != null && !jsonObj.get(SERIALIZED_NAME_RECURRING_FREQUENCY).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `recurringFrequency` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RECURRING_FREQUENCY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_RECURRING_PROCESSING_MODEL) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_RECURRING_PROCESSING_MODEL).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `recurringProcessingModel` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RECURRING_PROCESSING_MODEL).toString()));
            }
            RecurringProcessingModelEnum.fromValue(jsonObj.get(SERIALIZED_NAME_RECURRING_PROCESSING_MODEL).getAsString());
        }
        if (jsonObj.get(SERIALIZED_NAME_REDIRECT_FROM_ISSUER_METHOD) != null && !jsonObj.get(SERIALIZED_NAME_REDIRECT_FROM_ISSUER_METHOD).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `redirectFromIssuerMethod` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REDIRECT_FROM_ISSUER_METHOD).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_REDIRECT_TO_ISSUER_METHOD) != null && !jsonObj.get(SERIALIZED_NAME_REDIRECT_TO_ISSUER_METHOD).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `redirectToIssuerMethod` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REDIRECT_TO_ISSUER_METHOD).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_REFERENCE) != null && !jsonObj.get(SERIALIZED_NAME_REFERENCE).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `reference` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REFERENCE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_RETURN_URL) != null && !jsonObj.get(SERIALIZED_NAME_RETURN_URL).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `returnUrl` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RETURN_URL).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_RISK_DATA) != null) {
            RiskData.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_RISK_DATA));
        }
        if (jsonObj.get(SERIALIZED_NAME_SESSION_DATA) != null && !jsonObj.get(SERIALIZED_NAME_SESSION_DATA).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `sessionData` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SESSION_DATA).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SHOPPER_EMAIL) != null && !jsonObj.get(SERIALIZED_NAME_SHOPPER_EMAIL).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `shopperEmail` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SHOPPER_EMAIL).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SHOPPER_I_P) != null && !jsonObj.get(SERIALIZED_NAME_SHOPPER_I_P).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `shopperIP` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SHOPPER_I_P).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SHOPPER_INTERACTION) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_SHOPPER_INTERACTION).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `shopperInteraction` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SHOPPER_INTERACTION).toString()));
            }
            ShopperInteractionEnum.fromValue(jsonObj.get(SERIALIZED_NAME_SHOPPER_INTERACTION).getAsString());
        }
        if (jsonObj.get(SERIALIZED_NAME_SHOPPER_LOCALE) != null && !jsonObj.get(SERIALIZED_NAME_SHOPPER_LOCALE).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `shopperLocale` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SHOPPER_LOCALE).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_SHOPPER_NAME) != null) {
            Name.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_SHOPPER_NAME));
        }
        if (jsonObj.get(SERIALIZED_NAME_SHOPPER_REFERENCE) != null && !jsonObj.get(SERIALIZED_NAME_SHOPPER_REFERENCE).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `shopperReference` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SHOPPER_REFERENCE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SHOPPER_STATEMENT) != null && !jsonObj.get(SERIALIZED_NAME_SHOPPER_STATEMENT).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `shopperStatement` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SHOPPER_STATEMENT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SOCIAL_SECURITY_NUMBER) != null && !jsonObj.get(SERIALIZED_NAME_SOCIAL_SECURITY_NUMBER).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `socialSecurityNumber` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SOCIAL_SECURITY_NUMBER).toString()));
        }
        if ((jsonArraysplits = jsonObj.getAsJsonArray(SERIALIZED_NAME_SPLITS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_SPLITS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `splits` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SPLITS).toString()));
            }
            for (int i = 0; i < jsonArraysplits.size(); ++i) {
                Split.validateJsonObject(jsonArraysplits.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_STORE) != null && !jsonObj.get(SERIALIZED_NAME_STORE).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `store` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STORE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_STORE_PAYMENT_METHOD_MODE) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_STORE_PAYMENT_METHOD_MODE).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `storePaymentMethodMode` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STORE_PAYMENT_METHOD_MODE).toString()));
            }
            StorePaymentMethodModeEnum.fromValue(jsonObj.get(SERIALIZED_NAME_STORE_PAYMENT_METHOD_MODE).getAsString());
        }
        if (jsonObj.get(SERIALIZED_NAME_TELEPHONE_NUMBER) != null && !jsonObj.get(SERIALIZED_NAME_TELEPHONE_NUMBER).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `telephoneNumber` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TELEPHONE_NUMBER).toString()));
        }
    }

    public static CreateCheckoutSessionResponse fromJson(String jsonString) throws IOException {
        return (CreateCheckoutSessionResponse)JSON.getGson().fromJson(jsonString, CreateCheckoutSessionResponse.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ACCOUNT_INFO);
        openapiFields.add(SERIALIZED_NAME_ADDITIONAL_AMOUNT);
        openapiFields.add(SERIALIZED_NAME_ADDITIONAL_DATA);
        openapiFields.add(SERIALIZED_NAME_ALLOWED_PAYMENT_METHODS);
        openapiFields.add(SERIALIZED_NAME_AMOUNT);
        openapiFields.add(SERIALIZED_NAME_APPLICATION_INFO);
        openapiFields.add(SERIALIZED_NAME_AUTHENTICATION_DATA);
        openapiFields.add(SERIALIZED_NAME_BILLING_ADDRESS);
        openapiFields.add(SERIALIZED_NAME_BLOCKED_PAYMENT_METHODS);
        openapiFields.add(SERIALIZED_NAME_CAPTURE_DELAY_HOURS);
        openapiFields.add(SERIALIZED_NAME_CHANNEL);
        openapiFields.add(SERIALIZED_NAME_COMPANY);
        openapiFields.add(SERIALIZED_NAME_COUNTRY_CODE);
        openapiFields.add(SERIALIZED_NAME_DATE_OF_BIRTH);
        openapiFields.add(SERIALIZED_NAME_DELIVER_AT);
        openapiFields.add(SERIALIZED_NAME_DELIVERY_ADDRESS);
        openapiFields.add(SERIALIZED_NAME_ENABLE_ONE_CLICK);
        openapiFields.add(SERIALIZED_NAME_ENABLE_PAY_OUT);
        openapiFields.add(SERIALIZED_NAME_ENABLE_RECURRING);
        openapiFields.add(SERIALIZED_NAME_EXPIRES_AT);
        openapiFields.add(SERIALIZED_NAME_FUND_ORIGIN);
        openapiFields.add(SERIALIZED_NAME_FUND_RECIPIENT);
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_INSTALLMENT_OPTIONS);
        openapiFields.add(SERIALIZED_NAME_LINE_ITEMS);
        openapiFields.add(SERIALIZED_NAME_MANDATE);
        openapiFields.add(SERIALIZED_NAME_MCC);
        openapiFields.add(SERIALIZED_NAME_MERCHANT_ACCOUNT);
        openapiFields.add(SERIALIZED_NAME_MERCHANT_ORDER_REFERENCE);
        openapiFields.add(SERIALIZED_NAME_METADATA);
        openapiFields.add(SERIALIZED_NAME_MODE);
        openapiFields.add(SERIALIZED_NAME_MPI_DATA);
        openapiFields.add(SERIALIZED_NAME_RECURRING_EXPIRY);
        openapiFields.add(SERIALIZED_NAME_RECURRING_FREQUENCY);
        openapiFields.add(SERIALIZED_NAME_RECURRING_PROCESSING_MODEL);
        openapiFields.add(SERIALIZED_NAME_REDIRECT_FROM_ISSUER_METHOD);
        openapiFields.add(SERIALIZED_NAME_REDIRECT_TO_ISSUER_METHOD);
        openapiFields.add(SERIALIZED_NAME_REFERENCE);
        openapiFields.add(SERIALIZED_NAME_RETURN_URL);
        openapiFields.add(SERIALIZED_NAME_RISK_DATA);
        openapiFields.add(SERIALIZED_NAME_SESSION_DATA);
        openapiFields.add(SERIALIZED_NAME_SHOPPER_EMAIL);
        openapiFields.add(SERIALIZED_NAME_SHOPPER_I_P);
        openapiFields.add(SERIALIZED_NAME_SHOPPER_INTERACTION);
        openapiFields.add(SERIALIZED_NAME_SHOPPER_LOCALE);
        openapiFields.add(SERIALIZED_NAME_SHOPPER_NAME);
        openapiFields.add(SERIALIZED_NAME_SHOPPER_REFERENCE);
        openapiFields.add(SERIALIZED_NAME_SHOPPER_STATEMENT);
        openapiFields.add(SERIALIZED_NAME_SOCIAL_SECURITY_NUMBER);
        openapiFields.add(SERIALIZED_NAME_SPLIT_CARD_FUNDING_SOURCES);
        openapiFields.add(SERIALIZED_NAME_SPLITS);
        openapiFields.add(SERIALIZED_NAME_STORE);
        openapiFields.add(SERIALIZED_NAME_STORE_PAYMENT_METHOD);
        openapiFields.add(SERIALIZED_NAME_STORE_PAYMENT_METHOD_MODE);
        openapiFields.add(SERIALIZED_NAME_TELEPHONE_NUMBER);
        openapiFields.add(SERIALIZED_NAME_THREE_D_S_AUTHENTICATION_ONLY);
        openapiFields.add(SERIALIZED_NAME_TRUSTED_SHOPPER);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_AMOUNT);
        openapiRequiredFields.add(SERIALIZED_NAME_EXPIRES_AT);
        openapiRequiredFields.add(SERIALIZED_NAME_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_MERCHANT_ACCOUNT);
        openapiRequiredFields.add(SERIALIZED_NAME_REFERENCE);
        openapiRequiredFields.add(SERIALIZED_NAME_RETURN_URL);
        log = Logger.getLogger(CreateCheckoutSessionResponse.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!CreateCheckoutSessionResponse.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(CreateCheckoutSessionResponse.class));
            return new TypeAdapter<CreateCheckoutSessionResponse>(){

                public void write(JsonWriter out, CreateCheckoutSessionResponse value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public CreateCheckoutSessionResponse read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    CreateCheckoutSessionResponse.validateJsonObject(jsonObj);
                    return (CreateCheckoutSessionResponse)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StorePaymentMethodModeEnum {
        ASKFORCONSENT("askForConsent"),
        DISABLED("disabled"),
        ENABLED("enabled");

        private String value;

        private StorePaymentMethodModeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StorePaymentMethodModeEnum fromValue(String value) {
            for (StorePaymentMethodModeEnum b : StorePaymentMethodModeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<StorePaymentMethodModeEnum> {
            public void write(JsonWriter jsonWriter, StorePaymentMethodModeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StorePaymentMethodModeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StorePaymentMethodModeEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ShopperInteractionEnum {
        ECOMMERCE("Ecommerce"),
        CONTAUTH("ContAuth"),
        MOTO("Moto"),
        POS("POS");

        private String value;

        private ShopperInteractionEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ShopperInteractionEnum fromValue(String value) {
            for (ShopperInteractionEnum b : ShopperInteractionEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<ShopperInteractionEnum> {
            public void write(JsonWriter jsonWriter, ShopperInteractionEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ShopperInteractionEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ShopperInteractionEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum RecurringProcessingModelEnum {
        CARDONFILE("CardOnFile"),
        SUBSCRIPTION("Subscription"),
        UNSCHEDULEDCARDONFILE("UnscheduledCardOnFile");

        private String value;

        private RecurringProcessingModelEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static RecurringProcessingModelEnum fromValue(String value) {
            for (RecurringProcessingModelEnum b : RecurringProcessingModelEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<RecurringProcessingModelEnum> {
            public void write(JsonWriter jsonWriter, RecurringProcessingModelEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public RecurringProcessingModelEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return RecurringProcessingModelEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ModeEnum {
        EMBEDDED("embedded"),
        HOSTED("hosted");

        private String value;

        private ModeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ModeEnum fromValue(String value) {
            for (ModeEnum b : ModeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<ModeEnum> {
            public void write(JsonWriter jsonWriter, ModeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ModeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ModeEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ChannelEnum {
        IOS("iOS"),
        ANDROID("Android"),
        WEB("Web");

        private String value;

        private ChannelEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ChannelEnum fromValue(String value) {
            for (ChannelEnum b : ChannelEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<ChannelEnum> {
            public void write(JsonWriter jsonWriter, ChannelEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ChannelEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ChannelEnum.fromValue(value);
            }
        }
    }
}

