/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BankAccount {
    public static final String SERIALIZED_NAME_BANK_ACCOUNT_NUMBER = "bankAccountNumber";
    @SerializedName(value="bankAccountNumber")
    private String bankAccountNumber;
    public static final String SERIALIZED_NAME_BANK_CITY = "bankCity";
    @SerializedName(value="bankCity")
    private String bankCity;
    public static final String SERIALIZED_NAME_BANK_LOCATION_ID = "bankLocationId";
    @SerializedName(value="bankLocationId")
    private String bankLocationId;
    public static final String SERIALIZED_NAME_BANK_NAME = "bankName";
    @SerializedName(value="bankName")
    private String bankName;
    public static final String SERIALIZED_NAME_BIC = "bic";
    @SerializedName(value="bic")
    private String bic;
    public static final String SERIALIZED_NAME_COUNTRY_CODE = "countryCode";
    @SerializedName(value="countryCode")
    private String countryCode;
    public static final String SERIALIZED_NAME_IBAN = "iban";
    @SerializedName(value="iban")
    private String iban;
    public static final String SERIALIZED_NAME_OWNER_NAME = "ownerName";
    @SerializedName(value="ownerName")
    private String ownerName;
    public static final String SERIALIZED_NAME_TAX_ID = "taxId";
    @SerializedName(value="taxId")
    private String taxId;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public BankAccount bankAccountNumber(String bankAccountNumber) {
        this.bankAccountNumber = bankAccountNumber;
        return this;
    }

    @ApiModelProperty(value="The bank account number (without separators).")
    public String getBankAccountNumber() {
        return this.bankAccountNumber;
    }

    public void setBankAccountNumber(String bankAccountNumber) {
        this.bankAccountNumber = bankAccountNumber;
    }

    public BankAccount bankCity(String bankCity) {
        this.bankCity = bankCity;
        return this;
    }

    @ApiModelProperty(value="The bank city.")
    public String getBankCity() {
        return this.bankCity;
    }

    public void setBankCity(String bankCity) {
        this.bankCity = bankCity;
    }

    public BankAccount bankLocationId(String bankLocationId) {
        this.bankLocationId = bankLocationId;
        return this;
    }

    @ApiModelProperty(value="The location id of the bank. The field value is `nil` in most cases.")
    public String getBankLocationId() {
        return this.bankLocationId;
    }

    public void setBankLocationId(String bankLocationId) {
        this.bankLocationId = bankLocationId;
    }

    public BankAccount bankName(String bankName) {
        this.bankName = bankName;
        return this;
    }

    @ApiModelProperty(value="The name of the bank.")
    public String getBankName() {
        return this.bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }

    public BankAccount bic(String bic) {
        this.bic = bic;
        return this;
    }

    @ApiModelProperty(value="The [Business Identifier Code](https://en.wikipedia.org/wiki/ISO_9362) (BIC) is the SWIFT address assigned to a bank. The field value is `nil` in most cases.")
    public String getBic() {
        return this.bic;
    }

    public void setBic(String bic) {
        this.bic = bic;
    }

    public BankAccount countryCode(String countryCode) {
        this.countryCode = countryCode;
        return this;
    }

    @ApiModelProperty(value="Country code where the bank is located.  A valid value is an ISO two-character country code (e.g. 'NL').")
    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public BankAccount iban(String iban) {
        this.iban = iban;
        return this;
    }

    @ApiModelProperty(value="The [International Bank Account Number](https://en.wikipedia.org/wiki/International_Bank_Account_Number) (IBAN).")
    public String getIban() {
        return this.iban;
    }

    public void setIban(String iban) {
        this.iban = iban;
    }

    public BankAccount ownerName(String ownerName) {
        this.ownerName = ownerName;
        return this;
    }

    @ApiModelProperty(value="The name of the bank account holder. If you submit a name with non-Latin characters, we automatically replace some of them with corresponding Latin characters to meet the FATF recommendations. For example: * \u03c712 is converted to ch12. * \u00fcA is converted to euA. * Peter M\u00f8ller is converted to Peter Mller, because banks don't accept '\u00f8'. After replacement, the ownerName must have at least three alphanumeric characters (A-Z, a-z, 0-9), and at least one of them must be a valid Latin character (A-Z, a-z). For example: * John17 - allowed. * J17 - allowed. * 171 - not allowed. * John-7 - allowed. > If provided details don't match the required format, the response returns the error message: 203 'Invalid bank account holder name'.")
    public String getOwnerName() {
        return this.ownerName;
    }

    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    public BankAccount taxId(String taxId) {
        this.taxId = taxId;
        return this;
    }

    @ApiModelProperty(value="The bank account holder's tax ID.")
    public String getTaxId() {
        return this.taxId;
    }

    public void setTaxId(String taxId) {
        this.taxId = taxId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BankAccount bankAccount = (BankAccount)o;
        return Objects.equals(this.bankAccountNumber, bankAccount.bankAccountNumber) && Objects.equals(this.bankCity, bankAccount.bankCity) && Objects.equals(this.bankLocationId, bankAccount.bankLocationId) && Objects.equals(this.bankName, bankAccount.bankName) && Objects.equals(this.bic, bankAccount.bic) && Objects.equals(this.countryCode, bankAccount.countryCode) && Objects.equals(this.iban, bankAccount.iban) && Objects.equals(this.ownerName, bankAccount.ownerName) && Objects.equals(this.taxId, bankAccount.taxId);
    }

    public int hashCode() {
        return Objects.hash(this.bankAccountNumber, this.bankCity, this.bankLocationId, this.bankName, this.bic, this.countryCode, this.iban, this.ownerName, this.taxId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BankAccount {\n");
        sb.append("    bankAccountNumber: ").append(this.toIndentedString(this.bankAccountNumber)).append("\n");
        sb.append("    bankCity: ").append(this.toIndentedString(this.bankCity)).append("\n");
        sb.append("    bankLocationId: ").append(this.toIndentedString(this.bankLocationId)).append("\n");
        sb.append("    bankName: ").append(this.toIndentedString(this.bankName)).append("\n");
        sb.append("    bic: ").append(this.toIndentedString(this.bic)).append("\n");
        sb.append("    countryCode: ").append(this.toIndentedString(this.countryCode)).append("\n");
        sb.append("    iban: ").append(this.toIndentedString(this.iban)).append("\n");
        sb.append("    ownerName: ").append(this.toIndentedString(this.ownerName)).append("\n");
        sb.append("    taxId: ").append(this.toIndentedString(this.taxId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in BankAccount is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `BankAccount` properties.", entry.getKey()));
        }
        if (jsonObj.get(SERIALIZED_NAME_BANK_ACCOUNT_NUMBER) != null && !jsonObj.get(SERIALIZED_NAME_BANK_ACCOUNT_NUMBER).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `bankAccountNumber` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BANK_ACCOUNT_NUMBER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_BANK_CITY) != null && !jsonObj.get(SERIALIZED_NAME_BANK_CITY).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `bankCity` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BANK_CITY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_BANK_LOCATION_ID) != null && !jsonObj.get(SERIALIZED_NAME_BANK_LOCATION_ID).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `bankLocationId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BANK_LOCATION_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_BANK_NAME) != null && !jsonObj.get(SERIALIZED_NAME_BANK_NAME).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `bankName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BANK_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_BIC) != null && !jsonObj.get(SERIALIZED_NAME_BIC).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `bic` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BIC).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_COUNTRY_CODE) != null && !jsonObj.get(SERIALIZED_NAME_COUNTRY_CODE).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `countryCode` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_COUNTRY_CODE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_IBAN) != null && !jsonObj.get(SERIALIZED_NAME_IBAN).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `iban` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_IBAN).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_OWNER_NAME) != null && !jsonObj.get(SERIALIZED_NAME_OWNER_NAME).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `ownerName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_OWNER_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TAX_ID) != null && !jsonObj.get(SERIALIZED_NAME_TAX_ID).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `taxId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TAX_ID).toString()));
        }
    }

    public static BankAccount fromJson(String jsonString) throws IOException {
        return (BankAccount)JSON.getGson().fromJson(jsonString, BankAccount.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_BANK_ACCOUNT_NUMBER);
        openapiFields.add(SERIALIZED_NAME_BANK_CITY);
        openapiFields.add(SERIALIZED_NAME_BANK_LOCATION_ID);
        openapiFields.add(SERIALIZED_NAME_BANK_NAME);
        openapiFields.add(SERIALIZED_NAME_BIC);
        openapiFields.add(SERIALIZED_NAME_COUNTRY_CODE);
        openapiFields.add(SERIALIZED_NAME_IBAN);
        openapiFields.add(SERIALIZED_NAME_OWNER_NAME);
        openapiFields.add(SERIALIZED_NAME_TAX_ID);
        openapiRequiredFields = new HashSet();
        log = Logger.getLogger(BankAccount.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!BankAccount.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(BankAccount.class));
            return new TypeAdapter<BankAccount>(){

                public void write(JsonWriter out, BankAccount value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public BankAccount read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    BankAccount.validateJsonObject(jsonObj);
                    return (BankAccount)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

