/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.balanceplatform;

import com.adyen.model.balanceplatform.AccountHolderCapability;
import com.adyen.model.balanceplatform.ContactDetails;
import com.adyen.model.balanceplatform.JSON;
import com.adyen.model.balanceplatform.VerificationDeadline;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class AccountHolder {
    public static final String SERIALIZED_NAME_BALANCE_PLATFORM = "balancePlatform";
    @SerializedName(value="balancePlatform")
    private String balancePlatform;
    public static final String SERIALIZED_NAME_CAPABILITIES = "capabilities";
    @SerializedName(value="capabilities")
    private Map<String, AccountHolderCapability> capabilities = null;
    public static final String SERIALIZED_NAME_CONTACT_DETAILS = "contactDetails";
    @SerializedName(value="contactDetails")
    private ContactDetails contactDetails;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_LEGAL_ENTITY_ID = "legalEntityId";
    @SerializedName(value="legalEntityId")
    private String legalEntityId;
    public static final String SERIALIZED_NAME_METADATA = "metadata";
    @SerializedName(value="metadata")
    private Map<String, String> metadata = null;
    public static final String SERIALIZED_NAME_PRIMARY_BALANCE_ACCOUNT = "primaryBalanceAccount";
    @SerializedName(value="primaryBalanceAccount")
    private String primaryBalanceAccount;
    public static final String SERIALIZED_NAME_REFERENCE = "reference";
    @SerializedName(value="reference")
    private String reference;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private StatusEnum status;
    public static final String SERIALIZED_NAME_TIME_ZONE = "timeZone";
    @SerializedName(value="timeZone")
    private String timeZone;
    public static final String SERIALIZED_NAME_VERIFICATION_DEADLINES = "verificationDeadlines";
    @SerializedName(value="verificationDeadlines")
    private List<VerificationDeadline> verificationDeadlines = null;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public AccountHolder() {
    }

    public AccountHolder(String id, List<VerificationDeadline> verificationDeadlines) {
        this();
        this.id = id;
        this.verificationDeadlines = verificationDeadlines;
    }

    public AccountHolder balancePlatform(String balancePlatform) {
        this.balancePlatform = balancePlatform;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the [balance platform](https://docs.adyen.com/api-explorer/#/balanceplatform/latest/get/balancePlatforms/{id}__queryParam_id) to which the account holder belongs. Required in the request if your API credentials can be used for multiple balance platforms.")
    public String getBalancePlatform() {
        return this.balancePlatform;
    }

    public void setBalancePlatform(String balancePlatform) {
        this.balancePlatform = balancePlatform;
    }

    public AccountHolder capabilities(Map<String, AccountHolderCapability> capabilities) {
        this.capabilities = capabilities;
        return this;
    }

    public AccountHolder putCapabilitiesItem(String key, AccountHolderCapability capabilitiesItem) {
        if (this.capabilities == null) {
            this.capabilities = new HashMap<String, AccountHolderCapability>();
        }
        this.capabilities.put(key, capabilitiesItem);
        return this;
    }

    @ApiModelProperty(value="Contains key-value pairs that specify the actions that an account holder can do in your platform. The key is a capability required for your integration. For example, **issueCard** for Issuing. The value is an object containing the settings for the capability.")
    public Map<String, AccountHolderCapability> getCapabilities() {
        return this.capabilities;
    }

    public void setCapabilities(Map<String, AccountHolderCapability> capabilities) {
        this.capabilities = capabilities;
    }

    public AccountHolder contactDetails(ContactDetails contactDetails) {
        this.contactDetails = contactDetails;
        return this;
    }

    @ApiModelProperty(value="")
    public ContactDetails getContactDetails() {
        return this.contactDetails;
    }

    public void setContactDetails(ContactDetails contactDetails) {
        this.contactDetails = contactDetails;
    }

    public AccountHolder description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="Your description for the account holder, maximum 300 characters.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @ApiModelProperty(required=true, value="The unique identifier of the account holder.")
    public String getId() {
        return this.id;
    }

    public AccountHolder legalEntityId(String legalEntityId) {
        this.legalEntityId = legalEntityId;
        return this;
    }

    @ApiModelProperty(required=true, value="The unique identifier of the [legal entity](https://docs.adyen.com/api-explorer/legalentity/latest/post/legalEntities#responses-200-id) associated with the account holder. Adyen performs a verification process against the legal entity of the account holder.")
    public String getLegalEntityId() {
        return this.legalEntityId;
    }

    public void setLegalEntityId(String legalEntityId) {
        this.legalEntityId = legalEntityId;
    }

    public AccountHolder metadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public AccountHolder putMetadataItem(String key, String metadataItem) {
        if (this.metadata == null) {
            this.metadata = new HashMap<String, String>();
        }
        this.metadata.put(key, metadataItem);
        return this;
    }

    @ApiModelProperty(value="A set of key and value pairs for general use by the merchant. The keys do not have specific names and may be used for storing miscellaneous data as desired. > Note that during an update of metadata, the omission of existing key-value pairs will result in the deletion of those key-value pairs.")
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public AccountHolder primaryBalanceAccount(String primaryBalanceAccount) {
        this.primaryBalanceAccount = primaryBalanceAccount;
        return this;
    }

    @ApiModelProperty(value="The ID of the account holder's primary balance account. By default, this is set to the first balance account that you create for the account holder. To assign a different balance account, send a PATCH request.")
    public String getPrimaryBalanceAccount() {
        return this.primaryBalanceAccount;
    }

    public void setPrimaryBalanceAccount(String primaryBalanceAccount) {
        this.primaryBalanceAccount = primaryBalanceAccount;
    }

    public AccountHolder reference(String reference) {
        this.reference = reference;
        return this;
    }

    @ApiModelProperty(value="Your reference for the account holder, maximum 150 characters.")
    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public AccountHolder status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="The status of the account holder.  Possible values:    * **active**: The account holder is active. This is the default status when creating an account holder.    * **inactive (Deprecated)**: The account holder is temporarily inactive due to missing KYC details. You can set the account back to active by providing the missing KYC details.    * **suspended**: The account holder is permanently deactivated by Adyen. This action cannot be undone.   * **closed**: The account holder is permanently deactivated by you. This action cannot be undone.")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public AccountHolder timeZone(String timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    @ApiModelProperty(value="The time zone of the account holder. For example, **Europe/Amsterdam**. Defaults to the time zone of the balance platform if no time zone is set. For possible values, see the [list of time zone codes](https://en.wikipedia.org/wiki/List_of_tz_database_time_zones).")
    public String getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    @ApiModelProperty(value="List of verification deadlines and the capabilities that will be disallowed if verification errors are not resolved.")
    public List<VerificationDeadline> getVerificationDeadlines() {
        return this.verificationDeadlines;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountHolder accountHolder = (AccountHolder)o;
        return Objects.equals(this.balancePlatform, accountHolder.balancePlatform) && Objects.equals(this.capabilities, accountHolder.capabilities) && Objects.equals(this.contactDetails, accountHolder.contactDetails) && Objects.equals(this.description, accountHolder.description) && Objects.equals(this.id, accountHolder.id) && Objects.equals(this.legalEntityId, accountHolder.legalEntityId) && Objects.equals(this.metadata, accountHolder.metadata) && Objects.equals(this.primaryBalanceAccount, accountHolder.primaryBalanceAccount) && Objects.equals(this.reference, accountHolder.reference) && Objects.equals((Object)this.status, (Object)accountHolder.status) && Objects.equals(this.timeZone, accountHolder.timeZone) && Objects.equals(this.verificationDeadlines, accountHolder.verificationDeadlines);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.balancePlatform, this.capabilities, this.contactDetails, this.description, this.id, this.legalEntityId, this.metadata, this.primaryBalanceAccount, this.reference, this.status, this.timeZone, this.verificationDeadlines});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AccountHolder {\n");
        sb.append("    balancePlatform: ").append(this.toIndentedString(this.balancePlatform)).append("\n");
        sb.append("    capabilities: ").append(this.toIndentedString(this.capabilities)).append("\n");
        sb.append("    contactDetails: ").append(this.toIndentedString(this.contactDetails)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    legalEntityId: ").append(this.toIndentedString(this.legalEntityId)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    primaryBalanceAccount: ").append(this.toIndentedString(this.primaryBalanceAccount)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    timeZone: ").append(this.toIndentedString(this.timeZone)).append("\n");
        sb.append("    verificationDeadlines: ").append(this.toIndentedString(this.verificationDeadlines)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        AccountHolder.validateJsonObject(jsonObj, false);
    }

    public static void validateJsonObject(JsonObject jsonObj, boolean strictValidation) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in AccountHolder is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        if (strictValidation) {
            Set entries = jsonObj.entrySet();
            Iterator iterator = entries.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                if (openapiFields.contains(entry.getKey())) continue;
                throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `AccountHolder` properties.", entry.getKey()));
            }
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_BALANCE_PLATFORM) != null && !jsonObj.get(SERIALIZED_NAME_BALANCE_PLATFORM).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `balancePlatform` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BALANCE_PLATFORM).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_CONTACT_DETAILS) != null) {
            ContactDetails.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_CONTACT_DETAILS));
        }
        if (jsonObj.get(SERIALIZED_NAME_DESCRIPTION) != null && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DESCRIPTION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_LEGAL_ENTITY_ID) != null && !jsonObj.get(SERIALIZED_NAME_LEGAL_ENTITY_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `legalEntityId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_LEGAL_ENTITY_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PRIMARY_BALANCE_ACCOUNT) != null && !jsonObj.get(SERIALIZED_NAME_PRIMARY_BALANCE_ACCOUNT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `primaryBalanceAccount` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PRIMARY_BALANCE_ACCOUNT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_REFERENCE) != null && !jsonObj.get(SERIALIZED_NAME_REFERENCE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `reference` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REFERENCE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_STATUS) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_STATUS).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `status` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STATUS).toString()));
            }
            StatusEnum.fromValue(jsonObj.get(SERIALIZED_NAME_STATUS).getAsString());
        }
        if (jsonObj.get(SERIALIZED_NAME_TIME_ZONE) != null && !jsonObj.get(SERIALIZED_NAME_TIME_ZONE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `timeZone` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TIME_ZONE).toString()));
        }
        JsonArray jsonArrayverificationDeadlines = jsonObj.getAsJsonArray(SERIALIZED_NAME_VERIFICATION_DEADLINES);
        if (jsonArrayverificationDeadlines != null) {
            if (!jsonObj.get(SERIALIZED_NAME_VERIFICATION_DEADLINES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `verificationDeadlines` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VERIFICATION_DEADLINES).toString()));
            }
            for (int i = 0; i < jsonArrayverificationDeadlines.size(); ++i) {
                VerificationDeadline.validateJsonObject(jsonArrayverificationDeadlines.get(i).getAsJsonObject());
            }
        }
    }

    public static AccountHolder fromJson(String jsonString) throws IOException {
        return (AccountHolder)JSON.getGson().fromJson(jsonString, AccountHolder.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_BALANCE_PLATFORM);
        openapiFields.add(SERIALIZED_NAME_CAPABILITIES);
        openapiFields.add(SERIALIZED_NAME_CONTACT_DETAILS);
        openapiFields.add(SERIALIZED_NAME_DESCRIPTION);
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_LEGAL_ENTITY_ID);
        openapiFields.add(SERIALIZED_NAME_METADATA);
        openapiFields.add(SERIALIZED_NAME_PRIMARY_BALANCE_ACCOUNT);
        openapiFields.add(SERIALIZED_NAME_REFERENCE);
        openapiFields.add(SERIALIZED_NAME_STATUS);
        openapiFields.add(SERIALIZED_NAME_TIME_ZONE);
        openapiFields.add(SERIALIZED_NAME_VERIFICATION_DEADLINES);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_LEGAL_ENTITY_ID);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!AccountHolder.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(AccountHolder.class));
            return new TypeAdapter<AccountHolder>(){

                public void write(JsonWriter out, AccountHolder value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public AccountHolder read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    AccountHolder.validateJsonObject(jsonObj);
                    return (AccountHolder)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StatusEnum {
        ACTIVE("active"),
        CLOSED("closed"),
        INACTIVE("inactive"),
        SUSPENDED("suspended");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<StatusEnum> {
            public void write(JsonWriter jsonWriter, StatusEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StatusEnum.fromValue(value);
            }
        }
    }
}

