/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.transferwebhooks;

import com.adyen.model.transferwebhooks.JSON;
import com.adyen.model.transferwebhooks.TransactionEventViolation;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TransactionRulesResult {
    public static final String SERIALIZED_NAME_ADVICE = "advice";
    @SerializedName(value="advice")
    private String advice;
    public static final String SERIALIZED_NAME_ALL_RULES_PASSED = "allRulesPassed";
    @SerializedName(value="allRulesPassed")
    private Boolean allRulesPassed;
    public static final String SERIALIZED_NAME_FAILED_TRANSACTION_RULES = "failedTransactionRules";
    @SerializedName(value="failedTransactionRules")
    private List<TransactionEventViolation> failedTransactionRules = null;
    public static final String SERIALIZED_NAME_SCORE = "score";
    @SerializedName(value="score")
    private Integer score;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public TransactionRulesResult advice(String advice) {
        this.advice = advice;
        return this;
    }

    @ApiModelProperty(value="The advice given by the Risk analysis.")
    public String getAdvice() {
        return this.advice;
    }

    public void setAdvice(String advice) {
        this.advice = advice;
    }

    public TransactionRulesResult allRulesPassed(Boolean allRulesPassed) {
        this.allRulesPassed = allRulesPassed;
        return this;
    }

    @ApiModelProperty(value="Indicates whether the transaction passed the evaluation for all transaction rules.")
    public Boolean getAllRulesPassed() {
        return this.allRulesPassed;
    }

    public void setAllRulesPassed(Boolean allRulesPassed) {
        this.allRulesPassed = allRulesPassed;
    }

    public TransactionRulesResult failedTransactionRules(List<TransactionEventViolation> failedTransactionRules) {
        this.failedTransactionRules = failedTransactionRules;
        return this;
    }

    public TransactionRulesResult addFailedTransactionRulesItem(TransactionEventViolation failedTransactionRulesItem) {
        if (this.failedTransactionRules == null) {
            this.failedTransactionRules = new ArrayList<TransactionEventViolation>();
        }
        this.failedTransactionRules.add(failedTransactionRulesItem);
        return this;
    }

    @ApiModelProperty(value="Array containing all the transaction rules that the transaction violated. This list is only sent when `allRulesPassed` is **false**.")
    public List<TransactionEventViolation> getFailedTransactionRules() {
        return this.failedTransactionRules;
    }

    public void setFailedTransactionRules(List<TransactionEventViolation> failedTransactionRules) {
        this.failedTransactionRules = failedTransactionRules;
    }

    public TransactionRulesResult score(Integer score) {
        this.score = score;
        return this;
    }

    @ApiModelProperty(value="The score of the Risk analysis.")
    public Integer getScore() {
        return this.score;
    }

    public void setScore(Integer score) {
        this.score = score;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionRulesResult transactionRulesResult = (TransactionRulesResult)o;
        return Objects.equals(this.advice, transactionRulesResult.advice) && Objects.equals(this.allRulesPassed, transactionRulesResult.allRulesPassed) && Objects.equals(this.failedTransactionRules, transactionRulesResult.failedTransactionRules) && Objects.equals(this.score, transactionRulesResult.score);
    }

    public int hashCode() {
        return Objects.hash(this.advice, this.allRulesPassed, this.failedTransactionRules, this.score);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransactionRulesResult {\n");
        sb.append("    advice: ").append(this.toIndentedString(this.advice)).append("\n");
        sb.append("    allRulesPassed: ").append(this.toIndentedString(this.allRulesPassed)).append("\n");
        sb.append("    failedTransactionRules: ").append(this.toIndentedString(this.failedTransactionRules)).append("\n");
        sb.append("    score: ").append(this.toIndentedString(this.score)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArrayfailedTransactionRules;
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in TransactionRulesResult is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `TransactionRulesResult` properties.", entry.getKey()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ADVICE) != null && !jsonObj.get(SERIALIZED_NAME_ADVICE).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `advice` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ADVICE).toString()));
        }
        if ((jsonArrayfailedTransactionRules = jsonObj.getAsJsonArray(SERIALIZED_NAME_FAILED_TRANSACTION_RULES)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_FAILED_TRANSACTION_RULES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `failedTransactionRules` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FAILED_TRANSACTION_RULES).toString()));
            }
            for (int i = 0; i < jsonArrayfailedTransactionRules.size(); ++i) {
                TransactionEventViolation.validateJsonObject(jsonArrayfailedTransactionRules.get(i).getAsJsonObject());
            }
        }
    }

    public static TransactionRulesResult fromJson(String jsonString) throws IOException {
        return (TransactionRulesResult)JSON.getGson().fromJson(jsonString, TransactionRulesResult.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ADVICE);
        openapiFields.add(SERIALIZED_NAME_ALL_RULES_PASSED);
        openapiFields.add(SERIALIZED_NAME_FAILED_TRANSACTION_RULES);
        openapiFields.add(SERIALIZED_NAME_SCORE);
        openapiRequiredFields = new HashSet();
        log = Logger.getLogger(TransactionRulesResult.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!TransactionRulesResult.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(TransactionRulesResult.class));
            return new TypeAdapter<TransactionRulesResult>(){

                public void write(JsonWriter out, TransactionRulesResult value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public TransactionRulesResult read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    TransactionRulesResult.validateJsonObject(jsonObj);
                    return (TransactionRulesResult)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

