/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.transferwebhooks;

import com.adyen.model.transferwebhooks.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BalanceMutation {
    public static final String SERIALIZED_NAME_BALANCE = "balance";
    @SerializedName(value="balance")
    private Long balance;
    public static final String SERIALIZED_NAME_CURRENCY = "currency";
    @SerializedName(value="currency")
    private String currency;
    public static final String SERIALIZED_NAME_RECEIVED = "received";
    @SerializedName(value="received")
    private Long received;
    public static final String SERIALIZED_NAME_RESERVED = "reserved";
    @SerializedName(value="reserved")
    private Long reserved;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public BalanceMutation balance(Long balance) {
        this.balance = balance;
        return this;
    }

    @ApiModelProperty(value="The amount in the payment's currency that is debited or credited on the balance accounting register.")
    public Long getBalance() {
        return this.balance;
    }

    public void setBalance(Long balance) {
        this.balance = balance;
    }

    public BalanceMutation currency(String currency) {
        this.currency = currency;
        return this;
    }

    @ApiModelProperty(value="The three-character [ISO currency code](https://docs.adyen.com/development-resources/currency-codes).")
    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public BalanceMutation received(Long received) {
        this.received = received;
        return this;
    }

    @ApiModelProperty(value="The amount in the payment's currency that is debited or credited on the received accounting register.")
    public Long getReceived() {
        return this.received;
    }

    public void setReceived(Long received) {
        this.received = received;
    }

    public BalanceMutation reserved(Long reserved) {
        this.reserved = reserved;
        return this;
    }

    @ApiModelProperty(value="The amount in the payment's currency that is debited or credited on the reserved accounting register.")
    public Long getReserved() {
        return this.reserved;
    }

    public void setReserved(Long reserved) {
        this.reserved = reserved;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BalanceMutation balanceMutation = (BalanceMutation)o;
        return Objects.equals(this.balance, balanceMutation.balance) && Objects.equals(this.currency, balanceMutation.currency) && Objects.equals(this.received, balanceMutation.received) && Objects.equals(this.reserved, balanceMutation.reserved);
    }

    public int hashCode() {
        return Objects.hash(this.balance, this.currency, this.received, this.reserved);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BalanceMutation {\n");
        sb.append("    balance: ").append(this.toIndentedString(this.balance)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    received: ").append(this.toIndentedString(this.received)).append("\n");
        sb.append("    reserved: ").append(this.toIndentedString(this.reserved)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in BalanceMutation is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `BalanceMutation` properties.", entry.getKey()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CURRENCY) != null && !jsonObj.get(SERIALIZED_NAME_CURRENCY).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `currency` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CURRENCY).toString()));
        }
    }

    public static BalanceMutation fromJson(String jsonString) throws IOException {
        return (BalanceMutation)JSON.getGson().fromJson(jsonString, BalanceMutation.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_BALANCE);
        openapiFields.add(SERIALIZED_NAME_CURRENCY);
        openapiFields.add(SERIALIZED_NAME_RECEIVED);
        openapiFields.add(SERIALIZED_NAME_RESERVED);
        openapiRequiredFields = new HashSet();
        log = Logger.getLogger(BalanceMutation.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!BalanceMutation.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(BalanceMutation.class));
            return new TypeAdapter<BalanceMutation>(){

                public void write(JsonWriter out, BalanceMutation value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public BalanceMutation read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    BalanceMutation.validateJsonObject(jsonObj);
                    return (BalanceMutation)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

