/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.transfers;

import com.adyen.model.transfers.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NameLocation {
    public static final String SERIALIZED_NAME_CITY = "city";
    @SerializedName(value="city")
    private String city;
    public static final String SERIALIZED_NAME_COUNTRY = "country";
    @SerializedName(value="country")
    private String country;
    public static final String SERIALIZED_NAME_COUNTRY_OF_ORIGIN = "countryOfOrigin";
    @SerializedName(value="countryOfOrigin")
    private String countryOfOrigin;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_RAW_DATA = "rawData";
    @SerializedName(value="rawData")
    private String rawData;
    public static final String SERIALIZED_NAME_STATE = "state";
    @SerializedName(value="state")
    private String state;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public NameLocation city(String city) {
        this.city = city;
        return this;
    }

    @ApiModelProperty(value="The city where the merchant is located.")
    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public NameLocation country(String country) {
        this.country = country;
        return this;
    }

    @ApiModelProperty(value="The country where the merchant is located in [three-letter country code](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-3) format.")
    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public NameLocation countryOfOrigin(String countryOfOrigin) {
        this.countryOfOrigin = countryOfOrigin;
        return this;
    }

    @ApiModelProperty(value="The home country in [three-digit country code](https://en.wikipedia.org/wiki/ISO_3166-1_numeric) format, used for government-controlled merchants such as embassies.")
    public String getCountryOfOrigin() {
        return this.countryOfOrigin;
    }

    public void setCountryOfOrigin(String countryOfOrigin) {
        this.countryOfOrigin = countryOfOrigin;
    }

    public NameLocation name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="The name of the merchant's shop or service.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public NameLocation rawData(String rawData) {
        this.rawData = rawData;
        return this;
    }

    @ApiModelProperty(value="The raw data.")
    public String getRawData() {
        return this.rawData;
    }

    public void setRawData(String rawData) {
        this.rawData = rawData;
    }

    public NameLocation state(String state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(value="The state where the merchant is located.")
    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NameLocation nameLocation = (NameLocation)o;
        return Objects.equals(this.city, nameLocation.city) && Objects.equals(this.country, nameLocation.country) && Objects.equals(this.countryOfOrigin, nameLocation.countryOfOrigin) && Objects.equals(this.name, nameLocation.name) && Objects.equals(this.rawData, nameLocation.rawData) && Objects.equals(this.state, nameLocation.state);
    }

    public int hashCode() {
        return Objects.hash(this.city, this.country, this.countryOfOrigin, this.name, this.rawData, this.state);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NameLocation {\n");
        sb.append("    city: ").append(this.toIndentedString(this.city)).append("\n");
        sb.append("    country: ").append(this.toIndentedString(this.country)).append("\n");
        sb.append("    countryOfOrigin: ").append(this.toIndentedString(this.countryOfOrigin)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    rawData: ").append(this.toIndentedString(this.rawData)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in NameLocation is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `NameLocation` properties.", entry.getKey()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CITY) != null && !jsonObj.get(SERIALIZED_NAME_CITY).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `city` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CITY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_COUNTRY) != null && !jsonObj.get(SERIALIZED_NAME_COUNTRY).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `country` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_COUNTRY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_COUNTRY_OF_ORIGIN) != null && !jsonObj.get(SERIALIZED_NAME_COUNTRY_OF_ORIGIN).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `countryOfOrigin` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_COUNTRY_OF_ORIGIN).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_RAW_DATA) != null && !jsonObj.get(SERIALIZED_NAME_RAW_DATA).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `rawData` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RAW_DATA).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_STATE) != null && !jsonObj.get(SERIALIZED_NAME_STATE).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `state` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STATE).toString()));
        }
    }

    public static NameLocation fromJson(String jsonString) throws IOException {
        return (NameLocation)JSON.getGson().fromJson(jsonString, NameLocation.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_CITY);
        openapiFields.add(SERIALIZED_NAME_COUNTRY);
        openapiFields.add(SERIALIZED_NAME_COUNTRY_OF_ORIGIN);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_RAW_DATA);
        openapiFields.add(SERIALIZED_NAME_STATE);
        openapiRequiredFields = new HashSet();
        log = Logger.getLogger(NameLocation.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!NameLocation.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(NameLocation.class));
            return new TypeAdapter<NameLocation>(){

                public void write(JsonWriter out, NameLocation value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public NameLocation read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    NameLocation.validateJsonObject(jsonObj);
                    return (NameLocation)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

