/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.transfers;

import com.adyen.model.transfers.BankAccountV3;
import com.adyen.model.transfers.JSON;
import com.adyen.model.transfers.MerchantData;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CounterpartyV3 {
    public static final String SERIALIZED_NAME_BALANCE_ACCOUNT_ID = "balanceAccountId";
    @SerializedName(value="balanceAccountId")
    private String balanceAccountId;
    public static final String SERIALIZED_NAME_BANK_ACCOUNT = "bankAccount";
    @SerializedName(value="bankAccount")
    private BankAccountV3 bankAccount;
    public static final String SERIALIZED_NAME_MERCHANT = "merchant";
    @SerializedName(value="merchant")
    private MerchantData merchant;
    public static final String SERIALIZED_NAME_TRANSFER_INSTRUMENT_ID = "transferInstrumentId";
    @SerializedName(value="transferInstrumentId")
    private String transferInstrumentId;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public CounterpartyV3 balanceAccountId(String balanceAccountId) {
        this.balanceAccountId = balanceAccountId;
        return this;
    }

    @ApiModelProperty(value="Unique identifier of the [balance account](https://docs.adyen.com/api-explorer/#/balanceplatform/latest/post/balanceAccounts__resParam_id).")
    public String getBalanceAccountId() {
        return this.balanceAccountId;
    }

    public void setBalanceAccountId(String balanceAccountId) {
        this.balanceAccountId = balanceAccountId;
    }

    public CounterpartyV3 bankAccount(BankAccountV3 bankAccount) {
        this.bankAccount = bankAccount;
        return this;
    }

    @ApiModelProperty(value="")
    public BankAccountV3 getBankAccount() {
        return this.bankAccount;
    }

    public void setBankAccount(BankAccountV3 bankAccount) {
        this.bankAccount = bankAccount;
    }

    public CounterpartyV3 merchant(MerchantData merchant) {
        this.merchant = merchant;
        return this;
    }

    @ApiModelProperty(value="")
    public MerchantData getMerchant() {
        return this.merchant;
    }

    public void setMerchant(MerchantData merchant) {
        this.merchant = merchant;
    }

    public CounterpartyV3 transferInstrumentId(String transferInstrumentId) {
        this.transferInstrumentId = transferInstrumentId;
        return this;
    }

    @ApiModelProperty(value="Unique identifier of the [transfer instrument](https://docs.adyen.com/api-explorer/#/legalentity/latest/post/transferInstruments__resParam_id).")
    public String getTransferInstrumentId() {
        return this.transferInstrumentId;
    }

    public void setTransferInstrumentId(String transferInstrumentId) {
        this.transferInstrumentId = transferInstrumentId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CounterpartyV3 counterpartyV3 = (CounterpartyV3)o;
        return Objects.equals(this.balanceAccountId, counterpartyV3.balanceAccountId) && Objects.equals(this.bankAccount, counterpartyV3.bankAccount) && Objects.equals(this.merchant, counterpartyV3.merchant) && Objects.equals(this.transferInstrumentId, counterpartyV3.transferInstrumentId);
    }

    public int hashCode() {
        return Objects.hash(this.balanceAccountId, this.bankAccount, this.merchant, this.transferInstrumentId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CounterpartyV3 {\n");
        sb.append("    balanceAccountId: ").append(this.toIndentedString(this.balanceAccountId)).append("\n");
        sb.append("    bankAccount: ").append(this.toIndentedString(this.bankAccount)).append("\n");
        sb.append("    merchant: ").append(this.toIndentedString(this.merchant)).append("\n");
        sb.append("    transferInstrumentId: ").append(this.toIndentedString(this.transferInstrumentId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in CounterpartyV3 is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `CounterpartyV3` properties.", entry.getKey()));
        }
        if (jsonObj.get(SERIALIZED_NAME_BALANCE_ACCOUNT_ID) != null && !jsonObj.get(SERIALIZED_NAME_BALANCE_ACCOUNT_ID).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `balanceAccountId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BALANCE_ACCOUNT_ID).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_BANK_ACCOUNT) != null) {
            BankAccountV3.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_BANK_ACCOUNT));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_MERCHANT) != null) {
            MerchantData.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_MERCHANT));
        }
        if (jsonObj.get(SERIALIZED_NAME_TRANSFER_INSTRUMENT_ID) != null && !jsonObj.get(SERIALIZED_NAME_TRANSFER_INSTRUMENT_ID).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `transferInstrumentId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TRANSFER_INSTRUMENT_ID).toString()));
        }
    }

    public static CounterpartyV3 fromJson(String jsonString) throws IOException {
        return (CounterpartyV3)JSON.getGson().fromJson(jsonString, CounterpartyV3.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_BALANCE_ACCOUNT_ID);
        openapiFields.add(SERIALIZED_NAME_BANK_ACCOUNT);
        openapiFields.add(SERIALIZED_NAME_MERCHANT);
        openapiFields.add(SERIALIZED_NAME_TRANSFER_INSTRUMENT_ID);
        openapiRequiredFields = new HashSet();
        log = Logger.getLogger(CounterpartyV3.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!CounterpartyV3.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(CounterpartyV3.class));
            return new TypeAdapter<CounterpartyV3>(){

                public void write(JsonWriter out, CounterpartyV3 value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public CounterpartyV3 read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    CounterpartyV3.validateJsonObject(jsonObj);
                    return (CounterpartyV3)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

