/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.storedvalue;

import com.adyen.model.storedvalue.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StoredValueVoidRequest {
    public static final String SERIALIZED_NAME_MERCHANT_ACCOUNT = "merchantAccount";
    @SerializedName(value="merchantAccount")
    private String merchantAccount;
    public static final String SERIALIZED_NAME_ORIGINAL_REFERENCE = "originalReference";
    @SerializedName(value="originalReference")
    private String originalReference;
    public static final String SERIALIZED_NAME_REFERENCE = "reference";
    @SerializedName(value="reference")
    private String reference;
    public static final String SERIALIZED_NAME_STORE = "store";
    @SerializedName(value="store")
    private String store;
    public static final String SERIALIZED_NAME_TENDER_REFERENCE = "tenderReference";
    @SerializedName(value="tenderReference")
    private String tenderReference;
    public static final String SERIALIZED_NAME_UNIQUE_TERMINAL_ID = "uniqueTerminalId";
    @SerializedName(value="uniqueTerminalId")
    private String uniqueTerminalId;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public StoredValueVoidRequest merchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
        return this;
    }

    @ApiModelProperty(required=true, value="The merchant account identifier, with which you want to process the transaction.")
    public String getMerchantAccount() {
        return this.merchantAccount;
    }

    public void setMerchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
    }

    public StoredValueVoidRequest originalReference(String originalReference) {
        this.originalReference = originalReference;
        return this;
    }

    @ApiModelProperty(required=true, value="The original pspReference of the payment to modify.")
    public String getOriginalReference() {
        return this.originalReference;
    }

    public void setOriginalReference(String originalReference) {
        this.originalReference = originalReference;
    }

    public StoredValueVoidRequest reference(String reference) {
        this.reference = reference;
        return this;
    }

    @ApiModelProperty(value="Your reference for the payment modification. This reference is visible in Customer Area and in reports. Maximum length: 80 characters.")
    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public StoredValueVoidRequest store(String store) {
        this.store = store;
        return this;
    }

    @ApiModelProperty(value="The physical store, for which this payment is processed.")
    public String getStore() {
        return this.store;
    }

    public void setStore(String store) {
        this.store = store;
    }

    public StoredValueVoidRequest tenderReference(String tenderReference) {
        this.tenderReference = tenderReference;
        return this;
    }

    @ApiModelProperty(value="The reference of the tender.")
    public String getTenderReference() {
        return this.tenderReference;
    }

    public void setTenderReference(String tenderReference) {
        this.tenderReference = tenderReference;
    }

    public StoredValueVoidRequest uniqueTerminalId(String uniqueTerminalId) {
        this.uniqueTerminalId = uniqueTerminalId;
        return this;
    }

    @ApiModelProperty(value="The unique ID of a POS terminal.")
    public String getUniqueTerminalId() {
        return this.uniqueTerminalId;
    }

    public void setUniqueTerminalId(String uniqueTerminalId) {
        this.uniqueTerminalId = uniqueTerminalId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StoredValueVoidRequest storedValueVoidRequest = (StoredValueVoidRequest)o;
        return Objects.equals(this.merchantAccount, storedValueVoidRequest.merchantAccount) && Objects.equals(this.originalReference, storedValueVoidRequest.originalReference) && Objects.equals(this.reference, storedValueVoidRequest.reference) && Objects.equals(this.store, storedValueVoidRequest.store) && Objects.equals(this.tenderReference, storedValueVoidRequest.tenderReference) && Objects.equals(this.uniqueTerminalId, storedValueVoidRequest.uniqueTerminalId);
    }

    public int hashCode() {
        return Objects.hash(this.merchantAccount, this.originalReference, this.reference, this.store, this.tenderReference, this.uniqueTerminalId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StoredValueVoidRequest {\n");
        sb.append("    merchantAccount: ").append(this.toIndentedString(this.merchantAccount)).append("\n");
        sb.append("    originalReference: ").append(this.toIndentedString(this.originalReference)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    store: ").append(this.toIndentedString(this.store)).append("\n");
        sb.append("    tenderReference: ").append(this.toIndentedString(this.tenderReference)).append("\n");
        sb.append("    uniqueTerminalId: ").append(this.toIndentedString(this.uniqueTerminalId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in StoredValueVoidRequest is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `StoredValueVoidRequest` properties.", entry.getKey()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MERCHANT_ACCOUNT) != null && !jsonObj.get(SERIALIZED_NAME_MERCHANT_ACCOUNT).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `merchantAccount` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MERCHANT_ACCOUNT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ORIGINAL_REFERENCE) != null && !jsonObj.get(SERIALIZED_NAME_ORIGINAL_REFERENCE).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `originalReference` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ORIGINAL_REFERENCE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_REFERENCE) != null && !jsonObj.get(SERIALIZED_NAME_REFERENCE).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `reference` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REFERENCE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_STORE) != null && !jsonObj.get(SERIALIZED_NAME_STORE).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `store` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STORE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TENDER_REFERENCE) != null && !jsonObj.get(SERIALIZED_NAME_TENDER_REFERENCE).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `tenderReference` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TENDER_REFERENCE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_UNIQUE_TERMINAL_ID) != null && !jsonObj.get(SERIALIZED_NAME_UNIQUE_TERMINAL_ID).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `uniqueTerminalId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_UNIQUE_TERMINAL_ID).toString()));
        }
    }

    public static StoredValueVoidRequest fromJson(String jsonString) throws IOException {
        return (StoredValueVoidRequest)JSON.getGson().fromJson(jsonString, StoredValueVoidRequest.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_MERCHANT_ACCOUNT);
        openapiFields.add(SERIALIZED_NAME_ORIGINAL_REFERENCE);
        openapiFields.add(SERIALIZED_NAME_REFERENCE);
        openapiFields.add(SERIALIZED_NAME_STORE);
        openapiFields.add(SERIALIZED_NAME_TENDER_REFERENCE);
        openapiFields.add(SERIALIZED_NAME_UNIQUE_TERMINAL_ID);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_MERCHANT_ACCOUNT);
        openapiRequiredFields.add(SERIALIZED_NAME_ORIGINAL_REFERENCE);
        log = Logger.getLogger(StoredValueVoidRequest.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!StoredValueVoidRequest.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(StoredValueVoidRequest.class));
            return new TypeAdapter<StoredValueVoidRequest>(){

                public void write(JsonWriter out, StoredValueVoidRequest value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public StoredValueVoidRequest read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    StoredValueVoidRequest.validateJsonObject(jsonObj);
                    return (StoredValueVoidRequest)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

