/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.recurring;

import com.adyen.model.recurring.Address;
import com.adyen.model.recurring.BankAccount;
import com.adyen.model.recurring.Card;
import com.adyen.model.recurring.JSON;
import com.adyen.model.recurring.Name;
import com.adyen.model.recurring.TokenDetails;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RecurringDetail {
    public static final String SERIALIZED_NAME_ADDITIONAL_DATA = "additionalData";
    @SerializedName(value="additionalData")
    private Map<String, String> additionalData = null;
    public static final String SERIALIZED_NAME_ALIAS = "alias";
    @SerializedName(value="alias")
    private String alias;
    public static final String SERIALIZED_NAME_ALIAS_TYPE = "aliasType";
    @SerializedName(value="aliasType")
    private String aliasType;
    public static final String SERIALIZED_NAME_BANK = "bank";
    @SerializedName(value="bank")
    private BankAccount bank;
    public static final String SERIALIZED_NAME_BILLING_ADDRESS = "billingAddress";
    @SerializedName(value="billingAddress")
    private Address billingAddress;
    public static final String SERIALIZED_NAME_CARD = "card";
    @SerializedName(value="card")
    private Card card;
    public static final String SERIALIZED_NAME_CONTRACT_TYPES = "contractTypes";
    @SerializedName(value="contractTypes")
    private List<String> contractTypes = null;
    public static final String SERIALIZED_NAME_CREATION_DATE = "creationDate";
    @SerializedName(value="creationDate")
    private OffsetDateTime creationDate;
    public static final String SERIALIZED_NAME_FIRST_PSP_REFERENCE = "firstPspReference";
    @SerializedName(value="firstPspReference")
    private String firstPspReference;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_NETWORK_TX_REFERENCE = "networkTxReference";
    @SerializedName(value="networkTxReference")
    private String networkTxReference;
    public static final String SERIALIZED_NAME_PAYMENT_METHOD_VARIANT = "paymentMethodVariant";
    @SerializedName(value="paymentMethodVariant")
    private String paymentMethodVariant;
    public static final String SERIALIZED_NAME_RECURRING_DETAIL_REFERENCE = "recurringDetailReference";
    @SerializedName(value="recurringDetailReference")
    private String recurringDetailReference;
    public static final String SERIALIZED_NAME_SHOPPER_NAME = "shopperName";
    @SerializedName(value="shopperName")
    private Name shopperName;
    public static final String SERIALIZED_NAME_SOCIAL_SECURITY_NUMBER = "socialSecurityNumber";
    @SerializedName(value="socialSecurityNumber")
    private String socialSecurityNumber;
    public static final String SERIALIZED_NAME_TOKEN_DETAILS = "tokenDetails";
    @SerializedName(value="tokenDetails")
    private TokenDetails tokenDetails;
    public static final String SERIALIZED_NAME_VARIANT = "variant";
    @SerializedName(value="variant")
    private String variant;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public RecurringDetail additionalData(Map<String, String> additionalData) {
        this.additionalData = additionalData;
        return this;
    }

    public RecurringDetail putAdditionalDataItem(String key, String additionalDataItem) {
        if (this.additionalData == null) {
            this.additionalData = new HashMap<String, String>();
        }
        this.additionalData.put(key, additionalDataItem);
        return this;
    }

    @ApiModelProperty(value="This field contains additional data, which may be returned in a particular response.  The additionalData object consists of entries, each of which includes the key and value.")
    public Map<String, String> getAdditionalData() {
        return this.additionalData;
    }

    public void setAdditionalData(Map<String, String> additionalData) {
        this.additionalData = additionalData;
    }

    public RecurringDetail alias(String alias) {
        this.alias = alias;
        return this;
    }

    @ApiModelProperty(value="The alias of the credit card number.  Applies only to recurring contracts storing credit card details")
    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public RecurringDetail aliasType(String aliasType) {
        this.aliasType = aliasType;
        return this;
    }

    @ApiModelProperty(value="The alias type of the credit card number.  Applies only to recurring contracts storing credit card details.")
    public String getAliasType() {
        return this.aliasType;
    }

    public void setAliasType(String aliasType) {
        this.aliasType = aliasType;
    }

    public RecurringDetail bank(BankAccount bank) {
        this.bank = bank;
        return this;
    }

    @ApiModelProperty(value="")
    public BankAccount getBank() {
        return this.bank;
    }

    public void setBank(BankAccount bank) {
        this.bank = bank;
    }

    public RecurringDetail billingAddress(Address billingAddress) {
        this.billingAddress = billingAddress;
        return this;
    }

    @ApiModelProperty(value="")
    public Address getBillingAddress() {
        return this.billingAddress;
    }

    public void setBillingAddress(Address billingAddress) {
        this.billingAddress = billingAddress;
    }

    public RecurringDetail card(Card card) {
        this.card = card;
        return this;
    }

    @ApiModelProperty(value="")
    public Card getCard() {
        return this.card;
    }

    public void setCard(Card card) {
        this.card = card;
    }

    public RecurringDetail contractTypes(List<String> contractTypes) {
        this.contractTypes = contractTypes;
        return this;
    }

    public RecurringDetail addContractTypesItem(String contractTypesItem) {
        if (this.contractTypes == null) {
            this.contractTypes = new ArrayList<String>();
        }
        this.contractTypes.add(contractTypesItem);
        return this;
    }

    @ApiModelProperty(value="Types of recurring contracts.")
    public List<String> getContractTypes() {
        return this.contractTypes;
    }

    public void setContractTypes(List<String> contractTypes) {
        this.contractTypes = contractTypes;
    }

    public RecurringDetail creationDate(OffsetDateTime creationDate) {
        this.creationDate = creationDate;
        return this;
    }

    @ApiModelProperty(value="The date when the recurring details were created.")
    public OffsetDateTime getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(OffsetDateTime creationDate) {
        this.creationDate = creationDate;
    }

    public RecurringDetail firstPspReference(String firstPspReference) {
        this.firstPspReference = firstPspReference;
        return this;
    }

    @ApiModelProperty(value="The `pspReference` of the first recurring payment that created the recurring detail.")
    public String getFirstPspReference() {
        return this.firstPspReference;
    }

    public void setFirstPspReference(String firstPspReference) {
        this.firstPspReference = firstPspReference;
    }

    public RecurringDetail name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="An optional descriptive name for this recurring detail.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public RecurringDetail networkTxReference(String networkTxReference) {
        this.networkTxReference = networkTxReference;
        return this;
    }

    @ApiModelProperty(value="Returned in the response if you are not tokenizing with Adyen and are using the Merchant-initiated transactions (MIT) framework from Mastercard or Visa.  This contains either the Mastercard Trace ID or the Visa Transaction ID.")
    public String getNetworkTxReference() {
        return this.networkTxReference;
    }

    public void setNetworkTxReference(String networkTxReference) {
        this.networkTxReference = networkTxReference;
    }

    public RecurringDetail paymentMethodVariant(String paymentMethodVariant) {
        this.paymentMethodVariant = paymentMethodVariant;
        return this;
    }

    @ApiModelProperty(value="The  type or sub-brand of a payment method used, e.g. Visa Debit, Visa Corporate, etc. For more information, refer to [PaymentMethodVariant](https://docs.adyen.com/development-resources/paymentmethodvariant).")
    public String getPaymentMethodVariant() {
        return this.paymentMethodVariant;
    }

    public void setPaymentMethodVariant(String paymentMethodVariant) {
        this.paymentMethodVariant = paymentMethodVariant;
    }

    public RecurringDetail recurringDetailReference(String recurringDetailReference) {
        this.recurringDetailReference = recurringDetailReference;
        return this;
    }

    @ApiModelProperty(required=true, value="The reference that uniquely identifies the recurring detail.")
    public String getRecurringDetailReference() {
        return this.recurringDetailReference;
    }

    public void setRecurringDetailReference(String recurringDetailReference) {
        this.recurringDetailReference = recurringDetailReference;
    }

    public RecurringDetail shopperName(Name shopperName) {
        this.shopperName = shopperName;
        return this;
    }

    @ApiModelProperty(value="")
    public Name getShopperName() {
        return this.shopperName;
    }

    public void setShopperName(Name shopperName) {
        this.shopperName = shopperName;
    }

    public RecurringDetail socialSecurityNumber(String socialSecurityNumber) {
        this.socialSecurityNumber = socialSecurityNumber;
        return this;
    }

    @ApiModelProperty(value="A shopper's social security number (only in countries where it is legal to collect).")
    public String getSocialSecurityNumber() {
        return this.socialSecurityNumber;
    }

    public void setSocialSecurityNumber(String socialSecurityNumber) {
        this.socialSecurityNumber = socialSecurityNumber;
    }

    public RecurringDetail tokenDetails(TokenDetails tokenDetails) {
        this.tokenDetails = tokenDetails;
        return this;
    }

    @ApiModelProperty(value="")
    public TokenDetails getTokenDetails() {
        return this.tokenDetails;
    }

    public void setTokenDetails(TokenDetails tokenDetails) {
        this.tokenDetails = tokenDetails;
    }

    public RecurringDetail variant(String variant) {
        this.variant = variant;
        return this;
    }

    @ApiModelProperty(required=true, value="The payment method, such as \u201cmc\", \"visa\", \"ideal\", \"paypal\".")
    public String getVariant() {
        return this.variant;
    }

    public void setVariant(String variant) {
        this.variant = variant;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecurringDetail recurringDetail = (RecurringDetail)o;
        return Objects.equals(this.additionalData, recurringDetail.additionalData) && Objects.equals(this.alias, recurringDetail.alias) && Objects.equals(this.aliasType, recurringDetail.aliasType) && Objects.equals(this.bank, recurringDetail.bank) && Objects.equals(this.billingAddress, recurringDetail.billingAddress) && Objects.equals(this.card, recurringDetail.card) && Objects.equals(this.contractTypes, recurringDetail.contractTypes) && Objects.equals(this.creationDate, recurringDetail.creationDate) && Objects.equals(this.firstPspReference, recurringDetail.firstPspReference) && Objects.equals(this.name, recurringDetail.name) && Objects.equals(this.networkTxReference, recurringDetail.networkTxReference) && Objects.equals(this.paymentMethodVariant, recurringDetail.paymentMethodVariant) && Objects.equals(this.recurringDetailReference, recurringDetail.recurringDetailReference) && Objects.equals(this.shopperName, recurringDetail.shopperName) && Objects.equals(this.socialSecurityNumber, recurringDetail.socialSecurityNumber) && Objects.equals(this.tokenDetails, recurringDetail.tokenDetails) && Objects.equals(this.variant, recurringDetail.variant);
    }

    public int hashCode() {
        return Objects.hash(this.additionalData, this.alias, this.aliasType, this.bank, this.billingAddress, this.card, this.contractTypes, this.creationDate, this.firstPspReference, this.name, this.networkTxReference, this.paymentMethodVariant, this.recurringDetailReference, this.shopperName, this.socialSecurityNumber, this.tokenDetails, this.variant);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RecurringDetail {\n");
        sb.append("    additionalData: ").append(this.toIndentedString(this.additionalData)).append("\n");
        sb.append("    alias: ").append(this.toIndentedString(this.alias)).append("\n");
        sb.append("    aliasType: ").append(this.toIndentedString(this.aliasType)).append("\n");
        sb.append("    bank: ").append(this.toIndentedString(this.bank)).append("\n");
        sb.append("    billingAddress: ").append(this.toIndentedString(this.billingAddress)).append("\n");
        sb.append("    card: ").append(this.toIndentedString(this.card)).append("\n");
        sb.append("    contractTypes: ").append(this.toIndentedString(this.contractTypes)).append("\n");
        sb.append("    creationDate: ").append(this.toIndentedString(this.creationDate)).append("\n");
        sb.append("    firstPspReference: ").append(this.toIndentedString(this.firstPspReference)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    networkTxReference: ").append(this.toIndentedString(this.networkTxReference)).append("\n");
        sb.append("    paymentMethodVariant: ").append(this.toIndentedString(this.paymentMethodVariant)).append("\n");
        sb.append("    recurringDetailReference: ").append(this.toIndentedString(this.recurringDetailReference)).append("\n");
        sb.append("    shopperName: ").append(this.toIndentedString(this.shopperName)).append("\n");
        sb.append("    socialSecurityNumber: ").append(this.toIndentedString(this.socialSecurityNumber)).append("\n");
        sb.append("    tokenDetails: ").append(this.toIndentedString(this.tokenDetails)).append("\n");
        sb.append("    variant: ").append(this.toIndentedString(this.variant)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in RecurringDetail is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `RecurringDetail` properties.", entry.getKey()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ALIAS) != null && !jsonObj.get(SERIALIZED_NAME_ALIAS).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `alias` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ALIAS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ALIAS_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_ALIAS_TYPE).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `aliasType` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ALIAS_TYPE).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_BANK) != null) {
            BankAccount.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_BANK));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_BILLING_ADDRESS) != null) {
            Address.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_BILLING_ADDRESS));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_CARD) != null) {
            Card.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_CARD));
        }
        if (jsonObj.get(SERIALIZED_NAME_CONTRACT_TYPES) != null && !jsonObj.get(SERIALIZED_NAME_CONTRACT_TYPES).isJsonArray()) {
            log.log(Level.WARNING, String.format("Expected the field `contractTypes` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CONTRACT_TYPES).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_FIRST_PSP_REFERENCE) != null && !jsonObj.get(SERIALIZED_NAME_FIRST_PSP_REFERENCE).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `firstPspReference` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FIRST_PSP_REFERENCE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NETWORK_TX_REFERENCE) != null && !jsonObj.get(SERIALIZED_NAME_NETWORK_TX_REFERENCE).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `networkTxReference` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NETWORK_TX_REFERENCE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PAYMENT_METHOD_VARIANT) != null && !jsonObj.get(SERIALIZED_NAME_PAYMENT_METHOD_VARIANT).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `paymentMethodVariant` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PAYMENT_METHOD_VARIANT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_RECURRING_DETAIL_REFERENCE) != null && !jsonObj.get(SERIALIZED_NAME_RECURRING_DETAIL_REFERENCE).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `recurringDetailReference` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RECURRING_DETAIL_REFERENCE).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_SHOPPER_NAME) != null) {
            Name.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_SHOPPER_NAME));
        }
        if (jsonObj.get(SERIALIZED_NAME_SOCIAL_SECURITY_NUMBER) != null && !jsonObj.get(SERIALIZED_NAME_SOCIAL_SECURITY_NUMBER).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `socialSecurityNumber` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SOCIAL_SECURITY_NUMBER).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_TOKEN_DETAILS) != null) {
            TokenDetails.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_TOKEN_DETAILS));
        }
        if (jsonObj.get(SERIALIZED_NAME_VARIANT) != null && !jsonObj.get(SERIALIZED_NAME_VARIANT).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `variant` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VARIANT).toString()));
        }
    }

    public static RecurringDetail fromJson(String jsonString) throws IOException {
        return (RecurringDetail)JSON.getGson().fromJson(jsonString, RecurringDetail.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ADDITIONAL_DATA);
        openapiFields.add(SERIALIZED_NAME_ALIAS);
        openapiFields.add(SERIALIZED_NAME_ALIAS_TYPE);
        openapiFields.add(SERIALIZED_NAME_BANK);
        openapiFields.add(SERIALIZED_NAME_BILLING_ADDRESS);
        openapiFields.add(SERIALIZED_NAME_CARD);
        openapiFields.add(SERIALIZED_NAME_CONTRACT_TYPES);
        openapiFields.add(SERIALIZED_NAME_CREATION_DATE);
        openapiFields.add(SERIALIZED_NAME_FIRST_PSP_REFERENCE);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_NETWORK_TX_REFERENCE);
        openapiFields.add(SERIALIZED_NAME_PAYMENT_METHOD_VARIANT);
        openapiFields.add(SERIALIZED_NAME_RECURRING_DETAIL_REFERENCE);
        openapiFields.add(SERIALIZED_NAME_SHOPPER_NAME);
        openapiFields.add(SERIALIZED_NAME_SOCIAL_SECURITY_NUMBER);
        openapiFields.add(SERIALIZED_NAME_TOKEN_DETAILS);
        openapiFields.add(SERIALIZED_NAME_VARIANT);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_RECURRING_DETAIL_REFERENCE);
        openapiRequiredFields.add(SERIALIZED_NAME_VARIANT);
        log = Logger.getLogger(RecurringDetail.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!RecurringDetail.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(RecurringDetail.class));
            return new TypeAdapter<RecurringDetail>(){

                public void write(JsonWriter out, RecurringDetail value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public RecurringDetail read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    RecurringDetail.validateJsonObject(jsonObj);
                    return (RecurringDetail)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

