/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.posterminalmanagement;

import com.adyen.model.posterminalmanagement.JSON;
import com.adyen.model.posterminalmanagement.Store;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MerchantAccount {
    public static final String SERIALIZED_NAME_IN_STORE_TERMINALS = "inStoreTerminals";
    @SerializedName(value="inStoreTerminals")
    private List<String> inStoreTerminals = null;
    public static final String SERIALIZED_NAME_INVENTORY_TERMINALS = "inventoryTerminals";
    @SerializedName(value="inventoryTerminals")
    private List<String> inventoryTerminals = null;
    public static final String SERIALIZED_NAME_MERCHANT_ACCOUNT = "merchantAccount";
    @SerializedName(value="merchantAccount")
    private String merchantAccount;
    public static final String SERIALIZED_NAME_STORES = "stores";
    @SerializedName(value="stores")
    private List<Store> stores = null;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public MerchantAccount inStoreTerminals(List<String> inStoreTerminals) {
        this.inStoreTerminals = inStoreTerminals;
        return this;
    }

    public MerchantAccount addInStoreTerminalsItem(String inStoreTerminalsItem) {
        if (this.inStoreTerminals == null) {
            this.inStoreTerminals = new ArrayList<String>();
        }
        this.inStoreTerminals.add(inStoreTerminalsItem);
        return this;
    }

    @ApiModelProperty(value="List of terminals assigned to this merchant account as in-store terminals. This means that the terminal is ready to be boarded, or is already boarded.")
    public List<String> getInStoreTerminals() {
        return this.inStoreTerminals;
    }

    public void setInStoreTerminals(List<String> inStoreTerminals) {
        this.inStoreTerminals = inStoreTerminals;
    }

    public MerchantAccount inventoryTerminals(List<String> inventoryTerminals) {
        this.inventoryTerminals = inventoryTerminals;
        return this;
    }

    public MerchantAccount addInventoryTerminalsItem(String inventoryTerminalsItem) {
        if (this.inventoryTerminals == null) {
            this.inventoryTerminals = new ArrayList<String>();
        }
        this.inventoryTerminals.add(inventoryTerminalsItem);
        return this;
    }

    @ApiModelProperty(value="List of terminals assigned to the inventory of this merchant account.")
    public List<String> getInventoryTerminals() {
        return this.inventoryTerminals;
    }

    public void setInventoryTerminals(List<String> inventoryTerminals) {
        this.inventoryTerminals = inventoryTerminals;
    }

    public MerchantAccount merchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
        return this;
    }

    @ApiModelProperty(required=true, value="The merchant account.")
    public String getMerchantAccount() {
        return this.merchantAccount;
    }

    public void setMerchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
    }

    public MerchantAccount stores(List<Store> stores) {
        this.stores = stores;
        return this;
    }

    public MerchantAccount addStoresItem(Store storesItem) {
        if (this.stores == null) {
            this.stores = new ArrayList<Store>();
        }
        this.stores.add(storesItem);
        return this;
    }

    @ApiModelProperty(value="Array of stores under this merchant account.")
    public List<Store> getStores() {
        return this.stores;
    }

    public void setStores(List<Store> stores) {
        this.stores = stores;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MerchantAccount merchantAccount = (MerchantAccount)o;
        return Objects.equals(this.inStoreTerminals, merchantAccount.inStoreTerminals) && Objects.equals(this.inventoryTerminals, merchantAccount.inventoryTerminals) && Objects.equals(this.merchantAccount, merchantAccount.merchantAccount) && Objects.equals(this.stores, merchantAccount.stores);
    }

    public int hashCode() {
        return Objects.hash(this.inStoreTerminals, this.inventoryTerminals, this.merchantAccount, this.stores);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MerchantAccount {\n");
        sb.append("    inStoreTerminals: ").append(this.toIndentedString(this.inStoreTerminals)).append("\n");
        sb.append("    inventoryTerminals: ").append(this.toIndentedString(this.inventoryTerminals)).append("\n");
        sb.append("    merchantAccount: ").append(this.toIndentedString(this.merchantAccount)).append("\n");
        sb.append("    stores: ").append(this.toIndentedString(this.stores)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArraystores;
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in MerchantAccount is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `MerchantAccount` properties.", entry.getKey()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_IN_STORE_TERMINALS) != null && !jsonObj.get(SERIALIZED_NAME_IN_STORE_TERMINALS).isJsonArray()) {
            log.log(Level.WARNING, String.format("Expected the field `inStoreTerminals` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_IN_STORE_TERMINALS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_INVENTORY_TERMINALS) != null && !jsonObj.get(SERIALIZED_NAME_INVENTORY_TERMINALS).isJsonArray()) {
            log.log(Level.WARNING, String.format("Expected the field `inventoryTerminals` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_INVENTORY_TERMINALS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MERCHANT_ACCOUNT) != null && !jsonObj.get(SERIALIZED_NAME_MERCHANT_ACCOUNT).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `merchantAccount` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MERCHANT_ACCOUNT).toString()));
        }
        if ((jsonArraystores = jsonObj.getAsJsonArray(SERIALIZED_NAME_STORES)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_STORES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `stores` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STORES).toString()));
            }
            for (int i = 0; i < jsonArraystores.size(); ++i) {
                Store.validateJsonObject(jsonArraystores.get(i).getAsJsonObject());
            }
        }
    }

    public static MerchantAccount fromJson(String jsonString) throws IOException {
        return (MerchantAccount)JSON.getGson().fromJson(jsonString, MerchantAccount.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_IN_STORE_TERMINALS);
        openapiFields.add(SERIALIZED_NAME_INVENTORY_TERMINALS);
        openapiFields.add(SERIALIZED_NAME_MERCHANT_ACCOUNT);
        openapiFields.add(SERIALIZED_NAME_STORES);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_MERCHANT_ACCOUNT);
        log = Logger.getLogger(MerchantAccount.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!MerchantAccount.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(MerchantAccount.class));
            return new TypeAdapter<MerchantAccount>(){

                public void write(JsonWriter out, MerchantAccount value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public MerchantAccount read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    MerchantAccount.validateJsonObject(jsonObj);
                    return (MerchantAccount)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

