/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.payment;

import com.adyen.model.payment.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ThreeDSecureData {
    public static final String SERIALIZED_NAME_AUTHENTICATION_RESPONSE = "authenticationResponse";
    @SerializedName(value="authenticationResponse")
    private AuthenticationResponseEnum authenticationResponse;
    public static final String SERIALIZED_NAME_CAVV = "cavv";
    @SerializedName(value="cavv")
    private byte[] cavv;
    public static final String SERIALIZED_NAME_CAVV_ALGORITHM = "cavvAlgorithm";
    @SerializedName(value="cavvAlgorithm")
    private String cavvAlgorithm;
    public static final String SERIALIZED_NAME_CHALLENGE_CANCEL = "challengeCancel";
    @SerializedName(value="challengeCancel")
    private ChallengeCancelEnum challengeCancel;
    public static final String SERIALIZED_NAME_DIRECTORY_RESPONSE = "directoryResponse";
    @SerializedName(value="directoryResponse")
    private DirectoryResponseEnum directoryResponse;
    public static final String SERIALIZED_NAME_DS_TRANS_I_D = "dsTransID";
    @SerializedName(value="dsTransID")
    private String dsTransID;
    public static final String SERIALIZED_NAME_ECI = "eci";
    @SerializedName(value="eci")
    private String eci;
    public static final String SERIALIZED_NAME_RISK_SCORE = "riskScore";
    @SerializedName(value="riskScore")
    private String riskScore;
    public static final String SERIALIZED_NAME_THREE_D_S_VERSION = "threeDSVersion";
    @SerializedName(value="threeDSVersion")
    private String threeDSVersion;
    public static final String SERIALIZED_NAME_TOKEN_AUTHENTICATION_VERIFICATION_VALUE = "tokenAuthenticationVerificationValue";
    @SerializedName(value="tokenAuthenticationVerificationValue")
    private byte[] tokenAuthenticationVerificationValue;
    public static final String SERIALIZED_NAME_TRANS_STATUS_REASON = "transStatusReason";
    @SerializedName(value="transStatusReason")
    private String transStatusReason;
    public static final String SERIALIZED_NAME_XID = "xid";
    @SerializedName(value="xid")
    private byte[] xid;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public ThreeDSecureData authenticationResponse(AuthenticationResponseEnum authenticationResponse) {
        this.authenticationResponse = authenticationResponse;
        return this;
    }

    @ApiModelProperty(value="In 3D Secure 1, the authentication response if the shopper was redirected.  In 3D Secure 2, this is the `transStatus` from the challenge result. If the transaction was frictionless, omit this parameter.")
    public AuthenticationResponseEnum getAuthenticationResponse() {
        return this.authenticationResponse;
    }

    public void setAuthenticationResponse(AuthenticationResponseEnum authenticationResponse) {
        this.authenticationResponse = authenticationResponse;
    }

    public ThreeDSecureData cavv(byte[] cavv) {
        this.cavv = cavv;
        return this;
    }

    @ApiModelProperty(value="The cardholder authentication value (base64 encoded, 20 bytes in a decoded form).")
    public byte[] getCavv() {
        return this.cavv;
    }

    public void setCavv(byte[] cavv) {
        this.cavv = cavv;
    }

    public ThreeDSecureData cavvAlgorithm(String cavvAlgorithm) {
        this.cavvAlgorithm = cavvAlgorithm;
        return this;
    }

    @ApiModelProperty(value="The CAVV algorithm used. Include this only for 3D Secure 1.")
    public String getCavvAlgorithm() {
        return this.cavvAlgorithm;
    }

    public void setCavvAlgorithm(String cavvAlgorithm) {
        this.cavvAlgorithm = cavvAlgorithm;
    }

    public ThreeDSecureData challengeCancel(ChallengeCancelEnum challengeCancel) {
        this.challengeCancel = challengeCancel;
        return this;
    }

    @ApiModelProperty(value="Indicator informing the Access Control Server (ACS) and the Directory Server (DS) that the authentication has been cancelled. For possible values, refer to [3D Secure API reference](https://docs.adyen.com/online-payments/3d-secure/api-reference#mpidata).")
    public ChallengeCancelEnum getChallengeCancel() {
        return this.challengeCancel;
    }

    public void setChallengeCancel(ChallengeCancelEnum challengeCancel) {
        this.challengeCancel = challengeCancel;
    }

    public ThreeDSecureData directoryResponse(DirectoryResponseEnum directoryResponse) {
        this.directoryResponse = directoryResponse;
        return this;
    }

    @ApiModelProperty(value="In 3D Secure 1, this is the enrollment response from the 3D directory server.  In 3D Secure 2, this is the `transStatus` from the `ARes`.")
    public DirectoryResponseEnum getDirectoryResponse() {
        return this.directoryResponse;
    }

    public void setDirectoryResponse(DirectoryResponseEnum directoryResponse) {
        this.directoryResponse = directoryResponse;
    }

    public ThreeDSecureData dsTransID(String dsTransID) {
        this.dsTransID = dsTransID;
        return this;
    }

    @ApiModelProperty(value="Supported for 3D Secure 2. The unique transaction identifier assigned by the Directory Server (DS) to identify a single transaction.")
    public String getDsTransID() {
        return this.dsTransID;
    }

    public void setDsTransID(String dsTransID) {
        this.dsTransID = dsTransID;
    }

    public ThreeDSecureData eci(String eci) {
        this.eci = eci;
        return this;
    }

    @ApiModelProperty(value="The electronic commerce indicator.")
    public String getEci() {
        return this.eci;
    }

    public void setEci(String eci) {
        this.eci = eci;
    }

    public ThreeDSecureData riskScore(String riskScore) {
        this.riskScore = riskScore;
        return this;
    }

    @ApiModelProperty(value="Risk score calculated by Directory Server (DS). Required for Cartes Bancaires integrations.")
    public String getRiskScore() {
        return this.riskScore;
    }

    public void setRiskScore(String riskScore) {
        this.riskScore = riskScore;
    }

    public ThreeDSecureData threeDSVersion(String threeDSVersion) {
        this.threeDSVersion = threeDSVersion;
        return this;
    }

    @ApiModelProperty(value="The version of the 3D Secure protocol.")
    public String getThreeDSVersion() {
        return this.threeDSVersion;
    }

    public void setThreeDSVersion(String threeDSVersion) {
        this.threeDSVersion = threeDSVersion;
    }

    public ThreeDSecureData tokenAuthenticationVerificationValue(byte[] tokenAuthenticationVerificationValue) {
        this.tokenAuthenticationVerificationValue = tokenAuthenticationVerificationValue;
        return this;
    }

    @ApiModelProperty(value="Network token authentication verification value (TAVV). The network token cryptogram.")
    public byte[] getTokenAuthenticationVerificationValue() {
        return this.tokenAuthenticationVerificationValue;
    }

    public void setTokenAuthenticationVerificationValue(byte[] tokenAuthenticationVerificationValue) {
        this.tokenAuthenticationVerificationValue = tokenAuthenticationVerificationValue;
    }

    public ThreeDSecureData transStatusReason(String transStatusReason) {
        this.transStatusReason = transStatusReason;
        return this;
    }

    @ApiModelProperty(value="Provides information on why the `transStatus` field has the specified value. For possible values, refer to [our docs](https://docs.adyen.com/online-payments/3d-secure/api-reference#possible-transstatusreason-values).")
    public String getTransStatusReason() {
        return this.transStatusReason;
    }

    public void setTransStatusReason(String transStatusReason) {
        this.transStatusReason = transStatusReason;
    }

    public ThreeDSecureData xid(byte[] xid) {
        this.xid = xid;
        return this;
    }

    @ApiModelProperty(value="Supported for 3D Secure 1. The transaction identifier (Base64-encoded, 20 bytes in a decoded form).")
    public byte[] getXid() {
        return this.xid;
    }

    public void setXid(byte[] xid) {
        this.xid = xid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ThreeDSecureData threeDSecureData = (ThreeDSecureData)o;
        return Objects.equals((Object)this.authenticationResponse, (Object)threeDSecureData.authenticationResponse) && Arrays.equals(this.cavv, threeDSecureData.cavv) && Objects.equals(this.cavvAlgorithm, threeDSecureData.cavvAlgorithm) && Objects.equals((Object)this.challengeCancel, (Object)threeDSecureData.challengeCancel) && Objects.equals((Object)this.directoryResponse, (Object)threeDSecureData.directoryResponse) && Objects.equals(this.dsTransID, threeDSecureData.dsTransID) && Objects.equals(this.eci, threeDSecureData.eci) && Objects.equals(this.riskScore, threeDSecureData.riskScore) && Objects.equals(this.threeDSVersion, threeDSecureData.threeDSVersion) && Arrays.equals(this.tokenAuthenticationVerificationValue, threeDSecureData.tokenAuthenticationVerificationValue) && Objects.equals(this.transStatusReason, threeDSecureData.transStatusReason) && Arrays.equals(this.xid, threeDSecureData.xid);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.authenticationResponse, Arrays.hashCode(this.cavv), this.cavvAlgorithm, this.challengeCancel, this.directoryResponse, this.dsTransID, this.eci, this.riskScore, this.threeDSVersion, Arrays.hashCode(this.tokenAuthenticationVerificationValue), this.transStatusReason, Arrays.hashCode(this.xid)});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ThreeDSecureData {\n");
        sb.append("    authenticationResponse: ").append(this.toIndentedString((Object)this.authenticationResponse)).append("\n");
        sb.append("    cavv: ").append(this.toIndentedString(this.cavv)).append("\n");
        sb.append("    cavvAlgorithm: ").append(this.toIndentedString(this.cavvAlgorithm)).append("\n");
        sb.append("    challengeCancel: ").append(this.toIndentedString((Object)this.challengeCancel)).append("\n");
        sb.append("    directoryResponse: ").append(this.toIndentedString((Object)this.directoryResponse)).append("\n");
        sb.append("    dsTransID: ").append(this.toIndentedString(this.dsTransID)).append("\n");
        sb.append("    eci: ").append(this.toIndentedString(this.eci)).append("\n");
        sb.append("    riskScore: ").append(this.toIndentedString(this.riskScore)).append("\n");
        sb.append("    threeDSVersion: ").append(this.toIndentedString(this.threeDSVersion)).append("\n");
        sb.append("    tokenAuthenticationVerificationValue: ").append(this.toIndentedString(this.tokenAuthenticationVerificationValue)).append("\n");
        sb.append("    transStatusReason: ").append(this.toIndentedString(this.transStatusReason)).append("\n");
        sb.append("    xid: ").append(this.toIndentedString(this.xid)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in ThreeDSecureData is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `ThreeDSecureData` properties.", entry.getKey()));
        }
        if (jsonObj.get(SERIALIZED_NAME_AUTHENTICATION_RESPONSE) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_AUTHENTICATION_RESPONSE).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `authenticationResponse` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_AUTHENTICATION_RESPONSE).toString()));
            }
            AuthenticationResponseEnum.fromValue(jsonObj.get(SERIALIZED_NAME_AUTHENTICATION_RESPONSE).getAsString());
        }
        if (jsonObj.get(SERIALIZED_NAME_CAVV_ALGORITHM) != null && !jsonObj.get(SERIALIZED_NAME_CAVV_ALGORITHM).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `cavvAlgorithm` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CAVV_ALGORITHM).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CHALLENGE_CANCEL) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_CHALLENGE_CANCEL).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `challengeCancel` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CHALLENGE_CANCEL).toString()));
            }
            ChallengeCancelEnum.fromValue(jsonObj.get(SERIALIZED_NAME_CHALLENGE_CANCEL).getAsString());
        }
        if (jsonObj.get(SERIALIZED_NAME_DIRECTORY_RESPONSE) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_DIRECTORY_RESPONSE).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `directoryResponse` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DIRECTORY_RESPONSE).toString()));
            }
            DirectoryResponseEnum.fromValue(jsonObj.get(SERIALIZED_NAME_DIRECTORY_RESPONSE).getAsString());
        }
        if (jsonObj.get(SERIALIZED_NAME_DS_TRANS_I_D) != null && !jsonObj.get(SERIALIZED_NAME_DS_TRANS_I_D).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `dsTransID` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DS_TRANS_I_D).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ECI) != null && !jsonObj.get(SERIALIZED_NAME_ECI).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `eci` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ECI).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_RISK_SCORE) != null && !jsonObj.get(SERIALIZED_NAME_RISK_SCORE).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `riskScore` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RISK_SCORE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_THREE_D_S_VERSION) != null && !jsonObj.get(SERIALIZED_NAME_THREE_D_S_VERSION).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `threeDSVersion` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_THREE_D_S_VERSION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TRANS_STATUS_REASON) != null && !jsonObj.get(SERIALIZED_NAME_TRANS_STATUS_REASON).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `transStatusReason` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TRANS_STATUS_REASON).toString()));
        }
    }

    public static ThreeDSecureData fromJson(String jsonString) throws IOException {
        return (ThreeDSecureData)JSON.getGson().fromJson(jsonString, ThreeDSecureData.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_AUTHENTICATION_RESPONSE);
        openapiFields.add(SERIALIZED_NAME_CAVV);
        openapiFields.add(SERIALIZED_NAME_CAVV_ALGORITHM);
        openapiFields.add(SERIALIZED_NAME_CHALLENGE_CANCEL);
        openapiFields.add(SERIALIZED_NAME_DIRECTORY_RESPONSE);
        openapiFields.add(SERIALIZED_NAME_DS_TRANS_I_D);
        openapiFields.add(SERIALIZED_NAME_ECI);
        openapiFields.add(SERIALIZED_NAME_RISK_SCORE);
        openapiFields.add(SERIALIZED_NAME_THREE_D_S_VERSION);
        openapiFields.add(SERIALIZED_NAME_TOKEN_AUTHENTICATION_VERIFICATION_VALUE);
        openapiFields.add(SERIALIZED_NAME_TRANS_STATUS_REASON);
        openapiFields.add(SERIALIZED_NAME_XID);
        openapiRequiredFields = new HashSet();
        log = Logger.getLogger(ThreeDSecureData.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!ThreeDSecureData.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(ThreeDSecureData.class));
            return new TypeAdapter<ThreeDSecureData>(){

                public void write(JsonWriter out, ThreeDSecureData value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public ThreeDSecureData read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    ThreeDSecureData.validateJsonObject(jsonObj);
                    return (ThreeDSecureData)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum DirectoryResponseEnum {
        A("A"),
        C("C"),
        D("D"),
        I("I"),
        N("N"),
        R("R"),
        U("U"),
        Y("Y");

        private String value;

        private DirectoryResponseEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static DirectoryResponseEnum fromValue(String value) {
            for (DirectoryResponseEnum b : DirectoryResponseEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<DirectoryResponseEnum> {
            public void write(JsonWriter jsonWriter, DirectoryResponseEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public DirectoryResponseEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return DirectoryResponseEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ChallengeCancelEnum {
        _01("01"),
        _02("02"),
        _03("03"),
        _04("04"),
        _05("05"),
        _06("06"),
        _07("07");

        private String value;

        private ChallengeCancelEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ChallengeCancelEnum fromValue(String value) {
            for (ChallengeCancelEnum b : ChallengeCancelEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<ChallengeCancelEnum> {
            public void write(JsonWriter jsonWriter, ChallengeCancelEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ChallengeCancelEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ChallengeCancelEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum AuthenticationResponseEnum {
        Y("Y"),
        N("N"),
        U("U"),
        A("A");

        private String value;

        private AuthenticationResponseEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static AuthenticationResponseEnum fromValue(String value) {
            for (AuthenticationResponseEnum b : AuthenticationResponseEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<AuthenticationResponseEnum> {
            public void write(JsonWriter jsonWriter, AuthenticationResponseEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public AuthenticationResponseEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return AuthenticationResponseEnum.fromValue(value);
            }
        }
    }
}

