/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.payment;

import com.adyen.model.payment.Amount;
import com.adyen.model.payment.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ForexQuote {
    public static final String SERIALIZED_NAME_ACCOUNT = "account";
    @SerializedName(value="account")
    private String account;
    public static final String SERIALIZED_NAME_ACCOUNT_TYPE = "accountType";
    @SerializedName(value="accountType")
    private String accountType;
    public static final String SERIALIZED_NAME_BASE_AMOUNT = "baseAmount";
    @SerializedName(value="baseAmount")
    private Amount baseAmount;
    public static final String SERIALIZED_NAME_BASE_POINTS = "basePoints";
    @SerializedName(value="basePoints")
    private Integer basePoints;
    public static final String SERIALIZED_NAME_BUY = "buy";
    @SerializedName(value="buy")
    private Amount buy;
    public static final String SERIALIZED_NAME_INTERBANK = "interbank";
    @SerializedName(value="interbank")
    private Amount interbank;
    public static final String SERIALIZED_NAME_REFERENCE = "reference";
    @SerializedName(value="reference")
    private String reference;
    public static final String SERIALIZED_NAME_SELL = "sell";
    @SerializedName(value="sell")
    private Amount sell;
    public static final String SERIALIZED_NAME_SIGNATURE = "signature";
    @SerializedName(value="signature")
    private String signature;
    public static final String SERIALIZED_NAME_SOURCE = "source";
    @SerializedName(value="source")
    private String source;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private String type;
    public static final String SERIALIZED_NAME_VALID_TILL = "validTill";
    @SerializedName(value="validTill")
    private OffsetDateTime validTill;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public ForexQuote account(String account) {
        this.account = account;
        return this;
    }

    @ApiModelProperty(value="The account name.")
    public String getAccount() {
        return this.account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public ForexQuote accountType(String accountType) {
        this.accountType = accountType;
        return this;
    }

    @ApiModelProperty(value="The account type.")
    public String getAccountType() {
        return this.accountType;
    }

    public void setAccountType(String accountType) {
        this.accountType = accountType;
    }

    public ForexQuote baseAmount(Amount baseAmount) {
        this.baseAmount = baseAmount;
        return this;
    }

    @ApiModelProperty(value="")
    public Amount getBaseAmount() {
        return this.baseAmount;
    }

    public void setBaseAmount(Amount baseAmount) {
        this.baseAmount = baseAmount;
    }

    public ForexQuote basePoints(Integer basePoints) {
        this.basePoints = basePoints;
        return this;
    }

    @ApiModelProperty(required=true, value="The base points.")
    public Integer getBasePoints() {
        return this.basePoints;
    }

    public void setBasePoints(Integer basePoints) {
        this.basePoints = basePoints;
    }

    public ForexQuote buy(Amount buy) {
        this.buy = buy;
        return this;
    }

    @ApiModelProperty(value="")
    public Amount getBuy() {
        return this.buy;
    }

    public void setBuy(Amount buy) {
        this.buy = buy;
    }

    public ForexQuote interbank(Amount interbank) {
        this.interbank = interbank;
        return this;
    }

    @ApiModelProperty(value="")
    public Amount getInterbank() {
        return this.interbank;
    }

    public void setInterbank(Amount interbank) {
        this.interbank = interbank;
    }

    public ForexQuote reference(String reference) {
        this.reference = reference;
        return this;
    }

    @ApiModelProperty(value="The reference assigned to the forex quote request.")
    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public ForexQuote sell(Amount sell) {
        this.sell = sell;
        return this;
    }

    @ApiModelProperty(value="")
    public Amount getSell() {
        return this.sell;
    }

    public void setSell(Amount sell) {
        this.sell = sell;
    }

    public ForexQuote signature(String signature) {
        this.signature = signature;
        return this;
    }

    @ApiModelProperty(value="The signature to validate the integrity.")
    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public ForexQuote source(String source) {
        this.source = source;
        return this;
    }

    @ApiModelProperty(value="The source of the forex quote.")
    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public ForexQuote type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="The type of forex.")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public ForexQuote validTill(OffsetDateTime validTill) {
        this.validTill = validTill;
        return this;
    }

    @ApiModelProperty(required=true, value="The date until which the forex quote is valid.")
    public OffsetDateTime getValidTill() {
        return this.validTill;
    }

    public void setValidTill(OffsetDateTime validTill) {
        this.validTill = validTill;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ForexQuote forexQuote = (ForexQuote)o;
        return Objects.equals(this.account, forexQuote.account) && Objects.equals(this.accountType, forexQuote.accountType) && Objects.equals(this.baseAmount, forexQuote.baseAmount) && Objects.equals(this.basePoints, forexQuote.basePoints) && Objects.equals(this.buy, forexQuote.buy) && Objects.equals(this.interbank, forexQuote.interbank) && Objects.equals(this.reference, forexQuote.reference) && Objects.equals(this.sell, forexQuote.sell) && Objects.equals(this.signature, forexQuote.signature) && Objects.equals(this.source, forexQuote.source) && Objects.equals(this.type, forexQuote.type) && Objects.equals(this.validTill, forexQuote.validTill);
    }

    public int hashCode() {
        return Objects.hash(this.account, this.accountType, this.baseAmount, this.basePoints, this.buy, this.interbank, this.reference, this.sell, this.signature, this.source, this.type, this.validTill);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ForexQuote {\n");
        sb.append("    account: ").append(this.toIndentedString(this.account)).append("\n");
        sb.append("    accountType: ").append(this.toIndentedString(this.accountType)).append("\n");
        sb.append("    baseAmount: ").append(this.toIndentedString(this.baseAmount)).append("\n");
        sb.append("    basePoints: ").append(this.toIndentedString(this.basePoints)).append("\n");
        sb.append("    buy: ").append(this.toIndentedString(this.buy)).append("\n");
        sb.append("    interbank: ").append(this.toIndentedString(this.interbank)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    sell: ").append(this.toIndentedString(this.sell)).append("\n");
        sb.append("    signature: ").append(this.toIndentedString(this.signature)).append("\n");
        sb.append("    source: ").append(this.toIndentedString(this.source)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    validTill: ").append(this.toIndentedString(this.validTill)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in ForexQuote is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `ForexQuote` properties.", entry.getKey()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ACCOUNT) != null && !jsonObj.get(SERIALIZED_NAME_ACCOUNT).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `account` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ACCOUNT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ACCOUNT_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_ACCOUNT_TYPE).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `accountType` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ACCOUNT_TYPE).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_BASE_AMOUNT) != null) {
            Amount.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_BASE_AMOUNT));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_BUY) != null) {
            Amount.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_BUY));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_INTERBANK) != null) {
            Amount.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_INTERBANK));
        }
        if (jsonObj.get(SERIALIZED_NAME_REFERENCE) != null && !jsonObj.get(SERIALIZED_NAME_REFERENCE).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `reference` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REFERENCE).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_SELL) != null) {
            Amount.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_SELL));
        }
        if (jsonObj.get(SERIALIZED_NAME_SIGNATURE) != null && !jsonObj.get(SERIALIZED_NAME_SIGNATURE).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `signature` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SIGNATURE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SOURCE) != null && !jsonObj.get(SERIALIZED_NAME_SOURCE).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `source` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SOURCE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_TYPE).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TYPE).toString()));
        }
    }

    public static ForexQuote fromJson(String jsonString) throws IOException {
        return (ForexQuote)JSON.getGson().fromJson(jsonString, ForexQuote.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ACCOUNT);
        openapiFields.add(SERIALIZED_NAME_ACCOUNT_TYPE);
        openapiFields.add(SERIALIZED_NAME_BASE_AMOUNT);
        openapiFields.add(SERIALIZED_NAME_BASE_POINTS);
        openapiFields.add(SERIALIZED_NAME_BUY);
        openapiFields.add(SERIALIZED_NAME_INTERBANK);
        openapiFields.add(SERIALIZED_NAME_REFERENCE);
        openapiFields.add(SERIALIZED_NAME_SELL);
        openapiFields.add(SERIALIZED_NAME_SIGNATURE);
        openapiFields.add(SERIALIZED_NAME_SOURCE);
        openapiFields.add(SERIALIZED_NAME_TYPE);
        openapiFields.add(SERIALIZED_NAME_VALID_TILL);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_BASE_POINTS);
        openapiRequiredFields.add(SERIALIZED_NAME_VALID_TILL);
        log = Logger.getLogger(ForexQuote.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!ForexQuote.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(ForexQuote.class));
            return new TypeAdapter<ForexQuote>(){

                public void write(JsonWriter out, ForexQuote value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public ForexQuote read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    ForexQuote.validateJsonObject(jsonObj);
                    return (ForexQuote)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

