/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.marketpay;

import com.adyen.model.marketpay.TransactionListForAccount;
import com.adyen.util.Util;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class AccountHolderTransactionListRequest {
    @SerializedName(value="transactionListsPerAccount")
    private List<TransactionListForAccount> transactionListsPerAccount = new ArrayList<TransactionListForAccount>();
    @SerializedName(value="accountHolderCode")
    private String accountHolderCode = null;
    @SerializedName(value="transactionStatuses")
    private List<TransactionStatusesEnum> transactionStatuses = new ArrayList<TransactionStatusesEnum>();

    public AccountHolderTransactionListRequest transactionListsPerAccount(List<TransactionListForAccount> transactionListsPerAccount) {
        this.transactionListsPerAccount = transactionListsPerAccount;
        return this;
    }

    public AccountHolderTransactionListRequest addTransactionListsPerAccountItem(TransactionListForAccount transactionListsPerAccountItem) {
        this.transactionListsPerAccount.add(transactionListsPerAccountItem);
        return this;
    }

    public List<TransactionListForAccount> getTransactionListsPerAccount() {
        return this.transactionListsPerAccount;
    }

    public void setTransactionListsPerAccount(List<TransactionListForAccount> transactionListsPerAccount) {
        this.transactionListsPerAccount = transactionListsPerAccount;
    }

    public AccountHolderTransactionListRequest accountHolderCode(String accountHolderCode) {
        this.accountHolderCode = accountHolderCode;
        return this;
    }

    public String getAccountHolderCode() {
        return this.accountHolderCode;
    }

    public void setAccountHolderCode(String accountHolderCode) {
        this.accountHolderCode = accountHolderCode;
    }

    public AccountHolderTransactionListRequest transactionStatuses(List<TransactionStatusesEnum> transactionStatuses) {
        this.transactionStatuses = transactionStatuses;
        return this;
    }

    public AccountHolderTransactionListRequest addTransactionStatusesItem(TransactionStatusesEnum transactionStatusesItem) {
        this.transactionStatuses.add(transactionStatusesItem);
        return this;
    }

    public List<TransactionStatusesEnum> getTransactionStatuses() {
        return this.transactionStatuses;
    }

    public void setTransactionStatuses(List<TransactionStatusesEnum> transactionStatuses) {
        this.transactionStatuses = transactionStatuses;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountHolderTransactionListRequest accountHolderTransactionListRequest = (AccountHolderTransactionListRequest)o;
        return Objects.equals(this.transactionListsPerAccount, accountHolderTransactionListRequest.transactionListsPerAccount) && Objects.equals(this.accountHolderCode, accountHolderTransactionListRequest.accountHolderCode) && Objects.equals(this.transactionStatuses, accountHolderTransactionListRequest.transactionStatuses);
    }

    public int hashCode() {
        return Objects.hash(this.transactionListsPerAccount, this.accountHolderCode, this.transactionStatuses);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AccountHolderTransactionListRequest {\n");
        sb.append("    transactionListsPerAccount: ").append(Util.toIndentedString(this.transactionListsPerAccount)).append("\n");
        sb.append("    accountHolderCode: ").append(Util.toIndentedString(this.accountHolderCode)).append("\n");
        sb.append("    transactionStatuses: ").append(Util.toIndentedString(this.transactionStatuses)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    public static enum TransactionStatusesEnum {
        CHARGEBACK("Chargeback"),
        CHARGEBACKRECEIVED("ChargebackReceived"),
        CHARGEBACKREVERSED("ChargebackReversed"),
        CHARGEBACKREVERSEDRECEIVED("ChargebackReversedReceived"),
        CREDITFAILED("CreditFailed"),
        CREDITED("Credited"),
        DEBITFAILED("DebitFailed"),
        DEBITREVERSEDRECEIVED("DebitReversedReceived"),
        DEBITED("Debited"),
        DEBITEDREVERSED("DebitedReversed"),
        FUNDTRANSFER("FundTransfer"),
        PAYOUT("Payout"),
        PAYOUTREVERSED("PayoutReversed"),
        PENDINGCREDIT("PendingCredit"),
        PENDINGDEBIT("PendingDebit"),
        PENDINGFUNDTRANSFER("PendingFundTransfer"),
        CREDITCLOSED("CreditClosed"),
        CREDITSUSPENDED("CreditSuspended"),
        CONVERTED("Converted"),
        MANUALCORRECTED("ManualCorrected");

        private final String value;

        private TransactionStatusesEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

