/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.Address;
import com.adyen.model.management.Contact;
import com.adyen.model.management.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ShippingLocation {
    public static final String SERIALIZED_NAME_ADDRESS = "address";
    @SerializedName(value="address")
    private Address address;
    public static final String SERIALIZED_NAME_CONTACT = "contact";
    @SerializedName(value="contact")
    private Contact contact;
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public ShippingLocation address(Address address) {
        this.address = address;
        return this;
    }

    @ApiModelProperty(value="")
    public Address getAddress() {
        return this.address;
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    public ShippingLocation contact(Contact contact) {
        this.contact = contact;
        return this;
    }

    @ApiModelProperty(value="")
    public Contact getContact() {
        return this.contact;
    }

    public void setContact(Contact contact) {
        this.contact = contact;
    }

    public ShippingLocation id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the shipping location, for use as `shippingLocationId` when creating an order.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ShippingLocation name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="The unique name of the shipping location.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShippingLocation shippingLocation = (ShippingLocation)o;
        return Objects.equals(this.address, shippingLocation.address) && Objects.equals(this.contact, shippingLocation.contact) && Objects.equals(this.id, shippingLocation.id) && Objects.equals(this.name, shippingLocation.name);
    }

    public int hashCode() {
        return Objects.hash(this.address, this.contact, this.id, this.name);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ShippingLocation {\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    contact: ").append(this.toIndentedString(this.contact)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in ShippingLocation is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `ShippingLocation` properties.", entry.getKey()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_ADDRESS) != null) {
            Address.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_ADDRESS));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_CONTACT) != null) {
            Contact.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_CONTACT));
        }
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
    }

    public static ShippingLocation fromJson(String jsonString) throws IOException {
        return (ShippingLocation)JSON.getGson().fromJson(jsonString, ShippingLocation.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ADDRESS);
        openapiFields.add(SERIALIZED_NAME_CONTACT);
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiRequiredFields = new HashSet();
        log = Logger.getLogger(ShippingLocation.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!ShippingLocation.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(ShippingLocation.class));
            return new TypeAdapter<ShippingLocation>(){

                public void write(JsonWriter out, ShippingLocation value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public ShippingLocation read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    ShippingLocation.validateJsonObject(jsonObj);
                    return (ShippingLocation)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

