/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.JSON;
import com.adyen.model.management.ScheduleTerminalActionsRequestActionDetails;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ScheduleTerminalActionsRequest {
    public static final String SERIALIZED_NAME_ACTION_DETAILS = "actionDetails";
    @SerializedName(value="actionDetails")
    private ScheduleTerminalActionsRequestActionDetails actionDetails;
    public static final String SERIALIZED_NAME_SCHEDULED_AT = "scheduledAt";
    @SerializedName(value="scheduledAt")
    private String scheduledAt;
    public static final String SERIALIZED_NAME_STORE_ID = "storeId";
    @SerializedName(value="storeId")
    private String storeId;
    public static final String SERIALIZED_NAME_TERMINAL_IDS = "terminalIds";
    @SerializedName(value="terminalIds")
    private List<String> terminalIds = null;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public ScheduleTerminalActionsRequest actionDetails(ScheduleTerminalActionsRequestActionDetails actionDetails) {
        this.actionDetails = actionDetails;
        return this;
    }

    @ApiModelProperty(value="")
    public ScheduleTerminalActionsRequestActionDetails getActionDetails() {
        return this.actionDetails;
    }

    public void setActionDetails(ScheduleTerminalActionsRequestActionDetails actionDetails) {
        this.actionDetails = actionDetails;
    }

    public ScheduleTerminalActionsRequest scheduledAt(String scheduledAt) {
        this.scheduledAt = scheduledAt;
        return this;
    }

    @ApiModelProperty(value="The date and time when the action should happen.  Format: [RFC 3339](https://www.rfc-editor.org/rfc/rfc3339), but without the **Z** before the time offset. For example, **2021-11-15T12:16:21+01:00**  The action is sent with the first [maintenance call](https://docs.adyen.com/point-of-sale/automating-terminal-management/terminal-actions-api#when-actions-take-effect) after the specified date and time in the time zone of the terminal.  An empty value causes the action to be sent as soon as possible: at the next maintenance call.")
    public String getScheduledAt() {
        return this.scheduledAt;
    }

    public void setScheduledAt(String scheduledAt) {
        this.scheduledAt = scheduledAt;
    }

    public ScheduleTerminalActionsRequest storeId(String storeId) {
        this.storeId = storeId;
        return this;
    }

    @ApiModelProperty(value="The unique ID of the [store](https://docs.adyen.com/api-explorer/#/ManagementService/latest/get/stores). If present, all terminals in the `terminalIds` list must be assigned to this store.")
    public String getStoreId() {
        return this.storeId;
    }

    public void setStoreId(String storeId) {
        this.storeId = storeId;
    }

    public ScheduleTerminalActionsRequest terminalIds(List<String> terminalIds) {
        this.terminalIds = terminalIds;
        return this;
    }

    public ScheduleTerminalActionsRequest addTerminalIdsItem(String terminalIdsItem) {
        if (this.terminalIds == null) {
            this.terminalIds = new ArrayList<String>();
        }
        this.terminalIds.add(terminalIdsItem);
        return this;
    }

    @ApiModelProperty(value="A list of unique IDs of the terminals to apply the action to. You can extract the IDs from the [GET `/terminals`](https://docs.adyen.com/api-explorer/#/ManagementService/latest/get/terminals) response. Maximum length: 100 IDs.")
    public List<String> getTerminalIds() {
        return this.terminalIds;
    }

    public void setTerminalIds(List<String> terminalIds) {
        this.terminalIds = terminalIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScheduleTerminalActionsRequest scheduleTerminalActionsRequest = (ScheduleTerminalActionsRequest)o;
        return Objects.equals(this.actionDetails, scheduleTerminalActionsRequest.actionDetails) && Objects.equals(this.scheduledAt, scheduleTerminalActionsRequest.scheduledAt) && Objects.equals(this.storeId, scheduleTerminalActionsRequest.storeId) && Objects.equals(this.terminalIds, scheduleTerminalActionsRequest.terminalIds);
    }

    public int hashCode() {
        return Objects.hash(this.actionDetails, this.scheduledAt, this.storeId, this.terminalIds);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ScheduleTerminalActionsRequest {\n");
        sb.append("    actionDetails: ").append(this.toIndentedString(this.actionDetails)).append("\n");
        sb.append("    scheduledAt: ").append(this.toIndentedString(this.scheduledAt)).append("\n");
        sb.append("    storeId: ").append(this.toIndentedString(this.storeId)).append("\n");
        sb.append("    terminalIds: ").append(this.toIndentedString(this.terminalIds)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in ScheduleTerminalActionsRequest is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `ScheduleTerminalActionsRequest` properties.", entry.getKey()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_ACTION_DETAILS) != null) {
            ScheduleTerminalActionsRequestActionDetails.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_ACTION_DETAILS));
        }
        if (jsonObj.get(SERIALIZED_NAME_SCHEDULED_AT) != null && !jsonObj.get(SERIALIZED_NAME_SCHEDULED_AT).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `scheduledAt` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SCHEDULED_AT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_STORE_ID) != null && !jsonObj.get(SERIALIZED_NAME_STORE_ID).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `storeId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STORE_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TERMINAL_IDS) != null && !jsonObj.get(SERIALIZED_NAME_TERMINAL_IDS).isJsonArray()) {
            log.log(Level.WARNING, String.format("Expected the field `terminalIds` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TERMINAL_IDS).toString()));
        }
    }

    public static ScheduleTerminalActionsRequest fromJson(String jsonString) throws IOException {
        return (ScheduleTerminalActionsRequest)JSON.getGson().fromJson(jsonString, ScheduleTerminalActionsRequest.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ACTION_DETAILS);
        openapiFields.add(SERIALIZED_NAME_SCHEDULED_AT);
        openapiFields.add(SERIALIZED_NAME_STORE_ID);
        openapiFields.add(SERIALIZED_NAME_TERMINAL_IDS);
        openapiRequiredFields = new HashSet();
        log = Logger.getLogger(ScheduleTerminalActionsRequest.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!ScheduleTerminalActionsRequest.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(ScheduleTerminalActionsRequest.class));
            return new TypeAdapter<ScheduleTerminalActionsRequest>(){

                public void write(JsonWriter out, ScheduleTerminalActionsRequest value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public ScheduleTerminalActionsRequest read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    ScheduleTerminalActionsRequest.validateJsonObject(jsonObj);
                    return (ScheduleTerminalActionsRequest)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

