/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MinorUnitsMonetaryValue {
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private Integer amount;
    public static final String SERIALIZED_NAME_CURRENCY_CODE = "currencyCode";
    @SerializedName(value="currencyCode")
    private String currencyCode;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public MinorUnitsMonetaryValue amount(Integer amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(value="The transaction amount, in [minor units](https://docs.adyen.com/development-resources/currency-codes).")
    public Integer getAmount() {
        return this.amount;
    }

    public void setAmount(Integer amount) {
        this.amount = amount;
    }

    public MinorUnitsMonetaryValue currencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
        return this;
    }

    @ApiModelProperty(value="The three-character [ISO currency code](https://docs.adyen.com/development-resources/currency-codes).")
    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MinorUnitsMonetaryValue minorUnitsMonetaryValue = (MinorUnitsMonetaryValue)o;
        return Objects.equals(this.amount, minorUnitsMonetaryValue.amount) && Objects.equals(this.currencyCode, minorUnitsMonetaryValue.currencyCode);
    }

    public int hashCode() {
        return Objects.hash(this.amount, this.currencyCode);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MinorUnitsMonetaryValue {\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    currencyCode: ").append(this.toIndentedString(this.currencyCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in MinorUnitsMonetaryValue is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `MinorUnitsMonetaryValue` properties.", entry.getKey()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CURRENCY_CODE) != null && !jsonObj.get(SERIALIZED_NAME_CURRENCY_CODE).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `currencyCode` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CURRENCY_CODE).toString()));
        }
    }

    public static MinorUnitsMonetaryValue fromJson(String jsonString) throws IOException {
        return (MinorUnitsMonetaryValue)JSON.getGson().fromJson(jsonString, MinorUnitsMonetaryValue.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_AMOUNT);
        openapiFields.add(SERIALIZED_NAME_CURRENCY_CODE);
        openapiRequiredFields = new HashSet();
        log = Logger.getLogger(MinorUnitsMonetaryValue.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!MinorUnitsMonetaryValue.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(MinorUnitsMonetaryValue.class));
            return new TypeAdapter<MinorUnitsMonetaryValue>(){

                public void write(JsonWriter out, MinorUnitsMonetaryValue value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public MinorUnitsMonetaryValue read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    MinorUnitsMonetaryValue.validateJsonObject(jsonObj);
                    return (MinorUnitsMonetaryValue)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

