/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.AllowedOrigin;
import com.adyen.model.management.ApiCredentialLinks;
import com.adyen.model.management.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CreateCompanyApiCredentialResponse {
    public static final String SERIALIZED_NAME_LINKS = "_links";
    @SerializedName(value="_links")
    private ApiCredentialLinks links;
    public static final String SERIALIZED_NAME_ACTIVE = "active";
    @SerializedName(value="active")
    private Boolean active;
    public static final String SERIALIZED_NAME_ALLOWED_IP_ADDRESSES = "allowedIpAddresses";
    @SerializedName(value="allowedIpAddresses")
    private List<String> allowedIpAddresses = new ArrayList<String>();
    public static final String SERIALIZED_NAME_ALLOWED_ORIGINS = "allowedOrigins";
    @SerializedName(value="allowedOrigins")
    private List<AllowedOrigin> allowedOrigins = null;
    public static final String SERIALIZED_NAME_API_KEY = "apiKey";
    @SerializedName(value="apiKey")
    private String apiKey;
    public static final String SERIALIZED_NAME_ASSOCIATED_MERCHANT_ACCOUNTS = "associatedMerchantAccounts";
    @SerializedName(value="associatedMerchantAccounts")
    private List<String> associatedMerchantAccounts = new ArrayList<String>();
    public static final String SERIALIZED_NAME_CLIENT_KEY = "clientKey";
    @SerializedName(value="clientKey")
    private String clientKey;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_PASSWORD = "password";
    @SerializedName(value="password")
    private String password;
    public static final String SERIALIZED_NAME_ROLES = "roles";
    @SerializedName(value="roles")
    private List<String> roles = new ArrayList<String>();
    public static final String SERIALIZED_NAME_USERNAME = "username";
    @SerializedName(value="username")
    private String username;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public CreateCompanyApiCredentialResponse links(ApiCredentialLinks links) {
        this.links = links;
        return this;
    }

    @ApiModelProperty(value="")
    public ApiCredentialLinks getLinks() {
        return this.links;
    }

    public void setLinks(ApiCredentialLinks links) {
        this.links = links;
    }

    public CreateCompanyApiCredentialResponse active(Boolean active) {
        this.active = active;
        return this;
    }

    @ApiModelProperty(required=true, value="Indicates if the API credential is enabled. Must be set to **true** to use the credential in your integration.")
    public Boolean getActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public CreateCompanyApiCredentialResponse allowedIpAddresses(List<String> allowedIpAddresses) {
        this.allowedIpAddresses = allowedIpAddresses;
        return this;
    }

    public CreateCompanyApiCredentialResponse addAllowedIpAddressesItem(String allowedIpAddressesItem) {
        this.allowedIpAddresses.add(allowedIpAddressesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="List of IP addresses from which your client can make requests.  If the list is empty, we allow requests from any IP. If the list is not empty and we get a request from an IP which is not on the list, you get a security error.")
    public List<String> getAllowedIpAddresses() {
        return this.allowedIpAddresses;
    }

    public void setAllowedIpAddresses(List<String> allowedIpAddresses) {
        this.allowedIpAddresses = allowedIpAddresses;
    }

    public CreateCompanyApiCredentialResponse allowedOrigins(List<AllowedOrigin> allowedOrigins) {
        this.allowedOrigins = allowedOrigins;
        return this;
    }

    public CreateCompanyApiCredentialResponse addAllowedOriginsItem(AllowedOrigin allowedOriginsItem) {
        if (this.allowedOrigins == null) {
            this.allowedOrigins = new ArrayList<AllowedOrigin>();
        }
        this.allowedOrigins.add(allowedOriginsItem);
        return this;
    }

    @ApiModelProperty(value="List containing the [allowed origins](https://docs.adyen.com/development-resources/client-side-authentication#allowed-origins) linked to the API credential.")
    public List<AllowedOrigin> getAllowedOrigins() {
        return this.allowedOrigins;
    }

    public void setAllowedOrigins(List<AllowedOrigin> allowedOrigins) {
        this.allowedOrigins = allowedOrigins;
    }

    public CreateCompanyApiCredentialResponse apiKey(String apiKey) {
        this.apiKey = apiKey;
        return this;
    }

    @ApiModelProperty(required=true, value="The API key for the API credential that was created.")
    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public CreateCompanyApiCredentialResponse associatedMerchantAccounts(List<String> associatedMerchantAccounts) {
        this.associatedMerchantAccounts = associatedMerchantAccounts;
        return this;
    }

    public CreateCompanyApiCredentialResponse addAssociatedMerchantAccountsItem(String associatedMerchantAccountsItem) {
        this.associatedMerchantAccounts.add(associatedMerchantAccountsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="List of merchant accounts that the API credential has access to.")
    public List<String> getAssociatedMerchantAccounts() {
        return this.associatedMerchantAccounts;
    }

    public void setAssociatedMerchantAccounts(List<String> associatedMerchantAccounts) {
        this.associatedMerchantAccounts = associatedMerchantAccounts;
    }

    public CreateCompanyApiCredentialResponse clientKey(String clientKey) {
        this.clientKey = clientKey;
        return this;
    }

    @ApiModelProperty(required=true, value="Public key used for [client-side authentication](https://docs.adyen.com/development-resources/client-side-authentication). The client key is required for Drop-in and Components integrations.")
    public String getClientKey() {
        return this.clientKey;
    }

    public void setClientKey(String clientKey) {
        this.clientKey = clientKey;
    }

    public CreateCompanyApiCredentialResponse description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="Description of the API credential.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public CreateCompanyApiCredentialResponse id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="Unique identifier of the API credential.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public CreateCompanyApiCredentialResponse password(String password) {
        this.password = password;
        return this;
    }

    @ApiModelProperty(required=true, value="The password for the API credential that was created.")
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public CreateCompanyApiCredentialResponse roles(List<String> roles) {
        this.roles = roles;
        return this;
    }

    public CreateCompanyApiCredentialResponse addRolesItem(String rolesItem) {
        this.roles.add(rolesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="List of [roles](https://docs.adyen.com/development-resources/api-credentials#roles-1) for the API credential.")
    public List<String> getRoles() {
        return this.roles;
    }

    public void setRoles(List<String> roles) {
        this.roles = roles;
    }

    public CreateCompanyApiCredentialResponse username(String username) {
        this.username = username;
        return this;
    }

    @ApiModelProperty(required=true, value="The name of the [API credential](https://docs.adyen.com/development-resources/api-credentials), for example **ws@Company.TestCompany**.")
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateCompanyApiCredentialResponse createCompanyApiCredentialResponse = (CreateCompanyApiCredentialResponse)o;
        return Objects.equals(this.links, createCompanyApiCredentialResponse.links) && Objects.equals(this.active, createCompanyApiCredentialResponse.active) && Objects.equals(this.allowedIpAddresses, createCompanyApiCredentialResponse.allowedIpAddresses) && Objects.equals(this.allowedOrigins, createCompanyApiCredentialResponse.allowedOrigins) && Objects.equals(this.apiKey, createCompanyApiCredentialResponse.apiKey) && Objects.equals(this.associatedMerchantAccounts, createCompanyApiCredentialResponse.associatedMerchantAccounts) && Objects.equals(this.clientKey, createCompanyApiCredentialResponse.clientKey) && Objects.equals(this.description, createCompanyApiCredentialResponse.description) && Objects.equals(this.id, createCompanyApiCredentialResponse.id) && Objects.equals(this.password, createCompanyApiCredentialResponse.password) && Objects.equals(this.roles, createCompanyApiCredentialResponse.roles) && Objects.equals(this.username, createCompanyApiCredentialResponse.username);
    }

    public int hashCode() {
        return Objects.hash(this.links, this.active, this.allowedIpAddresses, this.allowedOrigins, this.apiKey, this.associatedMerchantAccounts, this.clientKey, this.description, this.id, this.password, this.roles, this.username);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateCompanyApiCredentialResponse {\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    active: ").append(this.toIndentedString(this.active)).append("\n");
        sb.append("    allowedIpAddresses: ").append(this.toIndentedString(this.allowedIpAddresses)).append("\n");
        sb.append("    allowedOrigins: ").append(this.toIndentedString(this.allowedOrigins)).append("\n");
        sb.append("    apiKey: ").append(this.toIndentedString(this.apiKey)).append("\n");
        sb.append("    associatedMerchantAccounts: ").append(this.toIndentedString(this.associatedMerchantAccounts)).append("\n");
        sb.append("    clientKey: ").append(this.toIndentedString(this.clientKey)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    password: ").append(this.toIndentedString(this.password)).append("\n");
        sb.append("    roles: ").append(this.toIndentedString(this.roles)).append("\n");
        sb.append("    username: ").append(this.toIndentedString(this.username)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArrayallowedOrigins;
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in CreateCompanyApiCredentialResponse is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `CreateCompanyApiCredentialResponse` properties.", entry.getKey()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_LINKS) != null) {
            ApiCredentialLinks.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_LINKS));
        }
        if (jsonObj.get(SERIALIZED_NAME_ALLOWED_IP_ADDRESSES) != null && !jsonObj.get(SERIALIZED_NAME_ALLOWED_IP_ADDRESSES).isJsonArray()) {
            log.log(Level.WARNING, String.format("Expected the field `allowedIpAddresses` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ALLOWED_IP_ADDRESSES).toString()));
        }
        if ((jsonArrayallowedOrigins = jsonObj.getAsJsonArray(SERIALIZED_NAME_ALLOWED_ORIGINS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_ALLOWED_ORIGINS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `allowedOrigins` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ALLOWED_ORIGINS).toString()));
            }
            for (int i = 0; i < jsonArrayallowedOrigins.size(); ++i) {
                AllowedOrigin.validateJsonObject(jsonArrayallowedOrigins.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_API_KEY) != null && !jsonObj.get(SERIALIZED_NAME_API_KEY).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `apiKey` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_API_KEY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ASSOCIATED_MERCHANT_ACCOUNTS) != null && !jsonObj.get(SERIALIZED_NAME_ASSOCIATED_MERCHANT_ACCOUNTS).isJsonArray()) {
            log.log(Level.WARNING, String.format("Expected the field `associatedMerchantAccounts` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ASSOCIATED_MERCHANT_ACCOUNTS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CLIENT_KEY) != null && !jsonObj.get(SERIALIZED_NAME_CLIENT_KEY).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `clientKey` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CLIENT_KEY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DESCRIPTION) != null && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DESCRIPTION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PASSWORD) != null && !jsonObj.get(SERIALIZED_NAME_PASSWORD).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `password` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PASSWORD).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ROLES) != null && !jsonObj.get(SERIALIZED_NAME_ROLES).isJsonArray()) {
            log.log(Level.WARNING, String.format("Expected the field `roles` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ROLES).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_USERNAME) != null && !jsonObj.get(SERIALIZED_NAME_USERNAME).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `username` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_USERNAME).toString()));
        }
    }

    public static CreateCompanyApiCredentialResponse fromJson(String jsonString) throws IOException {
        return (CreateCompanyApiCredentialResponse)JSON.getGson().fromJson(jsonString, CreateCompanyApiCredentialResponse.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_LINKS);
        openapiFields.add(SERIALIZED_NAME_ACTIVE);
        openapiFields.add(SERIALIZED_NAME_ALLOWED_IP_ADDRESSES);
        openapiFields.add(SERIALIZED_NAME_ALLOWED_ORIGINS);
        openapiFields.add(SERIALIZED_NAME_API_KEY);
        openapiFields.add(SERIALIZED_NAME_ASSOCIATED_MERCHANT_ACCOUNTS);
        openapiFields.add(SERIALIZED_NAME_CLIENT_KEY);
        openapiFields.add(SERIALIZED_NAME_DESCRIPTION);
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_PASSWORD);
        openapiFields.add(SERIALIZED_NAME_ROLES);
        openapiFields.add(SERIALIZED_NAME_USERNAME);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_ACTIVE);
        openapiRequiredFields.add(SERIALIZED_NAME_ALLOWED_IP_ADDRESSES);
        openapiRequiredFields.add(SERIALIZED_NAME_API_KEY);
        openapiRequiredFields.add(SERIALIZED_NAME_ASSOCIATED_MERCHANT_ACCOUNTS);
        openapiRequiredFields.add(SERIALIZED_NAME_CLIENT_KEY);
        openapiRequiredFields.add(SERIALIZED_NAME_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_PASSWORD);
        openapiRequiredFields.add(SERIALIZED_NAME_ROLES);
        openapiRequiredFields.add(SERIALIZED_NAME_USERNAME);
        log = Logger.getLogger(CreateCompanyApiCredentialResponse.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!CreateCompanyApiCredentialResponse.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(CreateCompanyApiCredentialResponse.class));
            return new TypeAdapter<CreateCompanyApiCredentialResponse>(){

                public void write(JsonWriter out, CreateCompanyApiCredentialResponse value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public CreateCompanyApiCredentialResponse read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    CreateCompanyApiCredentialResponse.validateJsonObject(jsonObj);
                    return (CreateCompanyApiCredentialResponse)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

