/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.legalentitymanagement;

import com.adyen.model.legalentitymanagement.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TaxReportingClassification {
    public static final String SERIALIZED_NAME_BUSINESS_TYPE = "businessType";
    @SerializedName(value="businessType")
    private BusinessTypeEnum businessType;
    public static final String SERIALIZED_NAME_FINANCIAL_INSTITUTION_NUMBER = "financialInstitutionNumber";
    @SerializedName(value="financialInstitutionNumber")
    private String financialInstitutionNumber;
    public static final String SERIALIZED_NAME_MAIN_SOURCE_OF_INCOME = "mainSourceOfIncome";
    @SerializedName(value="mainSourceOfIncome")
    private MainSourceOfIncomeEnum mainSourceOfIncome;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private TypeEnum type;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public TaxReportingClassification businessType(BusinessTypeEnum businessType) {
        this.businessType = businessType;
        return this;
    }

    @ApiModelProperty(value="The organization's business type.  Possible values: **other**, **listedPublicCompany**, **subsidiaryOfListedPublicCompany**, **governmentalOrganization**, **internationalOrganization**, **financialInstitution**.")
    public BusinessTypeEnum getBusinessType() {
        return this.businessType;
    }

    public void setBusinessType(BusinessTypeEnum businessType) {
        this.businessType = businessType;
    }

    public TaxReportingClassification financialInstitutionNumber(String financialInstitutionNumber) {
        this.financialInstitutionNumber = financialInstitutionNumber;
        return this;
    }

    @ApiModelProperty(value="The Global Intermediary Identification Number (GIIN) required for FATCA.")
    public String getFinancialInstitutionNumber() {
        return this.financialInstitutionNumber;
    }

    public void setFinancialInstitutionNumber(String financialInstitutionNumber) {
        this.financialInstitutionNumber = financialInstitutionNumber;
    }

    public TaxReportingClassification mainSourceOfIncome(MainSourceOfIncomeEnum mainSourceOfIncome) {
        this.mainSourceOfIncome = mainSourceOfIncome;
        return this;
    }

    @ApiModelProperty(value="The organization's main source of income.  Possible values: **businessOperation**, **realEstateSales**, **investmentInterestOrRoyalty**, **propertyRental**, **other**.")
    public MainSourceOfIncomeEnum getMainSourceOfIncome() {
        return this.mainSourceOfIncome;
    }

    public void setMainSourceOfIncome(MainSourceOfIncomeEnum mainSourceOfIncome) {
        this.mainSourceOfIncome = mainSourceOfIncome;
    }

    public TaxReportingClassification type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="The tax reporting classification type.  Possible values: **nonFinancialNonReportable**, **financialNonReportable**, **nonFinancialActive**, **nonFinancialPassive**.")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaxReportingClassification taxReportingClassification = (TaxReportingClassification)o;
        return Objects.equals((Object)this.businessType, (Object)taxReportingClassification.businessType) && Objects.equals(this.financialInstitutionNumber, taxReportingClassification.financialInstitutionNumber) && Objects.equals((Object)this.mainSourceOfIncome, (Object)taxReportingClassification.mainSourceOfIncome) && Objects.equals((Object)this.type, (Object)taxReportingClassification.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.businessType, this.financialInstitutionNumber, this.mainSourceOfIncome, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TaxReportingClassification {\n");
        sb.append("    businessType: ").append(this.toIndentedString((Object)this.businessType)).append("\n");
        sb.append("    financialInstitutionNumber: ").append(this.toIndentedString(this.financialInstitutionNumber)).append("\n");
        sb.append("    mainSourceOfIncome: ").append(this.toIndentedString((Object)this.mainSourceOfIncome)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in TaxReportingClassification is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `TaxReportingClassification` properties.", entry.getKey()));
        }
        if (jsonObj.get(SERIALIZED_NAME_BUSINESS_TYPE) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_BUSINESS_TYPE).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `businessType` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BUSINESS_TYPE).toString()));
            }
            BusinessTypeEnum.fromValue(jsonObj.get(SERIALIZED_NAME_BUSINESS_TYPE).getAsString());
        }
        if (jsonObj.get(SERIALIZED_NAME_FINANCIAL_INSTITUTION_NUMBER) != null && !jsonObj.get(SERIALIZED_NAME_FINANCIAL_INSTITUTION_NUMBER).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `financialInstitutionNumber` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FINANCIAL_INSTITUTION_NUMBER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MAIN_SOURCE_OF_INCOME) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_MAIN_SOURCE_OF_INCOME).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `mainSourceOfIncome` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MAIN_SOURCE_OF_INCOME).toString()));
            }
            MainSourceOfIncomeEnum.fromValue(jsonObj.get(SERIALIZED_NAME_MAIN_SOURCE_OF_INCOME).getAsString());
        }
        if (jsonObj.get(SERIALIZED_NAME_TYPE) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_TYPE).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TYPE).toString()));
            }
            TypeEnum.fromValue(jsonObj.get(SERIALIZED_NAME_TYPE).getAsString());
        }
    }

    public static TaxReportingClassification fromJson(String jsonString) throws IOException {
        return (TaxReportingClassification)JSON.getGson().fromJson(jsonString, TaxReportingClassification.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_BUSINESS_TYPE);
        openapiFields.add(SERIALIZED_NAME_FINANCIAL_INSTITUTION_NUMBER);
        openapiFields.add(SERIALIZED_NAME_MAIN_SOURCE_OF_INCOME);
        openapiFields.add(SERIALIZED_NAME_TYPE);
        openapiRequiredFields = new HashSet();
        log = Logger.getLogger(TaxReportingClassification.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!TaxReportingClassification.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(TaxReportingClassification.class));
            return new TypeAdapter<TaxReportingClassification>(){

                public void write(JsonWriter out, TaxReportingClassification value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public TaxReportingClassification read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    TaxReportingClassification.validateJsonObject(jsonObj);
                    return (TaxReportingClassification)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        NONFINANCIALNONREPORTABLE("nonFinancialNonReportable"),
        FINANCIALNONREPORTABLE("financialNonReportable"),
        NONFINANCIALACTIVE("nonFinancialActive"),
        NONFINANCIALPASSIVE("nonFinancialPassive");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum MainSourceOfIncomeEnum {
        BUSINESSOPERATION("businessOperation"),
        REALESTATESALES("realEstateSales"),
        INVESTMENTINTERESTORROYALTY("investmentInterestOrRoyalty"),
        PROPERTYRENTAL("propertyRental"),
        OTHER("other");

        private String value;

        private MainSourceOfIncomeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static MainSourceOfIncomeEnum fromValue(String value) {
            for (MainSourceOfIncomeEnum b : MainSourceOfIncomeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<MainSourceOfIncomeEnum> {
            public void write(JsonWriter jsonWriter, MainSourceOfIncomeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public MainSourceOfIncomeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return MainSourceOfIncomeEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum BusinessTypeEnum {
        OTHER("other"),
        LISTEDPUBLICCOMPANY("listedPublicCompany"),
        SUBSIDIARYOFLISTEDPUBLICCOMPANY("subsidiaryOfListedPublicCompany"),
        GOVERNMENTALORGANIZATION("governmentalOrganization"),
        INTERNATIONALORGANIZATION("internationalOrganization"),
        FINANCIALINSTITUTION_("financialInstitution.");

        private String value;

        private BusinessTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static BusinessTypeEnum fromValue(String value) {
            for (BusinessTypeEnum b : BusinessTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<BusinessTypeEnum> {
            public void write(JsonWriter jsonWriter, BusinessTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public BusinessTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return BusinessTypeEnum.fromValue(value);
            }
        }
    }
}

