/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.legalentitymanagement;

import com.adyen.model.legalentitymanagement.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SupportingEntityCapability {
    public static final String SERIALIZED_NAME_ALLOWED = "allowed";
    @SerializedName(value="allowed")
    private Boolean allowed;
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_REQUESTED = "requested";
    @SerializedName(value="requested")
    private Boolean requested;
    public static final String SERIALIZED_NAME_VERIFICATION_STATUS = "verificationStatus";
    @SerializedName(value="verificationStatus")
    private String verificationStatus;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public SupportingEntityCapability() {
    }

    public SupportingEntityCapability(Boolean allowed, String id, Boolean requested, String verificationStatus) {
        this();
        this.allowed = allowed;
        this.id = id;
        this.requested = requested;
        this.verificationStatus = verificationStatus;
    }

    @ApiModelProperty(value="Indicates whether the supporting entity capability is allowed.  If a supporting entity is allowed but its parent legal entity is not, it means there are other supporting entities that failed validation.  **The allowed supporting entity can still be used**")
    public Boolean getAllowed() {
        return this.allowed;
    }

    @ApiModelProperty(value="Supporting entity reference ")
    public String getId() {
        return this.id;
    }

    @ApiModelProperty(value="Indicates whether the supporting entity capability is requested. ")
    public Boolean getRequested() {
        return this.requested;
    }

    @ApiModelProperty(value="The status of the verification checks for the supporting entity capability.  Possible values:  * **pending**: Adyen is running the verification.  * **invalid**: The verification failed. Check if the `errors` array contains more information.  * **valid**: The verification has been successfully completed.  * **rejected**: Adyen has verified the information, but found reasons to not allow the capability. ")
    public String getVerificationStatus() {
        return this.verificationStatus;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SupportingEntityCapability supportingEntityCapability = (SupportingEntityCapability)o;
        return Objects.equals(this.allowed, supportingEntityCapability.allowed) && Objects.equals(this.id, supportingEntityCapability.id) && Objects.equals(this.requested, supportingEntityCapability.requested) && Objects.equals(this.verificationStatus, supportingEntityCapability.verificationStatus);
    }

    public int hashCode() {
        return Objects.hash(this.allowed, this.id, this.requested, this.verificationStatus);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SupportingEntityCapability {\n");
        sb.append("    allowed: ").append(this.toIndentedString(this.allowed)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    requested: ").append(this.toIndentedString(this.requested)).append("\n");
        sb.append("    verificationStatus: ").append(this.toIndentedString(this.verificationStatus)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in SupportingEntityCapability is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `SupportingEntityCapability` properties.", entry.getKey()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_VERIFICATION_STATUS) != null && !jsonObj.get(SERIALIZED_NAME_VERIFICATION_STATUS).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `verificationStatus` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VERIFICATION_STATUS).toString()));
        }
    }

    public static SupportingEntityCapability fromJson(String jsonString) throws IOException {
        return (SupportingEntityCapability)JSON.getGson().fromJson(jsonString, SupportingEntityCapability.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ALLOWED);
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_REQUESTED);
        openapiFields.add(SERIALIZED_NAME_VERIFICATION_STATUS);
        openapiRequiredFields = new HashSet();
        log = Logger.getLogger(SupportingEntityCapability.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!SupportingEntityCapability.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(SupportingEntityCapability.class));
            return new TypeAdapter<SupportingEntityCapability>(){

                public void write(JsonWriter out, SupportingEntityCapability value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public SupportingEntityCapability read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    SupportingEntityCapability.validateJsonObject(jsonObj);
                    return (SupportingEntityCapability)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

