/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.legalentitymanagement;

import com.adyen.model.legalentitymanagement.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PciSigningResponse {
    public static final String SERIALIZED_NAME_PCI_QUESTIONNAIRE_IDS = "pciQuestionnaireIds";
    @SerializedName(value="pciQuestionnaireIds")
    private List<String> pciQuestionnaireIds = null;
    public static final String SERIALIZED_NAME_SIGNED_BY = "signedBy";
    @SerializedName(value="signedBy")
    private String signedBy;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public PciSigningResponse pciQuestionnaireIds(List<String> pciQuestionnaireIds) {
        this.pciQuestionnaireIds = pciQuestionnaireIds;
        return this;
    }

    public PciSigningResponse addPciQuestionnaireIdsItem(String pciQuestionnaireIdsItem) {
        if (this.pciQuestionnaireIds == null) {
            this.pciQuestionnaireIds = new ArrayList<String>();
        }
        this.pciQuestionnaireIds.add(pciQuestionnaireIdsItem);
        return this;
    }

    @ApiModelProperty(value="The unique identifiers of the signed PCI documents.")
    public List<String> getPciQuestionnaireIds() {
        return this.pciQuestionnaireIds;
    }

    public void setPciQuestionnaireIds(List<String> pciQuestionnaireIds) {
        this.pciQuestionnaireIds = pciQuestionnaireIds;
    }

    public PciSigningResponse signedBy(String signedBy) {
        this.signedBy = signedBy;
        return this;
    }

    @ApiModelProperty(value="The [legal entity ID](https://docs.adyen.com/api-explorer/#/legalentity/latest/post/legalEntities__resParam_id) of the individual who signed the PCI questionnaire.")
    public String getSignedBy() {
        return this.signedBy;
    }

    public void setSignedBy(String signedBy) {
        this.signedBy = signedBy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PciSigningResponse pciSigningResponse = (PciSigningResponse)o;
        return Objects.equals(this.pciQuestionnaireIds, pciSigningResponse.pciQuestionnaireIds) && Objects.equals(this.signedBy, pciSigningResponse.signedBy);
    }

    public int hashCode() {
        return Objects.hash(this.pciQuestionnaireIds, this.signedBy);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PciSigningResponse {\n");
        sb.append("    pciQuestionnaireIds: ").append(this.toIndentedString(this.pciQuestionnaireIds)).append("\n");
        sb.append("    signedBy: ").append(this.toIndentedString(this.signedBy)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in PciSigningResponse is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `PciSigningResponse` properties.", entry.getKey()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PCI_QUESTIONNAIRE_IDS) != null && !jsonObj.get(SERIALIZED_NAME_PCI_QUESTIONNAIRE_IDS).isJsonArray()) {
            log.log(Level.WARNING, String.format("Expected the field `pciQuestionnaireIds` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PCI_QUESTIONNAIRE_IDS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SIGNED_BY) != null && !jsonObj.get(SERIALIZED_NAME_SIGNED_BY).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `signedBy` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SIGNED_BY).toString()));
        }
    }

    public static PciSigningResponse fromJson(String jsonString) throws IOException {
        return (PciSigningResponse)JSON.getGson().fromJson(jsonString, PciSigningResponse.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_PCI_QUESTIONNAIRE_IDS);
        openapiFields.add(SERIALIZED_NAME_SIGNED_BY);
        openapiRequiredFields = new HashSet();
        log = Logger.getLogger(PciSigningResponse.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!PciSigningResponse.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(PciSigningResponse.class));
            return new TypeAdapter<PciSigningResponse>(){

                public void write(JsonWriter out, PciSigningResponse value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public PciSigningResponse read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    PciSigningResponse.validateJsonObject(jsonObj);
                    return (PciSigningResponse)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

