/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.legalentitymanagement;

import com.adyen.model.legalentitymanagement.Individual;
import com.adyen.model.legalentitymanagement.JSON;
import com.adyen.model.legalentitymanagement.LegalEntityAssociation;
import com.adyen.model.legalentitymanagement.LegalEntityCapability;
import com.adyen.model.legalentitymanagement.Organization;
import com.adyen.model.legalentitymanagement.SoleProprietorship;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LegalEntityInfo {
    public static final String SERIALIZED_NAME_CAPABILITIES = "capabilities";
    @SerializedName(value="capabilities")
    private Map<String, LegalEntityCapability> capabilities = null;
    public static final String SERIALIZED_NAME_ENTITY_ASSOCIATIONS = "entityAssociations";
    @SerializedName(value="entityAssociations")
    private List<LegalEntityAssociation> entityAssociations = null;
    public static final String SERIALIZED_NAME_INDIVIDUAL = "individual";
    @SerializedName(value="individual")
    private Individual individual;
    public static final String SERIALIZED_NAME_ORGANIZATION = "organization";
    @SerializedName(value="organization")
    private Organization organization;
    public static final String SERIALIZED_NAME_REFERENCE = "reference";
    @SerializedName(value="reference")
    private String reference;
    public static final String SERIALIZED_NAME_SOLE_PROPRIETORSHIP = "soleProprietorship";
    @SerializedName(value="soleProprietorship")
    private SoleProprietorship soleProprietorship;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private TypeEnum type;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public LegalEntityInfo() {
    }

    public LegalEntityInfo(Map<String, LegalEntityCapability> capabilities) {
        this();
        this.capabilities = capabilities;
    }

    @ApiModelProperty(value="Contains key-value pairs that specify the actions that the legal entity can do in your platform.The key is a capability required for your integration. For example, **issueCard** for Issuing.The value is an object containing the settings for the capability.")
    public Map<String, LegalEntityCapability> getCapabilities() {
        return this.capabilities;
    }

    public LegalEntityInfo entityAssociations(List<LegalEntityAssociation> entityAssociations) {
        this.entityAssociations = entityAssociations;
        return this;
    }

    public LegalEntityInfo addEntityAssociationsItem(LegalEntityAssociation entityAssociationsItem) {
        if (this.entityAssociations == null) {
            this.entityAssociations = new ArrayList<LegalEntityAssociation>();
        }
        this.entityAssociations.add(entityAssociationsItem);
        return this;
    }

    @ApiModelProperty(value="List of legal entities associated with the current legal entity. For example, ultimate beneficial owners associated with an organization through ownership or control, or as signatories.")
    public List<LegalEntityAssociation> getEntityAssociations() {
        return this.entityAssociations;
    }

    public void setEntityAssociations(List<LegalEntityAssociation> entityAssociations) {
        this.entityAssociations = entityAssociations;
    }

    public LegalEntityInfo individual(Individual individual) {
        this.individual = individual;
        return this;
    }

    @ApiModelProperty(value="")
    public Individual getIndividual() {
        return this.individual;
    }

    public void setIndividual(Individual individual) {
        this.individual = individual;
    }

    public LegalEntityInfo organization(Organization organization) {
        this.organization = organization;
        return this;
    }

    @ApiModelProperty(value="")
    public Organization getOrganization() {
        return this.organization;
    }

    public void setOrganization(Organization organization) {
        this.organization = organization;
    }

    public LegalEntityInfo reference(String reference) {
        this.reference = reference;
        return this;
    }

    @ApiModelProperty(value="Your reference for the legal entity, maximum 150 characters.")
    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public LegalEntityInfo soleProprietorship(SoleProprietorship soleProprietorship) {
        this.soleProprietorship = soleProprietorship;
        return this;
    }

    @ApiModelProperty(value="")
    public SoleProprietorship getSoleProprietorship() {
        return this.soleProprietorship;
    }

    public void setSoleProprietorship(SoleProprietorship soleProprietorship) {
        this.soleProprietorship = soleProprietorship;
    }

    public LegalEntityInfo type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="The type of legal entity.   Possible values: **individual**, **organization**, or **soleProprietorship**.")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LegalEntityInfo legalEntityInfo = (LegalEntityInfo)o;
        return Objects.equals(this.capabilities, legalEntityInfo.capabilities) && Objects.equals(this.entityAssociations, legalEntityInfo.entityAssociations) && Objects.equals(this.individual, legalEntityInfo.individual) && Objects.equals(this.organization, legalEntityInfo.organization) && Objects.equals(this.reference, legalEntityInfo.reference) && Objects.equals(this.soleProprietorship, legalEntityInfo.soleProprietorship) && Objects.equals((Object)this.type, (Object)legalEntityInfo.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.capabilities, this.entityAssociations, this.individual, this.organization, this.reference, this.soleProprietorship, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LegalEntityInfo {\n");
        sb.append("    capabilities: ").append(this.toIndentedString(this.capabilities)).append("\n");
        sb.append("    entityAssociations: ").append(this.toIndentedString(this.entityAssociations)).append("\n");
        sb.append("    individual: ").append(this.toIndentedString(this.individual)).append("\n");
        sb.append("    organization: ").append(this.toIndentedString(this.organization)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    soleProprietorship: ").append(this.toIndentedString(this.soleProprietorship)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in LegalEntityInfo is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `LegalEntityInfo` properties.", entry.getKey()));
        }
        JsonArray jsonArrayentityAssociations = jsonObj.getAsJsonArray(SERIALIZED_NAME_ENTITY_ASSOCIATIONS);
        if (jsonArrayentityAssociations != null) {
            if (!jsonObj.get(SERIALIZED_NAME_ENTITY_ASSOCIATIONS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `entityAssociations` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ENTITY_ASSOCIATIONS).toString()));
            }
            for (int i = 0; i < jsonArrayentityAssociations.size(); ++i) {
                LegalEntityAssociation.validateJsonObject(jsonArrayentityAssociations.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_INDIVIDUAL) != null) {
            Individual.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_INDIVIDUAL));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_ORGANIZATION) != null) {
            Organization.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_ORGANIZATION));
        }
        if (jsonObj.get(SERIALIZED_NAME_REFERENCE) != null && !jsonObj.get(SERIALIZED_NAME_REFERENCE).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `reference` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REFERENCE).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_SOLE_PROPRIETORSHIP) != null) {
            SoleProprietorship.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_SOLE_PROPRIETORSHIP));
        }
        if (jsonObj.get(SERIALIZED_NAME_TYPE) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_TYPE).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TYPE).toString()));
            }
            TypeEnum.fromValue(jsonObj.get(SERIALIZED_NAME_TYPE).getAsString());
        }
    }

    public static LegalEntityInfo fromJson(String jsonString) throws IOException {
        return (LegalEntityInfo)JSON.getGson().fromJson(jsonString, LegalEntityInfo.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_CAPABILITIES);
        openapiFields.add(SERIALIZED_NAME_ENTITY_ASSOCIATIONS);
        openapiFields.add(SERIALIZED_NAME_INDIVIDUAL);
        openapiFields.add(SERIALIZED_NAME_ORGANIZATION);
        openapiFields.add(SERIALIZED_NAME_REFERENCE);
        openapiFields.add(SERIALIZED_NAME_SOLE_PROPRIETORSHIP);
        openapiFields.add(SERIALIZED_NAME_TYPE);
        openapiRequiredFields = new HashSet();
        log = Logger.getLogger(LegalEntityInfo.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!LegalEntityInfo.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(LegalEntityInfo.class));
            return new TypeAdapter<LegalEntityInfo>(){

                public void write(JsonWriter out, LegalEntityInfo value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public LegalEntityInfo read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    LegalEntityInfo.validateJsonObject(jsonObj);
                    return (LegalEntityInfo)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        INDIVIDUAL("individual"),
        ORGANIZATION("organization"),
        SOLEPROPRIETORSHIP("soleProprietorship"),
        TRUST("trust"),
        UNINCORPORATEDPARTNERSHIP("unincorporatedPartnership");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(value);
            }
        }
    }
}

