/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.configurationwebhooks;

import com.adyen.model.configurationwebhooks.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PersonalData {
    public static final String SERIALIZED_NAME_DATE_OF_BIRTH = "dateOfBirth";
    @SerializedName(value="dateOfBirth")
    private String dateOfBirth;
    public static final String SERIALIZED_NAME_ID_NUMBER = "idNumber";
    @SerializedName(value="idNumber")
    private String idNumber;
    public static final String SERIALIZED_NAME_NATIONALITY = "nationality";
    @SerializedName(value="nationality")
    private String nationality;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public PersonalData dateOfBirth(String dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
        return this;
    }

    @ApiModelProperty(value="The date of birth of the person. The date should be in ISO-8601 format yyyy-mm-dd (e.g. 2000-01-31).")
    public String getDateOfBirth() {
        return this.dateOfBirth;
    }

    public void setDateOfBirth(String dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
    }

    public PersonalData idNumber(String idNumber) {
        this.idNumber = idNumber;
        return this;
    }

    @ApiModelProperty(value="An ID number of the person.")
    public String getIdNumber() {
        return this.idNumber;
    }

    public void setIdNumber(String idNumber) {
        this.idNumber = idNumber;
    }

    public PersonalData nationality(String nationality) {
        this.nationality = nationality;
        return this;
    }

    @ApiModelProperty(value="The nationality of the person represented by a two-character country code. >The permitted country codes are defined in ISO-3166-1 alpha-2 (e.g. 'NL').")
    public String getNationality() {
        return this.nationality;
    }

    public void setNationality(String nationality) {
        this.nationality = nationality;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PersonalData personalData = (PersonalData)o;
        return Objects.equals(this.dateOfBirth, personalData.dateOfBirth) && Objects.equals(this.idNumber, personalData.idNumber) && Objects.equals(this.nationality, personalData.nationality);
    }

    public int hashCode() {
        return Objects.hash(this.dateOfBirth, this.idNumber, this.nationality);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PersonalData {\n");
        sb.append("    dateOfBirth: ").append(this.toIndentedString(this.dateOfBirth)).append("\n");
        sb.append("    idNumber: ").append(this.toIndentedString(this.idNumber)).append("\n");
        sb.append("    nationality: ").append(this.toIndentedString(this.nationality)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in PersonalData is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `PersonalData` properties.", entry.getKey()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DATE_OF_BIRTH) != null && !jsonObj.get(SERIALIZED_NAME_DATE_OF_BIRTH).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `dateOfBirth` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DATE_OF_BIRTH).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ID_NUMBER) != null && !jsonObj.get(SERIALIZED_NAME_ID_NUMBER).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `idNumber` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID_NUMBER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NATIONALITY) != null && !jsonObj.get(SERIALIZED_NAME_NATIONALITY).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `nationality` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NATIONALITY).toString()));
        }
    }

    public static PersonalData fromJson(String jsonString) throws IOException {
        return (PersonalData)JSON.getGson().fromJson(jsonString, PersonalData.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_DATE_OF_BIRTH);
        openapiFields.add(SERIALIZED_NAME_ID_NUMBER);
        openapiFields.add(SERIALIZED_NAME_NATIONALITY);
        openapiRequiredFields = new HashSet();
        log = Logger.getLogger(PersonalData.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!PersonalData.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(PersonalData.class));
            return new TypeAdapter<PersonalData>(){

                public void write(JsonWriter out, PersonalData value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public PersonalData read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    PersonalData.validateJsonObject(jsonObj);
                    return (PersonalData)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

