/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.configurationwebhooks;

import com.adyen.model.configurationwebhooks.Address;
import com.adyen.model.configurationwebhooks.JSON;
import com.adyen.model.configurationwebhooks.Name;
import com.adyen.model.configurationwebhooks.PersonalData;
import com.adyen.model.configurationwebhooks.PhoneNumber;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Contact {
    public static final String SERIALIZED_NAME_ADDRESS = "address";
    @SerializedName(value="address")
    private Address address;
    public static final String SERIALIZED_NAME_EMAIL = "email";
    @SerializedName(value="email")
    private String email;
    public static final String SERIALIZED_NAME_FULL_PHONE_NUMBER = "fullPhoneNumber";
    @SerializedName(value="fullPhoneNumber")
    private String fullPhoneNumber;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private Name name;
    public static final String SERIALIZED_NAME_PERSONAL_DATA = "personalData";
    @SerializedName(value="personalData")
    private PersonalData personalData;
    public static final String SERIALIZED_NAME_PHONE_NUMBER = "phoneNumber";
    @SerializedName(value="phoneNumber")
    private PhoneNumber phoneNumber;
    public static final String SERIALIZED_NAME_WEB_ADDRESS = "webAddress";
    @SerializedName(value="webAddress")
    private String webAddress;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public Contact address(Address address) {
        this.address = address;
        return this;
    }

    @ApiModelProperty(value="")
    public Address getAddress() {
        return this.address;
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    public Contact email(String email) {
        this.email = email;
        return this;
    }

    @ApiModelProperty(value="The e-mail address of the contact.")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Contact fullPhoneNumber(String fullPhoneNumber) {
        this.fullPhoneNumber = fullPhoneNumber;
        return this;
    }

    @ApiModelProperty(value="The phone number of the contact provided as a single string.  It will be handled as a landline phone. **Examples:** \"0031 6 11 22 33 44\", \"+316/1122-3344\", \"(0031) 611223344\"")
    public String getFullPhoneNumber() {
        return this.fullPhoneNumber;
    }

    public void setFullPhoneNumber(String fullPhoneNumber) {
        this.fullPhoneNumber = fullPhoneNumber;
    }

    public Contact name(Name name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="")
    public Name getName() {
        return this.name;
    }

    public void setName(Name name) {
        this.name = name;
    }

    public Contact personalData(PersonalData personalData) {
        this.personalData = personalData;
        return this;
    }

    @ApiModelProperty(value="")
    public PersonalData getPersonalData() {
        return this.personalData;
    }

    public void setPersonalData(PersonalData personalData) {
        this.personalData = personalData;
    }

    public Contact phoneNumber(PhoneNumber phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    @ApiModelProperty(value="")
    public PhoneNumber getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(PhoneNumber phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public Contact webAddress(String webAddress) {
        this.webAddress = webAddress;
        return this;
    }

    @ApiModelProperty(value="The URL of the website of the contact.")
    public String getWebAddress() {
        return this.webAddress;
    }

    public void setWebAddress(String webAddress) {
        this.webAddress = webAddress;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Contact contact = (Contact)o;
        return Objects.equals(this.address, contact.address) && Objects.equals(this.email, contact.email) && Objects.equals(this.fullPhoneNumber, contact.fullPhoneNumber) && Objects.equals(this.name, contact.name) && Objects.equals(this.personalData, contact.personalData) && Objects.equals(this.phoneNumber, contact.phoneNumber) && Objects.equals(this.webAddress, contact.webAddress);
    }

    public int hashCode() {
        return Objects.hash(this.address, this.email, this.fullPhoneNumber, this.name, this.personalData, this.phoneNumber, this.webAddress);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Contact {\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    fullPhoneNumber: ").append(this.toIndentedString(this.fullPhoneNumber)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    personalData: ").append(this.toIndentedString(this.personalData)).append("\n");
        sb.append("    phoneNumber: ").append(this.toIndentedString(this.phoneNumber)).append("\n");
        sb.append("    webAddress: ").append(this.toIndentedString(this.webAddress)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in Contact is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `Contact` properties.", entry.getKey()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_ADDRESS) != null) {
            Address.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_ADDRESS));
        }
        if (jsonObj.get(SERIALIZED_NAME_EMAIL) != null && !jsonObj.get(SERIALIZED_NAME_EMAIL).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `email` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_EMAIL).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_FULL_PHONE_NUMBER) != null && !jsonObj.get(SERIALIZED_NAME_FULL_PHONE_NUMBER).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `fullPhoneNumber` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FULL_PHONE_NUMBER).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_NAME) != null) {
            Name.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_NAME));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_PERSONAL_DATA) != null) {
            PersonalData.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_PERSONAL_DATA));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_PHONE_NUMBER) != null) {
            PhoneNumber.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_PHONE_NUMBER));
        }
        if (jsonObj.get(SERIALIZED_NAME_WEB_ADDRESS) != null && !jsonObj.get(SERIALIZED_NAME_WEB_ADDRESS).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `webAddress` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_WEB_ADDRESS).toString()));
        }
    }

    public static Contact fromJson(String jsonString) throws IOException {
        return (Contact)JSON.getGson().fromJson(jsonString, Contact.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ADDRESS);
        openapiFields.add(SERIALIZED_NAME_EMAIL);
        openapiFields.add(SERIALIZED_NAME_FULL_PHONE_NUMBER);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_PERSONAL_DATA);
        openapiFields.add(SERIALIZED_NAME_PHONE_NUMBER);
        openapiFields.add(SERIALIZED_NAME_WEB_ADDRESS);
        openapiRequiredFields = new HashSet();
        log = Logger.getLogger(Contact.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!Contact.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(Contact.class));
            return new TypeAdapter<Contact>(){

                public void write(JsonWriter out, Contact value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public Contact read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    Contact.validateJsonObject(jsonObj);
                    return (Contact)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

