/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.configurationwebhooks;

import com.adyen.model.configurationwebhooks.CardOrderItemDeliveryStatus;
import com.adyen.model.configurationwebhooks.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CardOrderItem {
    public static final String SERIALIZED_NAME_BALANCE_PLATFORM = "balancePlatform";
    @SerializedName(value="balancePlatform")
    private String balancePlatform;
    public static final String SERIALIZED_NAME_CARD = "card";
    @SerializedName(value="card")
    private CardOrderItemDeliveryStatus card;
    public static final String SERIALIZED_NAME_CARD_ORDER_ITEM_REFERENCE = "cardOrderItemReference";
    @SerializedName(value="cardOrderItemReference")
    private String cardOrderItemReference;
    public static final String SERIALIZED_NAME_CREATION_DATE = "creationDate";
    @SerializedName(value="creationDate")
    private OffsetDateTime creationDate;
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_PAYMENT_INSTRUMENT_REFERENCE = "paymentInstrumentReference";
    @SerializedName(value="paymentInstrumentReference")
    private String paymentInstrumentReference;
    public static final String SERIALIZED_NAME_PIN = "pin";
    @SerializedName(value="pin")
    private CardOrderItemDeliveryStatus pin;
    public static final String SERIALIZED_NAME_SHIPPING_METHOD = "shippingMethod";
    @SerializedName(value="shippingMethod")
    private String shippingMethod;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public CardOrderItem balancePlatform(String balancePlatform) {
        this.balancePlatform = balancePlatform;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the balance platform.")
    public String getBalancePlatform() {
        return this.balancePlatform;
    }

    public void setBalancePlatform(String balancePlatform) {
        this.balancePlatform = balancePlatform;
    }

    public CardOrderItem card(CardOrderItemDeliveryStatus card) {
        this.card = card;
        return this;
    }

    @ApiModelProperty(value="")
    public CardOrderItemDeliveryStatus getCard() {
        return this.card;
    }

    public void setCard(CardOrderItemDeliveryStatus card) {
        this.card = card;
    }

    public CardOrderItem cardOrderItemReference(String cardOrderItemReference) {
        this.cardOrderItemReference = cardOrderItemReference;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the card order.")
    public String getCardOrderItemReference() {
        return this.cardOrderItemReference;
    }

    public void setCardOrderItemReference(String cardOrderItemReference) {
        this.cardOrderItemReference = cardOrderItemReference;
    }

    public CardOrderItem creationDate(OffsetDateTime creationDate) {
        this.creationDate = creationDate;
        return this;
    }

    @ApiModelProperty(value="The date and time when the event was triggered, in ISO 8601 extended format. For example, **2020-12-18T10:15:30+01:00**.")
    public OffsetDateTime getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(OffsetDateTime creationDate) {
        this.creationDate = creationDate;
    }

    public CardOrderItem id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="The ID of the resource.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public CardOrderItem paymentInstrumentReference(String paymentInstrumentReference) {
        this.paymentInstrumentReference = paymentInstrumentReference;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the payment instrument related to the card order.")
    public String getPaymentInstrumentReference() {
        return this.paymentInstrumentReference;
    }

    public void setPaymentInstrumentReference(String paymentInstrumentReference) {
        this.paymentInstrumentReference = paymentInstrumentReference;
    }

    public CardOrderItem pin(CardOrderItemDeliveryStatus pin) {
        this.pin = pin;
        return this;
    }

    @ApiModelProperty(value="")
    public CardOrderItemDeliveryStatus getPin() {
        return this.pin;
    }

    public void setPin(CardOrderItemDeliveryStatus pin) {
        this.pin = pin;
    }

    public CardOrderItem shippingMethod(String shippingMethod) {
        this.shippingMethod = shippingMethod;
        return this;
    }

    @ApiModelProperty(value="Shipping method used to deliver the card or the PIN.")
    public String getShippingMethod() {
        return this.shippingMethod;
    }

    public void setShippingMethod(String shippingMethod) {
        this.shippingMethod = shippingMethod;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CardOrderItem cardOrderItem = (CardOrderItem)o;
        return Objects.equals(this.balancePlatform, cardOrderItem.balancePlatform) && Objects.equals(this.card, cardOrderItem.card) && Objects.equals(this.cardOrderItemReference, cardOrderItem.cardOrderItemReference) && Objects.equals(this.creationDate, cardOrderItem.creationDate) && Objects.equals(this.id, cardOrderItem.id) && Objects.equals(this.paymentInstrumentReference, cardOrderItem.paymentInstrumentReference) && Objects.equals(this.pin, cardOrderItem.pin) && Objects.equals(this.shippingMethod, cardOrderItem.shippingMethod);
    }

    public int hashCode() {
        return Objects.hash(this.balancePlatform, this.card, this.cardOrderItemReference, this.creationDate, this.id, this.paymentInstrumentReference, this.pin, this.shippingMethod);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CardOrderItem {\n");
        sb.append("    balancePlatform: ").append(this.toIndentedString(this.balancePlatform)).append("\n");
        sb.append("    card: ").append(this.toIndentedString(this.card)).append("\n");
        sb.append("    cardOrderItemReference: ").append(this.toIndentedString(this.cardOrderItemReference)).append("\n");
        sb.append("    creationDate: ").append(this.toIndentedString(this.creationDate)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    paymentInstrumentReference: ").append(this.toIndentedString(this.paymentInstrumentReference)).append("\n");
        sb.append("    pin: ").append(this.toIndentedString(this.pin)).append("\n");
        sb.append("    shippingMethod: ").append(this.toIndentedString(this.shippingMethod)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in CardOrderItem is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `CardOrderItem` properties.", entry.getKey()));
        }
        if (jsonObj.get(SERIALIZED_NAME_BALANCE_PLATFORM) != null && !jsonObj.get(SERIALIZED_NAME_BALANCE_PLATFORM).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `balancePlatform` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BALANCE_PLATFORM).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_CARD) != null) {
            CardOrderItemDeliveryStatus.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_CARD));
        }
        if (jsonObj.get(SERIALIZED_NAME_CARD_ORDER_ITEM_REFERENCE) != null && !jsonObj.get(SERIALIZED_NAME_CARD_ORDER_ITEM_REFERENCE).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `cardOrderItemReference` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CARD_ORDER_ITEM_REFERENCE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PAYMENT_INSTRUMENT_REFERENCE) != null && !jsonObj.get(SERIALIZED_NAME_PAYMENT_INSTRUMENT_REFERENCE).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `paymentInstrumentReference` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PAYMENT_INSTRUMENT_REFERENCE).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_PIN) != null) {
            CardOrderItemDeliveryStatus.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_PIN));
        }
        if (jsonObj.get(SERIALIZED_NAME_SHIPPING_METHOD) != null && !jsonObj.get(SERIALIZED_NAME_SHIPPING_METHOD).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `shippingMethod` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SHIPPING_METHOD).toString()));
        }
    }

    public static CardOrderItem fromJson(String jsonString) throws IOException {
        return (CardOrderItem)JSON.getGson().fromJson(jsonString, CardOrderItem.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_BALANCE_PLATFORM);
        openapiFields.add(SERIALIZED_NAME_CARD);
        openapiFields.add(SERIALIZED_NAME_CARD_ORDER_ITEM_REFERENCE);
        openapiFields.add(SERIALIZED_NAME_CREATION_DATE);
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_PAYMENT_INSTRUMENT_REFERENCE);
        openapiFields.add(SERIALIZED_NAME_PIN);
        openapiFields.add(SERIALIZED_NAME_SHIPPING_METHOD);
        openapiRequiredFields = new HashSet();
        log = Logger.getLogger(CardOrderItem.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!CardOrderItem.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(CardOrderItem.class));
            return new TypeAdapter<CardOrderItem>(){

                public void write(JsonWriter out, CardOrderItem value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public CardOrderItem read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    CardOrderItem.validateJsonObject(jsonObj);
                    return (CardOrderItem)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

