/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ResponsePaymentMethod {
    public static final String SERIALIZED_NAME_BRAND = "brand";
    @SerializedName(value="brand")
    private String brand;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private String type;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public ResponsePaymentMethod brand(String brand) {
        this.brand = brand;
        return this;
    }

    @ApiModelProperty(value="The card brand that the shopper used to pay. Only returned if `paymentMethod.type` is **scheme**.")
    public String getBrand() {
        return this.brand;
    }

    public void setBrand(String brand) {
        this.brand = brand;
    }

    public ResponsePaymentMethod type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="The `paymentMethod.type` value used in the request.")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResponsePaymentMethod responsePaymentMethod = (ResponsePaymentMethod)o;
        return Objects.equals(this.brand, responsePaymentMethod.brand) && Objects.equals(this.type, responsePaymentMethod.type);
    }

    public int hashCode() {
        return Objects.hash(this.brand, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ResponsePaymentMethod {\n");
        sb.append("    brand: ").append(this.toIndentedString(this.brand)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in ResponsePaymentMethod is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `ResponsePaymentMethod` properties.", entry.getKey()));
        }
        if (jsonObj.get(SERIALIZED_NAME_BRAND) != null && !jsonObj.get(SERIALIZED_NAME_BRAND).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `brand` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BRAND).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_TYPE).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TYPE).toString()));
        }
    }

    public static ResponsePaymentMethod fromJson(String jsonString) throws IOException {
        return (ResponsePaymentMethod)JSON.getGson().fromJson(jsonString, ResponsePaymentMethod.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_BRAND);
        openapiFields.add(SERIALIZED_NAME_TYPE);
        openapiRequiredFields = new HashSet();
        log = Logger.getLogger(ResponsePaymentMethod.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!ResponsePaymentMethod.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(ResponsePaymentMethod.class));
            return new TypeAdapter<ResponsePaymentMethod>(){

                public void write(JsonWriter out, ResponsePaymentMethod value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public ResponsePaymentMethod read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    ResponsePaymentMethod.validateJsonObject(jsonObj);
                    return (ResponsePaymentMethod)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

