/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.AccountInfo;
import com.adyen.model.checkout.Address;
import com.adyen.model.checkout.Amount;
import com.adyen.model.checkout.ApplicationInfo;
import com.adyen.model.checkout.AuthenticationData;
import com.adyen.model.checkout.BrowserInfo;
import com.adyen.model.checkout.CheckoutPaymentMethod;
import com.adyen.model.checkout.Company;
import com.adyen.model.checkout.EncryptedOrderData;
import com.adyen.model.checkout.ForexQuote;
import com.adyen.model.checkout.Installments;
import com.adyen.model.checkout.JSON;
import com.adyen.model.checkout.LineItem;
import com.adyen.model.checkout.Mandate;
import com.adyen.model.checkout.MerchantRiskIndicator;
import com.adyen.model.checkout.Name;
import com.adyen.model.checkout.PlatformChargebackLogic;
import com.adyen.model.checkout.RiskData;
import com.adyen.model.checkout.Split;
import com.adyen.model.checkout.ThreeDS2RequestData;
import com.adyen.model.checkout.ThreeDSecureData;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PaymentRequest {
    public static final String SERIALIZED_NAME_ACCOUNT_INFO = "accountInfo";
    @SerializedName(value="accountInfo")
    private AccountInfo accountInfo;
    public static final String SERIALIZED_NAME_ADDITIONAL_AMOUNT = "additionalAmount";
    @SerializedName(value="additionalAmount")
    private Amount additionalAmount;
    public static final String SERIALIZED_NAME_ADDITIONAL_DATA = "additionalData";
    @SerializedName(value="additionalData")
    private Map<String, String> additionalData = null;
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private Amount amount;
    public static final String SERIALIZED_NAME_APPLICATION_INFO = "applicationInfo";
    @SerializedName(value="applicationInfo")
    private ApplicationInfo applicationInfo;
    public static final String SERIALIZED_NAME_AUTHENTICATION_DATA = "authenticationData";
    @SerializedName(value="authenticationData")
    private AuthenticationData authenticationData;
    public static final String SERIALIZED_NAME_BILLING_ADDRESS = "billingAddress";
    @SerializedName(value="billingAddress")
    private Address billingAddress;
    public static final String SERIALIZED_NAME_BROWSER_INFO = "browserInfo";
    @SerializedName(value="browserInfo")
    private BrowserInfo browserInfo;
    public static final String SERIALIZED_NAME_CAPTURE_DELAY_HOURS = "captureDelayHours";
    @SerializedName(value="captureDelayHours")
    private Integer captureDelayHours;
    public static final String SERIALIZED_NAME_CHANNEL = "channel";
    @SerializedName(value="channel")
    private ChannelEnum channel;
    public static final String SERIALIZED_NAME_CHECKOUT_ATTEMPT_ID = "checkoutAttemptId";
    @SerializedName(value="checkoutAttemptId")
    private String checkoutAttemptId;
    public static final String SERIALIZED_NAME_COMPANY = "company";
    @SerializedName(value="company")
    private Company company;
    public static final String SERIALIZED_NAME_CONVERSION_ID = "conversionId";
    @Deprecated
    @SerializedName(value="conversionId")
    private String conversionId;
    public static final String SERIALIZED_NAME_COUNTRY_CODE = "countryCode";
    @SerializedName(value="countryCode")
    private String countryCode;
    public static final String SERIALIZED_NAME_DATE_OF_BIRTH = "dateOfBirth";
    @SerializedName(value="dateOfBirth")
    private LocalDate dateOfBirth;
    public static final String SERIALIZED_NAME_DCC_QUOTE = "dccQuote";
    @SerializedName(value="dccQuote")
    private ForexQuote dccQuote;
    public static final String SERIALIZED_NAME_DELIVERY_ADDRESS = "deliveryAddress";
    @SerializedName(value="deliveryAddress")
    private Address deliveryAddress;
    public static final String SERIALIZED_NAME_DELIVERY_DATE = "deliveryDate";
    @SerializedName(value="deliveryDate")
    private OffsetDateTime deliveryDate;
    public static final String SERIALIZED_NAME_DEVICE_FINGERPRINT = "deviceFingerprint";
    @SerializedName(value="deviceFingerprint")
    private String deviceFingerprint;
    public static final String SERIALIZED_NAME_ENABLE_ONE_CLICK = "enableOneClick";
    @SerializedName(value="enableOneClick")
    private Boolean enableOneClick;
    public static final String SERIALIZED_NAME_ENABLE_PAY_OUT = "enablePayOut";
    @SerializedName(value="enablePayOut")
    private Boolean enablePayOut;
    public static final String SERIALIZED_NAME_ENABLE_RECURRING = "enableRecurring";
    @SerializedName(value="enableRecurring")
    private Boolean enableRecurring;
    public static final String SERIALIZED_NAME_ENTITY_TYPE = "entityType";
    @SerializedName(value="entityType")
    private EntityTypeEnum entityType;
    public static final String SERIALIZED_NAME_FRAUD_OFFSET = "fraudOffset";
    @SerializedName(value="fraudOffset")
    private Integer fraudOffset;
    public static final String SERIALIZED_NAME_INDUSTRY_USAGE = "industryUsage";
    @SerializedName(value="industryUsage")
    private IndustryUsageEnum industryUsage;
    public static final String SERIALIZED_NAME_INSTALLMENTS = "installments";
    @SerializedName(value="installments")
    private Installments installments;
    public static final String SERIALIZED_NAME_LINE_ITEMS = "lineItems";
    @SerializedName(value="lineItems")
    private List<LineItem> lineItems = null;
    public static final String SERIALIZED_NAME_LOCALIZED_SHOPPER_STATEMENT = "localizedShopperStatement";
    @SerializedName(value="localizedShopperStatement")
    private Map<String, String> localizedShopperStatement = null;
    public static final String SERIALIZED_NAME_MANDATE = "mandate";
    @SerializedName(value="mandate")
    private Mandate mandate;
    public static final String SERIALIZED_NAME_MCC = "mcc";
    @SerializedName(value="mcc")
    private String mcc;
    public static final String SERIALIZED_NAME_MERCHANT_ACCOUNT = "merchantAccount";
    @SerializedName(value="merchantAccount")
    private String merchantAccount;
    public static final String SERIALIZED_NAME_MERCHANT_ORDER_REFERENCE = "merchantOrderReference";
    @SerializedName(value="merchantOrderReference")
    private String merchantOrderReference;
    public static final String SERIALIZED_NAME_MERCHANT_RISK_INDICATOR = "merchantRiskIndicator";
    @SerializedName(value="merchantRiskIndicator")
    private MerchantRiskIndicator merchantRiskIndicator;
    public static final String SERIALIZED_NAME_METADATA = "metadata";
    @SerializedName(value="metadata")
    private Map<String, String> metadata = null;
    public static final String SERIALIZED_NAME_MPI_DATA = "mpiData";
    @SerializedName(value="mpiData")
    private ThreeDSecureData mpiData;
    public static final String SERIALIZED_NAME_ORDER = "order";
    @SerializedName(value="order")
    private EncryptedOrderData order;
    public static final String SERIALIZED_NAME_ORDER_REFERENCE = "orderReference";
    @SerializedName(value="orderReference")
    private String orderReference;
    public static final String SERIALIZED_NAME_ORIGIN = "origin";
    @SerializedName(value="origin")
    private String origin;
    public static final String SERIALIZED_NAME_PAYMENT_METHOD = "paymentMethod";
    @SerializedName(value="paymentMethod")
    private CheckoutPaymentMethod paymentMethod;
    public static final String SERIALIZED_NAME_PLATFORM_CHARGEBACK_LOGIC = "platformChargebackLogic";
    @SerializedName(value="platformChargebackLogic")
    private PlatformChargebackLogic platformChargebackLogic;
    public static final String SERIALIZED_NAME_RECURRING_EXPIRY = "recurringExpiry";
    @SerializedName(value="recurringExpiry")
    private String recurringExpiry;
    public static final String SERIALIZED_NAME_RECURRING_FREQUENCY = "recurringFrequency";
    @SerializedName(value="recurringFrequency")
    private String recurringFrequency;
    public static final String SERIALIZED_NAME_RECURRING_PROCESSING_MODEL = "recurringProcessingModel";
    @SerializedName(value="recurringProcessingModel")
    private RecurringProcessingModelEnum recurringProcessingModel;
    public static final String SERIALIZED_NAME_REDIRECT_FROM_ISSUER_METHOD = "redirectFromIssuerMethod";
    @SerializedName(value="redirectFromIssuerMethod")
    private String redirectFromIssuerMethod;
    public static final String SERIALIZED_NAME_REDIRECT_TO_ISSUER_METHOD = "redirectToIssuerMethod";
    @SerializedName(value="redirectToIssuerMethod")
    private String redirectToIssuerMethod;
    public static final String SERIALIZED_NAME_REFERENCE = "reference";
    @SerializedName(value="reference")
    private String reference;
    public static final String SERIALIZED_NAME_RETURN_URL = "returnUrl";
    @SerializedName(value="returnUrl")
    private String returnUrl;
    public static final String SERIALIZED_NAME_RISK_DATA = "riskData";
    @SerializedName(value="riskData")
    private RiskData riskData;
    public static final String SERIALIZED_NAME_SESSION_VALIDITY = "sessionValidity";
    @SerializedName(value="sessionValidity")
    private String sessionValidity;
    public static final String SERIALIZED_NAME_SHOPPER_EMAIL = "shopperEmail";
    @SerializedName(value="shopperEmail")
    private String shopperEmail;
    public static final String SERIALIZED_NAME_SHOPPER_I_P = "shopperIP";
    @SerializedName(value="shopperIP")
    private String shopperIP;
    public static final String SERIALIZED_NAME_SHOPPER_INTERACTION = "shopperInteraction";
    @SerializedName(value="shopperInteraction")
    private ShopperInteractionEnum shopperInteraction;
    public static final String SERIALIZED_NAME_SHOPPER_LOCALE = "shopperLocale";
    @SerializedName(value="shopperLocale")
    private String shopperLocale;
    public static final String SERIALIZED_NAME_SHOPPER_NAME = "shopperName";
    @SerializedName(value="shopperName")
    private Name shopperName;
    public static final String SERIALIZED_NAME_SHOPPER_REFERENCE = "shopperReference";
    @SerializedName(value="shopperReference")
    private String shopperReference;
    public static final String SERIALIZED_NAME_SHOPPER_STATEMENT = "shopperStatement";
    @SerializedName(value="shopperStatement")
    private String shopperStatement;
    public static final String SERIALIZED_NAME_SOCIAL_SECURITY_NUMBER = "socialSecurityNumber";
    @SerializedName(value="socialSecurityNumber")
    private String socialSecurityNumber;
    public static final String SERIALIZED_NAME_SPLITS = "splits";
    @SerializedName(value="splits")
    private List<Split> splits = null;
    public static final String SERIALIZED_NAME_STORE = "store";
    @SerializedName(value="store")
    private String store;
    public static final String SERIALIZED_NAME_STORE_PAYMENT_METHOD = "storePaymentMethod";
    @SerializedName(value="storePaymentMethod")
    private Boolean storePaymentMethod;
    public static final String SERIALIZED_NAME_TELEPHONE_NUMBER = "telephoneNumber";
    @SerializedName(value="telephoneNumber")
    private String telephoneNumber;
    public static final String SERIALIZED_NAME_THREE_D_S2_REQUEST_DATA = "threeDS2RequestData";
    @SerializedName(value="threeDS2RequestData")
    private ThreeDS2RequestData threeDS2RequestData;
    public static final String SERIALIZED_NAME_THREE_D_S_AUTHENTICATION_ONLY = "threeDSAuthenticationOnly";
    @Deprecated
    @SerializedName(value="threeDSAuthenticationOnly")
    private Boolean threeDSAuthenticationOnly = false;
    public static final String SERIALIZED_NAME_TRUSTED_SHOPPER = "trustedShopper";
    @SerializedName(value="trustedShopper")
    private Boolean trustedShopper;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public PaymentRequest accountInfo(AccountInfo accountInfo) {
        this.accountInfo = accountInfo;
        return this;
    }

    @ApiModelProperty(value="")
    public AccountInfo getAccountInfo() {
        return this.accountInfo;
    }

    public void setAccountInfo(AccountInfo accountInfo) {
        this.accountInfo = accountInfo;
    }

    public PaymentRequest additionalAmount(Amount additionalAmount) {
        this.additionalAmount = additionalAmount;
        return this;
    }

    @ApiModelProperty(value="")
    public Amount getAdditionalAmount() {
        return this.additionalAmount;
    }

    public void setAdditionalAmount(Amount additionalAmount) {
        this.additionalAmount = additionalAmount;
    }

    public PaymentRequest additionalData(Map<String, String> additionalData) {
        this.additionalData = additionalData;
        return this;
    }

    public PaymentRequest putAdditionalDataItem(String key, String additionalDataItem) {
        if (this.additionalData == null) {
            this.additionalData = new HashMap<String, String>();
        }
        this.additionalData.put(key, additionalDataItem);
        return this;
    }

    @ApiModelProperty(value="This field contains additional data, which may be required for a particular payment request.  The `additionalData` object consists of entries, each of which includes the key and value.")
    public Map<String, String> getAdditionalData() {
        return this.additionalData;
    }

    public void setAdditionalData(Map<String, String> additionalData) {
        this.additionalData = additionalData;
    }

    public PaymentRequest amount(Amount amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Amount getAmount() {
        return this.amount;
    }

    public void setAmount(Amount amount) {
        this.amount = amount;
    }

    public PaymentRequest applicationInfo(ApplicationInfo applicationInfo) {
        this.applicationInfo = applicationInfo;
        return this;
    }

    @ApiModelProperty(value="")
    public ApplicationInfo getApplicationInfo() {
        return this.applicationInfo;
    }

    public void setApplicationInfo(ApplicationInfo applicationInfo) {
        this.applicationInfo = applicationInfo;
    }

    public PaymentRequest authenticationData(AuthenticationData authenticationData) {
        this.authenticationData = authenticationData;
        return this;
    }

    @ApiModelProperty(value="")
    public AuthenticationData getAuthenticationData() {
        return this.authenticationData;
    }

    public void setAuthenticationData(AuthenticationData authenticationData) {
        this.authenticationData = authenticationData;
    }

    public PaymentRequest billingAddress(Address billingAddress) {
        this.billingAddress = billingAddress;
        return this;
    }

    @ApiModelProperty(value="")
    public Address getBillingAddress() {
        return this.billingAddress;
    }

    public void setBillingAddress(Address billingAddress) {
        this.billingAddress = billingAddress;
    }

    public PaymentRequest browserInfo(BrowserInfo browserInfo) {
        this.browserInfo = browserInfo;
        return this;
    }

    @ApiModelProperty(value="")
    public BrowserInfo getBrowserInfo() {
        return this.browserInfo;
    }

    public void setBrowserInfo(BrowserInfo browserInfo) {
        this.browserInfo = browserInfo;
    }

    public PaymentRequest captureDelayHours(Integer captureDelayHours) {
        this.captureDelayHours = captureDelayHours;
        return this;
    }

    @ApiModelProperty(value="The delay between the authorisation and scheduled auto-capture, specified in hours.")
    public Integer getCaptureDelayHours() {
        return this.captureDelayHours;
    }

    public void setCaptureDelayHours(Integer captureDelayHours) {
        this.captureDelayHours = captureDelayHours;
    }

    public PaymentRequest channel(ChannelEnum channel) {
        this.channel = channel;
        return this;
    }

    @ApiModelProperty(value="The platform where a payment transaction takes place. This field is optional for filtering out payment methods that are only available on specific platforms. If this value is not set, then we will try to infer it from the `sdkVersion` or `token`.  Possible values: * iOS * Android * Web")
    public ChannelEnum getChannel() {
        return this.channel;
    }

    public void setChannel(ChannelEnum channel) {
        this.channel = channel;
    }

    public PaymentRequest checkoutAttemptId(String checkoutAttemptId) {
        this.checkoutAttemptId = checkoutAttemptId;
        return this;
    }

    @ApiModelProperty(value="Checkout attempt ID that corresponds to the Id generated by the client SDK for tracking user payment journey.")
    public String getCheckoutAttemptId() {
        return this.checkoutAttemptId;
    }

    public void setCheckoutAttemptId(String checkoutAttemptId) {
        this.checkoutAttemptId = checkoutAttemptId;
    }

    public PaymentRequest company(Company company) {
        this.company = company;
        return this;
    }

    @ApiModelProperty(value="")
    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    @Deprecated
    public PaymentRequest conversionId(String conversionId) {
        this.conversionId = conversionId;
        return this;
    }

    @Deprecated
    @ApiModelProperty(value="Conversion ID that corresponds to the Id generated by the client SDK for tracking user payment journey.")
    public String getConversionId() {
        return this.conversionId;
    }

    @Deprecated
    public void setConversionId(String conversionId) {
        this.conversionId = conversionId;
    }

    public PaymentRequest countryCode(String countryCode) {
        this.countryCode = countryCode;
        return this;
    }

    @ApiModelProperty(value="The shopper country.  Format: [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) Example: NL or DE")
    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public PaymentRequest dateOfBirth(LocalDate dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
        return this;
    }

    @ApiModelProperty(value="The shopper's date of birth.  Format [ISO-8601](https://www.w3.org/TR/NOTE-datetime): YYYY-MM-DD")
    public LocalDate getDateOfBirth() {
        return this.dateOfBirth;
    }

    public void setDateOfBirth(LocalDate dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
    }

    public PaymentRequest dccQuote(ForexQuote dccQuote) {
        this.dccQuote = dccQuote;
        return this;
    }

    @ApiModelProperty(value="")
    public ForexQuote getDccQuote() {
        return this.dccQuote;
    }

    public void setDccQuote(ForexQuote dccQuote) {
        this.dccQuote = dccQuote;
    }

    public PaymentRequest deliveryAddress(Address deliveryAddress) {
        this.deliveryAddress = deliveryAddress;
        return this;
    }

    @ApiModelProperty(value="")
    public Address getDeliveryAddress() {
        return this.deliveryAddress;
    }

    public void setDeliveryAddress(Address deliveryAddress) {
        this.deliveryAddress = deliveryAddress;
    }

    public PaymentRequest deliveryDate(OffsetDateTime deliveryDate) {
        this.deliveryDate = deliveryDate;
        return this;
    }

    @ApiModelProperty(value="The date and time the purchased goods should be delivered.  Format [ISO 8601](https://www.w3.org/TR/NOTE-datetime): YYYY-MM-DDThh:mm:ss.sssTZD  Example: 2017-07-17T13:42:40.428+01:00")
    public OffsetDateTime getDeliveryDate() {
        return this.deliveryDate;
    }

    public void setDeliveryDate(OffsetDateTime deliveryDate) {
        this.deliveryDate = deliveryDate;
    }

    public PaymentRequest deviceFingerprint(String deviceFingerprint) {
        this.deviceFingerprint = deviceFingerprint;
        return this;
    }

    @ApiModelProperty(value="A string containing the shopper's device fingerprint. For more information, refer to [Device fingerprinting](https://docs.adyen.com/risk-management/device-fingerprinting).")
    public String getDeviceFingerprint() {
        return this.deviceFingerprint;
    }

    public void setDeviceFingerprint(String deviceFingerprint) {
        this.deviceFingerprint = deviceFingerprint;
    }

    public PaymentRequest enableOneClick(Boolean enableOneClick) {
        this.enableOneClick = enableOneClick;
        return this;
    }

    @ApiModelProperty(value="When true and `shopperReference` is provided, the shopper will be asked if the payment details should be stored for future one-click payments.")
    public Boolean getEnableOneClick() {
        return this.enableOneClick;
    }

    public void setEnableOneClick(Boolean enableOneClick) {
        this.enableOneClick = enableOneClick;
    }

    public PaymentRequest enablePayOut(Boolean enablePayOut) {
        this.enablePayOut = enablePayOut;
        return this;
    }

    @ApiModelProperty(value="When true and `shopperReference` is provided, the payment details will be tokenized for payouts.")
    public Boolean getEnablePayOut() {
        return this.enablePayOut;
    }

    public void setEnablePayOut(Boolean enablePayOut) {
        this.enablePayOut = enablePayOut;
    }

    public PaymentRequest enableRecurring(Boolean enableRecurring) {
        this.enableRecurring = enableRecurring;
        return this;
    }

    @ApiModelProperty(value="When true and `shopperReference` is provided, the payment details will be tokenized for recurring payments.")
    public Boolean getEnableRecurring() {
        return this.enableRecurring;
    }

    public void setEnableRecurring(Boolean enableRecurring) {
        this.enableRecurring = enableRecurring;
    }

    public PaymentRequest entityType(EntityTypeEnum entityType) {
        this.entityType = entityType;
        return this;
    }

    @ApiModelProperty(value="The type of the entity the payment is processed for.")
    public EntityTypeEnum getEntityType() {
        return this.entityType;
    }

    public void setEntityType(EntityTypeEnum entityType) {
        this.entityType = entityType;
    }

    public PaymentRequest fraudOffset(Integer fraudOffset) {
        this.fraudOffset = fraudOffset;
        return this;
    }

    @ApiModelProperty(value="An integer value that is added to the normal fraud score. The value can be either positive or negative.")
    public Integer getFraudOffset() {
        return this.fraudOffset;
    }

    public void setFraudOffset(Integer fraudOffset) {
        this.fraudOffset = fraudOffset;
    }

    public PaymentRequest industryUsage(IndustryUsageEnum industryUsage) {
        this.industryUsage = industryUsage;
        return this;
    }

    @ApiModelProperty(value="The reason for the amount update. Possible values:  * **delayedCharge**  * **noShow**  * **installment**")
    public IndustryUsageEnum getIndustryUsage() {
        return this.industryUsage;
    }

    public void setIndustryUsage(IndustryUsageEnum industryUsage) {
        this.industryUsage = industryUsage;
    }

    public PaymentRequest installments(Installments installments) {
        this.installments = installments;
        return this;
    }

    @ApiModelProperty(value="")
    public Installments getInstallments() {
        return this.installments;
    }

    public void setInstallments(Installments installments) {
        this.installments = installments;
    }

    public PaymentRequest lineItems(List<LineItem> lineItems) {
        this.lineItems = lineItems;
        return this;
    }

    public PaymentRequest addLineItemsItem(LineItem lineItemsItem) {
        if (this.lineItems == null) {
            this.lineItems = new ArrayList<LineItem>();
        }
        this.lineItems.add(lineItemsItem);
        return this;
    }

    @ApiModelProperty(value="Price and product information of the refunded items, required for [partial refunds](https://docs.adyen.com/online-payments/refund#refund-a-payment). > This field is required for partial refunds with 3x 4x Oney, Affirm, Afterpay, Atome, Clearpay, Klarna, Ratepay, Walley, and Zip.")
    public List<LineItem> getLineItems() {
        return this.lineItems;
    }

    public void setLineItems(List<LineItem> lineItems) {
        this.lineItems = lineItems;
    }

    public PaymentRequest localizedShopperStatement(Map<String, String> localizedShopperStatement) {
        this.localizedShopperStatement = localizedShopperStatement;
        return this;
    }

    public PaymentRequest putLocalizedShopperStatementItem(String key, String localizedShopperStatementItem) {
        if (this.localizedShopperStatement == null) {
            this.localizedShopperStatement = new HashMap<String, String>();
        }
        this.localizedShopperStatement.put(key, localizedShopperStatementItem);
        return this;
    }

    @ApiModelProperty(value="This field allows merchants to use dynamic shopper statement in local character sets. The local shopper statement field can be supplied in markets where localized merchant descriptors are used. Currently, Adyen only supports this in the Japanese market .The available character sets at the moment are: * Processing in Japan: **ja-Kana** The character set **ja-Kana** supports UTF-8 based Katakana and alphanumeric and special characters. Merchants can use half-width or full-width characters. An example request would be: > {   \"shopperStatement\" : \"ADYEN - SELLER-A\",   \"localizedShopperStatement\" : {     \"ja-Kana\" : \"ADYEN - \u30bb\u30e9\u30fcA\"   } } We recommend merchants to always supply the field localizedShopperStatement in addition to the field shopperStatement.It is issuer dependent whether the localized shopper statement field is supported. In the case of non-domestic transactions (e.g. US-issued cards processed in JP) the field `shopperStatement` is used to modify the statement of the shopper. Adyen handles the complexity of ensuring the correct descriptors are assigned. Please note, this field can be used for only Visa and Mastercard transactions.")
    public Map<String, String> getLocalizedShopperStatement() {
        return this.localizedShopperStatement;
    }

    public void setLocalizedShopperStatement(Map<String, String> localizedShopperStatement) {
        this.localizedShopperStatement = localizedShopperStatement;
    }

    public PaymentRequest mandate(Mandate mandate) {
        this.mandate = mandate;
        return this;
    }

    @ApiModelProperty(value="")
    public Mandate getMandate() {
        return this.mandate;
    }

    public void setMandate(Mandate mandate) {
        this.mandate = mandate;
    }

    public PaymentRequest mcc(String mcc) {
        this.mcc = mcc;
        return this;
    }

    @ApiModelProperty(value="The [merchant category code](https://en.wikipedia.org/wiki/Merchant_category_code) (MCC) is a four-digit number, which relates to a particular market segment. This code reflects the predominant activity that is conducted by the merchant.")
    public String getMcc() {
        return this.mcc;
    }

    public void setMcc(String mcc) {
        this.mcc = mcc;
    }

    public PaymentRequest merchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
        return this;
    }

    @ApiModelProperty(required=true, value="The merchant account identifier, with which you want to process the transaction.")
    public String getMerchantAccount() {
        return this.merchantAccount;
    }

    public void setMerchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
    }

    public PaymentRequest merchantOrderReference(String merchantOrderReference) {
        this.merchantOrderReference = merchantOrderReference;
        return this;
    }

    @ApiModelProperty(value="This reference allows linking multiple transactions to each other for reporting purposes (i.e. order auth-rate). The reference should be unique per billing cycle. The same merchant order reference should never be reused after the first authorised attempt. If used, this field should be supplied for all incoming authorisations. > We strongly recommend you send the `merchantOrderReference` value to benefit from linking payment requests when authorisation retries take place. In addition, we recommend you provide `retry.orderAttemptNumber`, `retry.chainAttemptNumber`, and `retry.skipRetry` values in `PaymentRequest.additionalData`.")
    public String getMerchantOrderReference() {
        return this.merchantOrderReference;
    }

    public void setMerchantOrderReference(String merchantOrderReference) {
        this.merchantOrderReference = merchantOrderReference;
    }

    public PaymentRequest merchantRiskIndicator(MerchantRiskIndicator merchantRiskIndicator) {
        this.merchantRiskIndicator = merchantRiskIndicator;
        return this;
    }

    @ApiModelProperty(value="")
    public MerchantRiskIndicator getMerchantRiskIndicator() {
        return this.merchantRiskIndicator;
    }

    public void setMerchantRiskIndicator(MerchantRiskIndicator merchantRiskIndicator) {
        this.merchantRiskIndicator = merchantRiskIndicator;
    }

    public PaymentRequest metadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public PaymentRequest putMetadataItem(String key, String metadataItem) {
        if (this.metadata == null) {
            this.metadata = new HashMap<String, String>();
        }
        this.metadata.put(key, metadataItem);
        return this;
    }

    @ApiModelProperty(value="Metadata consists of entries, each of which includes a key and a value. Limits: * Maximum 20 key-value pairs per request. When exceeding, the \"177\" error occurs: \"Metadata size exceeds limit\". * Maximum 20 characters per key. * Maximum 80 characters per value. ")
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public PaymentRequest mpiData(ThreeDSecureData mpiData) {
        this.mpiData = mpiData;
        return this;
    }

    @ApiModelProperty(value="")
    public ThreeDSecureData getMpiData() {
        return this.mpiData;
    }

    public void setMpiData(ThreeDSecureData mpiData) {
        this.mpiData = mpiData;
    }

    public PaymentRequest order(EncryptedOrderData order) {
        this.order = order;
        return this;
    }

    @ApiModelProperty(value="")
    public EncryptedOrderData getOrder() {
        return this.order;
    }

    public void setOrder(EncryptedOrderData order) {
        this.order = order;
    }

    public PaymentRequest orderReference(String orderReference) {
        this.orderReference = orderReference;
        return this;
    }

    @ApiModelProperty(value="When you are doing multiple partial (gift card) payments, this is the `pspReference` of the first payment. We use this to link the multiple payments to each other. As your own reference for linking multiple payments, use the `merchantOrderReference`instead.")
    public String getOrderReference() {
        return this.orderReference;
    }

    public void setOrderReference(String orderReference) {
        this.orderReference = orderReference;
    }

    public PaymentRequest origin(String origin) {
        this.origin = origin;
        return this;
    }

    @ApiModelProperty(value="Required for the 3D Secure 2 `channel` **Web** integration.  Set this parameter to the origin URL of the page that you are loading the 3D Secure Component from.")
    public String getOrigin() {
        return this.origin;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }

    public PaymentRequest paymentMethod(CheckoutPaymentMethod paymentMethod) {
        this.paymentMethod = paymentMethod;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public CheckoutPaymentMethod getPaymentMethod() {
        return this.paymentMethod;
    }

    public void setPaymentMethod(CheckoutPaymentMethod paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    public PaymentRequest platformChargebackLogic(PlatformChargebackLogic platformChargebackLogic) {
        this.platformChargebackLogic = platformChargebackLogic;
        return this;
    }

    @ApiModelProperty(value="")
    public PlatformChargebackLogic getPlatformChargebackLogic() {
        return this.platformChargebackLogic;
    }

    public void setPlatformChargebackLogic(PlatformChargebackLogic platformChargebackLogic) {
        this.platformChargebackLogic = platformChargebackLogic;
    }

    public PaymentRequest recurringExpiry(String recurringExpiry) {
        this.recurringExpiry = recurringExpiry;
        return this;
    }

    @ApiModelProperty(value="Date after which no further authorisations shall be performed. Only for 3D Secure 2.")
    public String getRecurringExpiry() {
        return this.recurringExpiry;
    }

    public void setRecurringExpiry(String recurringExpiry) {
        this.recurringExpiry = recurringExpiry;
    }

    public PaymentRequest recurringFrequency(String recurringFrequency) {
        this.recurringFrequency = recurringFrequency;
        return this;
    }

    @ApiModelProperty(value="Minimum number of days between authorisations. Only for 3D Secure 2.")
    public String getRecurringFrequency() {
        return this.recurringFrequency;
    }

    public void setRecurringFrequency(String recurringFrequency) {
        this.recurringFrequency = recurringFrequency;
    }

    public PaymentRequest recurringProcessingModel(RecurringProcessingModelEnum recurringProcessingModel) {
        this.recurringProcessingModel = recurringProcessingModel;
        return this;
    }

    @ApiModelProperty(value="Defines a recurring payment type. Required when creating a token to store payment details or using stored payment details. Allowed values: * `Subscription` \u2013 A transaction for a fixed or variable amount, which follows a fixed schedule. * `CardOnFile` \u2013 With a card-on-file (CoF) transaction, card details are stored to enable one-click or omnichannel journeys, or simply to streamline the checkout process. Any subscription not following a fixed schedule is also considered a card-on-file transaction. * `UnscheduledCardOnFile` \u2013 An unscheduled card-on-file (UCoF) transaction is a transaction that occurs on a non-fixed schedule and/or have variable amounts. For example, automatic top-ups when a cardholder's balance drops below a certain amount. ")
    public RecurringProcessingModelEnum getRecurringProcessingModel() {
        return this.recurringProcessingModel;
    }

    public void setRecurringProcessingModel(RecurringProcessingModelEnum recurringProcessingModel) {
        this.recurringProcessingModel = recurringProcessingModel;
    }

    public PaymentRequest redirectFromIssuerMethod(String redirectFromIssuerMethod) {
        this.redirectFromIssuerMethod = redirectFromIssuerMethod;
        return this;
    }

    @ApiModelProperty(value="Specifies the redirect method (GET or POST) when redirecting back from the issuer.")
    public String getRedirectFromIssuerMethod() {
        return this.redirectFromIssuerMethod;
    }

    public void setRedirectFromIssuerMethod(String redirectFromIssuerMethod) {
        this.redirectFromIssuerMethod = redirectFromIssuerMethod;
    }

    public PaymentRequest redirectToIssuerMethod(String redirectToIssuerMethod) {
        this.redirectToIssuerMethod = redirectToIssuerMethod;
        return this;
    }

    @ApiModelProperty(value="Specifies the redirect method (GET or POST) when redirecting to the issuer.")
    public String getRedirectToIssuerMethod() {
        return this.redirectToIssuerMethod;
    }

    public void setRedirectToIssuerMethod(String redirectToIssuerMethod) {
        this.redirectToIssuerMethod = redirectToIssuerMethod;
    }

    public PaymentRequest reference(String reference) {
        this.reference = reference;
        return this;
    }

    @ApiModelProperty(required=true, value="The reference to uniquely identify a payment. This reference is used in all communication with you about the payment status. We recommend using a unique value per payment; however, it is not a requirement. If you need to provide multiple references for a transaction, separate them with hyphens (\"-\"). Maximum length: 80 characters.")
    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public PaymentRequest returnUrl(String returnUrl) {
        this.returnUrl = returnUrl;
        return this;
    }

    @ApiModelProperty(required=true, value="The URL to return to in case of a redirection. The format depends on the channel. This URL can have a maximum of 1024 characters. * For web, include the protocol `http://` or `https://`. You can also include your own additional query parameters, for example, shopper ID or order reference number. Example: `https://your-company.com/checkout?shopperOrder=12xy` * For iOS, use the custom URL for your app. To know more about setting custom URL schemes, refer to the [Apple Developer documentation](https://developer.apple.com/documentation/uikit/inter-process_communication/allowing_apps_and_websites_to_link_to_your_content/defining_a_custom_url_scheme_for_your_app). Example: `my-app://` * For Android, use a custom URL handled by an Activity on your app. You can configure it with an [intent filter](https://developer.android.com/guide/components/intents-filters). Example: `my-app://your.package.name`")
    public String getReturnUrl() {
        return this.returnUrl;
    }

    public void setReturnUrl(String returnUrl) {
        this.returnUrl = returnUrl;
    }

    public PaymentRequest riskData(RiskData riskData) {
        this.riskData = riskData;
        return this;
    }

    @ApiModelProperty(value="")
    public RiskData getRiskData() {
        return this.riskData;
    }

    public void setRiskData(RiskData riskData) {
        this.riskData = riskData;
    }

    public PaymentRequest sessionValidity(String sessionValidity) {
        this.sessionValidity = sessionValidity;
        return this;
    }

    @ApiModelProperty(value="The date and time until when the session remains valid, in [ISO 8601](https://www.w3.org/TR/NOTE-datetime) format.  For example: 2020-07-18T15:42:40.428+01:00")
    public String getSessionValidity() {
        return this.sessionValidity;
    }

    public void setSessionValidity(String sessionValidity) {
        this.sessionValidity = sessionValidity;
    }

    public PaymentRequest shopperEmail(String shopperEmail) {
        this.shopperEmail = shopperEmail;
        return this;
    }

    @ApiModelProperty(value="The shopper's email address. We recommend that you provide this data, as it is used in velocity fraud checks. > For 3D Secure 2 transactions, schemes require `shopperEmail` for all browser-based and mobile implementations.")
    public String getShopperEmail() {
        return this.shopperEmail;
    }

    public void setShopperEmail(String shopperEmail) {
        this.shopperEmail = shopperEmail;
    }

    public PaymentRequest shopperIP(String shopperIP) {
        this.shopperIP = shopperIP;
        return this;
    }

    @ApiModelProperty(value="The shopper's IP address. In general, we recommend that you provide this data, as it is used in a number of risk checks (for instance, number of payment attempts or location-based checks). > For 3D Secure 2 transactions, schemes require `shopperIP` for all browser-based implementations. This field is also mandatory for some merchants depending on your business model. For more information, [contact Support](https://www.adyen.help/hc/en-us/requests/new).")
    public String getShopperIP() {
        return this.shopperIP;
    }

    public void setShopperIP(String shopperIP) {
        this.shopperIP = shopperIP;
    }

    public PaymentRequest shopperInteraction(ShopperInteractionEnum shopperInteraction) {
        this.shopperInteraction = shopperInteraction;
        return this;
    }

    @ApiModelProperty(value="Specifies the sales channel, through which the shopper gives their card details, and whether the shopper is a returning customer. For the web service API, Adyen assumes Ecommerce shopper interaction by default.  This field has the following possible values: * `Ecommerce` - Online transactions where the cardholder is present (online). For better authorisation rates, we recommend sending the card security code (CSC) along with the request. * `ContAuth` - Card on file and/or subscription transactions, where the cardholder is known to the merchant (returning customer). If the shopper is present (online), you can supply also the CSC to improve authorisation (one-click payment). * `Moto` - Mail-order and telephone-order transactions where the shopper is in contact with the merchant via email or telephone. * `POS` - Point-of-sale transactions where the shopper is physically present to make a payment using a secure payment terminal.")
    public ShopperInteractionEnum getShopperInteraction() {
        return this.shopperInteraction;
    }

    public void setShopperInteraction(ShopperInteractionEnum shopperInteraction) {
        this.shopperInteraction = shopperInteraction;
    }

    public PaymentRequest shopperLocale(String shopperLocale) {
        this.shopperLocale = shopperLocale;
        return this;
    }

    @ApiModelProperty(value="The combination of a language code and a country code to specify the language to be used in the payment.")
    public String getShopperLocale() {
        return this.shopperLocale;
    }

    public void setShopperLocale(String shopperLocale) {
        this.shopperLocale = shopperLocale;
    }

    public PaymentRequest shopperName(Name shopperName) {
        this.shopperName = shopperName;
        return this;
    }

    @ApiModelProperty(value="")
    public Name getShopperName() {
        return this.shopperName;
    }

    public void setShopperName(Name shopperName) {
        this.shopperName = shopperName;
    }

    public PaymentRequest shopperReference(String shopperReference) {
        this.shopperReference = shopperReference;
        return this;
    }

    @ApiModelProperty(value="Required for recurring payments.  Your reference to uniquely identify this shopper, for example user ID or account ID. Minimum length: 3 characters. > Your reference must not include personally identifiable information (PII), for example name or email address.")
    public String getShopperReference() {
        return this.shopperReference;
    }

    public void setShopperReference(String shopperReference) {
        this.shopperReference = shopperReference;
    }

    public PaymentRequest shopperStatement(String shopperStatement) {
        this.shopperStatement = shopperStatement;
        return this;
    }

    @ApiModelProperty(value="The text to be shown on the shopper's bank statement.  We recommend sending a maximum of 22 characters, otherwise banks might truncate the string.  Allowed characters: **a-z**, **A-Z**, **0-9**, spaces, and special characters **. , ' _ - ? + * /_**.")
    public String getShopperStatement() {
        return this.shopperStatement;
    }

    public void setShopperStatement(String shopperStatement) {
        this.shopperStatement = shopperStatement;
    }

    public PaymentRequest socialSecurityNumber(String socialSecurityNumber) {
        this.socialSecurityNumber = socialSecurityNumber;
        return this;
    }

    @ApiModelProperty(value="The shopper's social security number.")
    public String getSocialSecurityNumber() {
        return this.socialSecurityNumber;
    }

    public void setSocialSecurityNumber(String socialSecurityNumber) {
        this.socialSecurityNumber = socialSecurityNumber;
    }

    public PaymentRequest splits(List<Split> splits) {
        this.splits = splits;
        return this;
    }

    public PaymentRequest addSplitsItem(Split splitsItem) {
        if (this.splits == null) {
            this.splits = new ArrayList<Split>();
        }
        this.splits.add(splitsItem);
        return this;
    }

    @ApiModelProperty(value="An array of objects specifying how the payment should be split when using [Adyen for Platforms](https://docs.adyen.com/marketplaces-and-platforms/processing-payments#providing-split-information) or [Issuing](https://docs.adyen.com/issuing/add-manage-funds#split).")
    public List<Split> getSplits() {
        return this.splits;
    }

    public void setSplits(List<Split> splits) {
        this.splits = splits;
    }

    public PaymentRequest store(String store) {
        this.store = store;
        return this;
    }

    @ApiModelProperty(value="The ecommerce or point-of-sale store that is processing the payment. Used in [partner model integrations](https://docs.adyen.com/marketplaces-and-platforms/classic/platforms-for-partners#route-payments) for Adyen for Platforms.")
    public String getStore() {
        return this.store;
    }

    public void setStore(String store) {
        this.store = store;
    }

    public PaymentRequest storePaymentMethod(Boolean storePaymentMethod) {
        this.storePaymentMethod = storePaymentMethod;
        return this;
    }

    @ApiModelProperty(value="When true and `shopperReference` is provided, the payment details will be stored.")
    public Boolean getStorePaymentMethod() {
        return this.storePaymentMethod;
    }

    public void setStorePaymentMethod(Boolean storePaymentMethod) {
        this.storePaymentMethod = storePaymentMethod;
    }

    public PaymentRequest telephoneNumber(String telephoneNumber) {
        this.telephoneNumber = telephoneNumber;
        return this;
    }

    @ApiModelProperty(value="The shopper's telephone number.")
    public String getTelephoneNumber() {
        return this.telephoneNumber;
    }

    public void setTelephoneNumber(String telephoneNumber) {
        this.telephoneNumber = telephoneNumber;
    }

    public PaymentRequest threeDS2RequestData(ThreeDS2RequestData threeDS2RequestData) {
        this.threeDS2RequestData = threeDS2RequestData;
        return this;
    }

    @ApiModelProperty(value="")
    public ThreeDS2RequestData getThreeDS2RequestData() {
        return this.threeDS2RequestData;
    }

    public void setThreeDS2RequestData(ThreeDS2RequestData threeDS2RequestData) {
        this.threeDS2RequestData = threeDS2RequestData;
    }

    @Deprecated
    public PaymentRequest threeDSAuthenticationOnly(Boolean threeDSAuthenticationOnly) {
        this.threeDSAuthenticationOnly = threeDSAuthenticationOnly;
        return this;
    }

    @Deprecated
    @ApiModelProperty(value="If set to true, you will only perform the [3D Secure 2 authentication](https://docs.adyen.com/online-payments/3d-secure/other-3ds-flows/authentication-only), and not the payment authorisation.")
    public Boolean getThreeDSAuthenticationOnly() {
        return this.threeDSAuthenticationOnly;
    }

    @Deprecated
    public void setThreeDSAuthenticationOnly(Boolean threeDSAuthenticationOnly) {
        this.threeDSAuthenticationOnly = threeDSAuthenticationOnly;
    }

    public PaymentRequest trustedShopper(Boolean trustedShopper) {
        this.trustedShopper = trustedShopper;
        return this;
    }

    @ApiModelProperty(value="Set to true if the payment should be routed to a trusted MID.")
    public Boolean getTrustedShopper() {
        return this.trustedShopper;
    }

    public void setTrustedShopper(Boolean trustedShopper) {
        this.trustedShopper = trustedShopper;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentRequest paymentRequest = (PaymentRequest)o;
        return Objects.equals(this.accountInfo, paymentRequest.accountInfo) && Objects.equals(this.additionalAmount, paymentRequest.additionalAmount) && Objects.equals(this.additionalData, paymentRequest.additionalData) && Objects.equals(this.amount, paymentRequest.amount) && Objects.equals(this.applicationInfo, paymentRequest.applicationInfo) && Objects.equals(this.authenticationData, paymentRequest.authenticationData) && Objects.equals(this.billingAddress, paymentRequest.billingAddress) && Objects.equals(this.browserInfo, paymentRequest.browserInfo) && Objects.equals(this.captureDelayHours, paymentRequest.captureDelayHours) && Objects.equals((Object)this.channel, (Object)paymentRequest.channel) && Objects.equals(this.checkoutAttemptId, paymentRequest.checkoutAttemptId) && Objects.equals(this.company, paymentRequest.company) && Objects.equals(this.conversionId, paymentRequest.conversionId) && Objects.equals(this.countryCode, paymentRequest.countryCode) && Objects.equals(this.dateOfBirth, paymentRequest.dateOfBirth) && Objects.equals(this.dccQuote, paymentRequest.dccQuote) && Objects.equals(this.deliveryAddress, paymentRequest.deliveryAddress) && Objects.equals(this.deliveryDate, paymentRequest.deliveryDate) && Objects.equals(this.deviceFingerprint, paymentRequest.deviceFingerprint) && Objects.equals(this.enableOneClick, paymentRequest.enableOneClick) && Objects.equals(this.enablePayOut, paymentRequest.enablePayOut) && Objects.equals(this.enableRecurring, paymentRequest.enableRecurring) && Objects.equals((Object)this.entityType, (Object)paymentRequest.entityType) && Objects.equals(this.fraudOffset, paymentRequest.fraudOffset) && Objects.equals((Object)this.industryUsage, (Object)paymentRequest.industryUsage) && Objects.equals(this.installments, paymentRequest.installments) && Objects.equals(this.lineItems, paymentRequest.lineItems) && Objects.equals(this.localizedShopperStatement, paymentRequest.localizedShopperStatement) && Objects.equals(this.mandate, paymentRequest.mandate) && Objects.equals(this.mcc, paymentRequest.mcc) && Objects.equals(this.merchantAccount, paymentRequest.merchantAccount) && Objects.equals(this.merchantOrderReference, paymentRequest.merchantOrderReference) && Objects.equals(this.merchantRiskIndicator, paymentRequest.merchantRiskIndicator) && Objects.equals(this.metadata, paymentRequest.metadata) && Objects.equals(this.mpiData, paymentRequest.mpiData) && Objects.equals(this.order, paymentRequest.order) && Objects.equals(this.orderReference, paymentRequest.orderReference) && Objects.equals(this.origin, paymentRequest.origin) && Objects.equals(this.paymentMethod, paymentRequest.paymentMethod) && Objects.equals(this.platformChargebackLogic, paymentRequest.platformChargebackLogic) && Objects.equals(this.recurringExpiry, paymentRequest.recurringExpiry) && Objects.equals(this.recurringFrequency, paymentRequest.recurringFrequency) && Objects.equals((Object)this.recurringProcessingModel, (Object)paymentRequest.recurringProcessingModel) && Objects.equals(this.redirectFromIssuerMethod, paymentRequest.redirectFromIssuerMethod) && Objects.equals(this.redirectToIssuerMethod, paymentRequest.redirectToIssuerMethod) && Objects.equals(this.reference, paymentRequest.reference) && Objects.equals(this.returnUrl, paymentRequest.returnUrl) && Objects.equals(this.riskData, paymentRequest.riskData) && Objects.equals(this.sessionValidity, paymentRequest.sessionValidity) && Objects.equals(this.shopperEmail, paymentRequest.shopperEmail) && Objects.equals(this.shopperIP, paymentRequest.shopperIP) && Objects.equals((Object)this.shopperInteraction, (Object)paymentRequest.shopperInteraction) && Objects.equals(this.shopperLocale, paymentRequest.shopperLocale) && Objects.equals(this.shopperName, paymentRequest.shopperName) && Objects.equals(this.shopperReference, paymentRequest.shopperReference) && Objects.equals(this.shopperStatement, paymentRequest.shopperStatement) && Objects.equals(this.socialSecurityNumber, paymentRequest.socialSecurityNumber) && Objects.equals(this.splits, paymentRequest.splits) && Objects.equals(this.store, paymentRequest.store) && Objects.equals(this.storePaymentMethod, paymentRequest.storePaymentMethod) && Objects.equals(this.telephoneNumber, paymentRequest.telephoneNumber) && Objects.equals(this.threeDS2RequestData, paymentRequest.threeDS2RequestData) && Objects.equals(this.threeDSAuthenticationOnly, paymentRequest.threeDSAuthenticationOnly) && Objects.equals(this.trustedShopper, paymentRequest.trustedShopper);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountInfo, this.additionalAmount, this.additionalData, this.amount, this.applicationInfo, this.authenticationData, this.billingAddress, this.browserInfo, this.captureDelayHours, this.channel, this.checkoutAttemptId, this.company, this.conversionId, this.countryCode, this.dateOfBirth, this.dccQuote, this.deliveryAddress, this.deliveryDate, this.deviceFingerprint, this.enableOneClick, this.enablePayOut, this.enableRecurring, this.entityType, this.fraudOffset, this.industryUsage, this.installments, this.lineItems, this.localizedShopperStatement, this.mandate, this.mcc, this.merchantAccount, this.merchantOrderReference, this.merchantRiskIndicator, this.metadata, this.mpiData, this.order, this.orderReference, this.origin, this.paymentMethod, this.platformChargebackLogic, this.recurringExpiry, this.recurringFrequency, this.recurringProcessingModel, this.redirectFromIssuerMethod, this.redirectToIssuerMethod, this.reference, this.returnUrl, this.riskData, this.sessionValidity, this.shopperEmail, this.shopperIP, this.shopperInteraction, this.shopperLocale, this.shopperName, this.shopperReference, this.shopperStatement, this.socialSecurityNumber, this.splits, this.store, this.storePaymentMethod, this.telephoneNumber, this.threeDS2RequestData, this.threeDSAuthenticationOnly, this.trustedShopper});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentRequest {\n");
        sb.append("    accountInfo: ").append(this.toIndentedString(this.accountInfo)).append("\n");
        sb.append("    additionalAmount: ").append(this.toIndentedString(this.additionalAmount)).append("\n");
        sb.append("    additionalData: ").append(this.toIndentedString(this.additionalData)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    applicationInfo: ").append(this.toIndentedString(this.applicationInfo)).append("\n");
        sb.append("    authenticationData: ").append(this.toIndentedString(this.authenticationData)).append("\n");
        sb.append("    billingAddress: ").append(this.toIndentedString(this.billingAddress)).append("\n");
        sb.append("    browserInfo: ").append(this.toIndentedString(this.browserInfo)).append("\n");
        sb.append("    captureDelayHours: ").append(this.toIndentedString(this.captureDelayHours)).append("\n");
        sb.append("    channel: ").append(this.toIndentedString((Object)this.channel)).append("\n");
        sb.append("    checkoutAttemptId: ").append(this.toIndentedString(this.checkoutAttemptId)).append("\n");
        sb.append("    company: ").append(this.toIndentedString(this.company)).append("\n");
        sb.append("    conversionId: ").append(this.toIndentedString(this.conversionId)).append("\n");
        sb.append("    countryCode: ").append(this.toIndentedString(this.countryCode)).append("\n");
        sb.append("    dateOfBirth: ").append(this.toIndentedString(this.dateOfBirth)).append("\n");
        sb.append("    dccQuote: ").append(this.toIndentedString(this.dccQuote)).append("\n");
        sb.append("    deliveryAddress: ").append(this.toIndentedString(this.deliveryAddress)).append("\n");
        sb.append("    deliveryDate: ").append(this.toIndentedString(this.deliveryDate)).append("\n");
        sb.append("    deviceFingerprint: ").append(this.toIndentedString(this.deviceFingerprint)).append("\n");
        sb.append("    enableOneClick: ").append(this.toIndentedString(this.enableOneClick)).append("\n");
        sb.append("    enablePayOut: ").append(this.toIndentedString(this.enablePayOut)).append("\n");
        sb.append("    enableRecurring: ").append(this.toIndentedString(this.enableRecurring)).append("\n");
        sb.append("    entityType: ").append(this.toIndentedString((Object)this.entityType)).append("\n");
        sb.append("    fraudOffset: ").append(this.toIndentedString(this.fraudOffset)).append("\n");
        sb.append("    industryUsage: ").append(this.toIndentedString((Object)this.industryUsage)).append("\n");
        sb.append("    installments: ").append(this.toIndentedString(this.installments)).append("\n");
        sb.append("    lineItems: ").append(this.toIndentedString(this.lineItems)).append("\n");
        sb.append("    localizedShopperStatement: ").append(this.toIndentedString(this.localizedShopperStatement)).append("\n");
        sb.append("    mandate: ").append(this.toIndentedString(this.mandate)).append("\n");
        sb.append("    mcc: ").append(this.toIndentedString(this.mcc)).append("\n");
        sb.append("    merchantAccount: ").append(this.toIndentedString(this.merchantAccount)).append("\n");
        sb.append("    merchantOrderReference: ").append(this.toIndentedString(this.merchantOrderReference)).append("\n");
        sb.append("    merchantRiskIndicator: ").append(this.toIndentedString(this.merchantRiskIndicator)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    mpiData: ").append(this.toIndentedString(this.mpiData)).append("\n");
        sb.append("    order: ").append(this.toIndentedString(this.order)).append("\n");
        sb.append("    orderReference: ").append(this.toIndentedString(this.orderReference)).append("\n");
        sb.append("    origin: ").append(this.toIndentedString(this.origin)).append("\n");
        sb.append("    paymentMethod: ").append(this.toIndentedString(this.paymentMethod)).append("\n");
        sb.append("    platformChargebackLogic: ").append(this.toIndentedString(this.platformChargebackLogic)).append("\n");
        sb.append("    recurringExpiry: ").append(this.toIndentedString(this.recurringExpiry)).append("\n");
        sb.append("    recurringFrequency: ").append(this.toIndentedString(this.recurringFrequency)).append("\n");
        sb.append("    recurringProcessingModel: ").append(this.toIndentedString((Object)this.recurringProcessingModel)).append("\n");
        sb.append("    redirectFromIssuerMethod: ").append(this.toIndentedString(this.redirectFromIssuerMethod)).append("\n");
        sb.append("    redirectToIssuerMethod: ").append(this.toIndentedString(this.redirectToIssuerMethod)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    returnUrl: ").append(this.toIndentedString(this.returnUrl)).append("\n");
        sb.append("    riskData: ").append(this.toIndentedString(this.riskData)).append("\n");
        sb.append("    sessionValidity: ").append(this.toIndentedString(this.sessionValidity)).append("\n");
        sb.append("    shopperEmail: ").append(this.toIndentedString(this.shopperEmail)).append("\n");
        sb.append("    shopperIP: ").append(this.toIndentedString(this.shopperIP)).append("\n");
        sb.append("    shopperInteraction: ").append(this.toIndentedString((Object)this.shopperInteraction)).append("\n");
        sb.append("    shopperLocale: ").append(this.toIndentedString(this.shopperLocale)).append("\n");
        sb.append("    shopperName: ").append(this.toIndentedString(this.shopperName)).append("\n");
        sb.append("    shopperReference: ").append(this.toIndentedString(this.shopperReference)).append("\n");
        sb.append("    shopperStatement: ").append(this.toIndentedString(this.shopperStatement)).append("\n");
        sb.append("    socialSecurityNumber: ").append(this.toIndentedString(this.socialSecurityNumber)).append("\n");
        sb.append("    splits: ").append(this.toIndentedString(this.splits)).append("\n");
        sb.append("    store: ").append(this.toIndentedString(this.store)).append("\n");
        sb.append("    storePaymentMethod: ").append(this.toIndentedString(this.storePaymentMethod)).append("\n");
        sb.append("    telephoneNumber: ").append(this.toIndentedString(this.telephoneNumber)).append("\n");
        sb.append("    threeDS2RequestData: ").append(this.toIndentedString(this.threeDS2RequestData)).append("\n");
        sb.append("    threeDSAuthenticationOnly: ").append(this.toIndentedString(this.threeDSAuthenticationOnly)).append("\n");
        sb.append("    trustedShopper: ").append(this.toIndentedString(this.trustedShopper)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArraysplits;
        JsonArray jsonArraylineItems;
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in PaymentRequest is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `PaymentRequest` properties.", entry.getKey()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_ACCOUNT_INFO) != null) {
            AccountInfo.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_ACCOUNT_INFO));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_ADDITIONAL_AMOUNT) != null) {
            Amount.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_ADDITIONAL_AMOUNT));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_AMOUNT) != null) {
            Amount.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_AMOUNT));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_APPLICATION_INFO) != null) {
            ApplicationInfo.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_APPLICATION_INFO));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_AUTHENTICATION_DATA) != null) {
            AuthenticationData.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_AUTHENTICATION_DATA));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_BILLING_ADDRESS) != null) {
            Address.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_BILLING_ADDRESS));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_BROWSER_INFO) != null) {
            BrowserInfo.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_BROWSER_INFO));
        }
        if (jsonObj.get(SERIALIZED_NAME_CHANNEL) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_CHANNEL).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `channel` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CHANNEL).toString()));
            }
            ChannelEnum.fromValue(jsonObj.get(SERIALIZED_NAME_CHANNEL).getAsString());
        }
        if (jsonObj.get(SERIALIZED_NAME_CHECKOUT_ATTEMPT_ID) != null && !jsonObj.get(SERIALIZED_NAME_CHECKOUT_ATTEMPT_ID).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `checkoutAttemptId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CHECKOUT_ATTEMPT_ID).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_COMPANY) != null) {
            Company.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_COMPANY));
        }
        if (jsonObj.get(SERIALIZED_NAME_CONVERSION_ID) != null && !jsonObj.get(SERIALIZED_NAME_CONVERSION_ID).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `conversionId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CONVERSION_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_COUNTRY_CODE) != null && !jsonObj.get(SERIALIZED_NAME_COUNTRY_CODE).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `countryCode` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_COUNTRY_CODE).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_DCC_QUOTE) != null) {
            ForexQuote.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_DCC_QUOTE));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_DELIVERY_ADDRESS) != null) {
            Address.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_DELIVERY_ADDRESS));
        }
        if (jsonObj.get(SERIALIZED_NAME_DEVICE_FINGERPRINT) != null && !jsonObj.get(SERIALIZED_NAME_DEVICE_FINGERPRINT).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `deviceFingerprint` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DEVICE_FINGERPRINT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ENTITY_TYPE) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_ENTITY_TYPE).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `entityType` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ENTITY_TYPE).toString()));
            }
            EntityTypeEnum.fromValue(jsonObj.get(SERIALIZED_NAME_ENTITY_TYPE).getAsString());
        }
        if (jsonObj.get(SERIALIZED_NAME_INDUSTRY_USAGE) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_INDUSTRY_USAGE).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `industryUsage` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_INDUSTRY_USAGE).toString()));
            }
            IndustryUsageEnum.fromValue(jsonObj.get(SERIALIZED_NAME_INDUSTRY_USAGE).getAsString());
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_INSTALLMENTS) != null) {
            Installments.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_INSTALLMENTS));
        }
        if ((jsonArraylineItems = jsonObj.getAsJsonArray(SERIALIZED_NAME_LINE_ITEMS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_LINE_ITEMS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `lineItems` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_LINE_ITEMS).toString()));
            }
            for (int i = 0; i < jsonArraylineItems.size(); ++i) {
                LineItem.validateJsonObject(jsonArraylineItems.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_MANDATE) != null) {
            Mandate.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_MANDATE));
        }
        if (jsonObj.get(SERIALIZED_NAME_MCC) != null && !jsonObj.get(SERIALIZED_NAME_MCC).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `mcc` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MCC).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MERCHANT_ACCOUNT) != null && !jsonObj.get(SERIALIZED_NAME_MERCHANT_ACCOUNT).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `merchantAccount` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MERCHANT_ACCOUNT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MERCHANT_ORDER_REFERENCE) != null && !jsonObj.get(SERIALIZED_NAME_MERCHANT_ORDER_REFERENCE).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `merchantOrderReference` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MERCHANT_ORDER_REFERENCE).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_MERCHANT_RISK_INDICATOR) != null) {
            MerchantRiskIndicator.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_MERCHANT_RISK_INDICATOR));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_MPI_DATA) != null) {
            ThreeDSecureData.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_MPI_DATA));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_ORDER) != null) {
            EncryptedOrderData.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_ORDER));
        }
        if (jsonObj.get(SERIALIZED_NAME_ORDER_REFERENCE) != null && !jsonObj.get(SERIALIZED_NAME_ORDER_REFERENCE).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `orderReference` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ORDER_REFERENCE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ORIGIN) != null && !jsonObj.get(SERIALIZED_NAME_ORIGIN).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `origin` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ORIGIN).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_PAYMENT_METHOD) != null) {
            CheckoutPaymentMethod.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_PAYMENT_METHOD));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_PLATFORM_CHARGEBACK_LOGIC) != null) {
            PlatformChargebackLogic.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_PLATFORM_CHARGEBACK_LOGIC));
        }
        if (jsonObj.get(SERIALIZED_NAME_RECURRING_EXPIRY) != null && !jsonObj.get(SERIALIZED_NAME_RECURRING_EXPIRY).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `recurringExpiry` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RECURRING_EXPIRY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_RECURRING_FREQUENCY) != null && !jsonObj.get(SERIALIZED_NAME_RECURRING_FREQUENCY).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `recurringFrequency` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RECURRING_FREQUENCY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_RECURRING_PROCESSING_MODEL) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_RECURRING_PROCESSING_MODEL).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `recurringProcessingModel` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RECURRING_PROCESSING_MODEL).toString()));
            }
            RecurringProcessingModelEnum.fromValue(jsonObj.get(SERIALIZED_NAME_RECURRING_PROCESSING_MODEL).getAsString());
        }
        if (jsonObj.get(SERIALIZED_NAME_REDIRECT_FROM_ISSUER_METHOD) != null && !jsonObj.get(SERIALIZED_NAME_REDIRECT_FROM_ISSUER_METHOD).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `redirectFromIssuerMethod` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REDIRECT_FROM_ISSUER_METHOD).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_REDIRECT_TO_ISSUER_METHOD) != null && !jsonObj.get(SERIALIZED_NAME_REDIRECT_TO_ISSUER_METHOD).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `redirectToIssuerMethod` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REDIRECT_TO_ISSUER_METHOD).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_REFERENCE) != null && !jsonObj.get(SERIALIZED_NAME_REFERENCE).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `reference` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REFERENCE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_RETURN_URL) != null && !jsonObj.get(SERIALIZED_NAME_RETURN_URL).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `returnUrl` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RETURN_URL).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_RISK_DATA) != null) {
            RiskData.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_RISK_DATA));
        }
        if (jsonObj.get(SERIALIZED_NAME_SESSION_VALIDITY) != null && !jsonObj.get(SERIALIZED_NAME_SESSION_VALIDITY).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `sessionValidity` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SESSION_VALIDITY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SHOPPER_EMAIL) != null && !jsonObj.get(SERIALIZED_NAME_SHOPPER_EMAIL).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `shopperEmail` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SHOPPER_EMAIL).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SHOPPER_I_P) != null && !jsonObj.get(SERIALIZED_NAME_SHOPPER_I_P).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `shopperIP` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SHOPPER_I_P).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SHOPPER_INTERACTION) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_SHOPPER_INTERACTION).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `shopperInteraction` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SHOPPER_INTERACTION).toString()));
            }
            ShopperInteractionEnum.fromValue(jsonObj.get(SERIALIZED_NAME_SHOPPER_INTERACTION).getAsString());
        }
        if (jsonObj.get(SERIALIZED_NAME_SHOPPER_LOCALE) != null && !jsonObj.get(SERIALIZED_NAME_SHOPPER_LOCALE).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `shopperLocale` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SHOPPER_LOCALE).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_SHOPPER_NAME) != null) {
            Name.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_SHOPPER_NAME));
        }
        if (jsonObj.get(SERIALIZED_NAME_SHOPPER_REFERENCE) != null && !jsonObj.get(SERIALIZED_NAME_SHOPPER_REFERENCE).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `shopperReference` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SHOPPER_REFERENCE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SHOPPER_STATEMENT) != null && !jsonObj.get(SERIALIZED_NAME_SHOPPER_STATEMENT).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `shopperStatement` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SHOPPER_STATEMENT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SOCIAL_SECURITY_NUMBER) != null && !jsonObj.get(SERIALIZED_NAME_SOCIAL_SECURITY_NUMBER).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `socialSecurityNumber` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SOCIAL_SECURITY_NUMBER).toString()));
        }
        if ((jsonArraysplits = jsonObj.getAsJsonArray(SERIALIZED_NAME_SPLITS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_SPLITS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `splits` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SPLITS).toString()));
            }
            for (int i = 0; i < jsonArraysplits.size(); ++i) {
                Split.validateJsonObject(jsonArraysplits.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_STORE) != null && !jsonObj.get(SERIALIZED_NAME_STORE).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `store` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STORE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TELEPHONE_NUMBER) != null && !jsonObj.get(SERIALIZED_NAME_TELEPHONE_NUMBER).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `telephoneNumber` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TELEPHONE_NUMBER).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_THREE_D_S2_REQUEST_DATA) != null) {
            ThreeDS2RequestData.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_THREE_D_S2_REQUEST_DATA));
        }
    }

    public static PaymentRequest fromJson(String jsonString) throws IOException {
        return (PaymentRequest)JSON.getGson().fromJson(jsonString, PaymentRequest.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ACCOUNT_INFO);
        openapiFields.add(SERIALIZED_NAME_ADDITIONAL_AMOUNT);
        openapiFields.add(SERIALIZED_NAME_ADDITIONAL_DATA);
        openapiFields.add(SERIALIZED_NAME_AMOUNT);
        openapiFields.add(SERIALIZED_NAME_APPLICATION_INFO);
        openapiFields.add(SERIALIZED_NAME_AUTHENTICATION_DATA);
        openapiFields.add(SERIALIZED_NAME_BILLING_ADDRESS);
        openapiFields.add(SERIALIZED_NAME_BROWSER_INFO);
        openapiFields.add(SERIALIZED_NAME_CAPTURE_DELAY_HOURS);
        openapiFields.add(SERIALIZED_NAME_CHANNEL);
        openapiFields.add(SERIALIZED_NAME_CHECKOUT_ATTEMPT_ID);
        openapiFields.add(SERIALIZED_NAME_COMPANY);
        openapiFields.add(SERIALIZED_NAME_CONVERSION_ID);
        openapiFields.add(SERIALIZED_NAME_COUNTRY_CODE);
        openapiFields.add(SERIALIZED_NAME_DATE_OF_BIRTH);
        openapiFields.add(SERIALIZED_NAME_DCC_QUOTE);
        openapiFields.add(SERIALIZED_NAME_DELIVERY_ADDRESS);
        openapiFields.add(SERIALIZED_NAME_DELIVERY_DATE);
        openapiFields.add(SERIALIZED_NAME_DEVICE_FINGERPRINT);
        openapiFields.add(SERIALIZED_NAME_ENABLE_ONE_CLICK);
        openapiFields.add(SERIALIZED_NAME_ENABLE_PAY_OUT);
        openapiFields.add(SERIALIZED_NAME_ENABLE_RECURRING);
        openapiFields.add(SERIALIZED_NAME_ENTITY_TYPE);
        openapiFields.add(SERIALIZED_NAME_FRAUD_OFFSET);
        openapiFields.add(SERIALIZED_NAME_INDUSTRY_USAGE);
        openapiFields.add(SERIALIZED_NAME_INSTALLMENTS);
        openapiFields.add(SERIALIZED_NAME_LINE_ITEMS);
        openapiFields.add(SERIALIZED_NAME_LOCALIZED_SHOPPER_STATEMENT);
        openapiFields.add(SERIALIZED_NAME_MANDATE);
        openapiFields.add(SERIALIZED_NAME_MCC);
        openapiFields.add(SERIALIZED_NAME_MERCHANT_ACCOUNT);
        openapiFields.add(SERIALIZED_NAME_MERCHANT_ORDER_REFERENCE);
        openapiFields.add(SERIALIZED_NAME_MERCHANT_RISK_INDICATOR);
        openapiFields.add(SERIALIZED_NAME_METADATA);
        openapiFields.add(SERIALIZED_NAME_MPI_DATA);
        openapiFields.add(SERIALIZED_NAME_ORDER);
        openapiFields.add(SERIALIZED_NAME_ORDER_REFERENCE);
        openapiFields.add(SERIALIZED_NAME_ORIGIN);
        openapiFields.add(SERIALIZED_NAME_PAYMENT_METHOD);
        openapiFields.add(SERIALIZED_NAME_PLATFORM_CHARGEBACK_LOGIC);
        openapiFields.add(SERIALIZED_NAME_RECURRING_EXPIRY);
        openapiFields.add(SERIALIZED_NAME_RECURRING_FREQUENCY);
        openapiFields.add(SERIALIZED_NAME_RECURRING_PROCESSING_MODEL);
        openapiFields.add(SERIALIZED_NAME_REDIRECT_FROM_ISSUER_METHOD);
        openapiFields.add(SERIALIZED_NAME_REDIRECT_TO_ISSUER_METHOD);
        openapiFields.add(SERIALIZED_NAME_REFERENCE);
        openapiFields.add(SERIALIZED_NAME_RETURN_URL);
        openapiFields.add(SERIALIZED_NAME_RISK_DATA);
        openapiFields.add(SERIALIZED_NAME_SESSION_VALIDITY);
        openapiFields.add(SERIALIZED_NAME_SHOPPER_EMAIL);
        openapiFields.add(SERIALIZED_NAME_SHOPPER_I_P);
        openapiFields.add(SERIALIZED_NAME_SHOPPER_INTERACTION);
        openapiFields.add(SERIALIZED_NAME_SHOPPER_LOCALE);
        openapiFields.add(SERIALIZED_NAME_SHOPPER_NAME);
        openapiFields.add(SERIALIZED_NAME_SHOPPER_REFERENCE);
        openapiFields.add(SERIALIZED_NAME_SHOPPER_STATEMENT);
        openapiFields.add(SERIALIZED_NAME_SOCIAL_SECURITY_NUMBER);
        openapiFields.add(SERIALIZED_NAME_SPLITS);
        openapiFields.add(SERIALIZED_NAME_STORE);
        openapiFields.add(SERIALIZED_NAME_STORE_PAYMENT_METHOD);
        openapiFields.add(SERIALIZED_NAME_TELEPHONE_NUMBER);
        openapiFields.add(SERIALIZED_NAME_THREE_D_S2_REQUEST_DATA);
        openapiFields.add(SERIALIZED_NAME_THREE_D_S_AUTHENTICATION_ONLY);
        openapiFields.add(SERIALIZED_NAME_TRUSTED_SHOPPER);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_AMOUNT);
        openapiRequiredFields.add(SERIALIZED_NAME_MERCHANT_ACCOUNT);
        openapiRequiredFields.add(SERIALIZED_NAME_PAYMENT_METHOD);
        openapiRequiredFields.add(SERIALIZED_NAME_REFERENCE);
        openapiRequiredFields.add(SERIALIZED_NAME_RETURN_URL);
        log = Logger.getLogger(PaymentRequest.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!PaymentRequest.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(PaymentRequest.class));
            return new TypeAdapter<PaymentRequest>(){

                public void write(JsonWriter out, PaymentRequest value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public PaymentRequest read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    PaymentRequest.validateJsonObject(jsonObj);
                    return (PaymentRequest)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ShopperInteractionEnum {
        ECOMMERCE("Ecommerce"),
        CONTAUTH("ContAuth"),
        MOTO("Moto"),
        POS("POS");

        private String value;

        private ShopperInteractionEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ShopperInteractionEnum fromValue(String value) {
            for (ShopperInteractionEnum b : ShopperInteractionEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<ShopperInteractionEnum> {
            public void write(JsonWriter jsonWriter, ShopperInteractionEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ShopperInteractionEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ShopperInteractionEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum RecurringProcessingModelEnum {
        CARDONFILE("CardOnFile"),
        SUBSCRIPTION("Subscription"),
        UNSCHEDULEDCARDONFILE("UnscheduledCardOnFile");

        private String value;

        private RecurringProcessingModelEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static RecurringProcessingModelEnum fromValue(String value) {
            for (RecurringProcessingModelEnum b : RecurringProcessingModelEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<RecurringProcessingModelEnum> {
            public void write(JsonWriter jsonWriter, RecurringProcessingModelEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public RecurringProcessingModelEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return RecurringProcessingModelEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum IndustryUsageEnum {
        DELAYEDCHARGE("delayedCharge"),
        INSTALLMENT("installment"),
        NOSHOW("noShow");

        private String value;

        private IndustryUsageEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static IndustryUsageEnum fromValue(String value) {
            for (IndustryUsageEnum b : IndustryUsageEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<IndustryUsageEnum> {
            public void write(JsonWriter jsonWriter, IndustryUsageEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public IndustryUsageEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return IndustryUsageEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum EntityTypeEnum {
        NATURALPERSON("NaturalPerson"),
        COMPANYNAME("CompanyName");

        private String value;

        private EntityTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static EntityTypeEnum fromValue(String value) {
            for (EntityTypeEnum b : EntityTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<EntityTypeEnum> {
            public void write(JsonWriter jsonWriter, EntityTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public EntityTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return EntityTypeEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ChannelEnum {
        IOS("iOS"),
        ANDROID("Android"),
        WEB("Web");

        private String value;

        private ChannelEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ChannelEnum fromValue(String value) {
            for (ChannelEnum b : ChannelEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<ChannelEnum> {
            public void write(JsonWriter jsonWriter, ChannelEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ChannelEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ChannelEnum.fromValue(value);
            }
        }
    }
}

