/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.Item;
import com.adyen.model.checkout.JSON;
import com.adyen.model.checkout.SubInputDetail;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class InputDetail {
    public static final String SERIALIZED_NAME_CONFIGURATION = "configuration";
    @SerializedName(value="configuration")
    private Map<String, String> configuration = null;
    public static final String SERIALIZED_NAME_DETAILS = "details";
    @SerializedName(value="details")
    private List<SubInputDetail> details = null;
    public static final String SERIALIZED_NAME_INPUT_DETAILS = "inputDetails";
    @Deprecated
    @SerializedName(value="inputDetails")
    private List<SubInputDetail> inputDetails = null;
    public static final String SERIALIZED_NAME_ITEM_SEARCH_URL = "itemSearchUrl";
    @SerializedName(value="itemSearchUrl")
    private String itemSearchUrl;
    public static final String SERIALIZED_NAME_ITEMS = "items";
    @SerializedName(value="items")
    private List<Item> items = null;
    public static final String SERIALIZED_NAME_KEY = "key";
    @SerializedName(value="key")
    private String key;
    public static final String SERIALIZED_NAME_OPTIONAL = "optional";
    @SerializedName(value="optional")
    private Boolean optional;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private String type;
    public static final String SERIALIZED_NAME_VALUE = "value";
    @SerializedName(value="value")
    private String value;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public InputDetail configuration(Map<String, String> configuration) {
        this.configuration = configuration;
        return this;
    }

    public InputDetail putConfigurationItem(String key, String configurationItem) {
        if (this.configuration == null) {
            this.configuration = new HashMap<String, String>();
        }
        this.configuration.put(key, configurationItem);
        return this;
    }

    @ApiModelProperty(value="Configuration parameters for the required input.")
    public Map<String, String> getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Map<String, String> configuration) {
        this.configuration = configuration;
    }

    public InputDetail details(List<SubInputDetail> details) {
        this.details = details;
        return this;
    }

    public InputDetail addDetailsItem(SubInputDetail detailsItem) {
        if (this.details == null) {
            this.details = new ArrayList<SubInputDetail>();
        }
        this.details.add(detailsItem);
        return this;
    }

    @ApiModelProperty(value="Input details can also be provided recursively.")
    public List<SubInputDetail> getDetails() {
        return this.details;
    }

    public void setDetails(List<SubInputDetail> details) {
        this.details = details;
    }

    @Deprecated
    public InputDetail inputDetails(List<SubInputDetail> inputDetails) {
        this.inputDetails = inputDetails;
        return this;
    }

    public InputDetail addInputDetailsItem(SubInputDetail inputDetailsItem) {
        if (this.inputDetails == null) {
            this.inputDetails = new ArrayList<SubInputDetail>();
        }
        this.inputDetails.add(inputDetailsItem);
        return this;
    }

    @Deprecated
    @ApiModelProperty(value="Input details can also be provided recursively (deprecated).")
    public List<SubInputDetail> getInputDetails() {
        return this.inputDetails;
    }

    @Deprecated
    public void setInputDetails(List<SubInputDetail> inputDetails) {
        this.inputDetails = inputDetails;
    }

    public InputDetail itemSearchUrl(String itemSearchUrl) {
        this.itemSearchUrl = itemSearchUrl;
        return this;
    }

    @ApiModelProperty(value="In case of a select, the URL from which to query the items.")
    public String getItemSearchUrl() {
        return this.itemSearchUrl;
    }

    public void setItemSearchUrl(String itemSearchUrl) {
        this.itemSearchUrl = itemSearchUrl;
    }

    public InputDetail items(List<Item> items) {
        this.items = items;
        return this;
    }

    public InputDetail addItemsItem(Item itemsItem) {
        if (this.items == null) {
            this.items = new ArrayList<Item>();
        }
        this.items.add(itemsItem);
        return this;
    }

    @ApiModelProperty(value="In case of a select, the items to choose from.")
    public List<Item> getItems() {
        return this.items;
    }

    public void setItems(List<Item> items) {
        this.items = items;
    }

    public InputDetail key(String key) {
        this.key = key;
        return this;
    }

    @ApiModelProperty(value="The value to provide in the result.")
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public InputDetail optional(Boolean optional) {
        this.optional = optional;
        return this;
    }

    @ApiModelProperty(value="True if this input value is optional.")
    public Boolean getOptional() {
        return this.optional;
    }

    public void setOptional(Boolean optional) {
        this.optional = optional;
    }

    public InputDetail type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="The type of the required input.")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public InputDetail value(String value) {
        this.value = value;
        return this;
    }

    @ApiModelProperty(value="The value can be pre-filled, if available.")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InputDetail inputDetail = (InputDetail)o;
        return Objects.equals(this.configuration, inputDetail.configuration) && Objects.equals(this.details, inputDetail.details) && Objects.equals(this.inputDetails, inputDetail.inputDetails) && Objects.equals(this.itemSearchUrl, inputDetail.itemSearchUrl) && Objects.equals(this.items, inputDetail.items) && Objects.equals(this.key, inputDetail.key) && Objects.equals(this.optional, inputDetail.optional) && Objects.equals(this.type, inputDetail.type) && Objects.equals(this.value, inputDetail.value);
    }

    public int hashCode() {
        return Objects.hash(this.configuration, this.details, this.inputDetails, this.itemSearchUrl, this.items, this.key, this.optional, this.type, this.value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InputDetail {\n");
        sb.append("    configuration: ").append(this.toIndentedString(this.configuration)).append("\n");
        sb.append("    details: ").append(this.toIndentedString(this.details)).append("\n");
        sb.append("    inputDetails: ").append(this.toIndentedString(this.inputDetails)).append("\n");
        sb.append("    itemSearchUrl: ").append(this.toIndentedString(this.itemSearchUrl)).append("\n");
        sb.append("    items: ").append(this.toIndentedString(this.items)).append("\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    optional: ").append(this.toIndentedString(this.optional)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArrayitems;
        JsonArray jsonArrayinputDetails;
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in InputDetail is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `InputDetail` properties.", entry.getKey()));
        }
        JsonArray jsonArraydetails = jsonObj.getAsJsonArray(SERIALIZED_NAME_DETAILS);
        if (jsonArraydetails != null) {
            if (!jsonObj.get(SERIALIZED_NAME_DETAILS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `details` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DETAILS).toString()));
            }
            for (int i = 0; i < jsonArraydetails.size(); ++i) {
                SubInputDetail.validateJsonObject(jsonArraydetails.get(i).getAsJsonObject());
            }
        }
        if ((jsonArrayinputDetails = jsonObj.getAsJsonArray(SERIALIZED_NAME_INPUT_DETAILS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_INPUT_DETAILS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `inputDetails` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_INPUT_DETAILS).toString()));
            }
            for (int i = 0; i < jsonArrayinputDetails.size(); ++i) {
                SubInputDetail.validateJsonObject(jsonArrayinputDetails.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_ITEM_SEARCH_URL) != null && !jsonObj.get(SERIALIZED_NAME_ITEM_SEARCH_URL).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `itemSearchUrl` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ITEM_SEARCH_URL).toString()));
        }
        if ((jsonArrayitems = jsonObj.getAsJsonArray(SERIALIZED_NAME_ITEMS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_ITEMS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `items` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ITEMS).toString()));
            }
            for (int i = 0; i < jsonArrayitems.size(); ++i) {
                Item.validateJsonObject(jsonArrayitems.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_KEY) != null && !jsonObj.get(SERIALIZED_NAME_KEY).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `key` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_KEY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_TYPE).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TYPE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_VALUE) != null && !jsonObj.get(SERIALIZED_NAME_VALUE).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `value` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VALUE).toString()));
        }
    }

    public static InputDetail fromJson(String jsonString) throws IOException {
        return (InputDetail)JSON.getGson().fromJson(jsonString, InputDetail.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_CONFIGURATION);
        openapiFields.add(SERIALIZED_NAME_DETAILS);
        openapiFields.add(SERIALIZED_NAME_INPUT_DETAILS);
        openapiFields.add(SERIALIZED_NAME_ITEM_SEARCH_URL);
        openapiFields.add(SERIALIZED_NAME_ITEMS);
        openapiFields.add(SERIALIZED_NAME_KEY);
        openapiFields.add(SERIALIZED_NAME_OPTIONAL);
        openapiFields.add(SERIALIZED_NAME_TYPE);
        openapiFields.add(SERIALIZED_NAME_VALUE);
        openapiRequiredFields = new HashSet();
        log = Logger.getLogger(InputDetail.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!InputDetail.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(InputDetail.class));
            return new TypeAdapter<InputDetail>(){

                public void write(JsonWriter out, InputDetail value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public InputDetail read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    InputDetail.validateJsonObject(jsonObj);
                    return (InputDetail)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

