/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.FraudCheckResult;
import com.adyen.model.checkout.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FraudResult {
    public static final String SERIALIZED_NAME_ACCOUNT_SCORE = "accountScore";
    @SerializedName(value="accountScore")
    private Integer accountScore;
    public static final String SERIALIZED_NAME_RESULTS = "results";
    @SerializedName(value="results")
    private List<FraudCheckResult> results = null;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public FraudResult accountScore(Integer accountScore) {
        this.accountScore = accountScore;
        return this;
    }

    @ApiModelProperty(required=true, value="The total fraud score generated by the risk checks.")
    public Integer getAccountScore() {
        return this.accountScore;
    }

    public void setAccountScore(Integer accountScore) {
        this.accountScore = accountScore;
    }

    public FraudResult results(List<FraudCheckResult> results) {
        this.results = results;
        return this;
    }

    public FraudResult addResultsItem(FraudCheckResult resultsItem) {
        if (this.results == null) {
            this.results = new ArrayList<FraudCheckResult>();
        }
        this.results.add(resultsItem);
        return this;
    }

    @ApiModelProperty(value="The result of the individual risk checks.")
    public List<FraudCheckResult> getResults() {
        return this.results;
    }

    public void setResults(List<FraudCheckResult> results) {
        this.results = results;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FraudResult fraudResult = (FraudResult)o;
        return Objects.equals(this.accountScore, fraudResult.accountScore) && Objects.equals(this.results, fraudResult.results);
    }

    public int hashCode() {
        return Objects.hash(this.accountScore, this.results);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FraudResult {\n");
        sb.append("    accountScore: ").append(this.toIndentedString(this.accountScore)).append("\n");
        sb.append("    results: ").append(this.toIndentedString(this.results)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in FraudResult is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `FraudResult` properties.", entry.getKey()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        JsonArray jsonArrayresults = jsonObj.getAsJsonArray(SERIALIZED_NAME_RESULTS);
        if (jsonArrayresults != null) {
            if (!jsonObj.get(SERIALIZED_NAME_RESULTS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `results` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RESULTS).toString()));
            }
            for (int i = 0; i < jsonArrayresults.size(); ++i) {
                FraudCheckResult.validateJsonObject(jsonArrayresults.get(i).getAsJsonObject());
            }
        }
    }

    public static FraudResult fromJson(String jsonString) throws IOException {
        return (FraudResult)JSON.getGson().fromJson(jsonString, FraudResult.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ACCOUNT_SCORE);
        openapiFields.add(SERIALIZED_NAME_RESULTS);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_ACCOUNT_SCORE);
        log = Logger.getLogger(FraudResult.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!FraudResult.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(FraudResult.class));
            return new TypeAdapter<FraudResult>(){

                public void write(JsonWriter out, FraudResult value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public FraudResult read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    FraudResult.validateJsonObject(jsonObj);
                    return (FraudResult)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

