/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.DetailsRequestAuthenticationData;
import com.adyen.model.checkout.JSON;
import com.adyen.model.checkout.PaymentCompletionDetails;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DetailsRequest {
    public static final String SERIALIZED_NAME_AUTHENTICATION_DATA = "authenticationData";
    @SerializedName(value="authenticationData")
    private DetailsRequestAuthenticationData authenticationData;
    public static final String SERIALIZED_NAME_DETAILS = "details";
    @SerializedName(value="details")
    private PaymentCompletionDetails details;
    public static final String SERIALIZED_NAME_PAYMENT_DATA = "paymentData";
    @SerializedName(value="paymentData")
    private String paymentData;
    public static final String SERIALIZED_NAME_THREE_D_S_AUTHENTICATION_ONLY = "threeDSAuthenticationOnly";
    @Deprecated
    @SerializedName(value="threeDSAuthenticationOnly")
    private Boolean threeDSAuthenticationOnly;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public DetailsRequest authenticationData(DetailsRequestAuthenticationData authenticationData) {
        this.authenticationData = authenticationData;
        return this;
    }

    @ApiModelProperty(value="")
    public DetailsRequestAuthenticationData getAuthenticationData() {
        return this.authenticationData;
    }

    public void setAuthenticationData(DetailsRequestAuthenticationData authenticationData) {
        this.authenticationData = authenticationData;
    }

    public DetailsRequest details(PaymentCompletionDetails details) {
        this.details = details;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public PaymentCompletionDetails getDetails() {
        return this.details;
    }

    public void setDetails(PaymentCompletionDetails details) {
        this.details = details;
    }

    public DetailsRequest paymentData(String paymentData) {
        this.paymentData = paymentData;
        return this;
    }

    @ApiModelProperty(value="The `paymentData` value from the `/payments` response. Required if the `/payments` response returns this value. ")
    public String getPaymentData() {
        return this.paymentData;
    }

    public void setPaymentData(String paymentData) {
        this.paymentData = paymentData;
    }

    @Deprecated
    public DetailsRequest threeDSAuthenticationOnly(Boolean threeDSAuthenticationOnly) {
        this.threeDSAuthenticationOnly = threeDSAuthenticationOnly;
        return this;
    }

    @Deprecated
    @ApiModelProperty(value="Change the `authenticationOnly` indicator originally set in the `/payments` request. Only needs to be set if you want to modify the value set previously.")
    public Boolean getThreeDSAuthenticationOnly() {
        return this.threeDSAuthenticationOnly;
    }

    @Deprecated
    public void setThreeDSAuthenticationOnly(Boolean threeDSAuthenticationOnly) {
        this.threeDSAuthenticationOnly = threeDSAuthenticationOnly;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DetailsRequest detailsRequest = (DetailsRequest)o;
        return Objects.equals(this.authenticationData, detailsRequest.authenticationData) && Objects.equals(this.details, detailsRequest.details) && Objects.equals(this.paymentData, detailsRequest.paymentData) && Objects.equals(this.threeDSAuthenticationOnly, detailsRequest.threeDSAuthenticationOnly);
    }

    public int hashCode() {
        return Objects.hash(this.authenticationData, this.details, this.paymentData, this.threeDSAuthenticationOnly);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DetailsRequest {\n");
        sb.append("    authenticationData: ").append(this.toIndentedString(this.authenticationData)).append("\n");
        sb.append("    details: ").append(this.toIndentedString(this.details)).append("\n");
        sb.append("    paymentData: ").append(this.toIndentedString(this.paymentData)).append("\n");
        sb.append("    threeDSAuthenticationOnly: ").append(this.toIndentedString(this.threeDSAuthenticationOnly)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in DetailsRequest is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `DetailsRequest` properties.", entry.getKey()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_AUTHENTICATION_DATA) != null) {
            DetailsRequestAuthenticationData.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_AUTHENTICATION_DATA));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_DETAILS) != null) {
            PaymentCompletionDetails.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_DETAILS));
        }
        if (jsonObj.get(SERIALIZED_NAME_PAYMENT_DATA) != null && !jsonObj.get(SERIALIZED_NAME_PAYMENT_DATA).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `paymentData` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PAYMENT_DATA).toString()));
        }
    }

    public static DetailsRequest fromJson(String jsonString) throws IOException {
        return (DetailsRequest)JSON.getGson().fromJson(jsonString, DetailsRequest.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_AUTHENTICATION_DATA);
        openapiFields.add(SERIALIZED_NAME_DETAILS);
        openapiFields.add(SERIALIZED_NAME_PAYMENT_DATA);
        openapiFields.add(SERIALIZED_NAME_THREE_D_S_AUTHENTICATION_ONLY);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_DETAILS);
        log = Logger.getLogger(DetailsRequest.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!DetailsRequest.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(DetailsRequest.class));
            return new TypeAdapter<DetailsRequest>(){

                public void write(JsonWriter out, DetailsRequest value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public DetailsRequest read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    DetailsRequest.validateJsonObject(jsonObj);
                    return (DetailsRequest)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

