/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.Amount;
import com.adyen.model.checkout.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CheckoutVoucherAction {
    public static final String SERIALIZED_NAME_ALTERNATIVE_REFERENCE = "alternativeReference";
    @SerializedName(value="alternativeReference")
    private String alternativeReference;
    public static final String SERIALIZED_NAME_COLLECTION_INSTITUTION_NUMBER = "collectionInstitutionNumber";
    @SerializedName(value="collectionInstitutionNumber")
    private String collectionInstitutionNumber;
    public static final String SERIALIZED_NAME_DOWNLOAD_URL = "downloadUrl";
    @SerializedName(value="downloadUrl")
    private String downloadUrl;
    public static final String SERIALIZED_NAME_ENTITY = "entity";
    @SerializedName(value="entity")
    private String entity;
    public static final String SERIALIZED_NAME_EXPIRES_AT = "expiresAt";
    @SerializedName(value="expiresAt")
    private String expiresAt;
    public static final String SERIALIZED_NAME_INITIAL_AMOUNT = "initialAmount";
    @SerializedName(value="initialAmount")
    private Amount initialAmount;
    public static final String SERIALIZED_NAME_INSTRUCTIONS_URL = "instructionsUrl";
    @SerializedName(value="instructionsUrl")
    private String instructionsUrl;
    public static final String SERIALIZED_NAME_ISSUER = "issuer";
    @SerializedName(value="issuer")
    private String issuer;
    public static final String SERIALIZED_NAME_MASKED_TELEPHONE_NUMBER = "maskedTelephoneNumber";
    @SerializedName(value="maskedTelephoneNumber")
    private String maskedTelephoneNumber;
    public static final String SERIALIZED_NAME_MERCHANT_NAME = "merchantName";
    @SerializedName(value="merchantName")
    private String merchantName;
    public static final String SERIALIZED_NAME_MERCHANT_REFERENCE = "merchantReference";
    @SerializedName(value="merchantReference")
    private String merchantReference;
    public static final String SERIALIZED_NAME_PAYMENT_DATA = "paymentData";
    @SerializedName(value="paymentData")
    private String paymentData;
    public static final String SERIALIZED_NAME_PAYMENT_METHOD_TYPE = "paymentMethodType";
    @SerializedName(value="paymentMethodType")
    private String paymentMethodType;
    public static final String SERIALIZED_NAME_REFERENCE = "reference";
    @SerializedName(value="reference")
    private String reference;
    public static final String SERIALIZED_NAME_SHOPPER_EMAIL = "shopperEmail";
    @SerializedName(value="shopperEmail")
    private String shopperEmail;
    public static final String SERIALIZED_NAME_SHOPPER_NAME = "shopperName";
    @SerializedName(value="shopperName")
    private String shopperName;
    public static final String SERIALIZED_NAME_SURCHARGE = "surcharge";
    @SerializedName(value="surcharge")
    private Amount surcharge;
    public static final String SERIALIZED_NAME_TOTAL_AMOUNT = "totalAmount";
    @SerializedName(value="totalAmount")
    private Amount totalAmount;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private TypeEnum type;
    public static final String SERIALIZED_NAME_URL = "url";
    @SerializedName(value="url")
    private String url;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public CheckoutVoucherAction alternativeReference(String alternativeReference) {
        this.alternativeReference = alternativeReference;
        return this;
    }

    @ApiModelProperty(value="The voucher alternative reference code.")
    public String getAlternativeReference() {
        return this.alternativeReference;
    }

    public void setAlternativeReference(String alternativeReference) {
        this.alternativeReference = alternativeReference;
    }

    public CheckoutVoucherAction collectionInstitutionNumber(String collectionInstitutionNumber) {
        this.collectionInstitutionNumber = collectionInstitutionNumber;
        return this;
    }

    @ApiModelProperty(value="A collection institution number (store number) for Econtext Pay-Easy ATM.")
    public String getCollectionInstitutionNumber() {
        return this.collectionInstitutionNumber;
    }

    public void setCollectionInstitutionNumber(String collectionInstitutionNumber) {
        this.collectionInstitutionNumber = collectionInstitutionNumber;
    }

    public CheckoutVoucherAction downloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
        return this;
    }

    @ApiModelProperty(value="The URL to download the voucher.")
    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    public void setDownloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
    }

    public CheckoutVoucherAction entity(String entity) {
        this.entity = entity;
        return this;
    }

    @ApiModelProperty(value="An entity number of Multibanco.")
    public String getEntity() {
        return this.entity;
    }

    public void setEntity(String entity) {
        this.entity = entity;
    }

    public CheckoutVoucherAction expiresAt(String expiresAt) {
        this.expiresAt = expiresAt;
        return this;
    }

    @ApiModelProperty(value="The date time of the voucher expiry.")
    public String getExpiresAt() {
        return this.expiresAt;
    }

    public void setExpiresAt(String expiresAt) {
        this.expiresAt = expiresAt;
    }

    public CheckoutVoucherAction initialAmount(Amount initialAmount) {
        this.initialAmount = initialAmount;
        return this;
    }

    @ApiModelProperty(value="")
    public Amount getInitialAmount() {
        return this.initialAmount;
    }

    public void setInitialAmount(Amount initialAmount) {
        this.initialAmount = initialAmount;
    }

    public CheckoutVoucherAction instructionsUrl(String instructionsUrl) {
        this.instructionsUrl = instructionsUrl;
        return this;
    }

    @ApiModelProperty(value="The URL to the detailed instructions to make payment using the voucher.")
    public String getInstructionsUrl() {
        return this.instructionsUrl;
    }

    public void setInstructionsUrl(String instructionsUrl) {
        this.instructionsUrl = instructionsUrl;
    }

    public CheckoutVoucherAction issuer(String issuer) {
        this.issuer = issuer;
        return this;
    }

    @ApiModelProperty(value="The issuer of the voucher.")
    public String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public CheckoutVoucherAction maskedTelephoneNumber(String maskedTelephoneNumber) {
        this.maskedTelephoneNumber = maskedTelephoneNumber;
        return this;
    }

    @ApiModelProperty(value="The shopper telephone number (partially masked).")
    public String getMaskedTelephoneNumber() {
        return this.maskedTelephoneNumber;
    }

    public void setMaskedTelephoneNumber(String maskedTelephoneNumber) {
        this.maskedTelephoneNumber = maskedTelephoneNumber;
    }

    public CheckoutVoucherAction merchantName(String merchantName) {
        this.merchantName = merchantName;
        return this;
    }

    @ApiModelProperty(value="The merchant name.")
    public String getMerchantName() {
        return this.merchantName;
    }

    public void setMerchantName(String merchantName) {
        this.merchantName = merchantName;
    }

    public CheckoutVoucherAction merchantReference(String merchantReference) {
        this.merchantReference = merchantReference;
        return this;
    }

    @ApiModelProperty(value="The merchant reference.")
    public String getMerchantReference() {
        return this.merchantReference;
    }

    public void setMerchantReference(String merchantReference) {
        this.merchantReference = merchantReference;
    }

    public CheckoutVoucherAction paymentData(String paymentData) {
        this.paymentData = paymentData;
        return this;
    }

    @ApiModelProperty(value="A value that must be submitted to the `/payments/details` endpoint to verify this payment.")
    public String getPaymentData() {
        return this.paymentData;
    }

    public void setPaymentData(String paymentData) {
        this.paymentData = paymentData;
    }

    public CheckoutVoucherAction paymentMethodType(String paymentMethodType) {
        this.paymentMethodType = paymentMethodType;
        return this;
    }

    @ApiModelProperty(value="Specifies the payment method.")
    public String getPaymentMethodType() {
        return this.paymentMethodType;
    }

    public void setPaymentMethodType(String paymentMethodType) {
        this.paymentMethodType = paymentMethodType;
    }

    public CheckoutVoucherAction reference(String reference) {
        this.reference = reference;
        return this;
    }

    @ApiModelProperty(value="The voucher reference code.")
    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public CheckoutVoucherAction shopperEmail(String shopperEmail) {
        this.shopperEmail = shopperEmail;
        return this;
    }

    @ApiModelProperty(value="The shopper email.")
    public String getShopperEmail() {
        return this.shopperEmail;
    }

    public void setShopperEmail(String shopperEmail) {
        this.shopperEmail = shopperEmail;
    }

    public CheckoutVoucherAction shopperName(String shopperName) {
        this.shopperName = shopperName;
        return this;
    }

    @ApiModelProperty(value="The shopper name.")
    public String getShopperName() {
        return this.shopperName;
    }

    public void setShopperName(String shopperName) {
        this.shopperName = shopperName;
    }

    public CheckoutVoucherAction surcharge(Amount surcharge) {
        this.surcharge = surcharge;
        return this;
    }

    @ApiModelProperty(value="")
    public Amount getSurcharge() {
        return this.surcharge;
    }

    public void setSurcharge(Amount surcharge) {
        this.surcharge = surcharge;
    }

    public CheckoutVoucherAction totalAmount(Amount totalAmount) {
        this.totalAmount = totalAmount;
        return this;
    }

    @ApiModelProperty(value="")
    public Amount getTotalAmount() {
        return this.totalAmount;
    }

    public void setTotalAmount(Amount totalAmount) {
        this.totalAmount = totalAmount;
    }

    public CheckoutVoucherAction type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="**voucher**")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public CheckoutVoucherAction url(String url) {
        this.url = url;
        return this;
    }

    @ApiModelProperty(value="Specifies the URL to redirect to.")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CheckoutVoucherAction checkoutVoucherAction = (CheckoutVoucherAction)o;
        return Objects.equals(this.alternativeReference, checkoutVoucherAction.alternativeReference) && Objects.equals(this.collectionInstitutionNumber, checkoutVoucherAction.collectionInstitutionNumber) && Objects.equals(this.downloadUrl, checkoutVoucherAction.downloadUrl) && Objects.equals(this.entity, checkoutVoucherAction.entity) && Objects.equals(this.expiresAt, checkoutVoucherAction.expiresAt) && Objects.equals(this.initialAmount, checkoutVoucherAction.initialAmount) && Objects.equals(this.instructionsUrl, checkoutVoucherAction.instructionsUrl) && Objects.equals(this.issuer, checkoutVoucherAction.issuer) && Objects.equals(this.maskedTelephoneNumber, checkoutVoucherAction.maskedTelephoneNumber) && Objects.equals(this.merchantName, checkoutVoucherAction.merchantName) && Objects.equals(this.merchantReference, checkoutVoucherAction.merchantReference) && Objects.equals(this.paymentData, checkoutVoucherAction.paymentData) && Objects.equals(this.paymentMethodType, checkoutVoucherAction.paymentMethodType) && Objects.equals(this.reference, checkoutVoucherAction.reference) && Objects.equals(this.shopperEmail, checkoutVoucherAction.shopperEmail) && Objects.equals(this.shopperName, checkoutVoucherAction.shopperName) && Objects.equals(this.surcharge, checkoutVoucherAction.surcharge) && Objects.equals(this.totalAmount, checkoutVoucherAction.totalAmount) && Objects.equals((Object)this.type, (Object)checkoutVoucherAction.type) && Objects.equals(this.url, checkoutVoucherAction.url);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.alternativeReference, this.collectionInstitutionNumber, this.downloadUrl, this.entity, this.expiresAt, this.initialAmount, this.instructionsUrl, this.issuer, this.maskedTelephoneNumber, this.merchantName, this.merchantReference, this.paymentData, this.paymentMethodType, this.reference, this.shopperEmail, this.shopperName, this.surcharge, this.totalAmount, this.type, this.url});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CheckoutVoucherAction {\n");
        sb.append("    alternativeReference: ").append(this.toIndentedString(this.alternativeReference)).append("\n");
        sb.append("    collectionInstitutionNumber: ").append(this.toIndentedString(this.collectionInstitutionNumber)).append("\n");
        sb.append("    downloadUrl: ").append(this.toIndentedString(this.downloadUrl)).append("\n");
        sb.append("    entity: ").append(this.toIndentedString(this.entity)).append("\n");
        sb.append("    expiresAt: ").append(this.toIndentedString(this.expiresAt)).append("\n");
        sb.append("    initialAmount: ").append(this.toIndentedString(this.initialAmount)).append("\n");
        sb.append("    instructionsUrl: ").append(this.toIndentedString(this.instructionsUrl)).append("\n");
        sb.append("    issuer: ").append(this.toIndentedString(this.issuer)).append("\n");
        sb.append("    maskedTelephoneNumber: ").append(this.toIndentedString(this.maskedTelephoneNumber)).append("\n");
        sb.append("    merchantName: ").append(this.toIndentedString(this.merchantName)).append("\n");
        sb.append("    merchantReference: ").append(this.toIndentedString(this.merchantReference)).append("\n");
        sb.append("    paymentData: ").append(this.toIndentedString(this.paymentData)).append("\n");
        sb.append("    paymentMethodType: ").append(this.toIndentedString(this.paymentMethodType)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    shopperEmail: ").append(this.toIndentedString(this.shopperEmail)).append("\n");
        sb.append("    shopperName: ").append(this.toIndentedString(this.shopperName)).append("\n");
        sb.append("    surcharge: ").append(this.toIndentedString(this.surcharge)).append("\n");
        sb.append("    totalAmount: ").append(this.toIndentedString(this.totalAmount)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in CheckoutVoucherAction is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `CheckoutVoucherAction` properties.", entry.getKey()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ALTERNATIVE_REFERENCE) != null && !jsonObj.get(SERIALIZED_NAME_ALTERNATIVE_REFERENCE).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `alternativeReference` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ALTERNATIVE_REFERENCE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_COLLECTION_INSTITUTION_NUMBER) != null && !jsonObj.get(SERIALIZED_NAME_COLLECTION_INSTITUTION_NUMBER).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `collectionInstitutionNumber` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_COLLECTION_INSTITUTION_NUMBER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DOWNLOAD_URL) != null && !jsonObj.get(SERIALIZED_NAME_DOWNLOAD_URL).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `downloadUrl` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DOWNLOAD_URL).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ENTITY) != null && !jsonObj.get(SERIALIZED_NAME_ENTITY).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `entity` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ENTITY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_EXPIRES_AT) != null && !jsonObj.get(SERIALIZED_NAME_EXPIRES_AT).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `expiresAt` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_EXPIRES_AT).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_INITIAL_AMOUNT) != null) {
            Amount.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_INITIAL_AMOUNT));
        }
        if (jsonObj.get(SERIALIZED_NAME_INSTRUCTIONS_URL) != null && !jsonObj.get(SERIALIZED_NAME_INSTRUCTIONS_URL).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `instructionsUrl` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_INSTRUCTIONS_URL).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ISSUER) != null && !jsonObj.get(SERIALIZED_NAME_ISSUER).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `issuer` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ISSUER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MASKED_TELEPHONE_NUMBER) != null && !jsonObj.get(SERIALIZED_NAME_MASKED_TELEPHONE_NUMBER).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `maskedTelephoneNumber` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MASKED_TELEPHONE_NUMBER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MERCHANT_NAME) != null && !jsonObj.get(SERIALIZED_NAME_MERCHANT_NAME).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `merchantName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MERCHANT_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MERCHANT_REFERENCE) != null && !jsonObj.get(SERIALIZED_NAME_MERCHANT_REFERENCE).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `merchantReference` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MERCHANT_REFERENCE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PAYMENT_DATA) != null && !jsonObj.get(SERIALIZED_NAME_PAYMENT_DATA).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `paymentData` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PAYMENT_DATA).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PAYMENT_METHOD_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_PAYMENT_METHOD_TYPE).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `paymentMethodType` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PAYMENT_METHOD_TYPE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_REFERENCE) != null && !jsonObj.get(SERIALIZED_NAME_REFERENCE).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `reference` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REFERENCE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SHOPPER_EMAIL) != null && !jsonObj.get(SERIALIZED_NAME_SHOPPER_EMAIL).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `shopperEmail` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SHOPPER_EMAIL).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SHOPPER_NAME) != null && !jsonObj.get(SERIALIZED_NAME_SHOPPER_NAME).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `shopperName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SHOPPER_NAME).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_SURCHARGE) != null) {
            Amount.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_SURCHARGE));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_TOTAL_AMOUNT) != null) {
            Amount.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_TOTAL_AMOUNT));
        }
        if (jsonObj.get(SERIALIZED_NAME_TYPE) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_TYPE).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TYPE).toString()));
            }
            TypeEnum.fromValue(jsonObj.get(SERIALIZED_NAME_TYPE).getAsString());
        }
        if (jsonObj.get(SERIALIZED_NAME_URL) != null && !jsonObj.get(SERIALIZED_NAME_URL).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `url` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_URL).toString()));
        }
    }

    public static CheckoutVoucherAction fromJson(String jsonString) throws IOException {
        return (CheckoutVoucherAction)JSON.getGson().fromJson(jsonString, CheckoutVoucherAction.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ALTERNATIVE_REFERENCE);
        openapiFields.add(SERIALIZED_NAME_COLLECTION_INSTITUTION_NUMBER);
        openapiFields.add(SERIALIZED_NAME_DOWNLOAD_URL);
        openapiFields.add(SERIALIZED_NAME_ENTITY);
        openapiFields.add(SERIALIZED_NAME_EXPIRES_AT);
        openapiFields.add(SERIALIZED_NAME_INITIAL_AMOUNT);
        openapiFields.add(SERIALIZED_NAME_INSTRUCTIONS_URL);
        openapiFields.add(SERIALIZED_NAME_ISSUER);
        openapiFields.add(SERIALIZED_NAME_MASKED_TELEPHONE_NUMBER);
        openapiFields.add(SERIALIZED_NAME_MERCHANT_NAME);
        openapiFields.add(SERIALIZED_NAME_MERCHANT_REFERENCE);
        openapiFields.add(SERIALIZED_NAME_PAYMENT_DATA);
        openapiFields.add(SERIALIZED_NAME_PAYMENT_METHOD_TYPE);
        openapiFields.add(SERIALIZED_NAME_REFERENCE);
        openapiFields.add(SERIALIZED_NAME_SHOPPER_EMAIL);
        openapiFields.add(SERIALIZED_NAME_SHOPPER_NAME);
        openapiFields.add(SERIALIZED_NAME_SURCHARGE);
        openapiFields.add(SERIALIZED_NAME_TOTAL_AMOUNT);
        openapiFields.add(SERIALIZED_NAME_TYPE);
        openapiFields.add(SERIALIZED_NAME_URL);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_TYPE);
        log = Logger.getLogger(CheckoutVoucherAction.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!CheckoutVoucherAction.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(CheckoutVoucherAction.class));
            return new TypeAdapter<CheckoutVoucherAction>(){

                public void write(JsonWriter out, CheckoutVoucherAction value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public CheckoutVoucherAction read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    CheckoutVoucherAction.validateJsonObject(jsonObj);
                    return (CheckoutVoucherAction)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        VOUCHER("voucher");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(value);
            }
        }
    }
}

