/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CheckoutThreeDS2Action {
    public static final String SERIALIZED_NAME_AUTHORISATION_TOKEN = "authorisationToken";
    @SerializedName(value="authorisationToken")
    private String authorisationToken;
    public static final String SERIALIZED_NAME_PAYMENT_DATA = "paymentData";
    @SerializedName(value="paymentData")
    private String paymentData;
    public static final String SERIALIZED_NAME_PAYMENT_METHOD_TYPE = "paymentMethodType";
    @SerializedName(value="paymentMethodType")
    private String paymentMethodType;
    public static final String SERIALIZED_NAME_SUBTYPE = "subtype";
    @SerializedName(value="subtype")
    private String subtype;
    public static final String SERIALIZED_NAME_TOKEN = "token";
    @SerializedName(value="token")
    private String token;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private TypeEnum type;
    public static final String SERIALIZED_NAME_URL = "url";
    @SerializedName(value="url")
    private String url;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public CheckoutThreeDS2Action authorisationToken(String authorisationToken) {
        this.authorisationToken = authorisationToken;
        return this;
    }

    @ApiModelProperty(value="A token needed to authorise a payment.")
    public String getAuthorisationToken() {
        return this.authorisationToken;
    }

    public void setAuthorisationToken(String authorisationToken) {
        this.authorisationToken = authorisationToken;
    }

    public CheckoutThreeDS2Action paymentData(String paymentData) {
        this.paymentData = paymentData;
        return this;
    }

    @ApiModelProperty(value="A value that must be submitted to the `/payments/details` endpoint to verify this payment.")
    public String getPaymentData() {
        return this.paymentData;
    }

    public void setPaymentData(String paymentData) {
        this.paymentData = paymentData;
    }

    public CheckoutThreeDS2Action paymentMethodType(String paymentMethodType) {
        this.paymentMethodType = paymentMethodType;
        return this;
    }

    @ApiModelProperty(value="Specifies the payment method.")
    public String getPaymentMethodType() {
        return this.paymentMethodType;
    }

    public void setPaymentMethodType(String paymentMethodType) {
        this.paymentMethodType = paymentMethodType;
    }

    public CheckoutThreeDS2Action subtype(String subtype) {
        this.subtype = subtype;
        return this;
    }

    @ApiModelProperty(value="A subtype of the token.")
    public String getSubtype() {
        return this.subtype;
    }

    public void setSubtype(String subtype) {
        this.subtype = subtype;
    }

    public CheckoutThreeDS2Action token(String token) {
        this.token = token;
        return this;
    }

    @ApiModelProperty(value="A token to pass to the 3DS2 Component to get the fingerprint.")
    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public CheckoutThreeDS2Action type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="**threeDS2**")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public CheckoutThreeDS2Action url(String url) {
        this.url = url;
        return this;
    }

    @ApiModelProperty(value="Specifies the URL to redirect to.")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CheckoutThreeDS2Action checkoutThreeDS2Action = (CheckoutThreeDS2Action)o;
        return Objects.equals(this.authorisationToken, checkoutThreeDS2Action.authorisationToken) && Objects.equals(this.paymentData, checkoutThreeDS2Action.paymentData) && Objects.equals(this.paymentMethodType, checkoutThreeDS2Action.paymentMethodType) && Objects.equals(this.subtype, checkoutThreeDS2Action.subtype) && Objects.equals(this.token, checkoutThreeDS2Action.token) && Objects.equals((Object)this.type, (Object)checkoutThreeDS2Action.type) && Objects.equals(this.url, checkoutThreeDS2Action.url);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.authorisationToken, this.paymentData, this.paymentMethodType, this.subtype, this.token, this.type, this.url});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CheckoutThreeDS2Action {\n");
        sb.append("    authorisationToken: ").append(this.toIndentedString(this.authorisationToken)).append("\n");
        sb.append("    paymentData: ").append(this.toIndentedString(this.paymentData)).append("\n");
        sb.append("    paymentMethodType: ").append(this.toIndentedString(this.paymentMethodType)).append("\n");
        sb.append("    subtype: ").append(this.toIndentedString(this.subtype)).append("\n");
        sb.append("    token: ").append(this.toIndentedString(this.token)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in CheckoutThreeDS2Action is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `CheckoutThreeDS2Action` properties.", entry.getKey()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_AUTHORISATION_TOKEN) != null && !jsonObj.get(SERIALIZED_NAME_AUTHORISATION_TOKEN).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `authorisationToken` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_AUTHORISATION_TOKEN).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PAYMENT_DATA) != null && !jsonObj.get(SERIALIZED_NAME_PAYMENT_DATA).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `paymentData` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PAYMENT_DATA).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PAYMENT_METHOD_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_PAYMENT_METHOD_TYPE).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `paymentMethodType` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PAYMENT_METHOD_TYPE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SUBTYPE) != null && !jsonObj.get(SERIALIZED_NAME_SUBTYPE).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `subtype` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SUBTYPE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TOKEN) != null && !jsonObj.get(SERIALIZED_NAME_TOKEN).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `token` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TOKEN).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TYPE) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_TYPE).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TYPE).toString()));
            }
            TypeEnum.fromValue(jsonObj.get(SERIALIZED_NAME_TYPE).getAsString());
        }
        if (jsonObj.get(SERIALIZED_NAME_URL) != null && !jsonObj.get(SERIALIZED_NAME_URL).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `url` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_URL).toString()));
        }
    }

    public static CheckoutThreeDS2Action fromJson(String jsonString) throws IOException {
        return (CheckoutThreeDS2Action)JSON.getGson().fromJson(jsonString, CheckoutThreeDS2Action.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_AUTHORISATION_TOKEN);
        openapiFields.add(SERIALIZED_NAME_PAYMENT_DATA);
        openapiFields.add(SERIALIZED_NAME_PAYMENT_METHOD_TYPE);
        openapiFields.add(SERIALIZED_NAME_SUBTYPE);
        openapiFields.add(SERIALIZED_NAME_TOKEN);
        openapiFields.add(SERIALIZED_NAME_TYPE);
        openapiFields.add(SERIALIZED_NAME_URL);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_TYPE);
        log = Logger.getLogger(CheckoutThreeDS2Action.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!CheckoutThreeDS2Action.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(CheckoutThreeDS2Action.class));
            return new TypeAdapter<CheckoutThreeDS2Action>(){

                public void write(JsonWriter out, CheckoutThreeDS2Action value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public CheckoutThreeDS2Action read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    CheckoutThreeDS2Action.validateJsonObject(jsonObj);
                    return (CheckoutThreeDS2Action)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        THREEDS2("threeDS2");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(value);
            }
        }
    }
}

