/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.capital;

import com.adyen.model.capital.Amount;
import com.adyen.model.capital.CapitalBalance;
import com.adyen.model.capital.Counterparty;
import com.adyen.model.capital.Fee;
import com.adyen.model.capital.JSON;
import com.adyen.model.capital.Repayment;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CapitalGrant {
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private Amount amount;
    public static final String SERIALIZED_NAME_BALANCES = "balances";
    @SerializedName(value="balances")
    private CapitalBalance balances;
    public static final String SERIALIZED_NAME_COUNTERPARTY = "counterparty";
    @SerializedName(value="counterparty")
    private Counterparty counterparty;
    public static final String SERIALIZED_NAME_FEE = "fee";
    @SerializedName(value="fee")
    private Fee fee;
    public static final String SERIALIZED_NAME_GRANT_ACCOUNT_ID = "grantAccountId";
    @SerializedName(value="grantAccountId")
    private String grantAccountId;
    public static final String SERIALIZED_NAME_GRANT_OFFER_ID = "grantOfferId";
    @SerializedName(value="grantOfferId")
    private String grantOfferId;
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_REPAYMENT = "repayment";
    @SerializedName(value="repayment")
    private Repayment repayment;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private StatusEnum status;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public CapitalGrant amount(Amount amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(value="")
    public Amount getAmount() {
        return this.amount;
    }

    public void setAmount(Amount amount) {
        this.amount = amount;
    }

    public CapitalGrant balances(CapitalBalance balances) {
        this.balances = balances;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public CapitalBalance getBalances() {
        return this.balances;
    }

    public void setBalances(CapitalBalance balances) {
        this.balances = balances;
    }

    public CapitalGrant counterparty(Counterparty counterparty) {
        this.counterparty = counterparty;
        return this;
    }

    @ApiModelProperty(value="")
    public Counterparty getCounterparty() {
        return this.counterparty;
    }

    public void setCounterparty(Counterparty counterparty) {
        this.counterparty = counterparty;
    }

    public CapitalGrant fee(Fee fee) {
        this.fee = fee;
        return this;
    }

    @ApiModelProperty(value="")
    public Fee getFee() {
        return this.fee;
    }

    public void setFee(Fee fee) {
        this.fee = fee;
    }

    public CapitalGrant grantAccountId(String grantAccountId) {
        this.grantAccountId = grantAccountId;
        return this;
    }

    @ApiModelProperty(required=true, value="The identifier of the grant account used for the grant.")
    public String getGrantAccountId() {
        return this.grantAccountId;
    }

    public void setGrantAccountId(String grantAccountId) {
        this.grantAccountId = grantAccountId;
    }

    public CapitalGrant grantOfferId(String grantOfferId) {
        this.grantOfferId = grantOfferId;
        return this;
    }

    @ApiModelProperty(required=true, value="The identifier of the grant offer that has been selected and from which the grant details will be used.")
    public String getGrantOfferId() {
        return this.grantOfferId;
    }

    public void setGrantOfferId(String grantOfferId) {
        this.grantOfferId = grantOfferId;
    }

    public CapitalGrant id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="The identifier of the grant reference.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public CapitalGrant repayment(Repayment repayment) {
        this.repayment = repayment;
        return this;
    }

    @ApiModelProperty(value="")
    public Repayment getRepayment() {
        return this.repayment;
    }

    public void setRepayment(Repayment repayment) {
        this.repayment = repayment;
    }

    public CapitalGrant status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(required=true, value="The current status of the grant. Possible values: **Pending**, **Active**, **Repaid**.")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CapitalGrant capitalGrant = (CapitalGrant)o;
        return Objects.equals(this.amount, capitalGrant.amount) && Objects.equals(this.balances, capitalGrant.balances) && Objects.equals(this.counterparty, capitalGrant.counterparty) && Objects.equals(this.fee, capitalGrant.fee) && Objects.equals(this.grantAccountId, capitalGrant.grantAccountId) && Objects.equals(this.grantOfferId, capitalGrant.grantOfferId) && Objects.equals(this.id, capitalGrant.id) && Objects.equals(this.repayment, capitalGrant.repayment) && Objects.equals((Object)this.status, (Object)capitalGrant.status);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.amount, this.balances, this.counterparty, this.fee, this.grantAccountId, this.grantOfferId, this.id, this.repayment, this.status});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CapitalGrant {\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    balances: ").append(this.toIndentedString(this.balances)).append("\n");
        sb.append("    counterparty: ").append(this.toIndentedString(this.counterparty)).append("\n");
        sb.append("    fee: ").append(this.toIndentedString(this.fee)).append("\n");
        sb.append("    grantAccountId: ").append(this.toIndentedString(this.grantAccountId)).append("\n");
        sb.append("    grantOfferId: ").append(this.toIndentedString(this.grantOfferId)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    repayment: ").append(this.toIndentedString(this.repayment)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in CapitalGrant is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `CapitalGrant` properties.", entry.getKey()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_AMOUNT) != null) {
            Amount.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_AMOUNT));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_BALANCES) != null) {
            CapitalBalance.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_BALANCES));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_COUNTERPARTY) != null) {
            Counterparty.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_COUNTERPARTY));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_FEE) != null) {
            Fee.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_FEE));
        }
        if (jsonObj.get(SERIALIZED_NAME_GRANT_ACCOUNT_ID) != null && !jsonObj.get(SERIALIZED_NAME_GRANT_ACCOUNT_ID).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `grantAccountId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_GRANT_ACCOUNT_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_GRANT_OFFER_ID) != null && !jsonObj.get(SERIALIZED_NAME_GRANT_OFFER_ID).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `grantOfferId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_GRANT_OFFER_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_REPAYMENT) != null) {
            Repayment.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_REPAYMENT));
        }
        if (jsonObj.get(SERIALIZED_NAME_STATUS) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_STATUS).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `status` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STATUS).toString()));
            }
            StatusEnum.fromValue(jsonObj.get(SERIALIZED_NAME_STATUS).getAsString());
        }
    }

    public static CapitalGrant fromJson(String jsonString) throws IOException {
        return (CapitalGrant)JSON.getGson().fromJson(jsonString, CapitalGrant.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_AMOUNT);
        openapiFields.add(SERIALIZED_NAME_BALANCES);
        openapiFields.add(SERIALIZED_NAME_COUNTERPARTY);
        openapiFields.add(SERIALIZED_NAME_FEE);
        openapiFields.add(SERIALIZED_NAME_GRANT_ACCOUNT_ID);
        openapiFields.add(SERIALIZED_NAME_GRANT_OFFER_ID);
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_REPAYMENT);
        openapiFields.add(SERIALIZED_NAME_STATUS);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_BALANCES);
        openapiRequiredFields.add(SERIALIZED_NAME_GRANT_ACCOUNT_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_GRANT_OFFER_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_STATUS);
        log = Logger.getLogger(CapitalGrant.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!CapitalGrant.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(CapitalGrant.class));
            return new TypeAdapter<CapitalGrant>(){

                public void write(JsonWriter out, CapitalGrant value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public CapitalGrant read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    CapitalGrant.validateJsonObject(jsonObj);
                    return (CapitalGrant)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StatusEnum {
        PENDING("Pending"),
        ACTIVE("Active"),
        REPAID("Repaid");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<StatusEnum> {
            public void write(JsonWriter jsonWriter, StatusEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StatusEnum.fromValue(value);
            }
        }
    }
}

